/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Enumeration;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToggleButtonUI;
import javax.swing.text.View;
import sun.awt.AppContext;
import sun.swing.SwingUtilities2;

public class BasicRadioButtonUI
extends BasicToggleButtonUI {
    private static final Object BASIC_RADIO_BUTTON_UI_KEY = new Object();
    protected Icon icon;
    private boolean defaults_initialized = false;
    private static final String propertyPrefix = "RadioButton.";
    private KeyListener keyListener = null;
    private static Dimension size = new Dimension();
    private static Rectangle viewRect = new Rectangle();
    private static Rectangle iconRect = new Rectangle();
    private static Rectangle textRect = new Rectangle();
    private static Rectangle prefViewRect = new Rectangle();
    private static Rectangle prefIconRect = new Rectangle();
    private static Rectangle prefTextRect = new Rectangle();
    private static Insets prefInsets = new Insets(0, 0, 0, 0);

    public static ComponentUI createUI(JComponent jComponent) {
        AppContext appContext = AppContext.getAppContext();
        BasicRadioButtonUI basicRadioButtonUI = (BasicRadioButtonUI)appContext.get(BASIC_RADIO_BUTTON_UI_KEY);
        if (basicRadioButtonUI == null) {
            basicRadioButtonUI = new BasicRadioButtonUI();
            appContext.put(BASIC_RADIO_BUTTON_UI_KEY, basicRadioButtonUI);
        }
        return basicRadioButtonUI;
    }

    @Override
    protected String getPropertyPrefix() {
        return propertyPrefix;
    }

    @Override
    protected void installDefaults(AbstractButton abstractButton) {
        super.installDefaults(abstractButton);
        if (!this.defaults_initialized) {
            this.icon = UIManager.getIcon(this.getPropertyPrefix() + "icon");
            this.defaults_initialized = true;
        }
    }

    @Override
    protected void uninstallDefaults(AbstractButton abstractButton) {
        super.uninstallDefaults(abstractButton);
        this.defaults_initialized = false;
    }

    public Icon getDefaultIcon() {
        return this.icon;
    }

    @Override
    protected void installListeners(AbstractButton abstractButton) {
        super.installListeners(abstractButton);
        if (!(abstractButton instanceof JRadioButton)) {
            return;
        }
        this.keyListener = this.createKeyListener();
        abstractButton.addKeyListener(this.keyListener);
        abstractButton.setFocusTraversalKeysEnabled(false);
        abstractButton.getActionMap().put("Previous", new SelectPreviousBtn());
        abstractButton.getActionMap().put("Next", new SelectNextBtn());
        abstractButton.getInputMap(1).put(KeyStroke.getKeyStroke("UP"), "Previous");
        abstractButton.getInputMap(1).put(KeyStroke.getKeyStroke("DOWN"), "Next");
        abstractButton.getInputMap(1).put(KeyStroke.getKeyStroke("LEFT"), "Previous");
        abstractButton.getInputMap(1).put(KeyStroke.getKeyStroke("RIGHT"), "Next");
    }

    @Override
    protected void uninstallListeners(AbstractButton abstractButton) {
        super.uninstallListeners(abstractButton);
        if (!(abstractButton instanceof JRadioButton)) {
            return;
        }
        abstractButton.getActionMap().remove("Previous");
        abstractButton.getActionMap().remove("Next");
        abstractButton.getInputMap(1).remove(KeyStroke.getKeyStroke("UP"));
        abstractButton.getInputMap(1).remove(KeyStroke.getKeyStroke("DOWN"));
        abstractButton.getInputMap(1).remove(KeyStroke.getKeyStroke("LEFT"));
        abstractButton.getInputMap(1).remove(KeyStroke.getKeyStroke("RIGHT"));
        if (this.keyListener != null) {
            abstractButton.removeKeyListener(this.keyListener);
            this.keyListener = null;
        }
    }

    @Override
    public synchronized void paint(Graphics graphics, JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        ButtonModel buttonModel = abstractButton.getModel();
        Font font = jComponent.getFont();
        graphics.setFont(font);
        FontMetrics fontMetrics = SwingUtilities2.getFontMetrics(jComponent, graphics, font);
        Insets insets = jComponent.getInsets();
        size = abstractButton.getSize(size);
        BasicRadioButtonUI.viewRect.x = insets.left;
        BasicRadioButtonUI.viewRect.y = insets.top;
        BasicRadioButtonUI.viewRect.width = BasicRadioButtonUI.size.width - (insets.right + BasicRadioButtonUI.viewRect.x);
        BasicRadioButtonUI.viewRect.height = BasicRadioButtonUI.size.height - (insets.bottom + BasicRadioButtonUI.viewRect.y);
        BasicRadioButtonUI.iconRect.height = 0;
        BasicRadioButtonUI.iconRect.width = 0;
        BasicRadioButtonUI.iconRect.y = 0;
        BasicRadioButtonUI.iconRect.x = 0;
        BasicRadioButtonUI.textRect.height = 0;
        BasicRadioButtonUI.textRect.width = 0;
        BasicRadioButtonUI.textRect.y = 0;
        BasicRadioButtonUI.textRect.x = 0;
        Icon icon = abstractButton.getIcon();
        Object var9_9 = null;
        Object var10_10 = null;
        String string = SwingUtilities.layoutCompoundLabel(jComponent, fontMetrics, abstractButton.getText(), icon != null ? icon : this.getDefaultIcon(), abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), viewRect, iconRect, textRect, abstractButton.getText() == null ? 0 : abstractButton.getIconTextGap());
        if (jComponent.isOpaque()) {
            graphics.setColor(abstractButton.getBackground());
            graphics.fillRect(0, 0, BasicRadioButtonUI.size.width, BasicRadioButtonUI.size.height);
        }
        if (icon != null) {
            if (!buttonModel.isEnabled()) {
                icon = buttonModel.isSelected() ? abstractButton.getDisabledSelectedIcon() : abstractButton.getDisabledIcon();
            } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
                icon = abstractButton.getPressedIcon();
                if (icon == null) {
                    icon = abstractButton.getSelectedIcon();
                }
            } else if (buttonModel.isSelected()) {
                if (abstractButton.isRolloverEnabled() && buttonModel.isRollover()) {
                    icon = abstractButton.getRolloverSelectedIcon();
                    if (icon == null) {
                        icon = abstractButton.getSelectedIcon();
                    }
                } else {
                    icon = abstractButton.getSelectedIcon();
                }
            } else if (abstractButton.isRolloverEnabled() && buttonModel.isRollover()) {
                icon = abstractButton.getRolloverIcon();
            }
            if (icon == null) {
                icon = abstractButton.getIcon();
            }
            icon.paintIcon(jComponent, graphics, BasicRadioButtonUI.iconRect.x, BasicRadioButtonUI.iconRect.y);
        } else {
            this.getDefaultIcon().paintIcon(jComponent, graphics, BasicRadioButtonUI.iconRect.x, BasicRadioButtonUI.iconRect.y);
        }
        if (string != null) {
            View view = (View)jComponent.getClientProperty("html");
            if (view != null) {
                view.paint(graphics, textRect);
            } else {
                this.paintText(graphics, abstractButton, textRect, string);
            }
            if (abstractButton.hasFocus() && abstractButton.isFocusPainted() && BasicRadioButtonUI.textRect.width > 0 && BasicRadioButtonUI.textRect.height > 0) {
                this.paintFocus(graphics, textRect, size);
            }
        }
    }

    protected void paintFocus(Graphics graphics, Rectangle rectangle, Dimension dimension) {
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        if (jComponent.getComponentCount() > 0) {
            return null;
        }
        AbstractButton abstractButton = (AbstractButton)jComponent;
        String string = abstractButton.getText();
        Icon icon = abstractButton.getIcon();
        if (icon == null) {
            icon = this.getDefaultIcon();
        }
        Font font = abstractButton.getFont();
        FontMetrics fontMetrics = abstractButton.getFontMetrics(font);
        BasicRadioButtonUI.prefViewRect.y = 0;
        BasicRadioButtonUI.prefViewRect.x = 0;
        BasicRadioButtonUI.prefViewRect.width = Short.MAX_VALUE;
        BasicRadioButtonUI.prefViewRect.height = Short.MAX_VALUE;
        BasicRadioButtonUI.prefIconRect.height = 0;
        BasicRadioButtonUI.prefIconRect.width = 0;
        BasicRadioButtonUI.prefIconRect.y = 0;
        BasicRadioButtonUI.prefIconRect.x = 0;
        BasicRadioButtonUI.prefTextRect.height = 0;
        BasicRadioButtonUI.prefTextRect.width = 0;
        BasicRadioButtonUI.prefTextRect.y = 0;
        BasicRadioButtonUI.prefTextRect.x = 0;
        SwingUtilities.layoutCompoundLabel(jComponent, fontMetrics, string, icon, abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), prefViewRect, prefIconRect, prefTextRect, string == null ? 0 : abstractButton.getIconTextGap());
        int n = Math.min(BasicRadioButtonUI.prefIconRect.x, BasicRadioButtonUI.prefTextRect.x);
        int n2 = Math.max(BasicRadioButtonUI.prefIconRect.x + BasicRadioButtonUI.prefIconRect.width, BasicRadioButtonUI.prefTextRect.x + BasicRadioButtonUI.prefTextRect.width);
        int n3 = Math.min(BasicRadioButtonUI.prefIconRect.y, BasicRadioButtonUI.prefTextRect.y);
        int n4 = Math.max(BasicRadioButtonUI.prefIconRect.y + BasicRadioButtonUI.prefIconRect.height, BasicRadioButtonUI.prefTextRect.y + BasicRadioButtonUI.prefTextRect.height);
        int n5 = n2 - n;
        int n6 = n4 - n3;
        prefInsets = abstractButton.getInsets(prefInsets);
        return new Dimension(n5 += BasicRadioButtonUI.prefInsets.left + BasicRadioButtonUI.prefInsets.right, n6 += BasicRadioButtonUI.prefInsets.top + BasicRadioButtonUI.prefInsets.bottom);
    }

    private KeyListener createKeyListener() {
        if (this.keyListener == null) {
            this.keyListener = new KeyHandler();
        }
        return this.keyListener;
    }

    private boolean isValidRadioButtonObj(Object object) {
        return object instanceof JRadioButton && ((JRadioButton)object).isVisible() && ((JRadioButton)object).isEnabled();
    }

    private void selectRadioButton(ActionEvent actionEvent, boolean bl) {
        Object object = actionEvent.getSource();
        if (!this.isValidRadioButtonObj(object)) {
            return;
        }
        ButtonGroupInfo buttonGroupInfo = new ButtonGroupInfo((JRadioButton)object);
        buttonGroupInfo.selectNewButton(bl);
    }

    private class KeyHandler
    implements KeyListener {
        private KeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            Object object;
            if (keyEvent.getKeyCode() == 9 && BasicRadioButtonUI.this.isValidRadioButtonObj(object = keyEvent.getSource())) {
                keyEvent.consume();
                ButtonGroupInfo buttonGroupInfo = new ButtonGroupInfo((JRadioButton)object);
                buttonGroupInfo.jumpToNextComponent(!keyEvent.isShiftDown());
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }
    }

    private class ButtonGroupInfo {
        JRadioButton activeBtn = null;
        JRadioButton firstBtn = null;
        JRadioButton lastBtn = null;
        JRadioButton previousBtn = null;
        JRadioButton nextBtn = null;
        HashSet<JRadioButton> btnsInGroup = null;
        boolean srcFound = false;

        public ButtonGroupInfo(JRadioButton jRadioButton) {
            this.activeBtn = jRadioButton;
            this.btnsInGroup = new HashSet();
        }

        boolean containsInGroup(Object object) {
            return this.btnsInGroup.contains(object);
        }

        Component getFocusTransferBaseComponent(boolean bl) {
            JRadioButton jRadioButton = this.activeBtn;
            Window window = SwingUtilities.getWindowAncestor(this.activeBtn);
            if (window != null) {
                Component component;
                FocusTraversalPolicy focusTraversalPolicy = window.getFocusTraversalPolicy();
                Component component2 = component = bl ? focusTraversalPolicy.getComponentAfter(window, this.activeBtn) : focusTraversalPolicy.getComponentBefore(window, this.activeBtn);
                if (this.containsInGroup(component)) {
                    jRadioButton = bl ? this.lastBtn : this.firstBtn;
                }
            }
            return jRadioButton;
        }

        boolean getButtonGroupInfo() {
            if (this.activeBtn == null) {
                return false;
            }
            this.btnsInGroup.clear();
            ButtonModel buttonModel = this.activeBtn.getModel();
            if (!(buttonModel instanceof DefaultButtonModel)) {
                return false;
            }
            DefaultButtonModel defaultButtonModel = (DefaultButtonModel)buttonModel;
            ButtonGroup buttonGroup = defaultButtonModel.getGroup();
            if (buttonGroup == null) {
                return false;
            }
            Enumeration<AbstractButton> enumeration = buttonGroup.getElements();
            if (enumeration == null) {
                return false;
            }
            while (enumeration.hasMoreElements()) {
                AbstractButton abstractButton = enumeration.nextElement();
                if (!BasicRadioButtonUI.this.isValidRadioButtonObj(abstractButton)) continue;
                this.btnsInGroup.add((JRadioButton)abstractButton);
                if (null == this.firstBtn) {
                    this.firstBtn = (JRadioButton)abstractButton;
                }
                if (this.activeBtn == abstractButton) {
                    this.srcFound = true;
                } else if (!this.srcFound) {
                    this.previousBtn = (JRadioButton)abstractButton;
                } else if (this.nextBtn == null) {
                    this.nextBtn = (JRadioButton)abstractButton;
                }
                this.lastBtn = (JRadioButton)abstractButton;
            }
            return true;
        }

        void selectNewButton(boolean bl) {
            if (!this.getButtonGroupInfo()) {
                return;
            }
            if (this.srcFound) {
                JRadioButton jRadioButton = null;
                if (bl) {
                    jRadioButton = null == this.nextBtn ? this.firstBtn : this.nextBtn;
                } else {
                    JRadioButton jRadioButton2 = jRadioButton = null == this.previousBtn ? this.lastBtn : this.previousBtn;
                }
                if (jRadioButton != null && jRadioButton != this.activeBtn) {
                    ButtonModel buttonModel = jRadioButton.getModel();
                    buttonModel.setPressed(true);
                    buttonModel.setArmed(true);
                    jRadioButton.requestFocusInWindow();
                    jRadioButton.setSelected(true);
                    buttonModel.setPressed(false);
                    buttonModel.setArmed(false);
                }
            }
        }

        void jumpToNextComponent(boolean bl) {
            if (!this.getButtonGroupInfo()) {
                if (this.activeBtn != null) {
                    this.lastBtn = this.activeBtn;
                    this.firstBtn = this.activeBtn;
                } else {
                    return;
                }
            }
            JRadioButton jRadioButton = this.activeBtn;
            Component component = this.getFocusTransferBaseComponent(bl);
            if (component != null) {
                if (bl) {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent(component);
                } else {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent(component);
                }
            }
        }
    }

    private class SelectNextBtn
    extends AbstractAction {
        public SelectNextBtn() {
            super("Next");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BasicRadioButtonUI.this.selectRadioButton(actionEvent, true);
        }
    }

    private class SelectPreviousBtn
    extends AbstractAction {
        public SelectPreviousBtn() {
            super("Previous");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BasicRadioButtonUI.this.selectRadioButton(actionEvent, false);
        }
    }
}

