/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import sun.misc.Unsafe;
import sun.reflect.CallerSensitive;
import sun.reflect.Reflection;
import sun.reflect.misc.ReflectUtil;

public abstract class AtomicLongFieldUpdater<T> {
    @CallerSensitive
    public static <U> AtomicLongFieldUpdater<U> newUpdater(Class<U> clazz, String string) {
        Class clazz2 = Reflection.getCallerClass();
        if (AtomicLong.VM_SUPPORTS_LONG_CAS) {
            return new CASUpdater<U>(clazz, string, clazz2);
        }
        return new LockedUpdater<U>(clazz, string, clazz2);
    }

    protected AtomicLongFieldUpdater() {
    }

    public abstract boolean compareAndSet(T var1, long var2, long var4);

    public abstract boolean weakCompareAndSet(T var1, long var2, long var4);

    public abstract void set(T var1, long var2);

    public abstract void lazySet(T var1, long var2);

    public abstract long get(T var1);

    public long getAndSet(T t, long l) {
        long l2;
        while (!this.compareAndSet(t, l2 = this.get(t), l)) {
        }
        return l2;
    }

    public long getAndIncrement(T t) {
        long l;
        long l2;
        while (!this.compareAndSet(t, l2 = this.get(t), l = l2 + 1L)) {
        }
        return l2;
    }

    public long getAndDecrement(T t) {
        long l;
        long l2;
        while (!this.compareAndSet(t, l2 = this.get(t), l = l2 - 1L)) {
        }
        return l2;
    }

    public long getAndAdd(T t, long l) {
        long l2;
        long l3;
        while (!this.compareAndSet(t, l3 = this.get(t), l2 = l3 + l)) {
        }
        return l3;
    }

    public long incrementAndGet(T t) {
        long l;
        long l2;
        while (!this.compareAndSet(t, l2 = this.get(t), l = l2 + 1L)) {
        }
        return l;
    }

    public long decrementAndGet(T t) {
        long l;
        long l2;
        while (!this.compareAndSet(t, l2 = this.get(t), l = l2 - 1L)) {
        }
        return l;
    }

    public long addAndGet(T t, long l) {
        long l2;
        long l3;
        while (!this.compareAndSet(t, l3 = this.get(t), l2 = l3 + l)) {
        }
        return l2;
    }

    static boolean isAncestor(ClassLoader classLoader, ClassLoader classLoader2) {
        ClassLoader classLoader3 = classLoader;
        do {
            if (classLoader2 != (classLoader3 = classLoader3.getParent())) continue;
            return true;
        } while (classLoader3 != null);
        return false;
    }

    private static boolean isSamePackage(Class<?> clazz, Class<?> clazz2) {
        return clazz.getClassLoader() == clazz2.getClassLoader() && Objects.equals(AtomicLongFieldUpdater.getPackageName(clazz), AtomicLongFieldUpdater.getPackageName(clazz2));
    }

    private static String getPackageName(Class<?> clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        return n != -1 ? string.substring(0, n) : "";
    }

    private static final class LockedUpdater<T>
    extends AtomicLongFieldUpdater<T> {
        private static final Unsafe U = Unsafe.getUnsafe();
        private final long offset;
        private final Class<?> cclass;
        private final Class<T> tclass;

        LockedUpdater(final Class<T> clazz, final String string, Class<?> clazz2) {
            Field field = null;
            int n = 0;
            try {
                field = AccessController.doPrivileged(new PrivilegedExceptionAction<Field>(){

                    @Override
                    public Field run() throws NoSuchFieldException {
                        return clazz.getDeclaredField(string);
                    }
                });
                n = field.getModifiers();
                ReflectUtil.ensureMemberAccess(clazz2, clazz, null, n);
                ClassLoader classLoader = clazz.getClassLoader();
                ClassLoader classLoader2 = clazz2.getClassLoader();
                if (!(classLoader2 == null || classLoader2 == classLoader || classLoader != null && LockedUpdater.isAncestor(classLoader, classLoader2))) {
                    ReflectUtil.checkPackageAccess(clazz);
                }
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw new RuntimeException(privilegedActionException.getException());
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            if (field.getType() != Long.TYPE) {
                throw new IllegalArgumentException("Must be long type");
            }
            if (!Modifier.isVolatile(n)) {
                throw new IllegalArgumentException("Must be volatile type");
            }
            this.cclass = Modifier.isProtected(n) && clazz.isAssignableFrom(clazz2) && !AtomicLongFieldUpdater.isSamePackage(clazz, clazz2) ? clazz2 : clazz;
            this.tclass = clazz;
            this.offset = U.objectFieldOffset(field);
        }

        private final void accessCheck(T t) {
            if (!this.cclass.isInstance(t)) {
                throw this.accessCheckException(t);
            }
        }

        private final RuntimeException accessCheckException(T t) {
            if (this.cclass == this.tclass) {
                return new ClassCastException();
            }
            return new RuntimeException(new IllegalAccessException("Class " + this.cclass.getName() + " can not access a protected member of class " + this.tclass.getName() + " using an instance of " + t.getClass().getName()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final boolean compareAndSet(T t, long l, long l2) {
            this.accessCheck(t);
            LockedUpdater lockedUpdater = this;
            synchronized (lockedUpdater) {
                long l3 = U.getLong(t, this.offset);
                if (l3 != l) {
                    return false;
                }
                U.putLong(t, this.offset, l2);
                return true;
            }
        }

        @Override
        public final boolean weakCompareAndSet(T t, long l, long l2) {
            return this.compareAndSet(t, l, l2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void set(T t, long l) {
            this.accessCheck(t);
            LockedUpdater lockedUpdater = this;
            synchronized (lockedUpdater) {
                U.putLong(t, this.offset, l);
            }
        }

        @Override
        public final void lazySet(T t, long l) {
            this.set(t, l);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final long get(T t) {
            this.accessCheck(t);
            LockedUpdater lockedUpdater = this;
            synchronized (lockedUpdater) {
                return U.getLong(t, this.offset);
            }
        }
    }

    private static final class CASUpdater<T>
    extends AtomicLongFieldUpdater<T> {
        private static final Unsafe U = Unsafe.getUnsafe();
        private final long offset;
        private final Class<?> cclass;
        private final Class<T> tclass;

        CASUpdater(final Class<T> clazz, final String string, Class<?> clazz2) {
            Field field = null;
            int n = 0;
            try {
                field = AccessController.doPrivileged(new PrivilegedExceptionAction<Field>(){

                    @Override
                    public Field run() throws NoSuchFieldException {
                        return clazz.getDeclaredField(string);
                    }
                });
                n = field.getModifiers();
                ReflectUtil.ensureMemberAccess(clazz2, clazz, null, n);
                ClassLoader classLoader = clazz.getClassLoader();
                ClassLoader classLoader2 = clazz2.getClassLoader();
                if (!(classLoader2 == null || classLoader2 == classLoader || classLoader != null && CASUpdater.isAncestor(classLoader, classLoader2))) {
                    ReflectUtil.checkPackageAccess(clazz);
                }
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw new RuntimeException(privilegedActionException.getException());
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            if (field.getType() != Long.TYPE) {
                throw new IllegalArgumentException("Must be long type");
            }
            if (!Modifier.isVolatile(n)) {
                throw new IllegalArgumentException("Must be volatile type");
            }
            this.cclass = Modifier.isProtected(n) && clazz.isAssignableFrom(clazz2) && !AtomicLongFieldUpdater.isSamePackage(clazz, clazz2) ? clazz2 : clazz;
            this.tclass = clazz;
            this.offset = U.objectFieldOffset(field);
        }

        private final void accessCheck(T t) {
            if (!this.cclass.isInstance(t)) {
                this.throwAccessCheckException(t);
            }
        }

        private final void throwAccessCheckException(T t) {
            if (this.cclass == this.tclass) {
                throw new ClassCastException();
            }
            throw new RuntimeException(new IllegalAccessException("Class " + this.cclass.getName() + " can not access a protected member of class " + this.tclass.getName() + " using an instance of " + t.getClass().getName()));
        }

        @Override
        public final boolean compareAndSet(T t, long l, long l2) {
            this.accessCheck(t);
            return U.compareAndSwapLong(t, this.offset, l, l2);
        }

        @Override
        public final boolean weakCompareAndSet(T t, long l, long l2) {
            this.accessCheck(t);
            return U.compareAndSwapLong(t, this.offset, l, l2);
        }

        @Override
        public final void set(T t, long l) {
            this.accessCheck(t);
            U.putLongVolatile(t, this.offset, l);
        }

        @Override
        public final void lazySet(T t, long l) {
            this.accessCheck(t);
            U.putOrderedLong(t, this.offset, l);
        }

        @Override
        public final long get(T t) {
            this.accessCheck(t);
            return U.getLongVolatile(t, this.offset);
        }
    }
}

