/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.SymmetricCipher;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import javax.crypto.AEADBadTagException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;

abstract class FeedbackCipher {
    final SymmetricCipher embeddedCipher;
    final int blockSize;
    byte[] iv;

    FeedbackCipher(SymmetricCipher symmetricCipher) {
        this.embeddedCipher = symmetricCipher;
        this.blockSize = symmetricCipher.getBlockSize();
    }

    final SymmetricCipher getEmbeddedCipher() {
        return this.embeddedCipher;
    }

    final int getBlockSize() {
        return this.blockSize;
    }

    abstract String getFeedback();

    abstract void save();

    abstract void restore();

    abstract void init(boolean var1, String var2, byte[] var3, byte[] var4) throws InvalidKeyException, InvalidAlgorithmParameterException;

    final byte[] getIV() {
        return this.iv;
    }

    int getBufferedLength() {
        return 0;
    }

    abstract void reset();

    abstract int encrypt(byte[] var1, int var2, int var3, byte[] var4, int var5);

    int encryptFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws IllegalBlockSizeException, ShortBufferException {
        return this.encrypt(byArray, n, n2, byArray2, n3);
    }

    abstract int decrypt(byte[] var1, int var2, int var3, byte[] var4, int var5);

    int decryptFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws IllegalBlockSizeException, AEADBadTagException, ShortBufferException {
        return this.decrypt(byArray, n, n2, byArray2, n3);
    }

    void updateAAD(byte[] byArray, int n, int n2) {
        throw new IllegalStateException("No AAD accepted");
    }
}

