/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.asm.sparc;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import sun.jvm.hotspot.asm.Disassembler;
import sun.jvm.hotspot.asm.Instruction;
import sun.jvm.hotspot.asm.InstructionVisitor;
import sun.jvm.hotspot.asm.RTLDataTypes;
import sun.jvm.hotspot.asm.RTLOperations;
import sun.jvm.hotspot.asm.sparc.CallDecoder;
import sun.jvm.hotspot.asm.sparc.IllegalInstructionDecoder;
import sun.jvm.hotspot.asm.sparc.InstructionDecoder;
import sun.jvm.hotspot.asm.sparc.SPARCInstructionFactory;
import sun.jvm.hotspot.asm.sparc.SPARCOpcodes;

public abstract class SPARCDisassembler
extends Disassembler
implements SPARCOpcodes,
RTLDataTypes,
RTLOperations {
    protected static Map instructionCache = new HashMap();
    protected final SPARCInstructionFactory factory;
    protected static InstructionDecoder illegalDecoder = new IllegalInstructionDecoder();
    protected static InstructionDecoder callDecoder = new CallDecoder();

    public SPARCDisassembler(long startPc, byte[] code, SPARCInstructionFactory factory) {
        super(startPc, code);
        this.factory = factory;
    }

    protected Instruction decodeFormat1Instruction(int instruction) {
        return callDecoder.decode(instruction, this.factory);
    }

    protected abstract InstructionDecoder getFormat2Decoder(int var1);

    protected Instruction decodeFormat2Instruction(int instruction) {
        int op2 = (instruction & 0x1C00000) >>> 22;
        InstructionDecoder decoder = this.getFormat2Decoder(op2);
        return decoder.decode(instruction, this.factory);
    }

    protected static int getOp3(int instruction) {
        return (instruction & 0x1F80000) >>> 19;
    }

    protected static int getOp3Row(int op3) {
        return op3 & 0xF;
    }

    protected static int getOp3Column(int op3) {
        return op3 >>> 4 & 3;
    }

    protected abstract InstructionDecoder getFormat3Decoder(int var1, int var2);

    protected Instruction decodeFormat3Instruction(int instruction) {
        int op3 = SPARCDisassembler.getOp3(instruction);
        int row = SPARCDisassembler.getOp3Row(op3);
        int column = SPARCDisassembler.getOp3Column(op3);
        return this.getFormat3Decoder(row, column).decode(instruction, this.factory);
    }

    protected abstract InstructionDecoder getFormat3ADecoder(int var1, int var2);

    protected Instruction decodeFormat3AInstruction(int instruction) {
        int op3 = SPARCDisassembler.getOp3(instruction);
        int row = SPARCDisassembler.getOp3Row(op3);
        int column = SPARCDisassembler.getOp3Column(op3);
        return this.getFormat3ADecoder(row, column).decode(instruction, this.factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decode(InstructionVisitor visitor) {
        visitor.prologue();
        try {
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(this.code));
            int instruction = -1;
            int format = -1;
            Instruction instr = null;
            for (int len = 0; len < this.code.length; len += 4) {
                instr = null;
                instruction = dis.readInt();
                instr = (Instruction)instructionCache.get(new Integer(instruction));
                if (instr == null) {
                    format = (instruction & 0xC0000000) >>> 30;
                    switch (format) {
                        case 0: {
                            instr = this.decodeFormat2Instruction(instruction);
                            break;
                        }
                        case 1: {
                            instr = this.decodeFormat1Instruction(instruction);
                            break;
                        }
                        case 2: {
                            instr = this.decodeFormat3AInstruction(instruction);
                            break;
                        }
                        case 3: {
                            instr = this.decodeFormat3Instruction(instruction);
                        }
                    }
                    instructionCache.put(new Integer(instruction), instr);
                }
                visitor.visit(this.startPc + (long)len, instr);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            visitor.epilogue();
        }
    }
}

