/*
 * Copyright (c) 2012, 2020, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_is extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Moscow = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Moskvu",
               "",
               "Sumart\u00edmi \u00ed Moskvu",
               "",
               "Moskvut\u00edmi",
               "",
            };
        final String[] Pakistan = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Pakistan",
               "",
               "Sumart\u00edmi \u00ed Pakistan",
               "",
               "Pakistant\u00edmi",
               "",
            };
        final String[] Magadan = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Magadan",
               "",
               "Sumart\u00edmi \u00ed Magadan",
               "",
               "T\u00edmi \u00ed Magadan",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Mi\u00f0-Evr\u00f3pu",
               "",
               "Sumart\u00edmi \u00ed Mi\u00f0-Evr\u00f3pu",
               "",
               "Mi\u00f0-Evr\u00f3put\u00edmi",
               "",
            };
        final String[] America_Eastern = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed austurhluta Bandar\u00edkjanna og Kanada",
               "",
               "Sumart\u00edmi \u00ed austurhluta Bandar\u00edkjanna og Kanada",
               "",
               "T\u00edmi \u00ed austurhluta Bandar\u00edkjanna og Kanada",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Sta\u00f0alt\u00edmi \u00e1 Lord Howe-eyju",
               "",
               "Sumart\u00edmi \u00e1 Lord Howe-eyju",
               "",
               "T\u00edmi \u00e1 Lord Howe-eyju",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Sta\u00f0alt\u00edmi \u00e1 N\u00fdja-Sj\u00e1landi",
               "",
               "Sumart\u00edmi \u00e1 N\u00fdja-Sj\u00e1landi",
               "",
               "T\u00edmi \u00e1 N\u00fdja-Sj\u00e1landi",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Indlandshafst\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Yakutsk",
               "",
               "Sumart\u00edmi \u00ed Yakutsk",
               "",
               "T\u00edminn \u00ed Yakutsk",
               "",
            };
        final String[] East_Timor = new String[] {
               "T\u00edminn \u00e1 T\u00edmor-Leste",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kosrae = new String[] {
               "Kosrae-t\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Eastern = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Austur-Evr\u00f3pu",
               "",
               "Sumart\u00edmi \u00ed Austur-Evr\u00f3pu",
               "",
               "Austur-Evr\u00f3put\u00edmi",
               "",
            };
        final String[] Argentina_Western = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Vestur-Argent\u00ednu",
               "",
               "Sumart\u00edmi \u00ed Vestur-Argent\u00ednu",
               "",
               "Vestur-Argent\u00ednut\u00edmi",
               "",
            };
        final String[] Ponape = new String[] {
               "Ponape-t\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Bolivia = new String[] {
               "B\u00f3liv\u00edut\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Sta\u00f0alt\u00edmi \u00e1 Sankti Pierre og Miquelon",
               "",
               "Sumart\u00edmi \u00e1 Sankti Pierre og Miquelon",
               "",
               "T\u00edmi \u00e1 Sankti Pierre og Miquelon",
               "",
            };
        final String[] Indochina = new String[] {
               "Ind\u00f3k\u00ednat\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Yekaterinborg",
               "",
               "Sumart\u00edmi \u00ed Yekaterinburg",
               "",
               "T\u00edmi \u00ed Yekaterinburg",
               "",
            };
        final String[] Maldives = new String[] {
               "Mald\u00edveyja-t\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "Tah\u00edt\u00ed-t\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "T\u00edmi \u00e1 Wallis- og F\u00fat\u00fanaeyjum",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Africa_Southern = new String[] {
               "Su\u00f0ur-Afr\u00edkut\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Syowa = new String[] {
               "Syowa-t\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "L\u00ednueyja-t\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed \u00dasbekistan",
               "",
               "Sumart\u00edmi \u00ed \u00dasbekistan",
               "",
               "\u00dasbekistan-t\u00edmi",
               "",
            };
        final String[] Mongolia = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed \u00dalan Bator",
               "",
               "Sumart\u00edmi \u00ed \u00dalan Bator",
               "",
               "T\u00edmi \u00ed \u00dalan Bator",
               "",
            };
        final String[] America_Central = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed mi\u00f0hluta Bandar\u00edkjanna og Kanada",
               "",
               "Sumart\u00edmi \u00ed mi\u00f0hluta Bandar\u00edkjanna og Kanada",
               "",
               "T\u00edmi \u00ed mi\u00f0hluta Bandar\u00edkjanna og Kanada",
               "",
            };
        final String[] Niue = new String[] {
               "Niue-t\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "T\u00edmi \u00e1 Wake-eyju",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Falkland = new String[] {
               "Sta\u00f0alt\u00edmi \u00e1 Falklandseyjum",
               "",
               "Sumart\u00edmi \u00e1 Falklandseyjum",
               "",
               "Falklandseyjat\u00edmi",
               "",
            };
        final String[] Apia = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Ap\u00eda",
               "",
               "Sumart\u00edmi \u00ed Ap\u00eda",
               "",
               "T\u00edmi \u00ed Ap\u00eda",
               "",
            };
        final String[] Bhutan = new String[] {
               "B\u00fatant\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nauru = new String[] {
               "N\u00e1r\u00fa-t\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan_Western = new String[] {
               "T\u00edmi \u00ed Vestur-Kasakstan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Christmas = new String[] {
               "J\u00f3laeyjart\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Reunion = new String[] {
               "R\u00e9union-t\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cocos = new String[] {
               "K\u00f3koseyjat\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Chatham",
               "",
               "Sumart\u00edmi \u00ed Chatham",
               "",
               "Chatham-t\u00edmi",
               "",
            };
        final String[] Vostok = new String[] {
               "Vostok-t\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Argent\u00ednu",
               "",
               "Sumart\u00edmi \u00ed Argent\u00ednu",
               "",
               "Argent\u00ednut\u00edmi",
               "",
            };
        final String[] Gambier = new String[] {
               "Gambier-t\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Galapagos-t\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Venes\u00faelat\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Phoenix_Islands = new String[] {
               "F\u00f6nixeyjat\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Sta\u00f0alt\u00edmi \u00e1 Gr\u00e6nh\u00f6f\u00f0aeyjum",
               "",
               "Sumart\u00edmi \u00e1 Gr\u00e6nh\u00f6f\u00f0aeyjum",
               "",
               "Gr\u00e6nh\u00f6f\u00f0aeyjat\u00edmi",
               "",
            };
        final String[] Norfolk = new String[] {
               "T\u00edmi \u00e1 Norfolk-eyju",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Sta\u00f0alt\u00edmi \u00e1 Sam\u00f3a",
               "",
               "Sumart\u00edmi \u00e1 Sam\u00f3a",
               "",
               "Sam\u00f3a-t\u00edmi",
               "",
            };
        final String[] Davis = new String[] {
               "Davis-t\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cuba = new String[] {
               "Sta\u00f0alt\u00edmi \u00e1 K\u00fabu",
               "",
               "Sumart\u00edmi \u00e1 K\u00fabu",
               "",
               "K\u00fabut\u00edmi",
               "",
            };
        final String[] GMT = new String[] {
               "Greenwich-sta\u00f0alt\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Philippines = new String[] {
               "Sta\u00f0alt\u00edmi \u00e1 Filippseyjum",
               "",
               "Sumart\u00edmi \u00e1 Filippseyjum",
               "",
               "Filippseyjat\u00edmi",
               "",
            };
        final String[] French_Southern = new String[] {
               "T\u00edmi \u00e1 fr\u00f6nsku su\u00f0urhafssv\u00e6\u00f0um og Su\u00f0urskautslandssv\u00e6\u00f0i",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed N\u00fdju-Kaled\u00f3n\u00edu",
               "",
               "Sumart\u00edmi \u00ed N\u00fdju-Kaled\u00f3n\u00edu",
               "",
               "T\u00edmi \u00ed N\u00fdju-Kaled\u00f3n\u00edu",
               "",
            };
        final String[] Brunei = new String[] {
               "Br\u00faneit\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Iran = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed \u00cdran",
               "",
               "Sumart\u00edmi \u00ed \u00cdran",
               "",
               "\u00cdranst\u00edmi",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Tadsj\u00edkistan-t\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Sta\u00f0alt\u00edmi \u00e1 Tonga",
               "",
               "Sumart\u00edmi \u00e1 Tonga",
               "",
               "Tongat\u00edmi",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Bangladess",
               "",
               "Sumart\u00edmi \u00ed Bangladess",
               "",
               "Bangladess-t\u00edmi",
               "",
            };
        final String[] Peru = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Per\u00fa",
               "",
               "Sumart\u00edmi \u00ed Per\u00fa",
               "",
               "Per\u00fat\u00edmi",
               "",
            };
        final String[] Greenland_Eastern = new String[] {
               "Sta\u00f0alt\u00edmi \u00e1 Austur-Gr\u00e6nlandi",
               "",
               "Sumart\u00edmi \u00e1 Austur-Gr\u00e6nlandi",
               "",
               "Austur-Gr\u00e6nlandst\u00edmi",
               "",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Austur-Ind\u00f3nes\u00edut\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Kirgistan-t\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Eastern = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Austur-\u00c1stral\u00edu",
               "",
               "Sumart\u00edmi \u00ed Austur-\u00c1stral\u00edu",
               "",
               "T\u00edmi \u00ed Austur-\u00c1stral\u00edu",
               "",
            };
        final String[] French_Guiana = new String[] {
               "T\u00edmi \u00ed Fr\u00f6nsku Gv\u00e6jana",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Colombia = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed K\u00f3lumb\u00edu",
               "",
               "Sumart\u00edmi \u00ed K\u00f3lumb\u00edu",
               "",
               "K\u00f3lumb\u00edut\u00edmi",
               "",
            };
        final String[] Chile = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed S\u00edle",
               "",
               "Sumart\u00edmi \u00ed S\u00edle",
               "",
               "S\u00edlet\u00edmi",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "T\u00edmi \u00e1 Gilbert-eyjum",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Irkutsk",
               "",
               "Sumart\u00edmi \u00ed Irkutsk",
               "",
               "T\u00edmi \u00ed Irkutsk",
               "",
            };
        final String[] Georgia = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Georg\u00edu",
               "",
               "Sumart\u00edmi \u00ed Georg\u00edu",
               "",
               "Georg\u00edut\u00edmi",
               "",
            };
        final String[] Choibalsan = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Choibalsan",
               "",
               "Sumart\u00edmi \u00ed Choibalsan",
               "",
               "T\u00edmi \u00ed Choibalsan",
               "",
            };
        final String[] China = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed K\u00edna",
               "",
               "Sumart\u00edmi \u00ed K\u00edna",
               "",
               "K\u00ednat\u00edmi",
               "",
            };
        final String[] Armenia = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Armen\u00edu",
               "",
               "Sumart\u00edmi \u00ed Armen\u00edu",
               "",
               "Armen\u00edut\u00edmi",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Mi\u00f0-Afr\u00edkut\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Japan = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Japan",
               "",
               "Sumart\u00edmi \u00ed Japan",
               "",
               "Japanst\u00edmi",
               "",
            };
        final String[] Taipei = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Taipei",
               "",
               "Sumart\u00edmi \u00ed Taipei",
               "",
               "Taipei-t\u00edmi",
               "",
            };
        final String[] Hovd = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Hovd",
               "",
               "Sumart\u00edmi \u00ed Hovd",
               "",
               "Hovd-t\u00edmi",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed mi\u00f0vesturhluta \u00c1stral\u00edu",
               "",
               "Sumart\u00edmi \u00ed mi\u00f0vesturhluta \u00c1stral\u00edu",
               "",
               "T\u00edmi \u00ed mi\u00f0vesturhluta \u00c1stral\u00edu",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Sakhalin",
               "",
               "Sumart\u00edmi \u00ed Sakhalin",
               "",
               "T\u00edmi \u00ed Sakhalin",
               "",
            };
        final String[] Paraguay = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Paragv\u00e6",
               "",
               "Sumart\u00edmi \u00ed Paragv\u00e6",
               "",
               "Paragv\u00e6t\u00edmi",
               "",
            };
        final String[] Malaysia = new String[] {
               "Malas\u00edut\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Samr\u00e6mdur al\u00fej\u00f3\u00f0legur t\u00edmi",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Sta\u00f0alt\u00edmi \u00e1 M\u00e1rit\u00edus",
               "",
               "Sumart\u00edmi \u00e1 M\u00e1rit\u00edus",
               "",
               "M\u00e1rit\u00edust\u00edmi",
               "",
            };
        final String[] Africa_Eastern = new String[] {
               "Austur-Afr\u00edkut\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Sal\u00f3monseyjat\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Marshall_Islands = new String[] {
               "T\u00edmi \u00e1 Marshall-eyjum",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Sta\u00f0alt\u00edmi \u00e1 N\u00fdfundnalandi",
               "",
               "Sumart\u00edmi \u00e1 N\u00fdfundnalandi",
               "",
               "T\u00edmi \u00e1 N\u00fdfundnalandi",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Afganistant\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Hong Kong",
               "",
               "Sumart\u00edmi \u00ed Hong Kong",
               "",
               "Hong Kong-t\u00edmi",
               "",
            };
        final String[] Atlantic = new String[] {
               "Sta\u00f0alt\u00edmi \u00e1 Atlantshafssv\u00e6\u00f0inu",
               "",
               "Sumart\u00edmi \u00e1 Atlantshafssv\u00e6\u00f0inu",
               "",
               "T\u00edmi \u00e1 Atlantshafssv\u00e6\u00f0inu",
               "",
            };
        final String[] Israel = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed \u00cdsrael",
               "",
               "Sumart\u00edmi \u00ed \u00cdsrael",
               "",
               "\u00cdsraelst\u00edmi",
               "",
            };
        final String[] Indonesia_Central = new String[] {
               "Mi\u00f0-Ind\u00f3nes\u00edut\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Omsk",
               "",
               "Sumart\u00edmi \u00ed Omsk",
               "",
               "T\u00edminn \u00ed Omsk",
               "",
            };
        final String[] Seychelles = new String[] {
               "Seychelles-eyjat\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed \u00dar\u00fagv\u00e6",
               "",
               "Sumart\u00edmi \u00ed \u00dar\u00fagv\u00e6",
               "",
               "\u00dar\u00fagv\u00e6t\u00edmi",
               "",
            };
        final String[] Nepal = new String[] {
               "Nepalt\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Truk = new String[] {
               "Chuuk-t\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Sta\u00f0alt\u00edmi \u00e1 Van\u00faat\u00fa",
               "",
               "Sumart\u00edmi \u00e1 Van\u00faat\u00fa",
               "",
               "Van\u00faat\u00fa-t\u00edmi",
               "",
            };
        final String[] Novosibirsk = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Novosibirsk",
               "",
               "Sumart\u00edmi \u00ed Novosibirsk",
               "",
               "T\u00edmi \u00ed Novosibirsk",
               "",
            };
        final String[] Singapore = new String[] {
               "Singap\u00fart\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azores = new String[] {
               "Sta\u00f0alt\u00edmi \u00e1 As\u00f3reyjum",
               "",
               "Sumart\u00edmi \u00e1 As\u00f3reyjum",
               "",
               "As\u00f3reyjat\u00edmi",
               "",
            };
        final String[] Suriname = new String[] {
               "S\u00farinamt\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Krasnoyarsk",
               "",
               "Sumart\u00edmi \u00ed Krasnoyarsk",
               "",
               "T\u00edmi \u00ed Krasnoyarsk",
               "",
            };
        final String[] Myanmar = new String[] {
               "Mjanmar-t\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Amazon = new String[] {
               "Sta\u00f0alt\u00edmi \u00e1 Amas\u00f3nsv\u00e6\u00f0inu",
               "",
               "Sumart\u00edmi \u00e1 Amas\u00f3nsv\u00e6\u00f0inu",
               "",
               "Amas\u00f3nt\u00edmi",
               "",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "T\u00edmi \u00ed Austur-Kasakstan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Fiji = new String[] {
               "Sta\u00f0alt\u00edmi \u00e1 F\u00eddj\u00edeyjum",
               "",
               "Sumart\u00edmi \u00e1 F\u00eddj\u00edeyjum",
               "",
               "F\u00eddj\u00edeyjat\u00edmi",
               "",
            };
        final String[] Kamchatka = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Petropavlovsk-Kamchatski",
               "",
               "Sumart\u00edmi \u00ed Petropavlovsk-Kamchatski",
               "",
               "T\u00edmi \u00ed Petropavlovsk-Kamchatski",
               "",
            };
        final String[] Tuvalu = new String[] {
               "T\u00faval\u00fat\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Macquarie = new String[] {
               "Macquarie-eyjart\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Sta\u00f0alt\u00edmi \u00e1 Hava\u00ed og Ale\u00fata",
               "",
               "Sumart\u00edmi \u00e1 Hava\u00ed og Ale\u00fata",
               "",
               "T\u00edmi \u00e1 Hava\u00ed og Ale\u00fata",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Mi\u00f0-\u00c1stral\u00edu",
               "",
               "Sumart\u00edmi \u00ed Mi\u00f0-\u00c1stral\u00edu",
               "",
               "T\u00edmi \u00ed Mi\u00f0-\u00c1stral\u00edu",
               "",
            };
        final String[] America_Pacific = new String[] {
               "Sta\u00f0alt\u00edmi \u00e1 Kyrrahafssv\u00e6\u00f0inu",
               "",
               "Sumart\u00edmi \u00e1 Kyrrahafssv\u00e6\u00f0inu",
               "",
               "T\u00edmi \u00e1 Kyrrahafssv\u00e6\u00f0inu",
               "",
            };
        final String[] Turkmenistan = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed T\u00farkmenistan",
               "",
               "Sumart\u00edmi \u00ed T\u00farkmenistan",
               "",
               "T\u00farkmenistan-t\u00edmi",
               "",
            };
        final String[] Europe_Western = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Vestur-Evr\u00f3pu",
               "",
               "Sumart\u00edmi \u00ed Vestur-Evr\u00f3pu",
               "",
               "Vestur-Evr\u00f3put\u00edmi",
               "",
            };
        final String[] Guyana = new String[] {
               "Gv\u00e6janat\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Pitcairn-t\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Rothera-t\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Pal\u00e1t\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Aserba\u00eddsjan",
               "",
               "Sumart\u00edmi \u00ed Aserba\u00eddsjan",
               "",
               "Aserba\u00eddsjant\u00edmi",
               "",
            };
        final String[] Mawson = new String[] {
               "Mawson-t\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mexico_Pacific = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Mex\u00edk\u00f3 \u00e1 Kyrrahafssv\u00e6\u00f0inu",
               "",
               "Sumart\u00edmi \u00ed Mex\u00edk\u00f3 \u00e1 Kyrrahafssv\u00e6\u00f0inu",
               "",
               "Kyrrahafst\u00edmi \u00ed Mex\u00edk\u00f3",
               "",
            };
        final String[] Africa_Western = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Vestur-Afr\u00edku",
               "",
               "Sumart\u00edmi \u00ed Vestur-Afr\u00edku",
               "",
               "Vestur-Afr\u00edkut\u00edmi",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Su\u00f0ur-Georg\u00edut\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Volgograd",
               "",
               "Sumart\u00edmi \u00ed Volgograd",
               "",
               "T\u00edmi \u00ed Volgograd",
               "",
            };
        final String[] Easter = new String[] {
               "Sta\u00f0alt\u00edmi \u00e1 P\u00e1skaeyju",
               "",
               "Sumart\u00edmi \u00e1 P\u00e1skaeyju",
               "",
               "P\u00e1skaeyjut\u00edmi",
               "",
            };
        final String[] Mexico_Northwest = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Nor\u00f0vestur-Mex\u00edk\u00f3",
               "",
               "Sumart\u00edmi \u00ed Nor\u00f0vestur-Mex\u00edk\u00f3",
               "",
               "T\u00edmi \u00ed Nor\u00f0vestur-Mex\u00edk\u00f3",
               "",
            };
        final String[] DumontDUrville = new String[] {
               "T\u00edmi \u00e1 Dumont-d\u2019Urville",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Greenland_Western = new String[] {
               "Sta\u00f0alt\u00edmi \u00e1 Vestur-Gr\u00e6nlandi",
               "",
               "Sumart\u00edmi \u00e1 Vestur-Gr\u00e6nlandi",
               "",
               "Vestur-Gr\u00e6nlandst\u00edmi",
               "",
            };
        final String[] Ecuador = new String[] {
               "Ekvadort\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gulf = new String[] {
               "Sta\u00f0alt\u00edmi vi\u00f0 Persafl\u00f3a",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Korea = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed K\u00f3reu",
               "",
               "Sumart\u00edmi \u00ed K\u00f3reu",
               "",
               "K\u00f3reut\u00edmi",
               "",
            };
        final String[] Australia_Western = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Vestur-\u00c1stral\u00edu",
               "",
               "Sumart\u00edmi \u00ed Vestur-\u00c1stral\u00edu",
               "",
               "T\u00edmi \u00ed Vestur-\u00c1stral\u00edu",
               "",
            };
        final String[] Indonesia_Western = new String[] {
               "Vestur-Ind\u00f3nes\u00edut\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Klettafj\u00f6llum",
               "",
               "Sumart\u00edmi \u00ed Klettafj\u00f6llum",
               "",
               "T\u00edmi \u00ed Klettafj\u00f6llum",
               "",
            };
        final String[] Marquesas = new String[] {
               "T\u00edmi \u00e1 Markgreifafr\u00fareyjum",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Arab\u00edu",
               "",
               "Sumart\u00edmi \u00ed Arab\u00edu",
               "",
               "Arab\u00edut\u00edmi",
               "",
            };
        final String[] Alaska = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Alaska",
               "",
               "Sumart\u00edmi \u00ed Alaska",
               "",
               "T\u00edmi \u00ed Alaska",
               "",
            };
        final String[] Vladivostok = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Vladivostok",
               "",
               "Sumart\u00edmi \u00ed Vladivostok",
               "",
               "T\u00edmi \u00ed Vladivostok",
               "",
            };
        final String[] Chamorro = new String[] {
               "Chamorro-sta\u00f0alt\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "T\u00f3kel\u00e1-t\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "T\u00edmi \u00e1 Pap\u00faa N\u00fdju-G\u00edneu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Noronha = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Fernando de Noronha",
               "",
               "Sumart\u00edmi \u00ed Fernando de Noronha",
               "",
               "T\u00edmi \u00ed Fernando de Noronha",
               "",
            };
        final String[] Brasilia = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Brasil\u00edu",
               "",
               "Sumart\u00edmi \u00ed Brasil\u00edu",
               "",
               "Brasil\u00edut\u00edmi",
               "",
            };
        final String[] Anadyr = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Anadyr",
               "",
               "Sumart\u00edmi \u00ed Anadyr",
               "",
               "T\u00edmi \u00ed Anadyr",
               "",
            };
        final String[] Samara = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Samara",
               "",
               "Sumart\u00edmi \u00ed Samara",
               "",
               "T\u00edmi \u00ed Samara",
               "",
            };
        final String[] India = new String[] {
               "Indlandst\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cook = new String[] {
               "Sta\u00f0alt\u00edmi \u00e1 Cooks-eyjum",
               "",
               "H\u00e1lfsumart\u00edmi \u00e1 Cooks-eyjum",
               "",
               "Cooks-eyjat\u00edmi",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "Asia/Aden", Arabian },
            { "timezone.excity.America/Phoenix", "Phoenix" },
            { "timezone.excity.Asia/Katmandu", "Katmand\u00fa" },
            { "timezone.excity.America/Antigua", "Ant\u00edgva" },
            { "timezone.excity.Europe/Ljubljana", "Ljubljana" },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "timezone.excity.Pacific/Marquesas", "Marquesas-eyjar" },
            { "America/El_Salvador", America_Central },
            { "timezone.excity.America/Buenos_Aires", "Buenos Aires" },
            { "Asia/Pontianak", Indonesia_Western },
            { "timezone.excity.America/Danmarkshavn", "Danmarkshavn" },
            { "timezone.excity.America/Anchorage", "Anchorage" },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Europe/London",
                new String[] {
                    "Greenwich-sta\u00f0alt\u00edmi",
                    "",
                    "Sumart\u00edmi \u00ed Bretlandi",
                    "",
                    "",
                    "",
                }
            },
            { "timezone.excity.Antarctica/Vostok", "Vostok" },
            { "America/Panama", America_Eastern },
            { "JST", Japan },
            { "timezone.excity.Pacific/Fiji", "Fidj\u00ed" },
            { "timezone.excity.Europe/Gibraltar", "G\u00edbraltar" },
            { "Europe/Jersey", GMT },
            { "timezone.excity.Africa/Malabo", "Malabo" },
            { "Europe/Luxembourg", Europe_Central },
            { "timezone.excity.Africa/Libreville", "Libreville" },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "timezone.excity.Africa/Dakar", "Dakar" },
            { "Atlantic/St_Helena", GMT },
            { "timezone.excity.Africa/Addis_Ababa", "Addis Ababa" },
            { "timezone.excity.Africa/Kinshasa", "Kinshasa" },
            { "timezone.excity.Asia/Dushanbe", "Dushanbe" },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", America_Eastern },
            { "Asia/Samarkand", Uzbekistan },
            { "timezone.excity.Europe/Tallinn", "Tallinn" },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "BET", Brasilia },
            { "timezone.excity.Pacific/Guam", "Gvam" },
            { "timezone.excity.Europe/Vaduz", "Vaduz" },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "timezone.excity.America/Santa_Isabel", "Santa Isabel" },
            { "timezone.excity.Asia/Barnaul", "Barnaul" },
            { "Antarctica/Syowa", Syowa },
            { "timezone.excity.Africa/Maseru", "Maseru" },
            { "Pacific/Palau", Palau },
            { "timezone.excity.Europe/London", "Lund\u00fanir" },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Central },
            { "Asia/Karachi", Pakistan },
            { "timezone.excity.Pacific/Pitcairn", "Pitcairn" },
            { "Australia/Perth", Australia_Western },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "timezone.excity.Asia/Krasnoyarsk", "Krasnoyarsk" },
            { "Antarctica/McMurdo", New_Zealand },
            { "timezone.excity.America/Nome", "Nome" },
            { "Pacific/Tahiti", Tahiti },
            { "timezone.excity.America/Vancouver", "Vancouver" },
            { "timezone.excity.America/Matamoros", "Matamoros" },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "timezone.excity.Asia/Choibalsan", "Choibalsan" },
            { "timezone.excity.America/Inuvik", "Inuvik" },
            { "Africa/Malabo", Africa_Western },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "timezone.excity.America/St_Lucia", "Sankti L\u00fas\u00eda" },
            { "timezone.excity.Asia/Novokuznetsk", "Novokuznetsk" },
            { "timezone.excity.Europe/Berlin", "Berl\u00edn" },
            { "Africa/Lagos", Africa_Western },
            { "timezone.excity.Pacific/Midway", "Midway" },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "timezone.excity.America/Martinique", "Martin\u00edk" },
            { "America/Dawson_Creek", America_Mountain },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "Asia/Dili", East_Timor },
            { "timezone.excity.Australia/Perth", "Perth" },
            { "Africa/Bamako", GMT },
            { "timezone.excity.Arctic/Longyearbyen", "Longyearbyen" },
            { "Pacific/Wallis", Wallis },
            { "timezone.excity.America/Tegucigalpa", "Tegucigalpa" },
            { "timezone.excity.Africa/Windhoek", "Windhoek" },
            { "Africa/Lubumbashi", Africa_Central },
            { "timezone.excity.Pacific/Majuro", "Majuro" },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "timezone.excity.Africa/Banjul", "Banjul" },
            { "Asia/Dhaka", Bangladesh },
            { "timezone.excity.Australia/Lindeman", "Lindeman" },
            { "timezone.excity.America/Miquelon", "Miquelon" },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "timezone.excity.America/Jujuy", "Jujuy" },
            { "timezone.excity.America/Argentina/Ushuaia", "Ushuaia" },
            { "timezone.excity.America/Cayenne", "Cayenne" },
            { "Pacific/Chatham", Chatham },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "timezone.excity.America/Belize", "Bel\u00eds" },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "timezone.excity.Asia/Bangkok", "Bangkok" },
            { "Europe/Moscow", Moscow },
            { "America/Puerto_Rico", Atlantic },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Helsinki", Europe_Eastern },
            { "timezone.excity.America/Montevideo", "Montevideo" },
            { "timezone.excity.Pacific/Johnston", "Johnston" },
            { "America/Cayenne", French_Guiana },
            { "timezone.excity.Europe/Jersey", "Jersey" },
            { "timezone.excity.America/Pangnirtung", "Pangnirtung" },
            { "timezone.excity.Atlantic/South_Georgia", "Su\u00f0ur-Georg\u00eda" },
            { "Pacific/Fiji", Fiji },
            { "timezone.excity.Africa/Juba", "Juba" },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "SystemV/AST4", Atlantic },
            { "timezone.excity.America/Havana", "Havana" },
            { "timezone.excity.Europe/Madrid", "Madr\u00edd" },
            { "Asia/Oral", Kazakhstan_Western },
            { "timezone.excity.America/Detroit", "Detroit" },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "timezone.excity.America/Grenada", "Grenada" },
            { "timezone.excity.Asia/Phnom_Penh", "Phnom Penh" },
            { "timezone.excity.Europe/Rome", "R\u00f3m" },
            { "timezone.excity.Asia/Hebron", "Hebron" },
            { "Asia/Jakarta", Indonesia_Western },
            { "timezone.excity.Antarctica/Mawson", "Mawson" },
            { "timezone.excity.Asia/Karachi", "Karachi" },
            { "timezone.excity.America/Resolute", "Resolute" },
            { "timezone.excity.Africa/Nouakchott", "Nouakchott" },
            { "timezone.excity.Africa/Bamako", "Bamako" },
            { "timezone.excity.America/Argentina/Salta", "Salta" },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "timezone.excity.Asia/Muscat", "Muscat" },
            { "America/Noronha", Noronha },
            { "timezone.excity.Africa/El_Aaiun", "El Aaiun" },
            { "timezone.excity.Australia/Hobart", "Hobart" },
            { "Australia/Adelaide", Australia_Central },
            { "timezone.excity.America/Lima", "Lima" },
            { "timezone.excity.Asia/Atyrau", "Atyrau" },
            { "America/Paramaribo", Suriname },
            { "timezone.excity.Asia/Bishkek", "Bishkek" },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "timezone.excity.America/Paramaribo", "Paramaribo" },
            { "Antarctica/Troll", GMT },
            { "timezone.excity.America/Ojinaga", "Ojinaga" },
            { "timezone.excity.Europe/Zurich", "Zurich" },
            { "Europe/Samara", Samara },
            { "America/Antigua", Atlantic },
            { "timezone.excity.America/Sao_Paulo", "Sao Paulo" },
            { "Pacific/Gambier", Gambier },
            { "Africa/Gaborone", Africa_Central },
            { "Asia/Pyongyang", Korea },
            { "timezone.excity.America/New_York", "New York" },
            { "Asia/Gaza", Europe_Eastern },
            { "timezone.excity.Africa/Accra", "Accra" },
            { "timezone.excity.Etc/Unknown", "\u00d3\u00feekkt borg" },
            { "Asia/Qyzylorda", Kazakhstan_Western },
            { "timezone.excity.America/Thule", "Thule" },
            { "timezone.excity.America/Grand_Turk", "Grand Turk" },
            { "America/Yakutat", Alaska },
            { "Europe/Vienna", Europe_Central },
            { "timezone.excity.America/Winnipeg", "Winnipeg" },
            { "timezone.excity.Antarctica/Macquarie", "Macquarie" },
            { "timezone.excity.Europe/Uzhgorod", "Uzhgorod" },
            { "timezone.excity.America/Caracas", "Caracas" },
            { "timezone.excity.America/Dawson_Creek", "Dawson Creek" },
            { "timezone.excity.America/Bogota", "Bogota" },
            { "timezone.excity.Asia/Baku", "Bak\u00fa" },
            { "timezone.excity.Asia/Hovd", "Hovd" },
            { "timezone.excity.Africa/Harare", "Harare" },
            { "Europe/Tirane", Europe_Central },
            { "timezone.excity.America/Blanc-Sablon", "Blanc-Sablon" },
            { "timezone.excity.Africa/Algiers", "Algeirsborg" },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "timezone.excity.Africa/Khartoum", "Khartoum" },
            { "Africa/Abidjan", GMT },
            { "America/Santarem", Brasilia },
            { "timezone.excity.Asia/Khandyga", "Khandyga" },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Atlantic/Bermuda", Atlantic },
            { "timezone.excity.Pacific/Galapagos", "Galapagos" },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Europe/Amsterdam", Europe_Central },
            { "timezone.excity.America/Argentina/Tucuman", "Tucuman" },
            { "timezone.excity.America/Rio_Branco", "Rio Branco" },
            { "Africa/Accra", GMT },
            { "timezone.excity.Europe/Ulyanovsk", "Ulyanovsk" },
            { "timezone.excity.Africa/Niamey", "Niamey" },
            { "timezone.excity.Indian/Mayotte", "Mayotte" },
            { "America/Maceio", Brasilia },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "Greenwich-sta\u00f0alt\u00edmi",
                    "",
                    "Sumart\u00edmi \u00e1 \u00cdrlandi",
                    "",
                    "",
                    "",
                }
            },
            { "Pacific/Truk", Truk },
            { "timezone.excity.Africa/Conakry", "Conakry" },
            { "timezone.excity.Asia/Jakarta", "Djakarta" },
            { "SST", Solomon },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "timezone.excity.Europe/Saratov", "Saratov" },
            { "SystemV/CST6", America_Central },
            { "timezone.excity.Pacific/Efate", "Efate" },
            { "timezone.excity.Asia/Aqtobe", "Aqtobe" },
            { "Asia/Vladivostok", Vladivostok },
            { "timezone.excity.Atlantic/St_Helena", "Sankti Helena" },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Ouagadougou", GMT },
            { "timezone.excity.Pacific/Rarotonga", "Rarotonga" },
            { "timezone.excity.Europe/Luxembourg", "L\u00faxemborg" },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "timezone.excity.Asia/Bahrain", "Barein" },
            { "timezone.excity.Indian/Mahe", "Mahe" },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "BST", Bangladesh },
            { "timezone.excity.Europe/Isle_of_Man", "M\u00f6n" },
            { "Pacific/Saipan", Chamorro },
            { "timezone.excity.America/Curacao", "Curacao" },
            { "timezone.excity.Pacific/Nauru", "N\u00e1r\u00fa" },
            { "timezone.excity.Pacific/Pago_Pago", "Pago Pago" },
            { "Antarctica/Rothera", Rothera },
            { "timezone.excity.America/Guyana", "Gv\u00e6jana" },
            { "Asia/Damascus", Europe_Eastern },
            { "MIT", Apia },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "timezone.excity.Europe/Paris", "Par\u00eds" },
            { "timezone.excity.Europe/Zagreb", "Zagreb" },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "timezone.excity.America/Swift_Current", "Swift Current" },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "timezone.excity.America/Tortola", "Tort\u00f3la" },
            { "Atlantic/Madeira", Europe_Western },
            { "America/Thunder_Bay", America_Eastern },
            { "timezone.excity.Europe/Budapest", "B\u00fadapest" },
            { "timezone.excity.America/Catamarca", "Catamarca" },
            { "timezone.excity.America/Port_of_Spain", "Port of Spain" },
            { "timezone.excity.Asia/Chita", "Chita" },
            { "America/Indiana/Marengo", America_Eastern },
            { "timezone.excity.America/Rankin_Inlet", "Rankin Inlet" },
            { "timezone.excity.America/Santarem", "Santarem" },
            { "timezone.excity.Asia/Tomsk", "Tomsk" },
            { "timezone.excity.Europe/Helsinki", "Helsinki" },
            { "America/Mexico_City", America_Central },
            { "timezone.excity.America/Yakutat", "Yakutat" },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "timezone.excity.Asia/Anadyr", "Anadyr" },
            { "timezone.excity.Asia/Urumqi", "Urumqi" },
            { "timezone.excity.America/Costa_Rica", "Kostar\u00edka" },
            { "timezone.excity.Africa/Lagos", "Lagos" },
            { "timezone.excity.Africa/Bissau", "Biss\u00e1" },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "timezone.excity.Africa/Douala", "Douala" },
            { "Europe/Oslo", Europe_Central },
            { "timezone.excity.Africa/Mogadishu", "Mogadishu" },
            { "timezone.excity.America/Bahia_Banderas", "Bahia Banderas" },
            { "timezone.excity.Asia/Jayapura", "Jayapura" },
            { "America/Menominee", America_Central },
            { "timezone.excity.Pacific/Guadalcanal", "Guadalcanal" },
            { "America/Resolute", America_Central },
            { "timezone.excity.Africa/Lome", "Lome" },
            { "timezone.excity.America/Nassau", "Nassau" },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "timezone.excity.Asia/Kuwait", "K\u00faveit" },
            { "timezone.excity.America/Santo_Domingo", "Santo Domingo" },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "timezone.excity.Europe/Moscow", "Moskva" },
            { "Africa/Bujumbura", Africa_Central },
            { "Europe/Minsk", Moscow },
            { "Pacific/Auckland", New_Zealand },
            { "timezone.excity.Asia/Taipei", "Taipei" },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "America/Port-au-Prince", America_Eastern },
            { "Europe/Belfast",
                new String[] {
                    "Greenwich-sta\u00f0alt\u00edmi",
                    "",
                    "Sumart\u00edmi \u00ed Bretlandi",
                    "",
                    "",
                    "",
                }
            },
            { "Asia/Ashgabat", Turkmenistan },
            { "timezone.excity.Asia/Dhaka", "Dakka" },
            { "America/Nipigon", America_Eastern },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "timezone.excity.America/Fort_Nelson", "Fort Nelson" },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "America/Lima", Peru },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "timezone.excity.Asia/Famagusta", "Famagusta" },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "America/Vancouver", America_Pacific },
            { "timezone.excity.America/Marigot", "Marigot" },
            { "Africa/Blantyre", Africa_Central },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "timezone.excity.Africa/Lubumbashi", "Lubumbashi" },
            { "Asia/Hong_Kong", Hong_Kong },
            { "timezone.excity.Asia/Ulaanbaatar", "\u00dalan Bator" },
            { "timezone.excity.Antarctica/McMurdo", "McMurdo" },
            { "Asia/Sakhalin", Sakhalin },
            { "timezone.excity.Asia/Novosibirsk", "Novosibirsk" },
            { "Africa/Harare", Africa_Central },
            { "timezone.excity.Asia/Srednekolymsk", "Srednekolymsk" },
            { "America/Nome", Alaska },
            { "timezone.excity.Africa/Nairobi", "Nairobi" },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "timezone.excity.Pacific/Fakaofo", "Fakaofo" },
            { "EAT", Africa_Eastern },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "timezone.excity.Asia/Tokyo", "T\u00f3k\u00fd\u00f3" },
            { "Asia/Saigon", Indochina },
            { "timezone.excity.Africa/Johannesburg", "J\u00f3hannesarborg" },
            { "Africa/Timbuktu", GMT },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "timezone.excity.Europe/Dublin", "Dublin" },
            { "timezone.excity.Antarctica/Casey", "Casey" },
            { "timezone.excity.Atlantic/Cape_Verde", "Gr\u00e6nh\u00f6f\u00f0aeyjar" },
            { "timezone.excity.Africa/Maputo", "Maputo" },
            { "timezone.excity.Africa/Luanda", "Luanda" },
            { "timezone.excity.America/Goose_Bay", "Goose Bay" },
            { "timezone.excity.America/Eirunepe", "Eirunepe" },
            { "timezone.excity.America/Los_Angeles", "Los Angeles" },
            { "America/Whitehorse", America_Pacific },
            { "timezone.excity.America/Cuiaba", "Cuiaba" },
            { "Pacific/Noumea", New_Caledonia },
            { "ECT", Europe_Central },
            { "timezone.excity.Atlantic/Azores", "Azoreyjar" },
            { "timezone.excity.Australia/Melbourne", "Melbourne" },
            { "America/Montreal", America_Eastern },
            { "timezone.excity.America/Anguilla", "Angvilla" },
            { "timezone.excity.Pacific/Honolulu", "Honolulu" },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "timezone.excity.Australia/Brisbane", "Brisbane" },
            { "timezone.excity.Indian/Antananarivo", "Antananarivo" },
            { "SystemV/MST7MDT", America_Mountain },
            { "timezone.excity.America/Manaus", "Manaus" },
            { "timezone.excity.Asia/Vientiane", "Vientiane" },
            { "America/Grenada", Atlantic },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "timezone.excity.Indian/Christmas", "J\u00f3laey" },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "timezone.excity.Asia/Aqtau", "Aqtau" },
            { "timezone.excity.America/Regina", "Regina" },
            { "SystemV/YST9YDT", Alaska },
            { "America/Merida", America_Central },
            { "CAT", Africa_Central },
            { "America/St_Kitts", Atlantic },
            { "timezone.excity.America/Thunder_Bay", "Thunder Bay" },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "Asia/Hebron", Europe_Eastern },
            { "SystemV/PST8PDT", America_Pacific },
            { "timezone.excity.Asia/Qostanay", "Kostanay" },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "timezone.excity.America/Louisville", "Louisville" },
            { "timezone.excity.America/Cancun", "Kank\u00fan" },
            { "timezone.excity.Australia/Broken_Hill", "Broken Hill" },
            { "timezone.excity.Europe/Kaliningrad", "Kaliningrad" },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Pacific/Kiritimati", "Kiritimati" },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Shiprock", America_Mountain },
            { "timezone.excity.Europe/Tirane", "Tirane" },
            { "timezone.excity.Europe/Prague", "Prag" },
            { "timezone.excity.Pacific/Tarawa", "Tarawa" },
            { "Europe/Vatican", Europe_Central },
            { "timezone.excity.America/Asuncion", "Asunci\u00f3n" },
            { "Asia/Amman", Europe_Eastern },
            { "Etc/UTC", ETC_UTC },
            { "timezone.excity.Europe/Chisinau", "Chisinau" },
            { "timezone.excity.America/Moncton", "Moncton" },
            { "Asia/Singapore", Singapore },
            { "timezone.excity.America/Guatemala", "Gvatemala" },
            { "SystemV/EST5EDT", America_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "timezone.excity.Europe/Vilnius", "Viln\u00edus" },
            { "Europe/Monaco", Europe_Central },
            { "timezone.excity.America/Chicago", "Chicago" },
            { "America/Cuiaba", Amazon },
            { "timezone.excity.Europe/San_Marino", "San Mar\u00edn\u00f3" },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "timezone.excity.Asia/Irkutsk", "Irkutsk" },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "timezone.excity.Europe/Skopje", "Skopje" },
            { "timezone.excity.America/Chihuahua", "Chihuahua" },
            { "America/Belize", America_Central },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "timezone.excity.Atlantic/Reykjavik", "Reykjav\u00edk" },
            { "timezone.excity.Asia/Kamchatka", "Kamtsjatka" },
            { "Europe/Warsaw", Europe_Central },
            { "Pacific/Yap", Truk },
            { "timezone.excity.Asia/Yakutsk", "Yakutsk" },
            { "timezone.excity.Africa/Djibouti", "Djib\u00fat\u00ed" },
            { "America/Tegucigalpa", America_Central },
            { "timezone.excity.America/Recife", "Recife" },
            { "timezone.excity.Pacific/Wallis", "Wallis" },
            { "America/Miquelon", Pierre_Miquelon },
            { "timezone.excity.Africa/Porto-Novo", "Porto-Novo" },
            { "timezone.excity.Antarctica/Palmer", "Palmer" },
            { "timezone.excity.Asia/Tashkent", "Tashkent" },
            { "timezone.excity.America/Argentina/San_Juan", "San Juan" },
            { "timezone.excity.Antarctica/Rothera", "Rothera" },
            { "timezone.excity.Asia/Shanghai", "Sjangh\u00e6" },
            { "timezone.excity.America/Juneau", "Juneau" },
            { "timezone.excity.Pacific/Bougainville", "Bougainville" },
            { "timezone.excity.Pacific/Apia", "Apia" },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "timezone.excity.America/El_Salvador", "El Salvador" },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "timezone.excity.Pacific/Easter", "P\u00e1skaeyja" },
            { "ACT", Australia_Central },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Indian/Comoro", Africa_Eastern },
            { "timezone.excity.Pacific/Niue", "Niue" },
            { "timezone.excity.America/Menominee", "Menominee" },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "timezone.excity.Australia/Lord_Howe", "Lord Howe" },
            { "Indian/Reunion", Reunion },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "timezone.excity.Asia/Magadan", "Magadan" },
            { "timezone.excity.Pacific/Wake", "Wake" },
            { "timezone.excity.Atlantic/Canary", "Kanar\u00edeyjar" },
            { "Africa/Mogadishu", Africa_Eastern },
            { "timezone.excity.America/Glace_Bay", "Glace Bay" },
            { "timezone.excity.Africa/Casablanca", "Casablanca" },
            { "Etc/GMT", GMT },
            { "timezone.excity.America/Kralendijk", "Kralendijk" },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "timezone.excity.Asia/Yerevan", "Yerevan" },
            { "timezone.excity.Europe/Kirov", "Kirov" },
            { "timezone.excity.America/Creston", "Creston" },
            { "timezone.excity.Africa/Cairo", "Ka\u00edr\u00f3" },
            { "AET", Australia_Eastern },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "timezone.excity.Europe/Warsaw", "Varsj\u00e1" },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Sarajevo", Europe_Central },
            { "America/Cordoba", Argentina },
            { "America/Regina", America_Central },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/Anguilla", Atlantic },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "America/Havana", Cuba },
            { "timezone.excity.America/Edmonton", "Edmonton" },
            { "timezone.excity.Africa/Sao_Tome", "Sa\u00f3 T\u00f3me" },
            { "timezone.excity.America/Dawson", "Dawson" },
            { "timezone.excity.Africa/Abidjan", "Abidjan" },
            { "America/Barbados", Atlantic },
            { "timezone.excity.America/Guadeloupe", "Gvadel\u00fap" },
            { "timezone.excity.Africa/Freetown", "Freetown" },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "timezone.excity.America/Fortaleza", "Fortaleza" },
            { "timezone.excity.Europe/Vatican", "Vat\u00edkani\u00f0" },
            { "timezone.excity.Asia/Almaty", "Almaty" },
            { "timezone.excity.Asia/Tbilisi", "Tbilisi" },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "timezone.excity.Europe/Andorra", "Andorra" },
            { "timezone.excity.Europe/Minsk", "Minsk" },
            { "America/Curacao", Atlantic },
            { "timezone.excity.Africa/Monrovia", "Monrovia" },
            { "America/Guayaquil", Ecuador },
            { "timezone.excity.Africa/Mbabane", "Mbabane" },
            { "timezone.excity.America/Rainy_River", "Rainy River" },
            { "timezone.excity.Asia/Beirut", "Beir\u00fat" },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Rankin_Inlet", America_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "timezone.excity.Asia/Pontianak", "Pontianak" },
            { "timezone.excity.America/Adak", "Adak" },
            { "Europe/Zagreb", Europe_Central },
            { "timezone.excity.America/Toronto", "Toronto" },
            { "America/Port_of_Spain", Atlantic },
            { "Asia/Beirut", Europe_Eastern },
            { "timezone.excity.Asia/Baghdad", "Bagdad" },
            { "Africa/Sao_Tome", GMT },
            { "Indian/Chagos", Indian_Ocean },
            { "timezone.excity.America/Metlakatla", "Metlakatla" },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "timezone.excity.America/Maceio", "Maceio" },
            { "timezone.excity.America/Guayaquil", "Guayaquil" },
            { "Africa/Ndjamena", Africa_Western },
            { "timezone.excity.America/St_Vincent", "Sankti Vinsent" },
            { "timezone.excity.America/Panama", "Panama" },
            { "timezone.excity.Europe/Simferopol", "Simferopol" },
            { "timezone.excity.Indian/Kerguelen", "Kerguelen" },
            { "CNT", Newfoundland },
            { "timezone.excity.Europe/Volgograd", "Volgograd" },
            { "timezone.excity.Europe/Monaco", "M\u00f3nak\u00f3" },
            { "Asia/Tashkent", Uzbekistan },
            { "Africa/Ceuta", Europe_Central },
            { "timezone.excity.America/La_Paz", "La Paz" },
            { "timezone.excity.Africa/Tripoli", "Tr\u00edp\u00f3l\u00ed" },
            { "America/Swift_Current", America_Central },
            { "timezone.excity.Pacific/Enderbury", "Enderbury" },
            { "timezone.excity.Asia/Pyongyang", "Pjongjang" },
            { "timezone.excity.Europe/Bucharest", "B\u00fakarest" },
            { "America/Metlakatla", Alaska },
            { "timezone.excity.Europe/Athens", "A\u00feena" },
            { "Africa/Djibouti", Africa_Eastern },
            { "Asia/Qostanay", Kazakhstan_Eastern },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "timezone.excity.America/Porto_Velho", "Porto Velho" },
            { "Europe/Prague", Europe_Central },
            { "timezone.excity.America/Managua", "Managua" },
            { "America/Kralendijk", Atlantic },
            { "Indian/Christmas", Christmas },
            { "NET", Armenia },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "timezone.excity.America/Montserrat", "Montserrat" },
            { "America/Moncton", Atlantic },
            { "timezone.excity.Europe/Copenhagen", "Kaupmannah\u00f6fn" },
            { "timezone.excity.Australia/Darwin", "Darwin" },
            { "America/St_Vincent", Atlantic },
            { "PST8PDT", America_Pacific },
            { "timezone.excity.Asia/Jerusalem", "Jer\u00fasalem" },
            { "Atlantic/Faeroe", Europe_Western },
            { "timezone.excity.Asia/Riyadh", "R\u00edjad" },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "timezone.excity.Africa/Bangui", "Bangui" },
            { "timezone.excity.Africa/Lusaka", "Lusaka" },
            { "Atlantic/Azores", Azores },
            { "timezone.excity.Asia/Ust-Nera", "Ust-Nera" },
            { "timezone.excity.Asia/Damascus", "Damaskus" },
            { "Pacific/Pitcairn", Pitcairn },
            { "timezone.excity.Pacific/Kosrae", "Kosrae" },
            { "America/Mazatlan", Mexico_Pacific },
            { "Pacific/Nauru", Nauru },
            { "timezone.excity.Africa/Brazzaville", "Brazzaville" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "Rio Gallegos" },
            { "SystemV/MST7", America_Mountain },
            { "America/Dominica", Atlantic },
            { "timezone.excity.America/Bahia", "Bahia" },
            { "America/Mendoza", Argentina },
            { "timezone.excity.Asia/Tehran", "Teheran" },
            { "timezone.excity.Pacific/Tahiti", "Tah\u00edt\u00ed" },
            { "timezone.excity.America/St_Kitts", "Sankti Kitts" },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "timezone.excity.Africa/Dar_es_Salaam", "Dar es Salaam" },
            { "timezone.excity.America/Monterrey", "Monterrey" },
            { "Pacific/Wake", Wake },
            { "timezone.excity.America/Belem", "Belem" },
            { "Asia/Chongqing", China },
            { "America/Indiana/Knox", America_Central },
            { "timezone.excity.Asia/Saigon", "Ho Chi Minh-borg" },
            { "PLT", Pakistan },
            { "America/North_Dakota/Beulah", America_Central },
            { "timezone.excity.Asia/Makassar", "Makassar" },
            { "Pacific/Apia", Apia },
            { "Pacific/Niue", Niue },
            { "timezone.excity.Asia/Yekaterinburg", "Yekaterinburg" },
            { "CST", America_Central },
            { "timezone.excity.Europe/Sofia", "S\u00f3f\u00eda" },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "timezone.excity.Europe/Astrakhan", "Astrakhan" },
            { "timezone.excity.America/Yellowknife", "Yellowknife" },
            { "timezone.excity.Europe/Belgrade", "Belgrad" },
            { "timezone.excity.America/Puerto_Rico", "P\u00faert\u00f3 R\u00edk\u00f3" },
            { "timezone.excity.America/Denver", "Denver" },
            { "timezone.excity.Asia/Calcutta", "Kalk\u00fatta" },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "CTT", China },
            { "timezone.excity.Asia/Gaza", "Gaza" },
            { "timezone.excity.Africa/Ceuta", "Ceuta" },
            { "Africa/Libreville", Africa_Western },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "timezone.excity.Antarctica/Troll", "Troll" },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "PNT", America_Mountain },
            { "timezone.excity.Asia/Hong_Kong", "Hong Kong" },
            { "timezone.excity.America/Port-au-Prince", "Port-au-Prince" },
            { "America/Tijuana", America_Pacific },
            { "timezone.excity.Australia/Eucla", "Eucla" },
            { "timezone.excity.America/Mexico_City", "Mex\u00edk\u00f3borg" },
            { "timezone.excity.Pacific/Kwajalein", "Kwajalein" },
            { "SystemV/YST9", Gambier },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "timezone.excity.Europe/Lisbon", "Lissabon" },
            { "timezone.excity.Pacific/Gambier", "Gambier" },
            { "timezone.excity.America/Boise", "Boise" },
            { "America/Santiago", Chile },
            { "timezone.excity.Europe/Zaporozhye", "Zaporozhye" },
            { "Asia/Baku", Azerbaijan },
            { "ART", Europe_Eastern },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.America/Dominica", "D\u00f3min\u00edka" },
            { "Asia/Taipei", Taipei },
            { "Antarctica/South_Pole", New_Zealand },
            { "timezone.excity.Africa/Kampala", "Kampala" },
            { "timezone.excity.Pacific/Chatham", "Chatham" },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "AST", Alaska },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "timezone.excity.Asia/Colombo", "K\u00f3lomb\u00f3" },
            { "timezone.excity.Pacific/Port_Moresby", "Port Moresby" },
            { "America/Creston", America_Mountain },
            { "timezone.excity.America/Mendoza", "Mendoza" },
            { "Asia/Vientiane", Indochina },
            { "timezone.excity.America/Noronha", "Noronha" },
            { "timezone.excity.Asia/Sakhalin", "Sakhalin" },
            { "Pacific/Kiritimati", Line_Islands },
            { "timezone.excity.America/Nipigon", "Nipigon" },
            { "timezone.excity.Europe/Guernsey", "Guernsey" },
            { "timezone.excity.America/Argentina/San_Luis", "San Luis" },
            { "timezone.excity.Europe/Riga", "Riga" },
            { "timezone.excity.America/Araguaina", "Araguaina" },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Asia/Harbin", China },
            { "PRT", Atlantic },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "timezone.excity.America/Cordoba", "Cordoba" },
            { "timezone.excity.America/Cambridge_Bay", "Cambridge Bay" },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "timezone.excity.America/Campo_Grande", "Campo Grande" },
            { "timezone.excity.Africa/Blantyre", "Blantyre" },
            { "timezone.excity.Europe/Malta", "Malta" },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "timezone.excity.Australia/Sydney", "Sydney" },
            { "timezone.excity.Asia/Qatar", "Katar" },
            { "timezone.excity.America/Sitka", "Sitka" },
            { "PST", America_Pacific },
            { "SystemV/EST5", America_Eastern },
            { "timezone.excity.Antarctica/Davis", "Davis" },
            { "America/Santo_Domingo", Atlantic },
            { "timezone.excity.America/Aruba", "Ar\u00faba" },
            { "timezone.excity.Asia/Qyzylorda", "Qyzylorda" },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Magadan", Magadan },
            { "SystemV/PST8", Pitcairn },
            { "timezone.excity.Indian/Mauritius", "M\u00e1rit\u00edus" },
            { "America/St_Barthelemy", Atlantic },
            { "timezone.excity.America/Argentina/La_Rioja", "La Rioja" },
            { "Africa/Luanda", Africa_Western },
            { "timezone.excity.Europe/Mariehamn", "Mar\u00eduh\u00f6fn" },
            { "timezone.excity.America/St_Barthelemy", "Sankti Bart\u00f3l\u00f3meusareyjar" },
            { "timezone.excity.America/Santiago", "Santiago" },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "timezone.excity.Asia/Oral", "Oral" },
            { "America/Cancun", America_Eastern },
            { "timezone.excity.Asia/Manila", "Manila" },
            { "Pacific/Kosrae", Kosrae },
            { "Australia/Sydney", Australia_Eastern },
            { "timezone.excity.America/Indianapolis", "Indianapolis" },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "timezone.excity.Asia/Seoul", "Se\u00fal" },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "timezone.excity.America/St_Thomas", "Sankti Thomas" },
            { "timezone.excity.Europe/Busingen", "Busingen" },
            { "Europe/Volgograd", Volgograd },
            { "America/Lower_Princes", Atlantic },
            { "timezone.excity.Europe/Istanbul", "Istanb\u00fal" },
            { "timezone.excity.Europe/Sarajevo", "Sarajev\u00f3" },
            { "America/Danmarkshavn", GMT },
            { "timezone.excity.Africa/Ndjamena", "Ndjamena" },
            { "timezone.excity.America/Punta_Arenas", "Punta Arenas" },
            { "timezone.excity.Africa/Kigali", "Kigali" },
            { "timezone.excity.Asia/Vladivostok", "Vladivostok" },
            { "Africa/Lusaka", Africa_Central },
            { "timezone.excity.Africa/Tunis", "T\u00fanisborg" },
            { "timezone.excity.Asia/Macau", "Maka\u00f3" },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "SystemV/CST6CDT", America_Central },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Asia/Kamchatka", Kamchatka },
            { "NST", New_Zealand },
            { "timezone.excity.Asia/Samarkand", "Samarkand" },
            { "Africa/Khartoum", Africa_Central },
            { "timezone.excity.Australia/Adelaide", "Adelaide" },
            { "timezone.excity.Asia/Singapore", "Singap\u00far" },
            { "Europe/Belgrade", Europe_Central },
            { "timezone.excity.Europe/Vienna", "V\u00edn" },
            { "Africa/Bissau", GMT },
            { "timezone.excity.America/Cayman", "Cayman-eyjar" },
            { "timezone.excity.Europe/Bratislava", "Bratislava" },
            { "Asia/Tehran", Iran },
            { "timezone.excity.America/Barbados", "Barbados" },
            { "timezone.excity.Asia/Nicosia", "N\u00edk\u00f3s\u00eda" },
            { "timezone.excity.Europe/Kiev", "K\u00e6nugar\u00f0ur" },
            { "timezone.excity.Asia/Dili", "Dili" },
            { "timezone.excity.Asia/Omsk", "Omsk" },
            { "timezone.excity.Africa/Bujumbura", "Bujumbura" },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "timezone.excity.America/Mazatlan", "Mazatlan" },
            { "timezone.excity.Asia/Brunei", "Br\u00fanei" },
            { "timezone.excity.Atlantic/Faeroe", "F\u00e6reyjar" },
            { "timezone.excity.America/Whitehorse", "Whitehorse" },
            { "timezone.excity.Asia/Kuching", "Kuching" },
            { "timezone.excity.America/Halifax", "Halifax" },
            { "timezone.excity.America/Merida", "Merida" },
            { "America/Pangnirtung", America_Eastern },
            { "timezone.excity.Pacific/Palau", "Pal\u00e1" },
            { "Asia/Katmandu", Nepal },
            { "timezone.excity.Pacific/Auckland", "Auckland" },
            { "Africa/Niamey", Africa_Western },
            { "timezone.excity.Pacific/Norfolk", "Norfolk" },
            { "Asia/Tbilisi", Georgia },
            { "timezone.excity.Asia/Ashgabat", "Ashgabat" },
            { "timezone.excity.Pacific/Tongatapu", "Tongatapu" },
            { "timezone.excity.Antarctica/Syowa", "Syowa" },
            { "timezone.excity.America/Jamaica", "Jama\u00edka" },
            { "timezone.excity.America/Hermosillo", "Hermosillo" },
            { "timezone.excity.Pacific/Funafuti", "Funafuti" },
            { "timezone.excity.Europe/Podgorica", "Podgorica" },
            { "timezone.excity.Indian/Reunion", "R\u00e9union" },
            { "timezone.excity.Pacific/Noumea", "Noumea" },
            { "timezone.excity.Asia/Aden", "Aden" },
            { "timezone.excity.Europe/Oslo", "Osl\u00f3" },
            { "America/Boa_Vista", Amazon },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Europe/Bratislava", Europe_Central },
            { "timezone.excity.Atlantic/Stanley", "Stanley" },
            { "Pacific/Tongatapu", Tonga },
            { "timezone.excity.Asia/Rangoon", "Rang\u00fan" },
            { "timezone.excity.Asia/Thimphu", "Thimphu" },
            { "timezone.excity.Asia/Dubai", "Dubai" },
            { "Arctic/Longyearbyen", Europe_Central },
            { "timezone.excity.Asia/Kuala_Lumpur", "K\u00faala L\u00famp\u00far" },
            { "America/Guadeloupe", Atlantic },
            { "Indian/Kerguelen", French_Southern },
            { "timezone.excity.Africa/Ouagadougou", "Ouagadougou" },
            { "timezone.excity.Africa/Gaborone", "Gaborone" },
            { "Asia/Anadyr", Anadyr },
            { "timezone.excity.Indian/Chagos", "Chagos" },
            { "timezone.excity.Asia/Kabul", "Kab\u00fal" },
            { "timezone.excity.America/Iqaluit", "Iqaluit" },
            { "America/Winnipeg", America_Central },
            { "timezone.excity.Europe/Amsterdam", "Amsterdam" },
            { "timezone.excity.Atlantic/Bermuda", "Berm\u00fada" },
            { "timezone.excity.Pacific/Saipan", "Saipan" },
            { "timezone.excity.Indian/Cocos", "K\u00f3koseyjar" },
            { "timezone.excity.Australia/Currie", "Currie" },
            { "SystemV/AST4ADT", Atlantic },
            { "timezone.excity.Asia/Amman", "Amman" },
            { "America/Toronto", America_Eastern },
            { "timezone.excity.Europe/Brussels", "Brussel" },
            { "Australia/Lindeman", Australia_Eastern },
            { "timezone.excity.Atlantic/Madeira", "Madeira" },
            { "timezone.excity.Indian/Comoro", "Comoro" },
            { "timezone.excity.America/Boa_Vista", "Boa Vista" },
            { "Pacific/Majuro", Marshall_Islands },
            { "timezone.excity.Europe/Stockholm", "Stokkh\u00f3lmur" },
            { "timezone.excity.Europe/Samara", "Samara" },
            { "timezone.excity.America/Tijuana", "Tijuana" },
            { "timezone.excity.Indian/Maldives", "Mald\u00edveyjar" },
        };
        return data;
    }
}
