/*
 * Copyright (c) 2012, 2020, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_de extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_FJ = "Fidschi";
        final String metaValue_NU = "Niue";
        final String metaValue_PW = "Palau";
        final String metaValue_ae = "Avestisch";
        final String metaValue_ar = "Arabisch";
        final String metaValue_bn = "Bengalisch";
        final String metaValue_bo = "Tibetisch";
        final String metaValue_el = "Griechisch";
        final String metaValue_gu = "Gujarati";
        final String metaValue_he = "Hebr\u00e4isch";
        final String metaValue_hy = "Armenisch";
        final String metaValue_ii = "Yi";
        final String metaValue_ja = "Japanisch";
        final String metaValue_ka = "Georgisch";
        final String metaValue_km = "Khmer";
        final String metaValue_kn = "Kannada";
        final String metaValue_ko = "Koreanisch";
        final String metaValue_lo = "Laotisch";
        final String metaValue_ml = "Malayalam";
        final String metaValue_mn = "Mongolisch";
        final String metaValue_my = "Birmanisch";
        final String metaValue_or = "Oriya";
        final String metaValue_si = "Singhalesisch";
        final String metaValue_su = "Sundanesisch";
        final String metaValue_te = "Telugu";
        final String metaValue_tl = "Tagalog";
        final String metaValue_zh = "Chinesisch";
        final String metaValue_ban = "Balinesisch";
        final String metaValue_bax = "Bamun";
        final String metaValue_bug = "Buginesisch";
        final String metaValue_chr = "Cherokee";
        final String metaValue_cop = "Koptisch";
        final String metaValue_got = "Gotisch";
        final String metaValue_kpe = "Kpelle";
        final String metaValue_men = "Mende";
        final String metaValue_nqo = "N\u2019Ko";
        final String metaValue_ota = "Osmanisch";
        final String metaValue_peo = "Altpersisch";
        final String metaValue_phn = "Ph\u00f6nizisch";
        final String metaValue_sam = "Samaritanisch";
        final String metaValue_saz = "Saurashtra";
        final String metaValue_ssy = "Saho";
        final String metaValue_syr = "Syrisch";
        final String metaValue_uga = "Ugaritisch";
        final String metaValue_vai = "Vai";
        final String metaValue_zbl = "Bliss-Symbole";
        final Object[][] data = new Object[][] {
            { "ksh", "K\u00f6lsch" },
            { "Ogam", "Ogham" },
            { "mwl", "Mirandesisch" },
            { "Zsym", "Symbole" },
            { "cch", "Atsam" },
            { "mwr", "Marwari" },
            { "type.nu.lanatham", "Lanna-Ziffern (sakral)" },
            { "egl", "Emilianisch" },
            { "mwv", "Mentawai" },
            { "Tagb", "Tagbanwa" },
            { "Zsye", "Emoji" },
            { "%%NJIVA", "Njiva-Dialekt" },
            { "xmf", "Mingrelisch" },
            { "egy", "\u00c4gyptisch" },
            { "raj", "Rajasthani" },
            { "Phag", "Phags-pa" },
            { "tem", "Temne" },
            { "teo", "Teso" },
            { "rap", "Rapanui" },
            { "ter", "Tereno" },
            { "AC", "Ascension" },
            { "rar", "Rarotonganisch" },
            { "tet", "Tetum" },
            { "AD", "Andorra" },
            { "AE", "Vereinigte Arabische Emirate" },
            { "nl_BE", "Fl\u00e4misch" },
            { "AF", "Afghanistan" },
            { "AG", "Antigua und Barbuda" },
            { "type.ca.ethiopic", "\u00c4thiopischer Kalender" },
            { "glk", "Gilaki" },
            { "AI", "Anguilla" },
            { "key.tz", "Zeitzone" },
            { "AL", "Albanien" },
            { "AM", "Armenien" },
            { "Teng", "Tengwar" },
            { "AO", "Angola" },
            { "AQ", "Antarktis" },
            { "AR", "Argentinien" },
            { "Prti", "Parthisch" },
            { "AS", "Amerikanisch-Samoa" },
            { "AT", "\u00d6sterreich" },
            { "AU", "Australien" },
            { "AW", "Aruba" },
            { "AX", "\u00c5landinseln" },
            { "mye", "Myene" },
            { "AZ", "Aserbaidschan" },
            { "%%AREVELA", "Ostarmenisch" },
            { "BA", "Bosnien und Herzegowina" },
            { "BB", "Barbados" },
            { "ceb", "Cebuano" },
            { "BD", "Bangladesch" },
            { "kum", "Kum\u00fckisch" },
            { "BE", "Belgien" },
            { "gmh", "Mittelhochdeutsch" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgarien" },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "St. Barth\u00e9lemy" },
            { "BM", "Bermuda" },
            { "kut", "Kutenai" },
            { "myv", "Ersja-Mordwinisch" },
            { "BN", "Brunei Darussalam" },
            { "BO", "Bolivien" },
            { "BQ", "Bonaire, Sint Eustatius und Saba" },
            { "BR", "Brasilien" },
            { "BS", "Bahamas" },
            { "xog", "Soga" },
            { "BT", "Bhutan" },
            { "BV", "Bouvetinsel" },
            { "BW", "Botsuana" },
            { "BY", "Belarus" },
            { "BZ", "Belize" },
            { "Visp", "Sichtbare Sprache" },
            { "type.ca.persian", "Persischer Kalender" },
            { "type.nu.hebr", "Hebr\u00e4ische Ziffern" },
            { "CA", "Kanada" },
            { "CC", "Kokosinseln" },
            { "mzn", "Masanderanisch" },
            { "CD", "Kongo-Kinshasa" },
            { "CF", "Zentralafrikanische Republik" },
            { "CG", "Kongo-Brazzaville" },
            { "CH", "Schweiz" },
            { "CI", "C\u00f4te d\u2019Ivoire" },
            { "CK", "Cookinseln" },
            { "CL", "Chile" },
            { "Kthi", "Kaithi" },
            { "CM", "Kamerun" },
            { "CN", "China" },
            { "CO", "Kolumbien" },
            { "CP", "Clipperton-Insel" },
            { "CR", "Costa Rica" },
            { "CU", "Kuba" },
            { "CV", "Cabo Verde" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "Weihnachtsinsel" },
            { "CY", "Zypern" },
            { "type.nu.bali", "Balinesische Ziffern" },
            { "CZ", "Tschechien" },
            { "eka", "Ekajuk" },
            { "Pauc", "Pau Cin Hau" },
            { "vls", "Westfl\u00e4misch" },
            { "DE", "Deutschland" },
            { "goh", "Althochdeutsch" },
            { "ace", "Aceh" },
            { "cgg", "Rukiga" },
            { "DG", "Diego Garcia" },
            { "gom", "Goa-Konkani" },
            { "type.nu.deva", "Devanagari-Ziffern" },
            { "DJ", "Dschibuti" },
            { "DK", "D\u00e4nemark" },
            { "ach", "Acholi" },
            { "gon", "Gondi" },
            { "Brai", "Braille" },
            { "Brah", "Brahmi" },
            { "DM", "Dominica" },
            { "type.nu.armnlow", "Armenische Ziffern in Kleinschrift" },
            { "DO", "Dominikanische Republik" },
            { "gor", "Mongondou" },
            { "got", metaValue_got },
            { "vmf", "Mainfr\u00e4nkisch" },
            { "Mtei", "Meitei Mayek" },
            { "zun", "Zuni" },
            { "tig", "Tigre" },
            { "Takr", "Takri" },
            { "DZ", "Algerien" },
            { "pag", "Pangasinan" },
            { "type.d0.hwidth", "Halbe Breite" },
            { "pal", "Mittelpersisch" },
            { "EA", "Ceuta und Melilla" },
            { "chb", "Chibcha" },
            { "pam", "Pampanggan" },
            { "EC", "Ecuador" },
            { "pap", "Papiamento" },
            { "ada", "Adangme" },
            { "EE", "Estland" },
            { "tiv", "Tiv" },
            { "EG", "\u00c4gypten" },
            { "EH", "Westsahara" },
            { "chg", "Tschagataisch" },
            { "pau", metaValue_PW },
            { "chk", "Chuukesisch" },
            { "chn", "Chinook" },
            { "chm", "Mari" },
            { "chp", "Chipewyan" },
            { "cho", "Choctaw" },
            { "chr", metaValue_chr },
            { "ER", "Eritrea" },
            { "ES", "Spanien" },
            { "ET", "\u00c4thiopien" },
            { "EU", "Europ\u00e4ische Union" },
            { "elx", "Elamisch" },
            { "type.ca.gregorian", "Gregorianischer Kalender" },
            { "EZ", "Eurozone" },
            { "chy", "Cheyenne" },
            { "type.nu.gujr", "Gujarati-Ziffern" },
            { "Inds", "Indus-Schrift" },
            { "ady", "Adygeisch" },
            { "aeb", "Tunesisches Arabisch" },
            { "FI", "Finnland" },
            { "FJ", metaValue_FJ },
            { "FK", "Falklandinseln" },
            { "FM", "Mikronesien" },
            { "key.va", "Lokale Variante" },
            { "FO", "F\u00e4r\u00f6er" },
            { "Taml", "Tamilisch" },
            { "FR", "Frankreich" },
            { "Kpel", metaValue_kpe },
            { "pcd", "Picardisch" },
            { "tkl", "Tokelauanisch" },
            { "grb", "Grebo" },
            { "root", "Root" },
            { "type.ca.indian", "Indischer Nationalkalender" },
            { "rgn", "Romagnol" },
            { "grc", "Altgriechisch" },
            { "GA", "Gabun" },
            { "tkr", "Tsachurisch" },
            { "vot", "Wotisch" },
            { "GB", "Vereinigtes K\u00f6nigreich" },
            { "pcm", "Nigerianisches Pidgin" },
            { "GD", "Grenada" },
            { "GE", "Georgien" },
            { "GF", "Franz\u00f6sisch-Guayana" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "Tale", "Tai Le" },
            { "GI", "Gibraltar" },
            { "afh", "Afrihili" },
            { "GL", "Gr\u00f6nland" },
            { "enm", "Mittelenglisch" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "GP", "Guadeloupe" },
            { "GQ", "\u00c4quatorialguinea" },
            { "GR", "Griechenland" },
            { "GS", "S\u00fcdgeorgien und die S\u00fcdlichen Sandwichinseln" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "pdc", "Pennsylvaniadeutsch" },
            { "GW", "Guinea-Bissau" },
            { "tli", "Tlingit" },
            { "tlh", "Klingonisch" },
            { "Talu", "Tai Lue" },
            { "GY", "Guyana" },
            { "ckb", "Zentralkurdisch" },
            { "zxx", "Keine Sprachinhalte" },
            { "Jurc", "Jurchen" },
            { "tly", "Talisch" },
            { "pdt", "Plautdietsch" },
            { "de_AT", "\u00d6sterreichisches Deutsch" },
            { "Vaii", metaValue_vai },
            { "HK", "Sonderverwaltungsregion Hongkong" },
            { "HM", "Heard und McDonaldinseln" },
            { "HN", "Honduras" },
            { "HR", "Kroatien" },
            { "agq", "Aghem" },
            { "gsw", "Schweizerdeutsch" },
            { "type.ca.islamic-umalqura", "Islamischer Kalender (Umm al-Qura" },
            { "HT", "Haiti" },
            { "HU", "Ungarn" },
            { "rif", "Tarifit" },
            { "tmh", "Tamaseq" },
            { "IC", "Kanarische Inseln" },
            { "nan", "Min Nan" },
            { "peo", metaValue_peo },
            { "ID", "Indonesien" },
            { "type.nu.kali", "Kayah-Li-Ziffern" },
            { "IE", "Irland" },
            { "nap", "Neapolitanisch" },
            { "naq", "Nama" },
            { "type.nu.sora", "Sora-Sompeng-Ziffern" },
            { "zza", "Zaza" },
            { "Tang", "Xixia" },
            { "IL", "Israel" },
            { "Nbat", "Nabat\u00e4isch" },
            { "IM", "Isle of Man" },
            { "IN", "Indien" },
            { "type.co.eor", "Europ\u00e4ische Sortierregeln" },
            { "IO", "Britisches Territorium im Indischen Ozean" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "Island" },
            { "IT", "Italien" },
            { "Zmth", "Mathematische Notation" },
            { "type.nu.thai", "Thai-Ziffern" },
            { "vro", "V\u00f5ro" },
            { "guc", "Way\u00fau" },
            { "%%POSIX", "Posix" },
            { "type.nu.beng", "Bengalische Ziffern" },
            { "pfl", "Pf\u00e4lzisch" },
            { "JE", "Jersey" },
            { "type.ca.islamic", "Islamischer Kalender" },
            { "Beng", metaValue_bn },
            { "JM", "Jamaika" },
            { "JO", "Jordanien" },
            { "gur", "Farefare" },
            { "JP", "Japan" },
            { "%%1606NICT", "Sp\u00e4tes Mittelfranz\u00f6sisch" },
            { "ain", "Ainu" },
            { "Mend", metaValue_men },
            { "guz", "Gusii" },
            { "tog", "Nyasa Tonga" },
            { "type.nu.knda", "Kannada-Ziffern" },
            { "Kali", "Kayah Li" },
            { "Sidd", "Siddham" },
            { "de_CH", "Schweizer Hochdeutsch" },
            { "type.co.phonetic", "Sortierung nach Phonetik" },
            { "izh", "Ischorisch" },
            { "type.ca.buddhist", "Buddhistischer Kalender" },
            { "KE", "Kenia" },
            { "419", "Lateinamerika" },
            { "KG", "Kirgisistan" },
            { "KH", "Kambodscha" },
            { "KI", "Kiribati" },
            { "KM", "Komoren" },
            { "Knda", metaValue_kn },
            { "KN", "St. Kitts und Nevis" },
            { "Zinh", "Geerbter Schriftwert" },
            { "KP", "Nordkorea" },
            { "KR", "S\u00fcdkorea" },
            { "Plrd", "Pollard Phonetisch" },
            { "KW", "Kuwait" },
            { "tpi", "Neumelanesisch" },
            { "KY", "Kaimaninseln" },
            { "KZ", "Kasachstan" },
            { "Cyrl", "Kyrillisch" },
            { "LA", "Laos" },
            { "LB", "Libanon" },
            { "phn", metaValue_phn },
            { "LC", "St. Lucia" },
            { "Cyrs", "Altkirchenslawisch" },
            { "gwi", "Kutchin" },
            { "nds", "Niederdeutsch" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "akk", "Akkadisch" },
            { "cop", metaValue_cop },
            { "LR", "Liberia" },
            { "esu", "Zentral-Alaska-Yupik" },
            { "LS", "Lesotho" },
            { "Phlv", "Pahlavi" },
            { "LT", "Litauen" },
            { "LU", "Luxemburg" },
            { "LV", "Lettland" },
            { "Kana", "Katakana" },
            { "Sora", "Sora Sompeng" },
            { "LY", "Libyen" },
            { "lad", "Ladino" },
            { "vun", "Vunjo" },
            { "akz", "Alabama" },
            { "lah", "Lahnda" },
            { "Mahj", "Mahajani" },
            { "lag", "Langi" },
            { "Thaa", "Thaana" },
            { "MA", "Marokko" },
            { "MC", "Monaco" },
            { "MD", "Republik Moldau" },
            { "Nshu", "Frauenschrift" },
            { "ME", "Montenegro" },
            { "MF", "St. Martin" },
            { "lam", "Lamba" },
            { "MG", "Madagaskar" },
            { "MH", "Marshallinseln" },
            { "ale", "Aleutisch" },
            { "Thai", "Thai" },
            { "type.nu.vaii", "Vai-Ziffern" },
            { "MK", "Nordmazedonien" },
            { "ML", "Mali" },
            { "MM", "Myanmar" },
            { "MN", "Mongolei" },
            { "new", "Newari" },
            { "MO", "Sonderverwaltungsregion Macau" },
            { "aln", "Gegisch" },
            { "MP", "N\u00f6rdliche Marianen" },
            { "MQ", "Martinique" },
            { "MR", "Mauretanien" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "cps", "Capiznon" },
            { "type.m0.ungegn", "UNGEGN" },
            { "MU", "Mauritius" },
            { "alt", "S\u00fcd-Altaisch" },
            { "MV", "Malediven" },
            { "MW", "Malawi" },
            { "MX", "Mexiko" },
            { "type.ca.japanese", "Japanischer Kalender" },
            { "MY", "Malaysia" },
            { "MZ", "Mosambik" },
            { "Phli", "Buch-Pahlavi" },
            { "NA", "Namibia" },
            { "202", "Subsahara-Afrika" },
            { "type.ca.hebrew", "Hebr\u00e4ischer Kalender" },
            { "type.co.dictionary", "Lexikographische Sortierreihenfolge" },
            { "NC", "Neukaledonien" },
            { "%%WADEGILE", "Wade-Giles" },
            { "tru", "Turoyo" },
            { "%%UCRCOR", "Vereinheitlichte \u00fcberarbeitete Rechtschreibung" },
            { "NE", "Niger" },
            { "NF", "Norfolkinsel" },
            { "NG", "Nigeria" },
            { "trv", "Taroko" },
            { "Phlp", "Psalter-Pahlavi" },
            { "NI", "Nicaragua" },
            { "Hmng", "Pahawh Hmong" },
            { "NL", "Niederlande" },
            { "NO", "Norwegen" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "tsd", "Tsakonisch" },
            { "NU", metaValue_NU },
            { "Phnx", metaValue_phn },
            { "rof", "Rombo" },
            { "tsi", "Tsimshian" },
            { "NZ", "Neuseeland" },
            { "Merc", "Meroitisch kursiv" },
            { "rom", "Romani" },
            { "Mero", "Meroitisch" },
            { "crh", "Krimtatarisch" },
            { "ang", "Altenglisch" },
            { "OM", "Oman" },
            { "anp", "Angika" },
            { "crs", "Seychellenkreol" },
            { "Xpeo", metaValue_peo },
            { "PA", "Panama" },
            { "type.ca.islamic-civil", "B\u00fcrgerlicher islamischer Kalender" },
            { "csb", "Kaschubisch" },
            { "PE", "Peru" },
            { "ttt", "Tatisch" },
            { "PF", "Franz\u00f6sisch-Polynesien" },
            { "PG", "Papua-Neuguinea" },
            { "PH", "Philippinen" },
            { "PK", "Pakistan" },
            { "PL", "Polen" },
            { "ewo", "Ewondo" },
            { "PM", "St. Pierre und Miquelon" },
            { "PN", "Pitcairninseln" },
            { "PR", "Puerto Rico" },
            { "Bali", metaValue_ban },
            { "PS", "Pal\u00e4stinensische Autonomiegebiete" },
            { "PT", "Portugal" },
            { "PW", metaValue_PW },
            { "nia", "Nias" },
            { "type.nu.greklow", "Griechische Ziffern in Kleinschrift" },
            { "PY", "Paraguay" },
            { "tum", "Tumbuka" },
            { "Hebr", metaValue_he },
            { "QA", "Katar" },
            { "%%SCOTLAND", "Schottisches Standardenglisch" },
            { "jam", "Jamaikanisch-Kreolisch" },
            { "pms", "Piemontesisch" },
            { "niu", metaValue_NU },
            { "QO", "\u00c4u\u00dferes Ozeanien" },
            { "ext", "Extremadurisch" },
            { "lez", "Lesgisch" },
            { "%%FONUPA", "Phonetisch (UPA)" },
            { "type.nu.takr", "Takri-Ziffern" },
            { "tvl", "Tuvaluisch" },
            { "Tavt", "Tai-Viet" },
            { "001", "Welt" },
            { "002", "Afrika" },
            { "njo", "Ao-Naga" },
            { "003", "Nordamerika" },
            { "RE", "R\u00e9union" },
            { "005", "S\u00fcdamerika" },
            { "lfn", "Lingua Franca Nova" },
            { "jbo", "Lojban" },
            { "pnt", "Pontisch" },
            { "Rjng", "Rejang" },
            { "009", "Ozeanien" },
            { "RO", "Rum\u00e4nien" },
            { "RS", "Serbien" },
            { "Mroo", "Mro" },
            { "RU", "Russland" },
            { "RW", "Ruanda" },
            { "type.nu.talu", "Neue Tai-L\u00fc-Ziffern" },
            { "Ugar", metaValue_uga },
            { "Mani", "Manich\u00e4isch" },
            { "Khar", "Kharoshthi" },
            { "SA", "Saudi-Arabien" },
            { "pon", "Ponapeanisch" },
            { "Mand", "Mand\u00e4isch" },
            { "SB", "Salomonen" },
            { "twq", "Tasawaq" },
            { "011", "Westafrika" },
            { "SC", "Seychellen" },
            { "SD", "Sudan" },
            { "013", "Mittelamerika" },
            { "SE", "Schweden" },
            { "014", "Ostafrika" },
            { "arc", "Aram\u00e4isch" },
            { "Loma", "Loma" },
            { "015", "Nordafrika" },
            { "SG", "Singapur" },
            { "SH", "St. Helena" },
            { "type.lb.strict", "fester Zeilenumbruch" },
            { "017", "Zentralafrika" },
            { "SI", "Slowenien" },
            { "018", "S\u00fcdliches Afrika" },
            { "SJ", "Spitzbergen und Jan Mayen" },
            { "Bamu", metaValue_bax },
            { "019", "Amerika" },
            { "SK", "Slowakei" },
            { "Wole", "Woleaianisch" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "arn", "Mapudungun" },
            { "arp", "Arapaho" },
            { "type.nu.taml", "Tamilische Ziffern" },
            { "SR", "Suriname" },
            { "aro", "Araona" },
            { "SS", "S\u00fcdsudan" },
            { "ST", "S\u00e3o Tom\u00e9 und Pr\u00edncipe" },
            { "arq", "Algerisches Arabisch" },
            { "SV", "El Salvador" },
            { "ars", "Arabisch (Nadschd)" },
            { "SX", "Sint Maarten" },
            { "SY", "Syrien" },
            { "yao", "Yao" },
            { "SZ", "Swasiland" },
            { "arw", "Arawak" },
            { "arz", "\u00c4gyptisches Arabisch" },
            { "ary", "Marokkanisches Arabisch" },
            { "yap", "Yapesisch" },
            { "rtm", "Rotumanisch" },
            { "TA", "Tristan da Cunha" },
            { "asa", "Asu" },
            { "type.ms.ussystem", "US-Ma\u00dfsystem" },
            { "021", "N\u00f6rdliches Amerika" },
            { "TC", "Turks- und Caicosinseln" },
            { "yav", "Yangben" },
            { "TD", "Tschad" },
            { "TF", "Franz\u00f6sische S\u00fcd- und Antarktisgebiete" },
            { "ase", "Amerikanische Geb\u00e4rdensprache" },
            { "TG", "Togo" },
            { "TH", "Thailand" },
            { "TJ", "Tadschikistan" },
            { "029", "Karibik" },
            { "TK", "Tokelau" },
            { "TL", "Timor-Leste" },
            { "ybb", "Yemba" },
            { "type.co.searchjl", "Suche nach Anfangsbuchstaben des koreanischen Alphabets" },
            { "TM", "Turkmenistan" },
            { "%%BOONT", "Boontling" },
            { "TN", "Tunesien" },
            { "TO", "Tonga" },
            { "TR", "T\u00fcrkei" },
            { "TT", "Trinidad und Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "ast", "Asturianisch" },
            { "rue", "Russinisch" },
            { "rug", "Roviana" },
            { "Orkh", "Orchon-Runen" },
            { "TZ", "Tansania" },
            { "nmg", "Kwasio" },
            { "Zzzz", "Unbekannte Schrift" },
            { "Sind", "Khudawadi" },
            { "UA", "Ukraine" },
            { "lij", "Ligurisch" },
            { "rup", "Aromunisch" },
            { "030", "Ostasien" },
            { "tyv", "Tuwinisch" },
            { "sw_CD", "Kongo-Swahili" },
            { "034", "S\u00fcdasien" },
            { "hai", "Haida" },
            { "035", "S\u00fcdostasien" },
            { "UG", "Uganda" },
            { "hak", "Hakka" },
            { "type.co.pinyin", "Pinyin-Sortierregeln" },
            { "039", "S\u00fcdeuropa" },
            { "Sinh", metaValue_si },
            { "UM", "Amerikanische \u00dcberseeinseln" },
            { "liv", "Livisch" },
            { "UN", "Vereinte Nationen" },
            { "US", "Vereinigte Staaten" },
            { "haw", "Hawaiisch" },
            { "%%1959ACAD", "Akademisch" },
            { "type.co.gb2312han", "Vereinfachtes Chinesisch - GB2312" },
            { "UY", "Uruguay" },
            { "prg", "Altpreu\u00dfisch" },
            { "UZ", "Usbekistan" },
            { "tzm", "Zentralatlas-Tamazight" },
            { "type.co.stroke", "Strichfolge" },
            { "nnh", "Ngiemboon" },
            { "VA", "Vatikanstadt" },
            { "pro", "Altprovenzalisch" },
            { "VC", "St. Vincent und die Grenadinen" },
            { "VE", "Venezuela" },
            { "VG", "Britische Jungferninseln" },
            { "VI", "Amerikanische Jungferninseln" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "nog", "Nogai" },
            { "rwk", "Rwa" },
            { "non", "Altnordisch" },
            { "053", "Australasien" },
            { "%%AREVMDA", "Westarmenisch" },
            { "054", "Melanesien" },
            { "WF", "Wallis und Futuna" },
            { "type.co.traditional", "Traditionelle Sortierregeln" },
            { "057", "Mikronesisches Inselgebiet" },
            { "jgo", "Ngomba" },
            { "lkt", "Lakota" },
            { "nov", "Novial" },
            { "type.nu.finance", "Finanzzahlen" },
            { "avk", "Kotava" },
            { "type.co.compat", "vorherige Sortierung, Kompatibilit\u00e4t" },
            { "wae", "Walliserdeutsch" },
            { "WS", "Samoa" },
            { "Bass", "Bassa" },
            { "type.nu.mtei", "Meitei-Mayek-Ziffern" },
            { "wal", "Walamo" },
            { "was", "Washo" },
            { "war", "Waray" },
            { "awa", "Awadhi" },
            { "061", "Polynesien" },
            { "XK", "Kosovo" },
            { "type.nu.brah", "Brahmi-Ziffern" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "Schriftlos" },
            { "Olck", "Ol Chiki" },
            { "wbp", "Warlpiri" },
            { "Batk", "Battakisch" },
            { "Blis", metaValue_zbl },
            { "YE", "Jemen" },
            { "nqo", metaValue_nqo },
            { "type.co.standard", "Standard-Sortierung" },
            { "lmo", "Lombardisch" },
            { "fan", "Pangwe" },
            { "%%ROZAJ", "Resianisch" },
            { "fat", "Fanti" },
            { "Sgnw", "Geb\u00e4rdensprache" },
            { "YT", "Mayotte" },
            { "type.nu.cham", "Cham-Ziffern" },
            { "ZA", "S\u00fcdafrika" },
            { "type.nu.sund", "Sundanesische Ziffern" },
            { "type.lb.loose", "lockerer Zeilenumbruch" },
            { "Deva", "Devanagari" },
            { "type.nu.geor", "Georgische Ziffern" },
            { "type.co.zhuyin", "Zhuyin-Sortierregeln" },
            { "Hira", "Hiragana" },
            { "ZM", "Sambia" },
            { "%%PINYIN", "Pinyin" },
            { "ZW", "Simbabwe" },
            { "ZZ", "Unbekannte Region" },
            { "Runr", "Runenschrift" },
            { "type.ms.metric", "metrisches System" },
            { "type.ca.iso8601", "ISO-8601-Kalender" },
            { "lol", "Mongo" },
            { "nso", "Nord-Sotho" },
            { "type.nu.telu", "Telugu-Ziffern" },
            { "lou", "Kreol (Louisiana)" },
            { "loz", "Lozi" },
            { "Nkgb", "Geba" },
            { "jmc", "Machame" },
            { "hif", "Fidschi-Hindi" },
            { "type.nu.hansfin", "Vereinfacht-chinesische Finanzziffern" },
            { "hil", "Hiligaynon" },
            { "type.nu.arabext", "Erweiterte arabisch-indische Ziffern" },
            { "nus", "Nuer" },
            { "dak", "Dakota" },
            { "type.nu.fullwide", "Vollbreite Ziffern" },
            { "hit", "Hethitisch" },
            { "dar", "Darginisch" },
            { "dav", "Taita" },
            { "Maya", "Maya-Hieroglyphen" },
            { "lrc", "N\u00f6rdliches Luri" },
            { "Copt", metaValue_cop },
            { "nwc", "Alt-Newari" },
            { "udm", "Udmurtisch" },
            { "Khmr", metaValue_km },
            { "type.ca.islamic-rgsa", "Islamischer Kalender (Saudi-Arabien, Beobachtung)" },
            { "Limb", "Limbu" },
            { "sad", "Sandawe" },
            { "type.nu.roman", "R\u00f6mische Ziffern" },
            { "sah", "Jakutisch" },
            { "type.nu.shrd", "Sharada-Ziffern" },
            { "sam", metaValue_sam },
            { "ltg", "Lettgallisch" },
            { "Aghb", "Kaukasisch-Albanisch" },
            { "%%SCOUSE", "Scouse-Dialekt" },
            { "saq", "Samburu" },
            { "sas", "Sasak" },
            { "sat", "Santali" },
            { "Tfng", "Tifinagh" },
            { "saz", metaValue_saz },
            { "jpr", "J\u00fcdisch-Persisch" },
            { "type.d0.npinyin", "Numerisch" },
            { "type.nu.native", "Native Ziffern" },
            { "sba", "Ngambay" },
            { "Guru", "Gurmukhi" },
            { "lua", "Luba-Lulua" },
            { "type.d0.fwidth", "Breit" },
            { "sbp", "Sangu" },
            { "lui", "Luiseno" },
            { "nyn", "Nyankole" },
            { "nym", "Nyamwezi" },
            { "lun", "Lunda" },
            { "nyo", "Nyoro" },
            { "luo", "Luo" },
            { "fil", "Filipino" },
            { "hmn", "Miao" },
            { "del", "Delaware" },
            { "lus", "Lushai" },
            { "bal", "Belutschisch" },
            { "den", "Slave" },
            { "ban", metaValue_ban },
            { "uga", metaValue_uga },
            { "fit", "Me\u00e4nkieli" },
            { "luy", "Luhya" },
            { "bar", "Bairisch" },
            { "bas", "Basaa" },
            { "bax", metaValue_bax },
            { "jrb", "J\u00fcdisch-Arabisch" },
            { "nzi", "Nzima" },
            { "sco", "Schottisch" },
            { "scn", "Sizilianisch" },
            { "aa", "Afar" },
            { "ab", "Abchasisch" },
            { "bbc", "Batak Toba" },
            { "ae", metaValue_ae },
            { "af", "Afrikaans" },
            { "ak", "Akan" },
            { "type.nu.cakm", "Chakma-Ziffern" },
            { "bbj", "Ghomala" },
            { "am", "Amharisch" },
            { "Arab", metaValue_ar },
            { "an", "Aragonesisch" },
            { "%%SOLBA", "Solbica-Dialekt" },
            { "Jpan", metaValue_ja },
            { "ar", metaValue_ar },
            { "Hrkt", "Japanische Silbenschrift" },
            { "as", "Assamesisch" },
            { "sdc", "Sassarisch" },
            { "Lina", "Linear A" },
            { "av", "Awarisch" },
            { "Linb", "Linear B" },
            { "sdh", "S\u00fcdkurdisch" },
            { "ay", "Aymara" },
            { "az", "Aserbaidschanisch" },
            { "Khoj", "Khojki" },
            { "%%OSOJS", "Osojane-Dialekt" },
            { "ba", "Baschkirisch" },
            { "type.co.unihan", "Radikal-Strich-Sortierregeln" },
            { "be", "Wei\u00dfrussisch" },
            { "bg", "Bulgarisch" },
            { "bi", "Bislama" },
            { "type.nu.java", "Javanesische Ziffern" },
            { "bm", "Bambara" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "dgr", "Dogrib" },
            { "br", "Bretonisch" },
            { "bs", "Bosnisch" },
            { "see", "Seneca" },
            { "Mymr", metaValue_my },
            { "sei", "Seri" },
            { "type.nu.laoo", "Laotische Ziffern" },
            { "seh", "Sena" },
            { "Nkoo", metaValue_nqo },
            { "sel", "Selkupisch" },
            { "ca", "Katalanisch" },
            { "ses", "Koyra Senni" },
            { "ce", "Tschetschenisch" },
            { "ch", "Chamorro" },
            { "%%REVISED", "Revidierte Rechtschreibung" },
            { "co", "Korsisch" },
            { "Orya", metaValue_or },
            { "cr", "Cree" },
            { "cs", "Tschechisch" },
            { "cu", "Kirchenslawisch" },
            { "yrl", "Nheengatu" },
            { "cv", "Tschuwaschisch" },
            { "cy", "Walisisch" },
            { "type.nu.ethi", "\u00c4thiopische Ziffern" },
            { "Yiii", metaValue_ii },
            { "da", "D\u00e4nisch" },
            { "de", "Deutsch" },
            { "type.cf.standard", "W\u00e4hrungsformat (Standard)" },
            { "bej", "Bedauye" },
            { "din", "Dinka" },
            { "jut", "J\u00fctisch" },
            { "Bugi", metaValue_bug },
            { "bem", "Bemba" },
            { "sga", "Altirisch" },
            { "type.nu.mong", "Mongolische Ziffern" },
            { "dv", "Dhivehi" },
            { "bew", "Betawi" },
            { "dz", "Dzongkha" },
            { "bez", "Bena" },
            { "type.ca.chinese", "Chinesischer Kalender" },
            { "lzh", "Klassisches Chinesisch" },
            { "Lisu", "Fraser" },
            { "dje", "Zarma" },
            { "sgs", "Samogitisch" },
            { "type.nu.grek", "Griechische Ziffern" },
            { "ee", "Ewe" },
            { "bfd", "Bafut" },
            { "type.lb.normal", "normaler Zeilenumbruch" },
            { "ro_MD", "Moldauisch" },
            { "el", metaValue_el },
            { "en", "Englisch" },
            { "eo", "Esperanto" },
            { "bfq", "Badaga" },
            { "lzz", "Lasisch" },
            { "type.co.big5han", "Traditionelles Chinesisch - Big5" },
            { "es", "Spanisch" },
            { "et", "Estnisch" },
            { "Hanb", "Hanb" },
            { "eu", "Baskisch" },
            { "Buhd", "Buhid" },
            { "Hang", "Hangul" },
            { "Samr", metaValue_sam },
            { "shi", "Taschelhit" },
            { "Hani", metaValue_zh },
            { "hsb", "Obersorbisch" },
            { "shn", "Schan" },
            { "Hano", "Hanunoo" },
            { "fa", "Persisch" },
            { "Hans", "Vereinfacht" },
            { "type.nu.latn", "Westliche Ziffern" },
            { "Hant", "Traditionell" },
            { "ff", "Ful" },
            { "shu", "Tschadisch-Arabisch" },
            { "hsn", "Xiang" },
            { "fi", "Finnisch" },
            { "fj", metaValue_FJ },
            { "fon", "Fon" },
            { "bgn", "Westliches Belutschi" },
            { "yue", "Kantonesisch" },
            { "fo", "F\u00e4r\u00f6isch" },
            { "type.m0.bgn", "BGN" },
            { "umb", "Umbundu" },
            { "fr", "Franz\u00f6sisch" },
            { "sid", "Sidamo" },
            { "fy", "Westfriesisch" },
            { "ga", "Irisch" },
            { "gd", "Schottisches G\u00e4lisch" },
            { "gl", "Galicisch" },
            { "gn", "Guaran\u00ed" },
            { "bho", "Bhodschpuri" },
            { "und", "Unbekannte Sprache" },
            { "type.ca.ethiopic-amete-alem", "\u00c4thiopischer Kalender \"Amete Alem\"" },
            { "gu", metaValue_gu },
            { "type.ca.islamic-tbla", "Islamischer Kalender (tabellarisch, astronomische Epoche)" },
            { "gv", "Manx" },
            { "ha", "Haussa" },
            { "he", metaValue_he },
            { "hi", "Hindi" },
            { "hup", "Hupa" },
            { "bik", "Bikol" },
            { "bin", "Bini" },
            { "ho", "Hiri-Motu" },
            { "hr", "Kroatisch" },
            { "ht", "Haiti-Kreolisch" },
            { "hu", "Ungarisch" },
            { "hy", metaValue_hy },
            { "hz", "Herero" },
            { "frc", "Cajun" },
            { "%%FONIPA", "IPA Phonetisch" },
            { "ia", "Interlingua" },
            { "Jamo", "Jamo" },
            { "id", "Indonesisch" },
            { "type.nu.tibt", "Tibetische Ziffern" },
            { "ie", "Interlingue" },
            { "ig", "Igbo" },
            { "ii", metaValue_ii },
            { "frm", "Mittelfranz\u00f6sisch" },
            { "ik", "Inupiak" },
            { "fro", "Altfranz\u00f6sisch" },
            { "frp", "Frankoprovenzalisch" },
            { "io", "Ido" },
            { "frs", "Ostfriesisch" },
            { "bjn", "Banjaresisch" },
            { "frr", "Nordfriesisch" },
            { "is", "Isl\u00e4ndisch" },
            { "it", "Italienisch" },
            { "iu", "Inuktitut" },
            { "sli", "Schlesisch (Niederschlesisch)" },
            { "ja", metaValue_ja },
            { "Mlym", metaValue_ml },
            { "Sarb", "Alts\u00fcdarabisch" },
            { "Sara", "Sarati" },
            { "doi", "Dogri" },
            { "sly", "Selayar" },
            { "type.nu.lepc", "Lepcha-Ziffern" },
            { "bkm", "Kom" },
            { "sma", "S\u00fcdsamisch" },
            { "jv", "Javanisch" },
            { "Shaw", "Shaw-Alphabet" },
            { "mad", "Maduresisch" },
            { "smj", "Lule-Samisch" },
            { "mag", "Khotta" },
            { "maf", "Mafa" },
            { "mai", "Maithili" },
            { "smn", "Inari-Samisch" },
            { "ka", metaValue_ka },
            { "bla", "Blackfoot" },
            { "mak", "Makassarisch" },
            { "wuu", "Wu" },
            { "sms", "Skolt-Samisch" },
            { "man", "Malinke" },
            { "kg", "Kongolesisch" },
            { "Goth", metaValue_got },
            { "ki", "Kikuyu" },
            { "mas", "Massai" },
            { "kj", "Kwanyama" },
            { "kk", "Kasachisch" },
            { "kl", "Gr\u00f6nl\u00e4ndisch" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "Kanuri" },
            { "ks", "Kaschmiri" },
            { "Cirt", "Cirth" },
            { "Lepc", "Lepcha" },
            { "Avst", metaValue_ae },
            { "ku", "Kurdisch" },
            { "kv", "Komi" },
            { "kw", "Kornisch" },
            { "ky", "Kirgisisch" },
            { "snk", "Soninke" },
            { "la", "Latein" },
            { "lb", "Luxemburgisch" },
            { "type.nu.mlym", "Malayalam-Ziffern" },
            { "lg", "Ganda" },
            { "Roro", "Rongorongo" },
            { "li", "Limburgisch" },
            { "Tibt", metaValue_bo },
            { "ln", "Lingala" },
            { "fur", "Friaulisch" },
            { "lo", metaValue_lo },
            { "type.ms.uksystem", "britisches Ma\u00dfsystem" },
            { "type.nu.lana", "Lanna-Ziffern (s\u00e4kular)" },
            { "lt", "Litauisch" },
            { "lu", "Luba-Katanga" },
            { "lv", "Lettisch" },
            { "sog", "Sogdisch" },
            { "mg", "Madagassisch" },
            { "mh", "Marschallesisch" },
            { "type.co.ducet", "Unicode-Sortierung" },
            { "mi", "Maori" },
            { "mk", "Mazedonisch" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "Marathi" },
            { "ms", "Malaiisch" },
            { "mt", "Maltesisch" },
            { "my", metaValue_my },
            { "Saur", metaValue_saz },
            { "Armn", metaValue_hy },
            { "mdf", "Mokschanisch" },
            { "mde", "Maba" },
            { "dsb", "Niedersorbisch" },
            { "Armi", "Armi" },
            { "na", "Nauruisch" },
            { "type.co.search", "allgemeine Suche" },
            { "nb", "Norwegisch Bokm\u00e5l" },
            { "nd", "Nord-Ndebele" },
            { "ne", "Nepalesisch" },
            { "ng", "Ndonga" },
            { "mdr", "Mandaresisch" },
            { "nl", "Niederl\u00e4ndisch" },
            { "nn", "Norwegisch Nynorsk" },
            { "no", "Norwegisch" },
            { "nr", "S\u00fcd-Ndebele" },
            { "nv", "Navajo" },
            { "kaa", "Karakalpakisch" },
            { "ny", "Nyanja" },
            { "kac", "Kachin" },
            { "kab", "Kabylisch" },
            { "%%POLYTON", "Polytonisch" },
            { "oc", "Okzitanisch" },
            { "kaj", "Jju" },
            { "kam", "Kamba" },
            { "men", metaValue_men },
            { "oj", "Ojibwa" },
            { "mer", "Meru" },
            { "type.nu.armn", "Armenische Ziffern" },
            { "om", "Oromo" },
            { "kaw", "Kawi" },
            { "dtp", "Zentral-Dusun" },
            { "or", metaValue_or },
            { "os", "Ossetisch" },
            { "bpy", "Bishnupriya" },
            { "kbd", "Kabardinisch" },
            { "mfe", "Morisyen" },
            { "srn", "Srananisch" },
            { "pa", "Punjabi" },
            { "dua", "Duala" },
            { "srr", "Serer" },
            { "%%LIPAW", "Lipovaz-Dialekt" },
            { "kbl", "Kanembu" },
            { "pi", "Pali" },
            { "bqi", "Bachtiarisch" },
            { "pl", "Polnisch" },
            { "dum", "Mittelniederl\u00e4ndisch" },
            { "type.nu.saur", "Saurashtra-Ziffern" },
            { "type.ca.dangi", "Dangi-Kalender" },
            { "ps", "Paschtu" },
            { "pt", "Portugiesisch" },
            { "mga", "Mittelirisch" },
            { "key.co", "Sortierung" },
            { "kcg", "Tyap" },
            { "mgh", "Makhuwa-Meetto" },
            { "key.cf", "W\u00e4hrungsformat" },
            { "type.nu.nkoo", "N\u2019Ko-Ziffern" },
            { "bra", "Braj-Bhakha" },
            { "key.ca", "Kalender" },
            { "Laoo", metaValue_lo },
            { "mgo", "Meta\u2019" },
            { "type.hc.h23", "24-Stunden-Format (0-23)" },
            { "type.hc.h24", "24-Stunden-Format (1-24)" },
            { "ssy", metaValue_ssy },
            { "brh", "Brahui" },
            { "type.nu.mymr", "Myanmar-Ziffern" },
            { "qu", "Quechua" },
            { "zap", "Zapotekisch" },
            { "brx", "Bodo" },
            { "Lana", "Lanna" },
            { "kde", "Makonde" },
            { "stq", "Saterfriesisch" },
            { "Ethi", "\u00c4thiopisch" },
            { "type.hc.h12", "12-Stunden-Format (1-12)" },
            { "type.hc.h11", "12-Stunden-Format (0-11)" },
            { "rm", "R\u00e4toromanisch" },
            { "rn", "Rundi" },
            { "key.cu", "W\u00e4hrung" },
            { "ro", "Rum\u00e4nisch" },
            { "%%SAAHO", metaValue_ssy },
            { "type.nu.orya", "Oriya-Ziffern" },
            { "type.nu.hanidec", "Chinesische Dezimalzahlen" },
            { "ru", "Russisch" },
            { "bss", "Akoose" },
            { "zbl", metaValue_zbl },
            { "rw", "Kinyarwanda" },
            { "kea", "Kabuverdianu" },
            { "mic", "Micmac" },
            { "suk", "Sukuma" },
            { "Dupl", "Duployanisch" },
            { "sa", "Sanskrit" },
            { "%%UCCOR", "Vereinheitlichte Rechtschreibung" },
            { "sc", "Sardisch" },
            { "sus", "Susu" },
            { "sd", "Sindhi" },
            { "se", "Nordsamisch" },
            { "min", "Minangkabau" },
            { "sg", "Sango" },
            { "sh", "Serbo-Kroatisch" },
            { "ken", "Kenyang" },
            { "si", metaValue_si },
            { "sux", "Sumerisch" },
            { "sk", "Slowakisch" },
            { "sl", "Slowenisch" },
            { "Gran", "Grantha" },
            { "sm", "Samoanisch" },
            { "sn", "Shona" },
            { "so", "Somali" },
            { "type.nu.arab", "Arabisch-indische Ziffern" },
            { "sq", "Albanisch" },
            { "sr", "Serbisch" },
            { "ss", "Swazi" },
            { "type.cf.account", "W\u00e4hrungsformat (Buchhaltung)" },
            { "st", "S\u00fcd-Sotho" },
            { "Java", "Javanesisch" },
            { "su", metaValue_su },
            { "%%NEDIS", "Natisone-Dialekt" },
            { "sv", "Schwedisch" },
            { "sw", "Suaheli" },
            { "type.nu.hantfin", "Traditionell-chinesische Finanzziffern" },
            { "ibb", "Ibibio" },
            { "iba", "Iban" },
            { "ta", "Tamil" },
            { "142", "Asien" },
            { "bua", "Burjatisch" },
            { "143", "Zentralasien" },
            { "te", metaValue_te },
            { "145", "Westasien" },
            { "tg", "Tadschikisch" },
            { "th", "Thail\u00e4ndisch" },
            { "bug", metaValue_bug },
            { "ti", "Tigrinya" },
            { "kfo", "Koro" },
            { "tk", "Turkmenisch" },
            { "tl", metaValue_tl },
            { "tn", "Tswana" },
            { "to", "Tongaisch" },
            { "bum", "Bulu" },
            { "dyo", "Diola" },
            { "type.nu.jpan", "Japanische Ziffern" },
            { "tr", "T\u00fcrkisch" },
            { "ts", "Tsonga" },
            { "swb", "Komorisch" },
            { "Cakm", "Chakma" },
            { "tt", "Tatarisch" },
            { "dyu", "Dyula" },
            { "tw", "Twi" },
            { "ty", "Tahitisch" },
            { "%%BISKE", "Bela-Dialekt" },
            { "150", "Europa" },
            { "151", "Osteuropa" },
            { "154", "Nordeuropa" },
            { "dzg", "Dazaga" },
            { "155", "Westeuropa" },
            { "ug", "Uigurisch" },
            { "Kore", metaValue_ko },
            { "Ital", "Altitalisch" },
            { "kgp", "Kaingang" },
            { "Zyyy", "Verbreitet" },
            { "uk", "Ukrainisch" },
            { "zea", "Seel\u00e4ndisch" },
            { "type.ca.coptic", "Koptischer Kalender" },
            { "ur", "Urdu" },
            { "%%1994", "Standardisierte Resianische Rechtschreibung" },
            { "xal", "Kalm\u00fcckisch" },
            { "zen", "Zenaga" },
            { "uz", "Usbekisch" },
            { "kha", "Khasi" },
            { "%%1996", "Neue deutsche Rechtschreibung" },
            { "nds_NL", "Nieders\u00e4chsisch" },
            { "Sylo", "Syloti Nagri" },
            { "ve", "Venda" },
            { "Wara", "Varang Kshiti" },
            { "type.ca.roc", "Kalender der Republik China" },
            { "vi", "Vietnamesisch" },
            { "kho", "Sakisch" },
            { "khq", "Koyra Chiini" },
            { "key.hc", "Stundenformat (12h/24h)" },
            { "%%TARASK", "Taraskievica-Orthographie" },
            { "vo", "Volap\u00fck" },
            { "khw", "Khowar" },
            { "syc", "Altsyrisch" },
            { "Osma", metaValue_ota },
            { "quc", "K\u2019iche\u2019" },
            { "qug", "Chimborazo Hochland-Quechua" },
            { "gaa", "Ga" },
            { "wa", "Wallonisch" },
            { "gag", "Gagausisch" },
            { "syr", metaValue_syr },
            { "Grek", metaValue_el },
            { "gan", "Gan" },
            { "kiu", "Kirmanjki" },
            { "Lydi", "Lydisch" },
            { "Xsux", "Sumerisch-akkadische Keilschrift" },
            { "wo", "Wolof" },
            { "zgh", "Tamazight" },
            { "ar_001", "Modernes Hocharabisch" },
            { "Cans", "UCAS" },
            { "gay", "Gayo" },
            { "Mong", metaValue_mn },
            { "mnc", "Mandschurisch" },
            { "Latf", "Lateinisch - Fraktur-Variante" },
            { "szl", "Schlesisch (Wasserpolnisch)" },
            { "Hluw", "Hieroglyphen-Luwisch" },
            { "gba", "Gbaya" },
            { "mni", "Meithei" },
            { "Latn", "Lateinisch" },
            { "Latg", "Lateinisch - G\u00e4lische Variante" },
            { "type.nu.hans", "Vereinfacht-chinesische Ziffern" },
            { "type.nu.hant", "Traditionell-chinesische Ziffern" },
            { "xh", "Xhosa" },
            { "type.nu.romanlow", "R\u00f6mische Ziffern in Kleinschrift" },
            { "byn", "Blin" },
            { "Lyci", "Lykisch" },
            { "osa", "Osage" },
            { "byv", "Medumba" },
            { "gbz", "Gabri" },
            { "Moon", "Moon" },
            { "moh", "Mohawk" },
            { "kkj", "Kako" },
            { "%%1694ACAD", "Klassisches Franz\u00f6sisch" },
            { "Syrc", metaValue_syr },
            { "yi", "Jiddisch" },
            { "mos", "Mossi" },
            { "Dsrt", "Deseret" },
            { "yo", "Yoruba" },
            { "type.nu.traditional", "Traditionelle Zahlen" },
            { "Syrj", "Westsyrisch" },
            { "ota", metaValue_ota },
            { "Syre", "Syrisch - Estrangelo-Variante" },
            { "vai", metaValue_vai },
            { "za", "Zhuang" },
            { "Cari", "Karisch" },
            { "kln", "Kalenjin" },
            { "zh", metaValue_zh },
            { "Afak", "Afaka" },
            { "Bopo", "Bopomofo" },
            { "Perm", "Altpermisch" },
            { "key.lb", "Zeilenumbruchstil" },
            { "zu", "Zulu" },
            { "type.co.phonebook", "Telefonbuch-Sortierung" },
            { "%%MONOTON", "Monotonisch" },
            { "Geor", metaValue_ka },
            { "Shrd", "Sharada" },
            { "kmb", "Kimbundu" },
            { "type.nu.jpanfin", "Japanische Finanzziffern" },
            { "gez", "Geez" },
            { "mrj", "Bergmari" },
            { "Syrn", "Ostsyrisch" },
            { "type.nu.mymrshan", "Myanmarische Shan-Ziffern" },
            { "Elba", "Elbasanisch" },
            { "Narb", "Altnordarabisch" },
            { "type.nu.olck", "Ol-Chiki-Ziffern" },
            { "type.co.reformed", "Reformierte Sortierreihenfolge" },
            { "Tglg", metaValue_tl },
            { "Egyd", "\u00c4gyptisch - Demotisch" },
            { "Egyh", "\u00c4gyptisch - Hieratisch" },
            { "Palm", "Palmyrenisch" },
            { "ebu", "Embu" },
            { "Egyp", "\u00c4gyptische Hieroglyphen" },
            { "Geok", "Khutsuri" },
            { "zh_Hans", "Chinesisch (vereinfacht)" },
            { "koi", "Komi-Permjakisch" },
            { "Hung", "Altungarisch" },
            { "kok", "Konkani" },
            { "%%1901", "Alte deutsche Rechtschreibung" },
            { "kos", "Kosraeanisch" },
            { "vec", "Venetisch" },
            { "type.nu.limb", "Limbu-Ziffern" },
            { "zh_Hant", "Chinesisch (traditionell)" },
            { "Sund", metaValue_su },
            { "vep", "Wepsisch" },
            { "kpe", metaValue_kpe },
            { "type.nu.khmr", "Khmer-Ziffern" },
            { "Tirh", "Tirhuta" },
            { "ilo", "Ilokano" },
            { "%%VALENCIA", "Valencianisch" },
            { "Cprt", "Zypriotisch" },
            { "%%BAKU1926", "Einheitliches T\u00fcrkisches Alphabet" },
            { "mua", "Mundang" },
            { "type.nu.guru", "Gurmukhi-Ziffern" },
            { "mul", "Mehrsprachig" },
            { "cad", "Caddo" },
            { "key.ms", "Ma\u00dfsystem" },
            { "mus", "Muskogee" },
            { "Glag", "Glagolitisch" },
            { "gil", "Kiribatisch" },
            { "%%KKCOR", "Allgemeine Rechtschreibung" },
            { "Cher", metaValue_chr },
            { "car", "Karibisch" },
            { "cay", "Cayuga" },
            { "type.nu.tamldec", "Tamil-Ziffern" },
            { "krc", "Karatschaiisch-Balkarisch" },
            { "inh", "Inguschisch" },
            { "krj", "Kinaray-a" },
            { "kri", "Krio" },
            { "krl", "Karelisch" },
            { "efi", "Efik" },
            { "tcy", "Tulu" },
            { "key.nu", "Zahlen" },
            { "kru", "Oraon" },
            { "ksb", "Shambala" },
            { "Telu", metaValue_te },
            { "ksf", "Bafia" },
        };
        return data;
    }
}
