/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.graph;

import org.apache.zookeeper.graph.LogEntry;

public class TransactionEntry
extends LogEntry {
    public TransactionEntry(long timestamp, long clientId, long Cxid, long Zxid, String op) {
        this(timestamp, clientId, Cxid, Zxid, op, "");
    }

    public TransactionEntry(long timestamp, long clientId, long Cxid, long Zxid, String op, String extra) {
        super(timestamp);
        this.setAttribute("client-id", new Long(clientId));
        this.setAttribute("cxid", new Long(Cxid));
        this.setAttribute("zxid", new Long(Zxid));
        this.setAttribute("operation", op);
        this.setAttribute("extra", extra);
    }

    public long getClientId() {
        return (Long)this.getAttribute("client-id");
    }

    public long getCxid() {
        return (Long)this.getAttribute("cxid");
    }

    public long getZxid() {
        return (Long)this.getAttribute("zxid");
    }

    public String getOp() {
        return (String)this.getAttribute("operation");
    }

    public String getExtra() {
        return (String)this.getAttribute("extra");
    }

    public String toString() {
        return this.getTimestamp() + ":::session(0x" + Long.toHexString(this.getClientId()) + ") cxid(0x" + Long.toHexString(this.getCxid()) + ") zxid(0x" + Long.toHexString(this.getZxid()) + ") op(" + this.getOp() + ") extra(" + this.getExtra() + ")";
    }

    @Override
    public LogEntry.Type getType() {
        return LogEntry.Type.TXN;
    }
}

