const Builder = @import("std").build.Builder;
const builtin = @import("builtin");
const std = @import("std");
const CheckFileStep = std.build.CheckFileStep;

pub fn build(b: *Builder) void {
    const target = .{
        .cpu_arch = .thumb,
        .cpu_model = .{ .explicit = &std.Target.arm.cpu.cortex_m4 },
        .os_tag = .freestanding,
        .abi = .gnueabihf,
    };

    const mode = b.standardReleaseOptions();

    const elf = b.addExecutable("zig-nrf52-blink.elf", "main.zig");
    elf.setTarget(target);
    elf.setBuildMode(mode);

    const test_step = b.step("test", "Test the program");
    b.default_step.dependOn(test_step);

    const hex_step = b.addInstallRaw(elf, "hello.hex", .{});
    test_step.dependOn(&hex_step.step);

    const explicit_format_hex_step = b.addInstallRaw(elf, "hello.foo", .{ .format = .hex });
    test_step.dependOn(&explicit_format_hex_step.step);

    const expected_hex = &[_][]const u8{
        ":020000021000EC",
        ":1000D400A401010001000000A601010001000000CC",
        ":1000E400FC01010001000000F80101000100000012",
        ":1000F4000E02010001000000B60201000100000030",
        ":10010400E00201000100000079020200000000008A",
        ":1001140000000000000000000000000000000000DB",
        ":1001240000000000000000000000000000000000CB",
        ":1001340000000000000000000000000000000000BB",
        ":1001440083020200F401010009000000FE01010025",
        ":100154000900000001000000000000000000000091",
        ":1001640000080002008001010004000010000000EB",
        ":100174000000000000000000000000001F0000005C",
        ":1001840048010100000040888000FF01142800524B",
        ":100194000080610100040020110000000000000044",
        ":1001A40000000000000000001F000000000000002C",
        ":1001B400000000000000000000000000000000003B",
        ":1001C400000000000000000000000000000000002B",
        ":1001D4000802010010000000190201002C000000B8",
        ":1001E400460201001B00000062020100130000002F",
        ":1001F400636F727465785F6D3400636F72746578D1",
        ":100204002D6D34006469766973696F6E206279209C",
        ":100214007A65726F0072656D61696E6465722064DF",
        ":1002240069766973696F6E206279207A65726F20CE",
        ":100234006F72206E656761746976652076616C758E",
        ":100244006500696E746567657220636173742074F8",
        ":1002540072756E6361746564206269747300696E9B",
        ":10026400646578206F7574206F6620626F756E64A4",
        ":100274007300000081B00091FFE700BEFDE7D0B538",
        ":1002840002AF90B00391029007A800F029F80399F7",
        ":100294000020069048680490FFE7049906980190AE",
        ":1002A40088420FD2FFE7019903980068405C07F881",
        ":1002B400310C17F8311C07A800F021F8019801301F",
        ":1002C4000690EAE7029807A9B1E80C50A0E80C50A0",
        ":1002D40091E81C5080E81C5010B0D0BDFFE7FEE749",
        ":1002E400D0B502AF40F2B011C0F20101B1E80C5038",
        ":1002F400A0E80C5091E81C5080E81C50D0BD80B59B",
        ":100304006F4688B006906FF35F2127F80A1C37F810",
        ":100314000A0C0490012038B9FFE740F2D410C0F26F",
        ":1003240001000021FFF7A6FF0498C0F3431027F84B",
        ":10033400020C37F80A0C0390002038B9FFE7039841",
        ":1003440000F01F000290012038B914E040F2DC10E4",
        ":10035400C0F201000021FFF78DFF029800F01F009A",
        ":1003640007F8030C0698009037F8020C0146019137",
        ":1003740009280ED306E040F2E410C0F20100002187",
        ":10038400FFF778FF40F2EC10C0F201000021FFF704",
        ":1003940071FF0099019A51F8220017F803CC012348",
        ":1003A40003FA0CF3184341F8220008B080BD81B071",
        ":1003B40000F03F008DF802009DF802000F3000F0BD",
        ":1003C4003F00022804D3FFE700208DF8030003E078",
        ":1003D40001208DF80300FFE79DF8030001B070478A",
        ":1003E4000A00000012000000020071001200000068",
        ":1003F4006600000003007D0C060000000000000001",
        ":1004040000011101250E1305030E10171B0EB44233",
        ":0A0414001911011206000002340065",
        ":020000021000EC",
        ":1000D400A401010001000000A601010001000000CC",
        ":1000E400FC01010001000000F80101000100000012",
        ":1000F4000E02010001000000B60201000100000030",
        ":10010400E00201000100000079020200000000008A",
        ":1001140000000000000000000000000000000000DB",
        ":1001240000000000000000000000000000000000CB",
        ":1001340000000000000000000000000000000000BB",
        ":1001440083020200F401010009000000FE01010025",
        ":100154000900000001000000000000000000000091",
        ":1001640000080002008001010004000010000000EB",
        ":100174000000000000000000000000001F0000005C",
        ":1001840048010100000040888000FF01142800524B",
        ":100194000080610100040020110000000000000044",
        ":1001A40000000000000000001F000000000000002C",
        ":1001B400000000000000000000000000000000003B",
        ":1001C400000000000000000000000000000000002B",
        ":1001D4000802010010000000190201002C000000B8",
        ":1001E400460201001B00000062020100130000002F",
        ":1001F400636F727465785F6D3400636F72746578D1",
        ":100204002D6D34006469766973696F6E206279209C",
        ":100214007A65726F0072656D61696E6465722064DF",
        ":1002240069766973696F6E206279207A65726F20CE",
        ":100234006F72206E656761746976652076616C758E",
        ":100244006500696E746567657220636173742074F8",
        ":1002540072756E6361746564206269747300696E9B",
        ":10026400646578206F7574206F6620626F756E64A4",
        ":100274007300000081B00091FFE700BEFDE7D0B538",
        ":1002840002AF90B00391029007A800F029F80399F7",
        ":100294000020069048680490FFE7049906980190AE",
        ":1002A40088420FD2FFE7019903980068405C07F881",
        ":1002B400310C17F8311C07A800F021F8019801301F",
        ":1002C4000690EAE7029807A9B1E80C50A0E80C50A0",
        ":1002D40091E81C5080E81C5010B0D0BDFFE7FEE749",
        ":1002E400D0B502AF40F2B011C0F20101B1E80C5038",
        ":1002F400A0E80C5091E81C5080E81C50D0BD80B59B",
        ":100304006F4688B006906FF35F2127F80A1C37F810",
        ":100314000A0C0490012038B9FFE740F2D410C0F26F",
        ":1003240001000021FFF7A6FF0498C0F3431027F84B",
        ":10033400020C37F80A0C0390002038B9FFE7039841",
        ":1003440000F01F000290012038B914E040F2DC10E4",
        ":10035400C0F201000021FFF78DFF029800F01F009A",
        ":1003640007F8030C0698009037F8020C0146019137",
        ":1003740009280ED306E040F2E410C0F20100002187",
        ":10038400FFF778FF40F2EC10C0F201000021FFF704",
        ":1003940071FF0099019A51F8220017F803CC012348",
        ":1003A40003FA0CF3184341F8220008B080BD81B071",
        ":1003B40000F03F008DF802009DF802000F3000F0BD",
        ":1003C4003F00022804D3FFE700208DF8030003E078",
        ":1003D40001208DF80300FFE79DF8030001B070478A",
        ":1003E4000A00000012000000020071001200000068",
        ":1003F4006600000003007D0C060000000000000001",
        ":1004040000011101250E1305030E10171B0EB44233",
        ":0A0414001911011206000002340065",
        ":020000022000DC",
        ":1002780081B00091FFE700BEFDE7D0B502AF90B0B6",
        ":100288000391029007A800F029F80399002006902E",
        ":1002980048680490FFE704990698019088420FD2B5",
        ":1002A800FFE7019903980068405C07F8310C17F8DC",
        ":1002B800311C07A800F021F8019801300690EAE700",
        ":1002C800029807A9B1E80C50A0E80C5091E81C501E",
        ":1002D80080E81C5010B0D0BDFFE7FEE7D0B502AFF4",
        ":1002E80040F2B011C0F20101B1E80C50A0E80C5086",
        ":1002F80091E81C5080E81C50D0BD80B56F4688B08E",
        ":1003080006906FF35F2127F80A1C37F80A0C04904F",
        ":10031800012038B9FFE740F2D410C0F201000021F3",
        ":10032800FFF7A6FF0498C0F3431027F8020C37F82C",
        ":100338000A0C0390002038B9FFE7039800F01F006B",
        ":100348000290012038B914E040F2DC10C0F201003C",
        ":100358000021FFF78DFF029800F01F0007F8030C3B",
        ":100368000698009037F8020C0146019109280ED32F",
        ":1003780006E040F2E410C0F201000021FFF778FF28",
        ":1003880040F2EC10C0F201000021FFF771FF009964",
        ":10039800019A51F8220017F803CC012303FA0CF351",
        ":1003A800184341F8220008B080BD81B000F03F003A",
        ":1003B8008DF802009DF802000F3000F03F0002287F",
        ":1003C80004D3FFE700208DF8030003E001208DF837",
        ":0C03D8000300FFE79DF8030001B0704730",
        ":00000001FF",
    };

    test_step.dependOn(&CheckFileStep.create(b, hex_step.getOutputSource(), expected_hex).step);
    test_step.dependOn(&CheckFileStep.create(b, explicit_format_hex_step.getOutputSource(), expected_hex).step);
}
