---
title: "Zitieren mit Zettlr"
keywords:
  - Zotero
  - JabRef
  - CSL JSON
  - BibTex
  - Literaturverwaltung
...

# Zitieren mit Zettlr 💬

In dieser letzten Einführung wollen wir dir zeigen, wie du deine Literatur mit Zettlr verwalten kannst. Wenn du bereits Erfahrung mit dem Zotero- oder Citavi-Plugin für Word gemacht hast: Zettlr funktioniert sehr ähnlich, aber funktioniert wesentlich effizienter.

Um mit Zettlr zu zitieren, sind einige wenige Vorarbeiten nötig, wie das aufsetzen einer Literaturdatenbank. Das haben wir aber [im Zettlr-Handbuch ausführlich beschrieben](https://docs.zettlr.com/de/academic/citations/). Für dieses Tutorial haben wir dir bereits eine kleine Literaturdatenbank erstellt, sodass du das jetzt noch nicht machen musst. Lass uns diese nun erst laden!

Öffne die Einstellungen und wechsle zum „Exportieren“-Reiter. Dort kannst du eine „CSL-Datenbank“ auswählen. Die Datenbank ist im Tutorial-Ordner. Wenn du sie gefunden hast, speichere die Einstellungen. Zettlr wird die Datenbank nun automatisch laden.

## Deine erste Zitation 🎓

Nun wollen wir die Datenbank nutzen, um eine erste Zitation zu erstellen. In der Datenbank befinden sich die Angaben eines Buches, aus welchem folgendes Zitat stammt:

> Es findet hier also ein Widerstreit statt, Recht wider Recht, beide gleichmäßig durch das Gesetz des Warenaustauschs besiegelt. **Zwischen gleichen Rechten entscheidet die Gewalt.** Und so stellt sich in der Geschichte der kapitalistischen Produktion die Normierung des Arbeitstags als Kampf um die Schranken des Arbeitstags dar — ein Kampf zwischen dem Gesamtkapitalisten, d.h. der Klasse der Kapitalisten, und dem Gesamtarbeiter, oder der Arbeiterklasse.

Es handelt sich hierbei um das berühmte Zitat von Karl Marx‘ _Das Kapital_ (Ausgabe 1). Um das Werk zu zitieren benötigst du die entsprechende ID (oft „Cite Key“ genannt). Zettlr bietet dir, sobald du ein `@`-Zeichen eintippst, automatisch eine Liste aller Werke an, die sich in der Bibliothek befinden. Die Zitation selbst umgibst du mit eckigen Klammern. Weiterhin kannst du zusätzliche Angaben machen (wie etwa Seitenangaben). Insgesamt muss eine Zitation mindestens eine ID enthalten (`[@CiteKey]`), kann aber insgesamt einen Präfix, einen Locator (= die Seitenangaben oder Kapitelangaben) sowie einen Suffix enthalten (`[Präfix @CiteKey, Seitenangaben Suffix]`). Zettlr erkennt ebenfalls gängige Angaben wie "S.", "Abschnitt", oder "Abb." (z.B. `[vgl. @AutorJahr, Abb. 1.3]`).

Doch zurück zu obigem Zitat: Kannst du eine Literaturangabe dort machen, die als `(Marx 1962, 23: 249)` dargestellt wird? Du solltest dann in der Seitenleiste auch den vollständigen Nachweis sehen können.

> Wenn du aus Versehen einen Schreibfehler oder einen anderen Fehler gemacht hast, wird die Zitation nicht ersetzt und bleibt bei dem Ursprungstext, und wird auch nicht in der Seitenleiste angezeigt. In diesem Fall versuche, den Fehler zu korrigieren. Zettlr ist zwar intelligent im Umgang mit Zitationen, aber leider immer noch nur ein Computerprogramm.

## Das Literaturverzeichnis 💻

Sobald du längere Artikel, oder gar eine Abschlussarbeit mit Zettlr schreibst, wird es irgendwann unübersichtlich, alle Zitationen im Blick zu behalten. Daher bietet dir Zettlr im zweiten Reiter der Seitenleiste eine Vorschau aller verwendeten Zitationen im aktuellen Dokument. Dieses Literaturverzeichnis wird dargestellt, wie es auch beim Export geschieht. Denn nicht vergessen: Alle Zitationen in Zettlr sind nur zu _Vorschauzwecken_, deshalb musst du auch kein Literaturverzeichnis manuell am Ende deiner Dokumente anlegen. Zettlr verwendet zur Darstellung einen eigenen Stil, aber du kannst einen beliebigen Zitationsstil in den Einstellungen auswählen. Dieser wird dann beim finalen Export automatisch verwendet.

> Zum Zitieren benötigst du außer Pandoc noch Pandoc-Citeproc. Letzteres ist bei Pandoc ab Version 2.11 automatisch integriert. Bei früheren Pandoc-Versionen musst du es ggfs. noch manuell installieren. Mehr Informationen hierzu finden sich [im Handbuch](https://docs.zettlr.com/de/install/#pandoc-installieren).

## Zum Abschluss 🔥

Das war es mit unserer kurzen Einführung zu Zettlr – Jetzt bist du bereit, zu starten!

Eine letzte Sache, auf die wir hier noch aufmerksam machen wollen, ist die großartige Gemeinschaft um Zettlr herum. Wir könnten ein so großes, mächtiges Programm nicht ohne die Hilfe zahlreicher Unterstützer\*innen weltweit realisieren. Die Community hilft sich gegenseitig im Forum und auf Reddit, hilft mit, Übersetzungen für Zettlr (wie diese Einführung) zu realisieren und testet neue Versionen auf Fehler.

Wenn auch du Zettlr unterstützen möchtest, werde Teil der Community! Auch wenn du gerade erst neu in der Community bist, ist dein Input sehr wichtig. Eine Sache, die du in wenigen Stunden schon verlässlich einschätzen kannst, ist beispielsweise, wie gut diese Einführung ist! Wenn du denkst, dass einige Sachen in der Einführung verbessert werden können, öffne einfach ein neues Thema!

Unsere Community findest du hier (alles englischsprachig):

- [Im Forum](https://forum.zettlr.com/)
- [Auf Reddit](https://www.reddit.com/r/Zettlr/)
- [Auf GitHub](https://github.com/Zettlr/Zettlr/)

**Viel Spaß mit Zettlr!**

![zettlr.png](./zettlr.png)
