/*-
 * Copyright (c) 2001, 2003 Allan Saddi <allan@saddi.com>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY ALLAN SADDI AND HIS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL ALLAN SADDI OR HIS CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: statpack.c 354 2003-02-23 23:37:13Z asaddi $
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /* HAVE_CONFIG_H */

#include <sys/types.h>
#include <sys/stat.h>

#if HAVE_INTTYPES_H
# include <inttypes.h>
#else
# if HAVE_STDINT_H
#  include <stdint.h>
# endif
#endif

#include <string.h>

#include "yafic.h"
#include "statpack.h"
#include "sha1.h"

#ifndef lint
static const char rcsid[] =
	"$Id: statpack.c 354 2003-02-23 23:37:13Z asaddi $";
#endif /* !lint */

void
PackStat (struct stat *sb, uint8_t *buf)
{
  ST_MODE_PACK (sb->st_mode, buf); buf += SIZEOF_STAT_ST_MODE;
  ST_INO_PACK (sb->st_ino, buf); buf += SIZEOF_STAT_ST_INO;
  ST_NLINK_PACK (sb->st_nlink, buf); buf += SIZEOF_STAT_ST_NLINK;
  ST_UID_PACK (sb->st_uid, buf); buf += SIZEOF_STAT_ST_UID;
  ST_GID_PACK (sb->st_gid, buf); buf += SIZEOF_STAT_ST_GID;
  ST_SIZE_PACK (sb->st_size, buf); buf += SIZEOF_STAT_ST_SIZE;
  ST_ATIME_PACK (sb->st_atime, buf); buf += SIZEOF_STAT_ST_ATIME;
  ST_MTIME_PACK (sb->st_mtime, buf); buf += SIZEOF_STAT_ST_MTIME;
  ST_CTIME_PACK (sb->st_ctime, buf);
}

void
UnpackStat (uint8_t *buf, struct stat *sb)
{
  memset (sb, 0, sizeof (*sb));
  sb->st_mode = ST_MODE_UNPACK (buf); buf += SIZEOF_STAT_ST_MODE;
  sb->st_ino = ST_INO_UNPACK (buf); buf += SIZEOF_STAT_ST_INO;
  sb->st_nlink = ST_NLINK_UNPACK (buf); buf += SIZEOF_STAT_ST_NLINK;
  sb->st_uid = ST_UID_UNPACK (buf); buf += SIZEOF_STAT_ST_UID;
  sb->st_gid = ST_GID_UNPACK (buf); buf += SIZEOF_STAT_ST_GID;
  sb->st_size = ST_SIZE_UNPACK (buf); buf += SIZEOF_STAT_ST_SIZE;
  sb->st_atime = ST_ATIME_UNPACK (buf); buf += SIZEOF_STAT_ST_ATIME;
  sb->st_mtime = ST_MTIME_UNPACK (buf); buf += SIZEOF_STAT_ST_MTIME;
  sb->st_ctime = ST_CTIME_UNPACK (buf);
}
