// Copyright (c) 2020, QuantStack and XVega Contributors
//
// Distributed under the terms of the BSD 3-Clause License.
//
// The full license is in the file LICENSE, distributed with this software.

#ifndef XVEGA_ENCODING_X_HPP
#define XVEGA_ENCODING_X_HPP

#include <xproperty/xobserved.hpp>

#include <xtl/xoptional.hpp>
#include <xtl/xjson.hpp>

#include <nlohmann/json.hpp>

#include "../../encoding-channel-options/aggregate.hpp"
#include "../../encoding-channel-options/axis.hpp"
#include "../../encoding-channel-options/bin.hpp"
#include "../../encoding-channel-options/field.hpp"
#include "../../encoding-channel-options/impute.hpp"
#include "../../encoding-channel-options/scale.hpp"
#include "../../encoding-channel-options/sort.hpp"
#include "../../encoding-channel-options/stack.hpp"
#include "../../encoding-channel-options/timeunit.hpp"
#include "../../../../utils/custom_datatypes.hpp"

namespace nl = nlohmann;

namespace xv
{
    struct X : public xp::xobserved<X>
    {
        XPROPERTY(xtl::xoptional<agg_type>, X, aggregate);
        XPROPERTY(xtl::xoptional<axis_type>, X, axis);
        XPROPERTY(xtl::xoptional<double>, X, band);
        XPROPERTY(xtl::xoptional<bin_type>, X, bin);
        XPROPERTY(xtl::xoptional<field_type>, X, field);
        XPROPERTY(xtl::xoptional<impute_type>, X, impute);
        XPROPERTY(xtl::xoptional<scale_type>, X, scale);
        XPROPERTY(xtl::xoptional<sort_type>, X, sort);
        XPROPERTY(xtl::xoptional<stack_type>, X, stack);
        XPROPERTY(xtl::xoptional<time_unit_type>, X, timeUnit);
        XPROPERTY(xtl::xoptional<string_vec_none_type>, X, title);
        XPROPERTY(xtl::xoptional<std::string>, X, type);
    };

    XVEGA_API void to_json(nl::json& j, const X& data);
}

#endif
