
!Copyright (c) 2009,2010,2011,2012 Tom Schoonjans
!All rights reserved.

!Redistribution and use in source and binary forms, with or without
!modification, are permitted provided that the following conditions are met:
!    * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
!    * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
!    * The names of the contributors may not be used to endorse or promote products derived from this software without specific prior written permission.

!THIS SOFTWARE IS PROVIDED BY Tom Schoonjans ''AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL Tom Schoonjans BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.



!Fortran 2003 bindings for xraylib


#define _NIST_LIST_STRING_LENGTH 100
#define _RADIO_NUCLIDE_STRING_LENGTH 10
#define _CRYSTAL_STRING_LENGTH 100

MODULE xraylib

USE, INTRINSIC :: ISO_C_BINDING
IMPLICIT NONE

PRIVATE :: stringF2C

TYPE, BIND(C) :: compoundData_C
        INTEGER (C_INT) :: nElements
        REAL (C_DOUBLE) :: nAtomsAll
        TYPE (C_PTR) :: Elements
        TYPE (C_PTR) :: massFractions
        TYPE (C_PTR) :: nAtoms
        REAL (C_DOUBLE) :: molarMass
ENDTYPE

TYPE :: compoundData
        INTEGER (C_INT) :: nElements
        REAL (C_DOUBLE) :: nAtomsAll
        INTEGER (C_INT),DIMENSION(:),POINTER :: Elements
        REAL (C_DOUBLE),DIMENSION(:),POINTER :: massFractions
        REAL (C_DOUBLE),DIMENSION(:),POINTER :: nAtoms
        REAL (C_DOUBLE) :: molarMass
ENDTYPE

TYPE, BIND(C) :: xrlComplex_C
        REAL (C_DOUBLE) :: re
        REAL (C_DOUBLE) :: im
ENDTYPE

TYPE, BIND(C) :: Crystal_Atom
        INTEGER (C_INT) :: Zatom
        REAL (C_DOUBLE) :: fraction
        REAL (C_DOUBLE) :: x
        REAL (C_DOUBLE) :: y
        REAL (C_DOUBLE) :: z
ENDTYPE

TYPE, BIND(C) :: Crystal_Struct_C
        TYPE (C_PTR) :: name
        REAL (C_DOUBLE) :: a
        REAL (C_DOUBLE) :: b
        REAL (C_DOUBLE) :: c
        REAL (C_DOUBLE) :: alpha
        REAL (C_DOUBLE) :: beta
        REAL (C_DOUBLE) :: gamma
        REAL (C_DOUBLE) :: volume
        INTEGER (C_INT) :: n_atom
        TYPE (C_PTR) :: atom
ENDTYPE

TYPE :: Crystal_Struct
        CHARACTER (KIND=C_CHAR,LEN=40) :: name
        REAL (C_DOUBLE) :: a
        REAL (C_DOUBLE) :: b
        REAL (C_DOUBLE) :: c
        REAL (C_DOUBLE) :: alpha
        REAL (C_DOUBLE) :: beta
        REAL (C_DOUBLE) :: gamma
        REAL (C_DOUBLE) :: volume
        INTEGER (C_INT) :: n_atom
        TYPE (Crystal_Atom), DIMENSION(:), POINTER :: atom
ENDTYPE

TYPE, BIND(C) :: compoundDataNIST_C
        TYPE (C_PTR) :: name
        INTEGER (C_INT) :: nElements
        TYPE (C_PTR) :: Elements
        TYPE (C_PTR) :: massFractions
        REAL (C_DOUBLE) :: density
ENDTYPE

TYPE :: compoundDataNIST
        CHARACTER(LEN=_NIST_LIST_STRING_LENGTH, KIND=C_CHAR):: name
        INTEGER (C_INT) :: nElements
        INTEGER (C_INT), POINTER, DIMENSION(:) :: Elements
        REAL (C_DOUBLE), POINTER, DIMENSION(:)  :: massFractions
        REAL (C_DOUBLE) :: density
ENDTYPE

TYPE, BIND(C) :: Crystal_Array
        INTEGER (C_INT) :: n_crystal
        INTEGER (C_INT) :: n_alloc
        TYPE (C_PTR) :: crystal
ENDTYPE

TYPE, BIND(C) :: radioNuclideData_C
        TYPE (C_PTR) :: name
        INTEGER (C_INT) :: Z
        INTEGER (C_INT) :: A
        INTEGER (C_INT) :: N
        INTEGER (C_INT) :: Z_xray
        INTEGER (C_INT) :: nXrays
        TYPE (C_PTR) :: XrayLines
        TYPE (C_PTR) :: XrayIntensities
        INTEGER (C_INT) :: nGammas
        TYPE (C_PTR) :: GammaEnergies
        TYPE (C_PTR) :: GammaIntensities
ENDTYPE

TYPE :: radioNuclideData
        CHARACTER(LEN=_RADIO_NUCLIDE_STRING_LENGTH, KIND=C_CHAR):: name
        INTEGER (C_INT) :: Z
        INTEGER (C_INT) :: A
        INTEGER (C_INT) :: N
        INTEGER (C_INT) :: Z_xray
        INTEGER (C_INT) :: nXrays
        INTEGER (C_INT), POINTER, DIMENSION(:) :: XrayLines
        REAL (C_DOUBLE), POINTER, DIMENSION(:) :: XrayIntensities
        INTEGER (C_INT) :: nGammas
        REAL (C_DOUBLE), POINTER, DIMENSION(:) :: GammaEnergies
        REAL (C_DOUBLE), POINTER, DIMENSION(:) :: GammaIntensities
ENDTYPE



!NIST constants
REAL (KIND=C_DOUBLE),PARAMETER :: AVOGNUM = 0.602214179     ! Avogadro number (mol-1 * barn-1 * cm2)
REAL (KIND=C_DOUBLE),PARAMETER :: KEV2ANGST = 12.39841875   ! keV to angstrom-1 conversion factor
REAL (KIND=C_DOUBLE),PARAMETER :: MEC2 = 510.998910         ! electron rest mass (keV)
REAL (KIND=C_DOUBLE),PARAMETER :: RE2 = 0.079407877         ! square of classical electron radius (barn)
REAL (KIND=C_DOUBLE),PARAMETER :: R_E = 2.8179403267E-15    ! Classical electron radius (barn)



!Constants
INTEGER (KIND=C_INT),PARAMETER ::  NIST_LIST_STRING_LENGTH = _NIST_LIST_STRING_LENGTH
INTEGER (KIND=C_INT),PARAMETER ::  RADIO_NUCLIDE_STRING_LENGTH =&
_RADIO_NUCLIDE_STRING_LENGTH
INTEGER (KIND=C_INT),PARAMETER ::  CRYSTAL_STRING_LENGTH =&
_CRYSTAL_STRING_LENGTH

INTEGER (KIND=C_INT),PARAMETER ::  F1_TRANS   = 0
INTEGER (KIND=C_INT),PARAMETER ::  F12_TRANS  = 1
INTEGER (KIND=C_INT),PARAMETER ::  F13_TRANS  = 2
INTEGER (KIND=C_INT),PARAMETER ::  FP13_TRANS = 3
INTEGER (KIND=C_INT),PARAMETER ::  F23_TRANS  = 4

INTEGER (KIND=C_INT),PARAMETER :: FL12_TRANS = 1
INTEGER (KIND=C_INT),PARAMETER :: FL13_TRANS = 2
INTEGER (KIND=C_INT),PARAMETER :: FLP13_TRANS = 3
INTEGER (KIND=C_INT),PARAMETER :: FL23_TRANS = 4
INTEGER (KIND=C_INT),PARAMETER :: FM12_TRANS = 5
INTEGER (KIND=C_INT),PARAMETER :: FM13_TRANS = 6
INTEGER (KIND=C_INT),PARAMETER :: FM14_TRANS = 7
INTEGER (KIND=C_INT),PARAMETER :: FM15_TRANS = 8
INTEGER (KIND=C_INT),PARAMETER :: FM23_TRANS = 9
INTEGER (KIND=C_INT),PARAMETER :: FM24_TRANS = 10
INTEGER (KIND=C_INT),PARAMETER :: FM25_TRANS = 11
INTEGER (KIND=C_INT),PARAMETER :: FM34_TRANS = 12
INTEGER (KIND=C_INT),PARAMETER :: FM35_TRANS = 13
INTEGER (KIND=C_INT),PARAMETER :: FM45_TRANS = 14

INTEGER (KIND=C_INT),PARAMETER ::  KA_LINE = 0
INTEGER (KIND=C_INT),PARAMETER ::  KB_LINE = 1
INTEGER (KIND=C_INT),PARAMETER ::  LA_LINE = 2
INTEGER (KIND=C_INT),PARAMETER ::  LB_LINE = 3

INTEGER (KIND=C_INT),PARAMETER :: KL1_LINE = -1
INTEGER (KIND=C_INT),PARAMETER :: KL2_LINE = -2
INTEGER (KIND=C_INT),PARAMETER :: KL3_LINE = -3
INTEGER (KIND=C_INT),PARAMETER :: KM1_LINE = -4
INTEGER (KIND=C_INT),PARAMETER :: KM2_LINE = -5
INTEGER (KIND=C_INT),PARAMETER :: KM3_LINE = -6
INTEGER (KIND=C_INT),PARAMETER :: KM4_LINE = -7
INTEGER (KIND=C_INT),PARAMETER :: KM5_LINE = -8
INTEGER (KIND=C_INT),PARAMETER :: KN1_LINE = -9
INTEGER (KIND=C_INT),PARAMETER :: KN2_LINE = -10
INTEGER (KIND=C_INT),PARAMETER :: KN3_LINE = -11
INTEGER (KIND=C_INT),PARAMETER :: KN4_LINE = -12
INTEGER (KIND=C_INT),PARAMETER :: KN5_LINE = -13
INTEGER (KIND=C_INT),PARAMETER :: KN6_LINE = -14
INTEGER (KIND=C_INT),PARAMETER :: KN7_LINE = -15
INTEGER (KIND=C_INT),PARAMETER :: KO_LINE = -16
INTEGER (KIND=C_INT),PARAMETER :: KO1_LINE = -17
INTEGER (KIND=C_INT),PARAMETER :: KO2_LINE = -18
INTEGER (KIND=C_INT),PARAMETER :: KO3_LINE = -19
INTEGER (KIND=C_INT),PARAMETER :: KO4_LINE = -20
INTEGER (KIND=C_INT),PARAMETER :: KO5_LINE = -21
INTEGER (KIND=C_INT),PARAMETER :: KO6_LINE = -22
INTEGER (KIND=C_INT),PARAMETER :: KO7_LINE = -23
INTEGER (KIND=C_INT),PARAMETER :: KP_LINE = -24
INTEGER (KIND=C_INT),PARAMETER :: KP1_LINE = -25
INTEGER (KIND=C_INT),PARAMETER :: KP2_LINE = -26
INTEGER (KIND=C_INT),PARAMETER :: KP3_LINE = -27
INTEGER (KIND=C_INT),PARAMETER :: KP4_LINE = -28
INTEGER (KIND=C_INT),PARAMETER :: KP5_LINE = -29
INTEGER (KIND=C_INT),PARAMETER :: L1L2_LINE = -30
INTEGER (KIND=C_INT),PARAMETER :: L1L3_LINE = -31
INTEGER (KIND=C_INT),PARAMETER :: L1M1_LINE = -32
INTEGER (KIND=C_INT),PARAMETER :: L1M2_LINE = -33
INTEGER (KIND=C_INT),PARAMETER :: L1M3_LINE = -34
INTEGER (KIND=C_INT),PARAMETER :: L1M4_LINE = -35
INTEGER (KIND=C_INT),PARAMETER :: L1M5_LINE = -36
INTEGER (KIND=C_INT),PARAMETER :: L1N1_LINE = -37
INTEGER (KIND=C_INT),PARAMETER :: L1N2_LINE = -38
INTEGER (KIND=C_INT),PARAMETER :: L1N3_LINE = -39
INTEGER (KIND=C_INT),PARAMETER :: L1N4_LINE = -40
INTEGER (KIND=C_INT),PARAMETER :: L1N5_LINE = -41
INTEGER (KIND=C_INT),PARAMETER :: L1N6_LINE = -42
INTEGER (KIND=C_INT),PARAMETER :: L1N67_LINE = -43
INTEGER (KIND=C_INT),PARAMETER :: L1N7_LINE = -44
INTEGER (KIND=C_INT),PARAMETER :: L1O1_LINE = -45
INTEGER (KIND=C_INT),PARAMETER :: L1O2_LINE = -46
INTEGER (KIND=C_INT),PARAMETER :: L1O3_LINE = -47
INTEGER (KIND=C_INT),PARAMETER :: L1O4_LINE = -48
INTEGER (KIND=C_INT),PARAMETER :: L1O45_LINE = -49
INTEGER (KIND=C_INT),PARAMETER :: L1O5_LINE = -50
INTEGER (KIND=C_INT),PARAMETER :: L1O6_LINE = -51
INTEGER (KIND=C_INT),PARAMETER :: L1O7_LINE = -52
INTEGER (KIND=C_INT),PARAMETER :: L1P1_LINE = -53
INTEGER (KIND=C_INT),PARAMETER :: L1P2_LINE = -54
INTEGER (KIND=C_INT),PARAMETER :: L1P23_LINE = -55
INTEGER (KIND=C_INT),PARAMETER :: L1P3_LINE = -56
INTEGER (KIND=C_INT),PARAMETER :: L1P4_LINE = -57
INTEGER (KIND=C_INT),PARAMETER :: L1P5_LINE = -58
INTEGER (KIND=C_INT),PARAMETER :: L2L3_LINE = -59
INTEGER (KIND=C_INT),PARAMETER :: L2M1_LINE = -60
INTEGER (KIND=C_INT),PARAMETER :: L2M2_LINE = -61
INTEGER (KIND=C_INT),PARAMETER :: L2M3_LINE = -62
INTEGER (KIND=C_INT),PARAMETER :: L2M4_LINE = -63
INTEGER (KIND=C_INT),PARAMETER :: L2M5_LINE = -64
INTEGER (KIND=C_INT),PARAMETER :: L2N1_LINE = -65
INTEGER (KIND=C_INT),PARAMETER :: L2N2_LINE = -66
INTEGER (KIND=C_INT),PARAMETER :: L2N3_LINE = -67
INTEGER (KIND=C_INT),PARAMETER :: L2N4_LINE = -68
INTEGER (KIND=C_INT),PARAMETER :: L2N5_LINE = -69
INTEGER (KIND=C_INT),PARAMETER :: L2N6_LINE = -70
INTEGER (KIND=C_INT),PARAMETER :: L2N7_LINE = -71
INTEGER (KIND=C_INT),PARAMETER :: L2O1_LINE = -72
INTEGER (KIND=C_INT),PARAMETER :: L2O2_LINE = -73
INTEGER (KIND=C_INT),PARAMETER :: L2O3_LINE = -74
INTEGER (KIND=C_INT),PARAMETER :: L2O4_LINE = -75
INTEGER (KIND=C_INT),PARAMETER :: L2O5_LINE = -76
INTEGER (KIND=C_INT),PARAMETER :: L2O6_LINE = -77
INTEGER (KIND=C_INT),PARAMETER :: L2O7_LINE = -78
INTEGER (KIND=C_INT),PARAMETER :: L2P1_LINE = -79
INTEGER (KIND=C_INT),PARAMETER :: L2P2_LINE = -80
INTEGER (KIND=C_INT),PARAMETER :: L2P23_LINE = -81
INTEGER (KIND=C_INT),PARAMETER :: L2P3_LINE = -82
INTEGER (KIND=C_INT),PARAMETER :: L2P4_LINE = -83
INTEGER (KIND=C_INT),PARAMETER :: L2P5_LINE = -84
INTEGER (KIND=C_INT),PARAMETER :: L2Q1_LINE = -85
INTEGER (KIND=C_INT),PARAMETER :: L3M1_LINE = -86
INTEGER (KIND=C_INT),PARAMETER :: L3M2_LINE = -87
INTEGER (KIND=C_INT),PARAMETER :: L3M3_LINE = -88
INTEGER (KIND=C_INT),PARAMETER :: L3M4_LINE = -89
INTEGER (KIND=C_INT),PARAMETER :: L3M5_LINE = -90
INTEGER (KIND=C_INT),PARAMETER :: L3N1_LINE = -91
INTEGER (KIND=C_INT),PARAMETER :: L3N2_LINE = -92
INTEGER (KIND=C_INT),PARAMETER :: L3N3_LINE = -93
INTEGER (KIND=C_INT),PARAMETER :: L3N4_LINE = -94
INTEGER (KIND=C_INT),PARAMETER :: L3N5_LINE = -95
INTEGER (KIND=C_INT),PARAMETER :: L3N6_LINE = -96
INTEGER (KIND=C_INT),PARAMETER :: L3N7_LINE = -97
INTEGER (KIND=C_INT),PARAMETER :: L3O1_LINE = -98
INTEGER (KIND=C_INT),PARAMETER :: L3O2_LINE = -99
INTEGER (KIND=C_INT),PARAMETER :: L3O3_LINE = -100
INTEGER (KIND=C_INT),PARAMETER :: L3O4_LINE = -101
INTEGER (KIND=C_INT),PARAMETER :: L3O45_LINE = -102
INTEGER (KIND=C_INT),PARAMETER :: L3O5_LINE = -103
INTEGER (KIND=C_INT),PARAMETER :: L3O6_LINE = -104
INTEGER (KIND=C_INT),PARAMETER :: L3O7_LINE = -105
INTEGER (KIND=C_INT),PARAMETER :: L3P1_LINE = -106
INTEGER (KIND=C_INT),PARAMETER :: L3P2_LINE = -107
INTEGER (KIND=C_INT),PARAMETER :: L3P23_LINE = -108
INTEGER (KIND=C_INT),PARAMETER :: L3P3_LINE = -109
INTEGER (KIND=C_INT),PARAMETER :: L3P4_LINE = -110
INTEGER (KIND=C_INT),PARAMETER :: L3P45_LINE = -111
INTEGER (KIND=C_INT),PARAMETER :: L3P5_LINE = -112
INTEGER (KIND=C_INT),PARAMETER :: L3Q1_LINE = -113
INTEGER (KIND=C_INT),PARAMETER :: M1M2_LINE = -114
INTEGER (KIND=C_INT),PARAMETER :: M1M3_LINE = -115
INTEGER (KIND=C_INT),PARAMETER :: M1M4_LINE = -116
INTEGER (KIND=C_INT),PARAMETER :: M1M5_LINE = -117
INTEGER (KIND=C_INT),PARAMETER :: M1N1_LINE = -118
INTEGER (KIND=C_INT),PARAMETER :: M1N2_LINE = -119
INTEGER (KIND=C_INT),PARAMETER :: M1N3_LINE = -120
INTEGER (KIND=C_INT),PARAMETER :: M1N4_LINE = -121
INTEGER (KIND=C_INT),PARAMETER :: M1N5_LINE = -122
INTEGER (KIND=C_INT),PARAMETER :: M1N6_LINE = -123
INTEGER (KIND=C_INT),PARAMETER :: M1N7_LINE = -124
INTEGER (KIND=C_INT),PARAMETER :: M1O1_LINE = -125
INTEGER (KIND=C_INT),PARAMETER :: M1O2_LINE = -126
INTEGER (KIND=C_INT),PARAMETER :: M1O3_LINE = -127
INTEGER (KIND=C_INT),PARAMETER :: M1O4_LINE = -128
INTEGER (KIND=C_INT),PARAMETER :: M1O5_LINE = -129
INTEGER (KIND=C_INT),PARAMETER :: M1O6_LINE = -130
INTEGER (KIND=C_INT),PARAMETER :: M1O7_LINE = -131
INTEGER (KIND=C_INT),PARAMETER :: M1P1_LINE = -132
INTEGER (KIND=C_INT),PARAMETER :: M1P2_LINE = -133
INTEGER (KIND=C_INT),PARAMETER :: M1P3_LINE = -134
INTEGER (KIND=C_INT),PARAMETER :: M1P4_LINE = -135
INTEGER (KIND=C_INT),PARAMETER :: M1P5_LINE = -136
INTEGER (KIND=C_INT),PARAMETER :: M2M3_LINE = -137
INTEGER (KIND=C_INT),PARAMETER :: M2M4_LINE = -138
INTEGER (KIND=C_INT),PARAMETER :: M2M5_LINE = -139
INTEGER (KIND=C_INT),PARAMETER :: M2N1_LINE = -140
INTEGER (KIND=C_INT),PARAMETER :: M2N2_LINE = -141
INTEGER (KIND=C_INT),PARAMETER :: M2N3_LINE = -142
INTEGER (KIND=C_INT),PARAMETER :: M2N4_LINE = -143
INTEGER (KIND=C_INT),PARAMETER :: M2N5_LINE = -144
INTEGER (KIND=C_INT),PARAMETER :: M2N6_LINE = -145
INTEGER (KIND=C_INT),PARAMETER :: M2N7_LINE = -146
INTEGER (KIND=C_INT),PARAMETER :: M2O1_LINE = -147
INTEGER (KIND=C_INT),PARAMETER :: M2O2_LINE = -148
INTEGER (KIND=C_INT),PARAMETER :: M2O3_LINE = -149
INTEGER (KIND=C_INT),PARAMETER :: M2O4_LINE = -150
INTEGER (KIND=C_INT),PARAMETER :: M2O5_LINE = -151
INTEGER (KIND=C_INT),PARAMETER :: M2O6_LINE = -152
INTEGER (KIND=C_INT),PARAMETER :: M2O7_LINE = -153
INTEGER (KIND=C_INT),PARAMETER :: M2P1_LINE = -154
INTEGER (KIND=C_INT),PARAMETER :: M2P2_LINE = -155
INTEGER (KIND=C_INT),PARAMETER :: M2P3_LINE = -156
INTEGER (KIND=C_INT),PARAMETER :: M2P4_LINE = -157
INTEGER (KIND=C_INT),PARAMETER :: M2P5_LINE = -158
INTEGER (KIND=C_INT),PARAMETER :: M3M4_LINE = -159
INTEGER (KIND=C_INT),PARAMETER :: M3M5_LINE = -160
INTEGER (KIND=C_INT),PARAMETER :: M3N1_LINE = -161
INTEGER (KIND=C_INT),PARAMETER :: M3N2_LINE = -162
INTEGER (KIND=C_INT),PARAMETER :: M3N3_LINE = -163
INTEGER (KIND=C_INT),PARAMETER :: M3N4_LINE = -164
INTEGER (KIND=C_INT),PARAMETER :: M3N5_LINE = -165
INTEGER (KIND=C_INT),PARAMETER :: M3N6_LINE = -166
INTEGER (KIND=C_INT),PARAMETER :: M3N7_LINE = -167
INTEGER (KIND=C_INT),PARAMETER :: M3O1_LINE = -168
INTEGER (KIND=C_INT),PARAMETER :: M3O2_LINE = -169
INTEGER (KIND=C_INT),PARAMETER :: M3O3_LINE = -170
INTEGER (KIND=C_INT),PARAMETER :: M3O4_LINE = -171
INTEGER (KIND=C_INT),PARAMETER :: M3O5_LINE = -172
INTEGER (KIND=C_INT),PARAMETER :: M3O6_LINE = -173
INTEGER (KIND=C_INT),PARAMETER :: M3O7_LINE = -174
INTEGER (KIND=C_INT),PARAMETER :: M3P1_LINE = -175
INTEGER (KIND=C_INT),PARAMETER :: M3P2_LINE = -176
INTEGER (KIND=C_INT),PARAMETER :: M3P3_LINE = -177
INTEGER (KIND=C_INT),PARAMETER :: M3P4_LINE = -178
INTEGER (KIND=C_INT),PARAMETER :: M3P5_LINE = -179
INTEGER (KIND=C_INT),PARAMETER :: M3Q1_LINE = -180
INTEGER (KIND=C_INT),PARAMETER :: M4M5_LINE = -181
INTEGER (KIND=C_INT),PARAMETER :: M4N1_LINE = -182
INTEGER (KIND=C_INT),PARAMETER :: M4N2_LINE = -183
INTEGER (KIND=C_INT),PARAMETER :: M4N3_LINE = -184
INTEGER (KIND=C_INT),PARAMETER :: M4N4_LINE = -185
INTEGER (KIND=C_INT),PARAMETER :: M4N5_LINE = -186
INTEGER (KIND=C_INT),PARAMETER :: M4N6_LINE = -187
INTEGER (KIND=C_INT),PARAMETER :: M4N7_LINE = -188
INTEGER (KIND=C_INT),PARAMETER :: M4O1_LINE = -189
INTEGER (KIND=C_INT),PARAMETER :: M4O2_LINE = -190
INTEGER (KIND=C_INT),PARAMETER :: M4O3_LINE = -191
INTEGER (KIND=C_INT),PARAMETER :: M4O4_LINE = -192
INTEGER (KIND=C_INT),PARAMETER :: M4O5_LINE = -193
INTEGER (KIND=C_INT),PARAMETER :: M4O6_LINE = -194
INTEGER (KIND=C_INT),PARAMETER :: M4O7_LINE = -195
INTEGER (KIND=C_INT),PARAMETER :: M4P1_LINE = -196
INTEGER (KIND=C_INT),PARAMETER :: M4P2_LINE = -197
INTEGER (KIND=C_INT),PARAMETER :: M4P3_LINE = -198
INTEGER (KIND=C_INT),PARAMETER :: M4P4_LINE = -199
INTEGER (KIND=C_INT),PARAMETER :: M4P5_LINE = -200
INTEGER (KIND=C_INT),PARAMETER :: M5N1_LINE = -201
INTEGER (KIND=C_INT),PARAMETER :: M5N2_LINE = -202
INTEGER (KIND=C_INT),PARAMETER :: M5N3_LINE = -203
INTEGER (KIND=C_INT),PARAMETER :: M5N4_LINE = -204
INTEGER (KIND=C_INT),PARAMETER :: M5N5_LINE = -205
INTEGER (KIND=C_INT),PARAMETER :: M5N6_LINE = -206
INTEGER (KIND=C_INT),PARAMETER :: M5N7_LINE = -207
INTEGER (KIND=C_INT),PARAMETER :: M5O1_LINE = -208
INTEGER (KIND=C_INT),PARAMETER :: M5O2_LINE = -209
INTEGER (KIND=C_INT),PARAMETER :: M5O3_LINE = -210
INTEGER (KIND=C_INT),PARAMETER :: M5O4_LINE = -211
INTEGER (KIND=C_INT),PARAMETER :: M5O5_LINE = -212
INTEGER (KIND=C_INT),PARAMETER :: M5O6_LINE = -213
INTEGER (KIND=C_INT),PARAMETER :: M5O7_LINE = -214
INTEGER (KIND=C_INT),PARAMETER :: M5P1_LINE = -215
INTEGER (KIND=C_INT),PARAMETER :: M5P2_LINE = -216
INTEGER (KIND=C_INT),PARAMETER :: M5P3_LINE = -217
INTEGER (KIND=C_INT),PARAMETER :: M5P4_LINE = -218
INTEGER (KIND=C_INT),PARAMETER :: M5P5_LINE = -219
INTEGER (KIND=C_INT),PARAMETER :: N1N2_LINE = -220
INTEGER (KIND=C_INT),PARAMETER :: N1N3_LINE = -221
INTEGER (KIND=C_INT),PARAMETER :: N1N4_LINE = -222
INTEGER (KIND=C_INT),PARAMETER :: N1N5_LINE = -223
INTEGER (KIND=C_INT),PARAMETER :: N1N6_LINE = -224
INTEGER (KIND=C_INT),PARAMETER :: N1N7_LINE = -225
INTEGER (KIND=C_INT),PARAMETER :: N1O1_LINE = -226
INTEGER (KIND=C_INT),PARAMETER :: N1O2_LINE = -227
INTEGER (KIND=C_INT),PARAMETER :: N1O3_LINE = -228
INTEGER (KIND=C_INT),PARAMETER :: N1O4_LINE = -229
INTEGER (KIND=C_INT),PARAMETER :: N1O5_LINE = -230
INTEGER (KIND=C_INT),PARAMETER :: N1O6_LINE = -231
INTEGER (KIND=C_INT),PARAMETER :: N1O7_LINE = -232
INTEGER (KIND=C_INT),PARAMETER :: N1P1_LINE = -233
INTEGER (KIND=C_INT),PARAMETER :: N1P2_LINE = -234
INTEGER (KIND=C_INT),PARAMETER :: N1P3_LINE = -235
INTEGER (KIND=C_INT),PARAMETER :: N1P4_LINE = -236
INTEGER (KIND=C_INT),PARAMETER :: N1P5_LINE = -237
INTEGER (KIND=C_INT),PARAMETER :: N2N3_LINE = -238
INTEGER (KIND=C_INT),PARAMETER :: N2N4_LINE = -239
INTEGER (KIND=C_INT),PARAMETER :: N2N5_LINE = -240
INTEGER (KIND=C_INT),PARAMETER :: N2N6_LINE = -241
INTEGER (KIND=C_INT),PARAMETER :: N2N7_LINE = -242
INTEGER (KIND=C_INT),PARAMETER :: N2O1_LINE = -243
INTEGER (KIND=C_INT),PARAMETER :: N2O2_LINE = -244
INTEGER (KIND=C_INT),PARAMETER :: N2O3_LINE = -245
INTEGER (KIND=C_INT),PARAMETER :: N2O4_LINE = -246
INTEGER (KIND=C_INT),PARAMETER :: N2O5_LINE = -247
INTEGER (KIND=C_INT),PARAMETER :: N2O6_LINE = -248
INTEGER (KIND=C_INT),PARAMETER :: N2O7_LINE = -249
INTEGER (KIND=C_INT),PARAMETER :: N2P1_LINE = -250
INTEGER (KIND=C_INT),PARAMETER :: N2P2_LINE = -251
INTEGER (KIND=C_INT),PARAMETER :: N2P3_LINE = -252
INTEGER (KIND=C_INT),PARAMETER :: N2P4_LINE = -253
INTEGER (KIND=C_INT),PARAMETER :: N2P5_LINE = -254
INTEGER (KIND=C_INT),PARAMETER :: N3N4_LINE = -255
INTEGER (KIND=C_INT),PARAMETER :: N3N5_LINE = -256
INTEGER (KIND=C_INT),PARAMETER :: N3N6_LINE = -257
INTEGER (KIND=C_INT),PARAMETER :: N3N7_LINE = -258
INTEGER (KIND=C_INT),PARAMETER :: N3O1_LINE = -259
INTEGER (KIND=C_INT),PARAMETER :: N3O2_LINE = -260
INTEGER (KIND=C_INT),PARAMETER :: N3O3_LINE = -261
INTEGER (KIND=C_INT),PARAMETER :: N3O4_LINE = -262
INTEGER (KIND=C_INT),PARAMETER :: N3O5_LINE = -263
INTEGER (KIND=C_INT),PARAMETER :: N3O6_LINE = -264
INTEGER (KIND=C_INT),PARAMETER :: N3O7_LINE = -265
INTEGER (KIND=C_INT),PARAMETER :: N3P1_LINE = -266
INTEGER (KIND=C_INT),PARAMETER :: N3P2_LINE = -267
INTEGER (KIND=C_INT),PARAMETER :: N3P3_LINE = -268
INTEGER (KIND=C_INT),PARAMETER :: N3P4_LINE = -269
INTEGER (KIND=C_INT),PARAMETER :: N3P5_LINE = -270
INTEGER (KIND=C_INT),PARAMETER :: N4N5_LINE = -271
INTEGER (KIND=C_INT),PARAMETER :: N4N6_LINE = -272
INTEGER (KIND=C_INT),PARAMETER :: N4N7_LINE = -273
INTEGER (KIND=C_INT),PARAMETER :: N4O1_LINE = -274
INTEGER (KIND=C_INT),PARAMETER :: N4O2_LINE = -275
INTEGER (KIND=C_INT),PARAMETER :: N4O3_LINE = -276
INTEGER (KIND=C_INT),PARAMETER :: N4O4_LINE = -277
INTEGER (KIND=C_INT),PARAMETER :: N4O5_LINE = -278
INTEGER (KIND=C_INT),PARAMETER :: N4O6_LINE = -279
INTEGER (KIND=C_INT),PARAMETER :: N4O7_LINE = -280
INTEGER (KIND=C_INT),PARAMETER :: N4P1_LINE = -281
INTEGER (KIND=C_INT),PARAMETER :: N4P2_LINE = -282
INTEGER (KIND=C_INT),PARAMETER :: N4P3_LINE = -283
INTEGER (KIND=C_INT),PARAMETER :: N4P4_LINE = -284
INTEGER (KIND=C_INT),PARAMETER :: N4P5_LINE = -285
INTEGER (KIND=C_INT),PARAMETER :: N5N6_LINE = -286
INTEGER (KIND=C_INT),PARAMETER :: N5N7_LINE = -287
INTEGER (KIND=C_INT),PARAMETER :: N5O1_LINE = -288
INTEGER (KIND=C_INT),PARAMETER :: N5O2_LINE = -289
INTEGER (KIND=C_INT),PARAMETER :: N5O3_LINE = -290
INTEGER (KIND=C_INT),PARAMETER :: N5O4_LINE = -291
INTEGER (KIND=C_INT),PARAMETER :: N5O5_LINE = -292
INTEGER (KIND=C_INT),PARAMETER :: N5O6_LINE = -293
INTEGER (KIND=C_INT),PARAMETER :: N5O7_LINE = -294
INTEGER (KIND=C_INT),PARAMETER :: N5P1_LINE = -295
INTEGER (KIND=C_INT),PARAMETER :: N5P2_LINE = -296
INTEGER (KIND=C_INT),PARAMETER :: N5P3_LINE = -297
INTEGER (KIND=C_INT),PARAMETER :: N5P4_LINE = -298
INTEGER (KIND=C_INT),PARAMETER :: N5P5_LINE = -299
INTEGER (KIND=C_INT),PARAMETER :: N6N7_LINE = -300
INTEGER (KIND=C_INT),PARAMETER :: N6O1_LINE = -301
INTEGER (KIND=C_INT),PARAMETER :: N6O2_LINE = -302
INTEGER (KIND=C_INT),PARAMETER :: N6O3_LINE = -303
INTEGER (KIND=C_INT),PARAMETER :: N6O4_LINE = -304
INTEGER (KIND=C_INT),PARAMETER :: N6O5_LINE = -305
INTEGER (KIND=C_INT),PARAMETER :: N6O6_LINE = -306
INTEGER (KIND=C_INT),PARAMETER :: N6O7_LINE = -307
INTEGER (KIND=C_INT),PARAMETER :: N6P1_LINE = -308
INTEGER (KIND=C_INT),PARAMETER :: N6P2_LINE = -309
INTEGER (KIND=C_INT),PARAMETER :: N6P3_LINE = -310
INTEGER (KIND=C_INT),PARAMETER :: N6P4_LINE = -311
INTEGER (KIND=C_INT),PARAMETER :: N6P5_LINE = -312
INTEGER (KIND=C_INT),PARAMETER :: N7O1_LINE = -313
INTEGER (KIND=C_INT),PARAMETER :: N7O2_LINE = -314
INTEGER (KIND=C_INT),PARAMETER :: N7O3_LINE = -315
INTEGER (KIND=C_INT),PARAMETER :: N7O4_LINE = -316
INTEGER (KIND=C_INT),PARAMETER :: N7O5_LINE = -317
INTEGER (KIND=C_INT),PARAMETER :: N7O6_LINE = -318
INTEGER (KIND=C_INT),PARAMETER :: N7O7_LINE = -319
INTEGER (KIND=C_INT),PARAMETER :: N7P1_LINE = -320
INTEGER (KIND=C_INT),PARAMETER :: N7P2_LINE = -321
INTEGER (KIND=C_INT),PARAMETER :: N7P3_LINE = -322
INTEGER (KIND=C_INT),PARAMETER :: N7P4_LINE = -323
INTEGER (KIND=C_INT),PARAMETER :: N7P5_LINE = -324
INTEGER (KIND=C_INT),PARAMETER :: O1O2_LINE = -325
INTEGER (KIND=C_INT),PARAMETER :: O1O3_LINE = -326
INTEGER (KIND=C_INT),PARAMETER :: O1O4_LINE = -327
INTEGER (KIND=C_INT),PARAMETER :: O1O5_LINE = -328
INTEGER (KIND=C_INT),PARAMETER :: O1O6_LINE = -329
INTEGER (KIND=C_INT),PARAMETER :: O1O7_LINE = -330
INTEGER (KIND=C_INT),PARAMETER :: O1P1_LINE = -331
INTEGER (KIND=C_INT),PARAMETER :: O1P2_LINE = -332
INTEGER (KIND=C_INT),PARAMETER :: O1P3_LINE = -333
INTEGER (KIND=C_INT),PARAMETER :: O1P4_LINE = -334
INTEGER (KIND=C_INT),PARAMETER :: O1P5_LINE = -335
INTEGER (KIND=C_INT),PARAMETER :: O2O3_LINE = -336
INTEGER (KIND=C_INT),PARAMETER :: O2O4_LINE = -337
INTEGER (KIND=C_INT),PARAMETER :: O2O5_LINE = -338
INTEGER (KIND=C_INT),PARAMETER :: O2O6_LINE = -339
INTEGER (KIND=C_INT),PARAMETER :: O2O7_LINE = -340
INTEGER (KIND=C_INT),PARAMETER :: O2P1_LINE = -341
INTEGER (KIND=C_INT),PARAMETER :: O2P2_LINE = -342
INTEGER (KIND=C_INT),PARAMETER :: O2P3_LINE = -343
INTEGER (KIND=C_INT),PARAMETER :: O2P4_LINE = -344
INTEGER (KIND=C_INT),PARAMETER :: O2P5_LINE = -345
INTEGER (KIND=C_INT),PARAMETER :: O3O4_LINE = -346
INTEGER (KIND=C_INT),PARAMETER :: O3O5_LINE = -347
INTEGER (KIND=C_INT),PARAMETER :: O3O6_LINE = -348
INTEGER (KIND=C_INT),PARAMETER :: O3O7_LINE = -349
INTEGER (KIND=C_INT),PARAMETER :: O3P1_LINE = -350
INTEGER (KIND=C_INT),PARAMETER :: O3P2_LINE = -351
INTEGER (KIND=C_INT),PARAMETER :: O3P3_LINE = -352
INTEGER (KIND=C_INT),PARAMETER :: O3P4_LINE = -353
INTEGER (KIND=C_INT),PARAMETER :: O3P5_LINE = -354
INTEGER (KIND=C_INT),PARAMETER :: O4O5_LINE = -355
INTEGER (KIND=C_INT),PARAMETER :: O4O6_LINE = -356
INTEGER (KIND=C_INT),PARAMETER :: O4O7_LINE = -357
INTEGER (KIND=C_INT),PARAMETER :: O4P1_LINE = -358
INTEGER (KIND=C_INT),PARAMETER :: O4P2_LINE = -359
INTEGER (KIND=C_INT),PARAMETER :: O4P3_LINE = -360
INTEGER (KIND=C_INT),PARAMETER :: O4P4_LINE = -361
INTEGER (KIND=C_INT),PARAMETER :: O4P5_LINE = -362
INTEGER (KIND=C_INT),PARAMETER :: O5O6_LINE = -363
INTEGER (KIND=C_INT),PARAMETER :: O5O7_LINE = -364
INTEGER (KIND=C_INT),PARAMETER :: O5P1_LINE = -365
INTEGER (KIND=C_INT),PARAMETER :: O5P2_LINE = -366
INTEGER (KIND=C_INT),PARAMETER :: O5P3_LINE = -367
INTEGER (KIND=C_INT),PARAMETER :: O5P4_LINE = -368
INTEGER (KIND=C_INT),PARAMETER :: O5P5_LINE = -369
INTEGER (KIND=C_INT),PARAMETER :: O6O7_LINE = -370
INTEGER (KIND=C_INT),PARAMETER :: O6P4_LINE = -371
INTEGER (KIND=C_INT),PARAMETER :: O6P5_LINE = -372
INTEGER (KIND=C_INT),PARAMETER :: O7P4_LINE = -373
INTEGER (KIND=C_INT),PARAMETER :: O7P5_LINE = -374
INTEGER (KIND=C_INT),PARAMETER :: P1P2_LINE = -375
INTEGER (KIND=C_INT),PARAMETER :: P1P3_LINE = -376
INTEGER (KIND=C_INT),PARAMETER :: P1P4_LINE = -377
INTEGER (KIND=C_INT),PARAMETER :: P1P5_LINE = -378
INTEGER (KIND=C_INT),PARAMETER :: P2P3_LINE = -379
INTEGER (KIND=C_INT),PARAMETER :: P2P4_LINE = -380
INTEGER (KIND=C_INT),PARAMETER :: P2P5_LINE = -381
INTEGER (KIND=C_INT),PARAMETER :: P3P4_LINE = -382
INTEGER (KIND=C_INT),PARAMETER :: P3P5_LINE = -383



INTEGER (KIND=C_INT),PARAMETER ::  K_SHELL = 0
INTEGER (KIND=C_INT),PARAMETER ::  L1_SHELL = 1
INTEGER (KIND=C_INT),PARAMETER ::  L2_SHELL = 2
INTEGER (KIND=C_INT),PARAMETER ::  L3_SHELL = 3
INTEGER (KIND=C_INT),PARAMETER ::  M1_SHELL = 4
INTEGER (KIND=C_INT),PARAMETER ::  M2_SHELL = 5
INTEGER (KIND=C_INT),PARAMETER ::  M3_SHELL = 6
INTEGER (KIND=C_INT),PARAMETER ::  M4_SHELL = 7
INTEGER (KIND=C_INT),PARAMETER ::  M5_SHELL = 8
INTEGER (KIND=C_INT),PARAMETER ::  N1_SHELL = 9
INTEGER (KIND=C_INT),PARAMETER ::  N2_SHELL = 10
INTEGER (KIND=C_INT),PARAMETER ::  N3_SHELL = 11
INTEGER (KIND=C_INT),PARAMETER ::  N4_SHELL = 12
INTEGER (KIND=C_INT),PARAMETER ::  N5_SHELL = 13
INTEGER (KIND=C_INT),PARAMETER ::  N6_SHELL = 14
INTEGER (KIND=C_INT),PARAMETER ::  N7_SHELL = 15
INTEGER (KIND=C_INT),PARAMETER ::  O1_SHELL = 16
INTEGER (KIND=C_INT),PARAMETER ::  O2_SHELL = 17
INTEGER (KIND=C_INT),PARAMETER ::  O3_SHELL = 18
INTEGER (KIND=C_INT),PARAMETER ::  O4_SHELL = 19
INTEGER (KIND=C_INT),PARAMETER ::  O5_SHELL = 20
INTEGER (KIND=C_INT),PARAMETER ::  O6_SHELL = 21
INTEGER (KIND=C_INT),PARAMETER ::  O7_SHELL = 22
INTEGER (KIND=C_INT),PARAMETER ::  P1_SHELL = 23
INTEGER (KIND=C_INT),PARAMETER ::  P2_SHELL = 24
INTEGER (KIND=C_INT),PARAMETER ::  P3_SHELL = 25
INTEGER (KIND=C_INT),PARAMETER ::  P4_SHELL = 26
INTEGER (KIND=C_INT),PARAMETER ::  P5_SHELL = 27
INTEGER (KIND=C_INT),PARAMETER ::  Q1_SHELL = 28
INTEGER (KIND=C_INT),PARAMETER ::  Q2_SHELL = 29
INTEGER (KIND=C_INT),PARAMETER ::  Q3_SHELL = 30

INTEGER (KIND=C_INT),PARAMETER ::  KA1_LINE = KL3_LINE
INTEGER (KIND=C_INT),PARAMETER ::  KA2_LINE = KL2_LINE
INTEGER (KIND=C_INT),PARAMETER ::  KA3_LINE = KL1_LINE
INTEGER (KIND=C_INT),PARAMETER ::  KB1_LINE = KM3_LINE
INTEGER (KIND=C_INT),PARAMETER ::  KB2_LINE = KN3_LINE
INTEGER (KIND=C_INT),PARAMETER ::  KB3_LINE = KM2_LINE
INTEGER (KIND=C_INT),PARAMETER ::  KB4_LINE = KN5_LINE
INTEGER (KIND=C_INT),PARAMETER ::  KB5_LINE = KM5_LINE
INTEGER (KIND=C_INT),PARAMETER ::  LA1_LINE = L3M5_LINE
INTEGER (KIND=C_INT),PARAMETER ::  LA2_LINE = L3M4_LINE
INTEGER (KIND=C_INT),PARAMETER ::  LB1_LINE = L2M4_LINE
INTEGER (KIND=C_INT),PARAMETER ::  LB2_LINE = L3N5_LINE
INTEGER (KIND=C_INT),PARAMETER ::  LB3_LINE = L1M3_LINE
INTEGER (KIND=C_INT),PARAMETER ::  LB4_LINE = L1M2_LINE
INTEGER (KIND=C_INT),PARAMETER ::  LB5_LINE = L3O45_LINE
INTEGER (KIND=C_INT),PARAMETER ::  LB6_LINE = L3N1_LINE
INTEGER (KIND=C_INT),PARAMETER ::  LB7_LINE = L3O1_LINE
INTEGER (KIND=C_INT),PARAMETER ::  LB9_LINE = L1M5_LINE
INTEGER (KIND=C_INT),PARAMETER ::  LB10_LINE = L1M4_LINE
INTEGER (KIND=C_INT),PARAMETER ::  LB15_LINE = L3N4_LINE
INTEGER (KIND=C_INT),PARAMETER ::  LB17_LINE = L2M3_LINE
INTEGER (KIND=C_INT),PARAMETER ::  LG1_LINE = L2N4_LINE
INTEGER (KIND=C_INT),PARAMETER ::  LG2_LINE = L1N2_LINE
INTEGER (KIND=C_INT),PARAMETER ::  LG3_LINE = L1N3_LINE
INTEGER (KIND=C_INT),PARAMETER ::  LG4_LINE = L1O3_LINE
INTEGER (KIND=C_INT),PARAMETER ::  LG5_LINE = L2N1_LINE
INTEGER (KIND=C_INT),PARAMETER ::  LG6_LINE = L2O4_LINE
INTEGER (KIND=C_INT),PARAMETER ::  LG8_LINE = L2O1_LINE
INTEGER (KIND=C_INT),PARAMETER ::  LE_LINE = L2M1_LINE
INTEGER (KIND=C_INT),PARAMETER ::  LH_LINE = L2M1_LINE
INTEGER (KIND=C_INT),PARAMETER ::  LL_LINE = L3M1_LINE
INTEGER (KIND=C_INT),PARAMETER ::  LS_LINE = L3M3_LINE
INTEGER (KIND=C_INT),PARAMETER ::  LT_LINE = L3M2_LINE
INTEGER (KIND=C_INT),PARAMETER ::  LU_LINE = L3N6_LINE
INTEGER (KIND=C_INT),PARAMETER ::  LV_LINE = L2N6_LINE
INTEGER (KIND=C_INT),PARAMETER ::  MA1_LINE = M5N7_LINE
INTEGER (KIND=C_INT),PARAMETER ::  MA2_LINE = M5N6_LINE
INTEGER (KIND=C_INT),PARAMETER ::  MB_LINE = M4N6_LINE
INTEGER (KIND=C_INT),PARAMETER ::  MG_LINE = M3N5_LINE

!Auger macros
INTEGER (KIND=C_INT),PARAMETER ::  K_L1L1_AUGER = 0
INTEGER (KIND=C_INT),PARAMETER ::  K_L1L2_AUGER = 1
INTEGER (KIND=C_INT),PARAMETER ::  K_L1L3_AUGER = 2
INTEGER (KIND=C_INT),PARAMETER ::  K_L1M1_AUGER = 3
INTEGER (KIND=C_INT),PARAMETER ::  K_L1M2_AUGER = 4
INTEGER (KIND=C_INT),PARAMETER ::  K_L1M3_AUGER = 5
INTEGER (KIND=C_INT),PARAMETER ::  K_L1M4_AUGER = 6
INTEGER (KIND=C_INT),PARAMETER ::  K_L1M5_AUGER = 7
INTEGER (KIND=C_INT),PARAMETER ::  K_L1N1_AUGER = 8
INTEGER (KIND=C_INT),PARAMETER ::  K_L1N2_AUGER = 9
INTEGER (KIND=C_INT),PARAMETER ::  K_L1N3_AUGER = 10
INTEGER (KIND=C_INT),PARAMETER ::  K_L1N4_AUGER = 11
INTEGER (KIND=C_INT),PARAMETER ::  K_L1N5_AUGER = 12
INTEGER (KIND=C_INT),PARAMETER ::  K_L1N6_AUGER = 13
INTEGER (KIND=C_INT),PARAMETER ::  K_L1N7_AUGER = 14
INTEGER (KIND=C_INT),PARAMETER ::  K_L1O1_AUGER = 15
INTEGER (KIND=C_INT),PARAMETER ::  K_L1O2_AUGER = 16
INTEGER (KIND=C_INT),PARAMETER ::  K_L1O3_AUGER = 17
INTEGER (KIND=C_INT),PARAMETER ::  K_L1O4_AUGER = 18
INTEGER (KIND=C_INT),PARAMETER ::  K_L1O5_AUGER = 19
INTEGER (KIND=C_INT),PARAMETER ::  K_L1O6_AUGER = 20
INTEGER (KIND=C_INT),PARAMETER ::  K_L1O7_AUGER = 21
INTEGER (KIND=C_INT),PARAMETER ::  K_L1P1_AUGER = 22
INTEGER (KIND=C_INT),PARAMETER ::  K_L1P2_AUGER = 23
INTEGER (KIND=C_INT),PARAMETER ::  K_L1P3_AUGER = 24
INTEGER (KIND=C_INT),PARAMETER ::  K_L1P4_AUGER = 25
INTEGER (KIND=C_INT),PARAMETER ::  K_L1P5_AUGER = 26
INTEGER (KIND=C_INT),PARAMETER ::  K_L1Q1_AUGER = 27
INTEGER (KIND=C_INT),PARAMETER ::  K_L1Q2_AUGER = 28
INTEGER (KIND=C_INT),PARAMETER ::  K_L1Q3_AUGER = 29
INTEGER (KIND=C_INT),PARAMETER ::  K_L2L1_AUGER = 30
INTEGER (KIND=C_INT),PARAMETER ::  K_L2L2_AUGER = 31
INTEGER (KIND=C_INT),PARAMETER ::  K_L2L3_AUGER = 32
INTEGER (KIND=C_INT),PARAMETER ::  K_L2M1_AUGER = 33
INTEGER (KIND=C_INT),PARAMETER ::  K_L2M2_AUGER = 34
INTEGER (KIND=C_INT),PARAMETER ::  K_L2M3_AUGER = 35
INTEGER (KIND=C_INT),PARAMETER ::  K_L2M4_AUGER = 36
INTEGER (KIND=C_INT),PARAMETER ::  K_L2M5_AUGER = 37
INTEGER (KIND=C_INT),PARAMETER ::  K_L2N1_AUGER = 38
INTEGER (KIND=C_INT),PARAMETER ::  K_L2N2_AUGER = 39
INTEGER (KIND=C_INT),PARAMETER ::  K_L2N3_AUGER = 40
INTEGER (KIND=C_INT),PARAMETER ::  K_L2N4_AUGER = 41
INTEGER (KIND=C_INT),PARAMETER ::  K_L2N5_AUGER = 42
INTEGER (KIND=C_INT),PARAMETER ::  K_L2N6_AUGER = 43
INTEGER (KIND=C_INT),PARAMETER ::  K_L2N7_AUGER = 44
INTEGER (KIND=C_INT),PARAMETER ::  K_L2O1_AUGER = 45
INTEGER (KIND=C_INT),PARAMETER ::  K_L2O2_AUGER = 46
INTEGER (KIND=C_INT),PARAMETER ::  K_L2O3_AUGER = 47
INTEGER (KIND=C_INT),PARAMETER ::  K_L2O4_AUGER = 48
INTEGER (KIND=C_INT),PARAMETER ::  K_L2O5_AUGER = 49
INTEGER (KIND=C_INT),PARAMETER ::  K_L2O6_AUGER = 50
INTEGER (KIND=C_INT),PARAMETER ::  K_L2O7_AUGER = 51
INTEGER (KIND=C_INT),PARAMETER ::  K_L2P1_AUGER = 52
INTEGER (KIND=C_INT),PARAMETER ::  K_L2P2_AUGER = 53
INTEGER (KIND=C_INT),PARAMETER ::  K_L2P3_AUGER = 54
INTEGER (KIND=C_INT),PARAMETER ::  K_L2P4_AUGER = 55
INTEGER (KIND=C_INT),PARAMETER ::  K_L2P5_AUGER = 56
INTEGER (KIND=C_INT),PARAMETER ::  K_L2Q1_AUGER = 57
INTEGER (KIND=C_INT),PARAMETER ::  K_L2Q2_AUGER = 58
INTEGER (KIND=C_INT),PARAMETER ::  K_L2Q3_AUGER = 59
INTEGER (KIND=C_INT),PARAMETER ::  K_L3L1_AUGER = 60
INTEGER (KIND=C_INT),PARAMETER ::  K_L3L2_AUGER = 61
INTEGER (KIND=C_INT),PARAMETER ::  K_L3L3_AUGER = 62
INTEGER (KIND=C_INT),PARAMETER ::  K_L3M1_AUGER = 63
INTEGER (KIND=C_INT),PARAMETER ::  K_L3M2_AUGER = 64
INTEGER (KIND=C_INT),PARAMETER ::  K_L3M3_AUGER = 65
INTEGER (KIND=C_INT),PARAMETER ::  K_L3M4_AUGER = 66
INTEGER (KIND=C_INT),PARAMETER ::  K_L3M5_AUGER = 67
INTEGER (KIND=C_INT),PARAMETER ::  K_L3N1_AUGER = 68
INTEGER (KIND=C_INT),PARAMETER ::  K_L3N2_AUGER = 69
INTEGER (KIND=C_INT),PARAMETER ::  K_L3N3_AUGER = 70
INTEGER (KIND=C_INT),PARAMETER ::  K_L3N4_AUGER = 71
INTEGER (KIND=C_INT),PARAMETER ::  K_L3N5_AUGER = 72
INTEGER (KIND=C_INT),PARAMETER ::  K_L3N6_AUGER = 73
INTEGER (KIND=C_INT),PARAMETER ::  K_L3N7_AUGER = 74
INTEGER (KIND=C_INT),PARAMETER ::  K_L3O1_AUGER = 75
INTEGER (KIND=C_INT),PARAMETER ::  K_L3O2_AUGER = 76
INTEGER (KIND=C_INT),PARAMETER ::  K_L3O3_AUGER = 77
INTEGER (KIND=C_INT),PARAMETER ::  K_L3O4_AUGER = 78
INTEGER (KIND=C_INT),PARAMETER ::  K_L3O5_AUGER = 79
INTEGER (KIND=C_INT),PARAMETER ::  K_L3O6_AUGER = 80
INTEGER (KIND=C_INT),PARAMETER ::  K_L3O7_AUGER = 81
INTEGER (KIND=C_INT),PARAMETER ::  K_L3P1_AUGER = 82
INTEGER (KIND=C_INT),PARAMETER ::  K_L3P2_AUGER = 83
INTEGER (KIND=C_INT),PARAMETER ::  K_L3P3_AUGER = 84
INTEGER (KIND=C_INT),PARAMETER ::  K_L3P4_AUGER = 85
INTEGER (KIND=C_INT),PARAMETER ::  K_L3P5_AUGER = 86
INTEGER (KIND=C_INT),PARAMETER ::  K_L3Q1_AUGER = 87
INTEGER (KIND=C_INT),PARAMETER ::  K_L3Q2_AUGER = 88
INTEGER (KIND=C_INT),PARAMETER ::  K_L3Q3_AUGER = 89
INTEGER (KIND=C_INT),PARAMETER ::  K_M1L1_AUGER = 90
INTEGER (KIND=C_INT),PARAMETER ::  K_M1L2_AUGER = 91
INTEGER (KIND=C_INT),PARAMETER ::  K_M1L3_AUGER = 92
INTEGER (KIND=C_INT),PARAMETER ::  K_M1M1_AUGER = 93
INTEGER (KIND=C_INT),PARAMETER ::  K_M1M2_AUGER = 94
INTEGER (KIND=C_INT),PARAMETER ::  K_M1M3_AUGER = 95
INTEGER (KIND=C_INT),PARAMETER ::  K_M1M4_AUGER = 96
INTEGER (KIND=C_INT),PARAMETER ::  K_M1M5_AUGER = 97
INTEGER (KIND=C_INT),PARAMETER ::  K_M1N1_AUGER = 98
INTEGER (KIND=C_INT),PARAMETER ::  K_M1N2_AUGER = 99
INTEGER (KIND=C_INT),PARAMETER ::  K_M1N3_AUGER = 100
INTEGER (KIND=C_INT),PARAMETER ::  K_M1N4_AUGER = 101
INTEGER (KIND=C_INT),PARAMETER ::  K_M1N5_AUGER = 102
INTEGER (KIND=C_INT),PARAMETER ::  K_M1N6_AUGER = 103
INTEGER (KIND=C_INT),PARAMETER ::  K_M1N7_AUGER = 104
INTEGER (KIND=C_INT),PARAMETER ::  K_M1O1_AUGER = 105
INTEGER (KIND=C_INT),PARAMETER ::  K_M1O2_AUGER = 106
INTEGER (KIND=C_INT),PARAMETER ::  K_M1O3_AUGER = 107
INTEGER (KIND=C_INT),PARAMETER ::  K_M1O4_AUGER = 108
INTEGER (KIND=C_INT),PARAMETER ::  K_M1O5_AUGER = 109
INTEGER (KIND=C_INT),PARAMETER ::  K_M1O6_AUGER = 110
INTEGER (KIND=C_INT),PARAMETER ::  K_M1O7_AUGER = 111
INTEGER (KIND=C_INT),PARAMETER ::  K_M1P1_AUGER = 112
INTEGER (KIND=C_INT),PARAMETER ::  K_M1P2_AUGER = 113
INTEGER (KIND=C_INT),PARAMETER ::  K_M1P3_AUGER = 114
INTEGER (KIND=C_INT),PARAMETER ::  K_M1P4_AUGER = 115
INTEGER (KIND=C_INT),PARAMETER ::  K_M1P5_AUGER = 116
INTEGER (KIND=C_INT),PARAMETER ::  K_M1Q1_AUGER = 117
INTEGER (KIND=C_INT),PARAMETER ::  K_M1Q2_AUGER = 118
INTEGER (KIND=C_INT),PARAMETER ::  K_M1Q3_AUGER = 119
INTEGER (KIND=C_INT),PARAMETER ::  K_M2L1_AUGER = 120
INTEGER (KIND=C_INT),PARAMETER ::  K_M2L2_AUGER = 121
INTEGER (KIND=C_INT),PARAMETER ::  K_M2L3_AUGER = 122
INTEGER (KIND=C_INT),PARAMETER ::  K_M2M1_AUGER = 123
INTEGER (KIND=C_INT),PARAMETER ::  K_M2M2_AUGER = 124
INTEGER (KIND=C_INT),PARAMETER ::  K_M2M3_AUGER = 125
INTEGER (KIND=C_INT),PARAMETER ::  K_M2M4_AUGER = 126
INTEGER (KIND=C_INT),PARAMETER ::  K_M2M5_AUGER = 127
INTEGER (KIND=C_INT),PARAMETER ::  K_M2N1_AUGER = 128
INTEGER (KIND=C_INT),PARAMETER ::  K_M2N2_AUGER = 129
INTEGER (KIND=C_INT),PARAMETER ::  K_M2N3_AUGER = 130
INTEGER (KIND=C_INT),PARAMETER ::  K_M2N4_AUGER = 131
INTEGER (KIND=C_INT),PARAMETER ::  K_M2N5_AUGER = 132
INTEGER (KIND=C_INT),PARAMETER ::  K_M2N6_AUGER = 133
INTEGER (KIND=C_INT),PARAMETER ::  K_M2N7_AUGER = 134
INTEGER (KIND=C_INT),PARAMETER ::  K_M2O1_AUGER = 135
INTEGER (KIND=C_INT),PARAMETER ::  K_M2O2_AUGER = 136
INTEGER (KIND=C_INT),PARAMETER ::  K_M2O3_AUGER = 137
INTEGER (KIND=C_INT),PARAMETER ::  K_M2O4_AUGER = 138
INTEGER (KIND=C_INT),PARAMETER ::  K_M2O5_AUGER = 139
INTEGER (KIND=C_INT),PARAMETER ::  K_M2O6_AUGER = 140
INTEGER (KIND=C_INT),PARAMETER ::  K_M2O7_AUGER = 141
INTEGER (KIND=C_INT),PARAMETER ::  K_M2P1_AUGER = 142
INTEGER (KIND=C_INT),PARAMETER ::  K_M2P2_AUGER = 143
INTEGER (KIND=C_INT),PARAMETER ::  K_M2P3_AUGER = 144
INTEGER (KIND=C_INT),PARAMETER ::  K_M2P4_AUGER = 145
INTEGER (KIND=C_INT),PARAMETER ::  K_M2P5_AUGER = 146
INTEGER (KIND=C_INT),PARAMETER ::  K_M2Q1_AUGER = 147
INTEGER (KIND=C_INT),PARAMETER ::  K_M2Q2_AUGER = 148
INTEGER (KIND=C_INT),PARAMETER ::  K_M2Q3_AUGER = 149
INTEGER (KIND=C_INT),PARAMETER ::  K_M3L1_AUGER = 150
INTEGER (KIND=C_INT),PARAMETER ::  K_M3L2_AUGER = 151
INTEGER (KIND=C_INT),PARAMETER ::  K_M3L3_AUGER = 152
INTEGER (KIND=C_INT),PARAMETER ::  K_M3M1_AUGER = 153
INTEGER (KIND=C_INT),PARAMETER ::  K_M3M2_AUGER = 154
INTEGER (KIND=C_INT),PARAMETER ::  K_M3M3_AUGER = 155
INTEGER (KIND=C_INT),PARAMETER ::  K_M3M4_AUGER = 156
INTEGER (KIND=C_INT),PARAMETER ::  K_M3M5_AUGER = 157
INTEGER (KIND=C_INT),PARAMETER ::  K_M3N1_AUGER = 158
INTEGER (KIND=C_INT),PARAMETER ::  K_M3N2_AUGER = 159
INTEGER (KIND=C_INT),PARAMETER ::  K_M3N3_AUGER = 160
INTEGER (KIND=C_INT),PARAMETER ::  K_M3N4_AUGER = 161
INTEGER (KIND=C_INT),PARAMETER ::  K_M3N5_AUGER = 162
INTEGER (KIND=C_INT),PARAMETER ::  K_M3N6_AUGER = 163
INTEGER (KIND=C_INT),PARAMETER ::  K_M3N7_AUGER = 164
INTEGER (KIND=C_INT),PARAMETER ::  K_M3O1_AUGER = 165
INTEGER (KIND=C_INT),PARAMETER ::  K_M3O2_AUGER = 166
INTEGER (KIND=C_INT),PARAMETER ::  K_M3O3_AUGER = 167
INTEGER (KIND=C_INT),PARAMETER ::  K_M3O4_AUGER = 168
INTEGER (KIND=C_INT),PARAMETER ::  K_M3O5_AUGER = 169
INTEGER (KIND=C_INT),PARAMETER ::  K_M3O6_AUGER = 170
INTEGER (KIND=C_INT),PARAMETER ::  K_M3O7_AUGER = 171
INTEGER (KIND=C_INT),PARAMETER ::  K_M3P1_AUGER = 172
INTEGER (KIND=C_INT),PARAMETER ::  K_M3P2_AUGER = 173
INTEGER (KIND=C_INT),PARAMETER ::  K_M3P3_AUGER = 174
INTEGER (KIND=C_INT),PARAMETER ::  K_M3P4_AUGER = 175
INTEGER (KIND=C_INT),PARAMETER ::  K_M3P5_AUGER = 176
INTEGER (KIND=C_INT),PARAMETER ::  K_M3Q1_AUGER = 177
INTEGER (KIND=C_INT),PARAMETER ::  K_M3Q2_AUGER = 178
INTEGER (KIND=C_INT),PARAMETER ::  K_M3Q3_AUGER = 179
INTEGER (KIND=C_INT),PARAMETER ::  K_M4L1_AUGER = 180
INTEGER (KIND=C_INT),PARAMETER ::  K_M4L2_AUGER = 181
INTEGER (KIND=C_INT),PARAMETER ::  K_M4L3_AUGER = 182
INTEGER (KIND=C_INT),PARAMETER ::  K_M4M1_AUGER = 183
INTEGER (KIND=C_INT),PARAMETER ::  K_M4M2_AUGER = 184
INTEGER (KIND=C_INT),PARAMETER ::  K_M4M3_AUGER = 185
INTEGER (KIND=C_INT),PARAMETER ::  K_M4M4_AUGER = 186
INTEGER (KIND=C_INT),PARAMETER ::  K_M4M5_AUGER = 187
INTEGER (KIND=C_INT),PARAMETER ::  K_M4N1_AUGER = 188
INTEGER (KIND=C_INT),PARAMETER ::  K_M4N2_AUGER = 189
INTEGER (KIND=C_INT),PARAMETER ::  K_M4N3_AUGER = 190
INTEGER (KIND=C_INT),PARAMETER ::  K_M4N4_AUGER = 191
INTEGER (KIND=C_INT),PARAMETER ::  K_M4N5_AUGER = 192
INTEGER (KIND=C_INT),PARAMETER ::  K_M4N6_AUGER = 193
INTEGER (KIND=C_INT),PARAMETER ::  K_M4N7_AUGER = 194
INTEGER (KIND=C_INT),PARAMETER ::  K_M4O1_AUGER = 195
INTEGER (KIND=C_INT),PARAMETER ::  K_M4O2_AUGER = 196
INTEGER (KIND=C_INT),PARAMETER ::  K_M4O3_AUGER = 197
INTEGER (KIND=C_INT),PARAMETER ::  K_M4O4_AUGER = 198
INTEGER (KIND=C_INT),PARAMETER ::  K_M4O5_AUGER = 199
INTEGER (KIND=C_INT),PARAMETER ::  K_M4O6_AUGER = 200
INTEGER (KIND=C_INT),PARAMETER ::  K_M4O7_AUGER = 201
INTEGER (KIND=C_INT),PARAMETER ::  K_M4P1_AUGER = 202
INTEGER (KIND=C_INT),PARAMETER ::  K_M4P2_AUGER = 203
INTEGER (KIND=C_INT),PARAMETER ::  K_M4P3_AUGER = 204
INTEGER (KIND=C_INT),PARAMETER ::  K_M4P4_AUGER = 205
INTEGER (KIND=C_INT),PARAMETER ::  K_M4P5_AUGER = 206
INTEGER (KIND=C_INT),PARAMETER ::  K_M4Q1_AUGER = 207
INTEGER (KIND=C_INT),PARAMETER ::  K_M4Q2_AUGER = 208
INTEGER (KIND=C_INT),PARAMETER ::  K_M4Q3_AUGER = 209
INTEGER (KIND=C_INT),PARAMETER ::  K_M5L1_AUGER = 210
INTEGER (KIND=C_INT),PARAMETER ::  K_M5L2_AUGER = 211
INTEGER (KIND=C_INT),PARAMETER ::  K_M5L3_AUGER = 212
INTEGER (KIND=C_INT),PARAMETER ::  K_M5M1_AUGER = 213
INTEGER (KIND=C_INT),PARAMETER ::  K_M5M2_AUGER = 214
INTEGER (KIND=C_INT),PARAMETER ::  K_M5M3_AUGER = 215
INTEGER (KIND=C_INT),PARAMETER ::  K_M5M4_AUGER = 216
INTEGER (KIND=C_INT),PARAMETER ::  K_M5M5_AUGER = 217
INTEGER (KIND=C_INT),PARAMETER ::  K_M5N1_AUGER = 218
INTEGER (KIND=C_INT),PARAMETER ::  K_M5N2_AUGER = 219
INTEGER (KIND=C_INT),PARAMETER ::  K_M5N3_AUGER = 220
INTEGER (KIND=C_INT),PARAMETER ::  K_M5N4_AUGER = 221
INTEGER (KIND=C_INT),PARAMETER ::  K_M5N5_AUGER = 222
INTEGER (KIND=C_INT),PARAMETER ::  K_M5N6_AUGER = 223
INTEGER (KIND=C_INT),PARAMETER ::  K_M5N7_AUGER = 224
INTEGER (KIND=C_INT),PARAMETER ::  K_M5O1_AUGER = 225
INTEGER (KIND=C_INT),PARAMETER ::  K_M5O2_AUGER = 226
INTEGER (KIND=C_INT),PARAMETER ::  K_M5O3_AUGER = 227
INTEGER (KIND=C_INT),PARAMETER ::  K_M5O4_AUGER = 228
INTEGER (KIND=C_INT),PARAMETER ::  K_M5O5_AUGER = 229
INTEGER (KIND=C_INT),PARAMETER ::  K_M5O6_AUGER = 230
INTEGER (KIND=C_INT),PARAMETER ::  K_M5O7_AUGER = 231
INTEGER (KIND=C_INT),PARAMETER ::  K_M5P1_AUGER = 232
INTEGER (KIND=C_INT),PARAMETER ::  K_M5P2_AUGER = 233
INTEGER (KIND=C_INT),PARAMETER ::  K_M5P3_AUGER = 234
INTEGER (KIND=C_INT),PARAMETER ::  K_M5P4_AUGER = 235
INTEGER (KIND=C_INT),PARAMETER ::  K_M5P5_AUGER = 236
INTEGER (KIND=C_INT),PARAMETER ::  K_M5Q1_AUGER = 237
INTEGER (KIND=C_INT),PARAMETER ::  K_M5Q2_AUGER = 238
INTEGER (KIND=C_INT),PARAMETER ::  K_M5Q3_AUGER = 239
INTEGER (KIND=C_INT),PARAMETER ::  L1_L2L2_AUGER = 240
INTEGER (KIND=C_INT),PARAMETER ::  L1_L2L3_AUGER = 241
INTEGER (KIND=C_INT),PARAMETER ::  L1_L2M1_AUGER = 242
INTEGER (KIND=C_INT),PARAMETER ::  L1_L2M2_AUGER = 243
INTEGER (KIND=C_INT),PARAMETER ::  L1_L2M3_AUGER = 244
INTEGER (KIND=C_INT),PARAMETER ::  L1_L2M4_AUGER = 245
INTEGER (KIND=C_INT),PARAMETER ::  L1_L2M5_AUGER = 246
INTEGER (KIND=C_INT),PARAMETER ::  L1_L2N1_AUGER = 247
INTEGER (KIND=C_INT),PARAMETER ::  L1_L2N2_AUGER = 248
INTEGER (KIND=C_INT),PARAMETER ::  L1_L2N3_AUGER = 249
INTEGER (KIND=C_INT),PARAMETER ::  L1_L2N4_AUGER = 250
INTEGER (KIND=C_INT),PARAMETER ::  L1_L2N5_AUGER = 251
INTEGER (KIND=C_INT),PARAMETER ::  L1_L2N6_AUGER = 252
INTEGER (KIND=C_INT),PARAMETER ::  L1_L2N7_AUGER = 253
INTEGER (KIND=C_INT),PARAMETER ::  L1_L2O1_AUGER = 254
INTEGER (KIND=C_INT),PARAMETER ::  L1_L2O2_AUGER = 255
INTEGER (KIND=C_INT),PARAMETER ::  L1_L2O3_AUGER = 256
INTEGER (KIND=C_INT),PARAMETER ::  L1_L2O4_AUGER = 257
INTEGER (KIND=C_INT),PARAMETER ::  L1_L2O5_AUGER = 258
INTEGER (KIND=C_INT),PARAMETER ::  L1_L2O6_AUGER = 259
INTEGER (KIND=C_INT),PARAMETER ::  L1_L2O7_AUGER = 260
INTEGER (KIND=C_INT),PARAMETER ::  L1_L2P1_AUGER = 261
INTEGER (KIND=C_INT),PARAMETER ::  L1_L2P2_AUGER = 262
INTEGER (KIND=C_INT),PARAMETER ::  L1_L2P3_AUGER = 263
INTEGER (KIND=C_INT),PARAMETER ::  L1_L2P4_AUGER = 264
INTEGER (KIND=C_INT),PARAMETER ::  L1_L2P5_AUGER = 265
INTEGER (KIND=C_INT),PARAMETER ::  L1_L2Q1_AUGER = 266
INTEGER (KIND=C_INT),PARAMETER ::  L1_L2Q2_AUGER = 267
INTEGER (KIND=C_INT),PARAMETER ::  L1_L2Q3_AUGER = 268
INTEGER (KIND=C_INT),PARAMETER ::  L1_L3L2_AUGER = 269
INTEGER (KIND=C_INT),PARAMETER ::  L1_L3L3_AUGER = 270
INTEGER (KIND=C_INT),PARAMETER ::  L1_L3M1_AUGER = 271
INTEGER (KIND=C_INT),PARAMETER ::  L1_L3M2_AUGER = 272
INTEGER (KIND=C_INT),PARAMETER ::  L1_L3M3_AUGER = 273
INTEGER (KIND=C_INT),PARAMETER ::  L1_L3M4_AUGER = 274
INTEGER (KIND=C_INT),PARAMETER ::  L1_L3M5_AUGER = 275
INTEGER (KIND=C_INT),PARAMETER ::  L1_L3N1_AUGER = 276
INTEGER (KIND=C_INT),PARAMETER ::  L1_L3N2_AUGER = 277
INTEGER (KIND=C_INT),PARAMETER ::  L1_L3N3_AUGER = 278
INTEGER (KIND=C_INT),PARAMETER ::  L1_L3N4_AUGER = 279
INTEGER (KIND=C_INT),PARAMETER ::  L1_L3N5_AUGER = 280
INTEGER (KIND=C_INT),PARAMETER ::  L1_L3N6_AUGER = 281
INTEGER (KIND=C_INT),PARAMETER ::  L1_L3N7_AUGER = 282
INTEGER (KIND=C_INT),PARAMETER ::  L1_L3O1_AUGER = 283
INTEGER (KIND=C_INT),PARAMETER ::  L1_L3O2_AUGER = 284
INTEGER (KIND=C_INT),PARAMETER ::  L1_L3O3_AUGER = 285
INTEGER (KIND=C_INT),PARAMETER ::  L1_L3O4_AUGER = 286
INTEGER (KIND=C_INT),PARAMETER ::  L1_L3O5_AUGER = 287
INTEGER (KIND=C_INT),PARAMETER ::  L1_L3O6_AUGER = 288
INTEGER (KIND=C_INT),PARAMETER ::  L1_L3O7_AUGER = 289
INTEGER (KIND=C_INT),PARAMETER ::  L1_L3P1_AUGER = 290
INTEGER (KIND=C_INT),PARAMETER ::  L1_L3P2_AUGER = 291
INTEGER (KIND=C_INT),PARAMETER ::  L1_L3P3_AUGER = 292
INTEGER (KIND=C_INT),PARAMETER ::  L1_L3P4_AUGER = 293
INTEGER (KIND=C_INT),PARAMETER ::  L1_L3P5_AUGER = 294
INTEGER (KIND=C_INT),PARAMETER ::  L1_L3Q1_AUGER = 295
INTEGER (KIND=C_INT),PARAMETER ::  L1_L3Q2_AUGER = 296
INTEGER (KIND=C_INT),PARAMETER ::  L1_L3Q3_AUGER = 297
INTEGER (KIND=C_INT),PARAMETER ::  L1_M1L2_AUGER = 298
INTEGER (KIND=C_INT),PARAMETER ::  L1_M1L3_AUGER = 299
INTEGER (KIND=C_INT),PARAMETER ::  L1_M1M1_AUGER = 300
INTEGER (KIND=C_INT),PARAMETER ::  L1_M1M2_AUGER = 301
INTEGER (KIND=C_INT),PARAMETER ::  L1_M1M3_AUGER = 302
INTEGER (KIND=C_INT),PARAMETER ::  L1_M1M4_AUGER = 303
INTEGER (KIND=C_INT),PARAMETER ::  L1_M1M5_AUGER = 304
INTEGER (KIND=C_INT),PARAMETER ::  L1_M1N1_AUGER = 305
INTEGER (KIND=C_INT),PARAMETER ::  L1_M1N2_AUGER = 306
INTEGER (KIND=C_INT),PARAMETER ::  L1_M1N3_AUGER = 307
INTEGER (KIND=C_INT),PARAMETER ::  L1_M1N4_AUGER = 308
INTEGER (KIND=C_INT),PARAMETER ::  L1_M1N5_AUGER = 309
INTEGER (KIND=C_INT),PARAMETER ::  L1_M1N6_AUGER = 310
INTEGER (KIND=C_INT),PARAMETER ::  L1_M1N7_AUGER = 311
INTEGER (KIND=C_INT),PARAMETER ::  L1_M1O1_AUGER = 312
INTEGER (KIND=C_INT),PARAMETER ::  L1_M1O2_AUGER = 313
INTEGER (KIND=C_INT),PARAMETER ::  L1_M1O3_AUGER = 314
INTEGER (KIND=C_INT),PARAMETER ::  L1_M1O4_AUGER = 315
INTEGER (KIND=C_INT),PARAMETER ::  L1_M1O5_AUGER = 316
INTEGER (KIND=C_INT),PARAMETER ::  L1_M1O6_AUGER = 317
INTEGER (KIND=C_INT),PARAMETER ::  L1_M1O7_AUGER = 318
INTEGER (KIND=C_INT),PARAMETER ::  L1_M1P1_AUGER = 319
INTEGER (KIND=C_INT),PARAMETER ::  L1_M1P2_AUGER = 320
INTEGER (KIND=C_INT),PARAMETER ::  L1_M1P3_AUGER = 321
INTEGER (KIND=C_INT),PARAMETER ::  L1_M1P4_AUGER = 322
INTEGER (KIND=C_INT),PARAMETER ::  L1_M1P5_AUGER = 323
INTEGER (KIND=C_INT),PARAMETER ::  L1_M1Q1_AUGER = 324
INTEGER (KIND=C_INT),PARAMETER ::  L1_M1Q2_AUGER = 325
INTEGER (KIND=C_INT),PARAMETER ::  L1_M1Q3_AUGER = 326
INTEGER (KIND=C_INT),PARAMETER ::  L1_M2L2_AUGER = 327
INTEGER (KIND=C_INT),PARAMETER ::  L1_M2L3_AUGER = 328
INTEGER (KIND=C_INT),PARAMETER ::  L1_M2M1_AUGER = 329
INTEGER (KIND=C_INT),PARAMETER ::  L1_M2M2_AUGER = 330
INTEGER (KIND=C_INT),PARAMETER ::  L1_M2M3_AUGER = 331
INTEGER (KIND=C_INT),PARAMETER ::  L1_M2M4_AUGER = 332
INTEGER (KIND=C_INT),PARAMETER ::  L1_M2M5_AUGER = 333
INTEGER (KIND=C_INT),PARAMETER ::  L1_M2N1_AUGER = 334
INTEGER (KIND=C_INT),PARAMETER ::  L1_M2N2_AUGER = 335
INTEGER (KIND=C_INT),PARAMETER ::  L1_M2N3_AUGER = 336
INTEGER (KIND=C_INT),PARAMETER ::  L1_M2N4_AUGER = 337
INTEGER (KIND=C_INT),PARAMETER ::  L1_M2N5_AUGER = 338
INTEGER (KIND=C_INT),PARAMETER ::  L1_M2N6_AUGER = 339
INTEGER (KIND=C_INT),PARAMETER ::  L1_M2N7_AUGER = 340
INTEGER (KIND=C_INT),PARAMETER ::  L1_M2O1_AUGER = 341
INTEGER (KIND=C_INT),PARAMETER ::  L1_M2O2_AUGER = 342
INTEGER (KIND=C_INT),PARAMETER ::  L1_M2O3_AUGER = 343
INTEGER (KIND=C_INT),PARAMETER ::  L1_M2O4_AUGER = 344
INTEGER (KIND=C_INT),PARAMETER ::  L1_M2O5_AUGER = 345
INTEGER (KIND=C_INT),PARAMETER ::  L1_M2O6_AUGER = 346
INTEGER (KIND=C_INT),PARAMETER ::  L1_M2O7_AUGER = 347
INTEGER (KIND=C_INT),PARAMETER ::  L1_M2P1_AUGER = 348
INTEGER (KIND=C_INT),PARAMETER ::  L1_M2P2_AUGER = 349
INTEGER (KIND=C_INT),PARAMETER ::  L1_M2P3_AUGER = 350
INTEGER (KIND=C_INT),PARAMETER ::  L1_M2P4_AUGER = 351
INTEGER (KIND=C_INT),PARAMETER ::  L1_M2P5_AUGER = 352
INTEGER (KIND=C_INT),PARAMETER ::  L1_M2Q1_AUGER = 353
INTEGER (KIND=C_INT),PARAMETER ::  L1_M2Q2_AUGER = 354
INTEGER (KIND=C_INT),PARAMETER ::  L1_M2Q3_AUGER = 355
INTEGER (KIND=C_INT),PARAMETER ::  L1_M3L2_AUGER = 356
INTEGER (KIND=C_INT),PARAMETER ::  L1_M3L3_AUGER = 357
INTEGER (KIND=C_INT),PARAMETER ::  L1_M3M1_AUGER = 358
INTEGER (KIND=C_INT),PARAMETER ::  L1_M3M2_AUGER = 359
INTEGER (KIND=C_INT),PARAMETER ::  L1_M3M3_AUGER = 360
INTEGER (KIND=C_INT),PARAMETER ::  L1_M3M4_AUGER = 361
INTEGER (KIND=C_INT),PARAMETER ::  L1_M3M5_AUGER = 362
INTEGER (KIND=C_INT),PARAMETER ::  L1_M3N1_AUGER = 363
INTEGER (KIND=C_INT),PARAMETER ::  L1_M3N2_AUGER = 364
INTEGER (KIND=C_INT),PARAMETER ::  L1_M3N3_AUGER = 365
INTEGER (KIND=C_INT),PARAMETER ::  L1_M3N4_AUGER = 366
INTEGER (KIND=C_INT),PARAMETER ::  L1_M3N5_AUGER = 367
INTEGER (KIND=C_INT),PARAMETER ::  L1_M3N6_AUGER = 368
INTEGER (KIND=C_INT),PARAMETER ::  L1_M3N7_AUGER = 369
INTEGER (KIND=C_INT),PARAMETER ::  L1_M3O1_AUGER = 370
INTEGER (KIND=C_INT),PARAMETER ::  L1_M3O2_AUGER = 371
INTEGER (KIND=C_INT),PARAMETER ::  L1_M3O3_AUGER = 372
INTEGER (KIND=C_INT),PARAMETER ::  L1_M3O4_AUGER = 373
INTEGER (KIND=C_INT),PARAMETER ::  L1_M3O5_AUGER = 374
INTEGER (KIND=C_INT),PARAMETER ::  L1_M3O6_AUGER = 375
INTEGER (KIND=C_INT),PARAMETER ::  L1_M3O7_AUGER = 376
INTEGER (KIND=C_INT),PARAMETER ::  L1_M3P1_AUGER = 377
INTEGER (KIND=C_INT),PARAMETER ::  L1_M3P2_AUGER = 378
INTEGER (KIND=C_INT),PARAMETER ::  L1_M3P3_AUGER = 379
INTEGER (KIND=C_INT),PARAMETER ::  L1_M3P4_AUGER = 380
INTEGER (KIND=C_INT),PARAMETER ::  L1_M3P5_AUGER = 381
INTEGER (KIND=C_INT),PARAMETER ::  L1_M3Q1_AUGER = 382
INTEGER (KIND=C_INT),PARAMETER ::  L1_M3Q2_AUGER = 383
INTEGER (KIND=C_INT),PARAMETER ::  L1_M3Q3_AUGER = 384
INTEGER (KIND=C_INT),PARAMETER ::  L1_M4L2_AUGER = 385
INTEGER (KIND=C_INT),PARAMETER ::  L1_M4L3_AUGER = 386
INTEGER (KIND=C_INT),PARAMETER ::  L1_M4M1_AUGER = 387
INTEGER (KIND=C_INT),PARAMETER ::  L1_M4M2_AUGER = 388
INTEGER (KIND=C_INT),PARAMETER ::  L1_M4M3_AUGER = 389
INTEGER (KIND=C_INT),PARAMETER ::  L1_M4M4_AUGER = 390
INTEGER (KIND=C_INT),PARAMETER ::  L1_M4M5_AUGER = 391
INTEGER (KIND=C_INT),PARAMETER ::  L1_M4N1_AUGER = 392
INTEGER (KIND=C_INT),PARAMETER ::  L1_M4N2_AUGER = 393
INTEGER (KIND=C_INT),PARAMETER ::  L1_M4N3_AUGER = 394
INTEGER (KIND=C_INT),PARAMETER ::  L1_M4N4_AUGER = 395
INTEGER (KIND=C_INT),PARAMETER ::  L1_M4N5_AUGER = 396
INTEGER (KIND=C_INT),PARAMETER ::  L1_M4N6_AUGER = 397
INTEGER (KIND=C_INT),PARAMETER ::  L1_M4N7_AUGER = 398
INTEGER (KIND=C_INT),PARAMETER ::  L1_M4O1_AUGER = 399
INTEGER (KIND=C_INT),PARAMETER ::  L1_M4O2_AUGER = 400
INTEGER (KIND=C_INT),PARAMETER ::  L1_M4O3_AUGER = 401
INTEGER (KIND=C_INT),PARAMETER ::  L1_M4O4_AUGER = 402
INTEGER (KIND=C_INT),PARAMETER ::  L1_M4O5_AUGER = 403
INTEGER (KIND=C_INT),PARAMETER ::  L1_M4O6_AUGER = 404
INTEGER (KIND=C_INT),PARAMETER ::  L1_M4O7_AUGER = 405
INTEGER (KIND=C_INT),PARAMETER ::  L1_M4P1_AUGER = 406
INTEGER (KIND=C_INT),PARAMETER ::  L1_M4P2_AUGER = 407
INTEGER (KIND=C_INT),PARAMETER ::  L1_M4P3_AUGER = 408
INTEGER (KIND=C_INT),PARAMETER ::  L1_M4P4_AUGER = 409
INTEGER (KIND=C_INT),PARAMETER ::  L1_M4P5_AUGER = 410
INTEGER (KIND=C_INT),PARAMETER ::  L1_M4Q1_AUGER = 411
INTEGER (KIND=C_INT),PARAMETER ::  L1_M4Q2_AUGER = 412
INTEGER (KIND=C_INT),PARAMETER ::  L1_M4Q3_AUGER = 413
INTEGER (KIND=C_INT),PARAMETER ::  L1_M5L2_AUGER = 414
INTEGER (KIND=C_INT),PARAMETER ::  L1_M5L3_AUGER = 415
INTEGER (KIND=C_INT),PARAMETER ::  L1_M5M1_AUGER = 416
INTEGER (KIND=C_INT),PARAMETER ::  L1_M5M2_AUGER = 417
INTEGER (KIND=C_INT),PARAMETER ::  L1_M5M3_AUGER = 418
INTEGER (KIND=C_INT),PARAMETER ::  L1_M5M4_AUGER = 419
INTEGER (KIND=C_INT),PARAMETER ::  L1_M5M5_AUGER = 420
INTEGER (KIND=C_INT),PARAMETER ::  L1_M5N1_AUGER = 421
INTEGER (KIND=C_INT),PARAMETER ::  L1_M5N2_AUGER = 422
INTEGER (KIND=C_INT),PARAMETER ::  L1_M5N3_AUGER = 423
INTEGER (KIND=C_INT),PARAMETER ::  L1_M5N4_AUGER = 424
INTEGER (KIND=C_INT),PARAMETER ::  L1_M5N5_AUGER = 425
INTEGER (KIND=C_INT),PARAMETER ::  L1_M5N6_AUGER = 426
INTEGER (KIND=C_INT),PARAMETER ::  L1_M5N7_AUGER = 427
INTEGER (KIND=C_INT),PARAMETER ::  L1_M5O1_AUGER = 428
INTEGER (KIND=C_INT),PARAMETER ::  L1_M5O2_AUGER = 429
INTEGER (KIND=C_INT),PARAMETER ::  L1_M5O3_AUGER = 430
INTEGER (KIND=C_INT),PARAMETER ::  L1_M5O4_AUGER = 431
INTEGER (KIND=C_INT),PARAMETER ::  L1_M5O5_AUGER = 432
INTEGER (KIND=C_INT),PARAMETER ::  L1_M5O6_AUGER = 433
INTEGER (KIND=C_INT),PARAMETER ::  L1_M5O7_AUGER = 434
INTEGER (KIND=C_INT),PARAMETER ::  L1_M5P1_AUGER = 435
INTEGER (KIND=C_INT),PARAMETER ::  L1_M5P2_AUGER = 436
INTEGER (KIND=C_INT),PARAMETER ::  L1_M5P3_AUGER = 437
INTEGER (KIND=C_INT),PARAMETER ::  L1_M5P4_AUGER = 438
INTEGER (KIND=C_INT),PARAMETER ::  L1_M5P5_AUGER = 439
INTEGER (KIND=C_INT),PARAMETER ::  L1_M5Q1_AUGER = 440
INTEGER (KIND=C_INT),PARAMETER ::  L1_M5Q2_AUGER = 441
INTEGER (KIND=C_INT),PARAMETER ::  L1_M5Q3_AUGER = 442
INTEGER (KIND=C_INT),PARAMETER ::  L2_L3L3_AUGER = 443
INTEGER (KIND=C_INT),PARAMETER ::  L2_L3M1_AUGER = 444
INTEGER (KIND=C_INT),PARAMETER ::  L2_L3M2_AUGER = 445
INTEGER (KIND=C_INT),PARAMETER ::  L2_L3M3_AUGER = 446
INTEGER (KIND=C_INT),PARAMETER ::  L2_L3M4_AUGER = 447
INTEGER (KIND=C_INT),PARAMETER ::  L2_L3M5_AUGER = 448
INTEGER (KIND=C_INT),PARAMETER ::  L2_L3N1_AUGER = 449
INTEGER (KIND=C_INT),PARAMETER ::  L2_L3N2_AUGER = 450
INTEGER (KIND=C_INT),PARAMETER ::  L2_L3N3_AUGER = 451
INTEGER (KIND=C_INT),PARAMETER ::  L2_L3N4_AUGER = 452
INTEGER (KIND=C_INT),PARAMETER ::  L2_L3N5_AUGER = 453
INTEGER (KIND=C_INT),PARAMETER ::  L2_L3N6_AUGER = 454
INTEGER (KIND=C_INT),PARAMETER ::  L2_L3N7_AUGER = 455
INTEGER (KIND=C_INT),PARAMETER ::  L2_L3O1_AUGER = 456
INTEGER (KIND=C_INT),PARAMETER ::  L2_L3O2_AUGER = 457
INTEGER (KIND=C_INT),PARAMETER ::  L2_L3O3_AUGER = 458
INTEGER (KIND=C_INT),PARAMETER ::  L2_L3O4_AUGER = 459
INTEGER (KIND=C_INT),PARAMETER ::  L2_L3O5_AUGER = 460
INTEGER (KIND=C_INT),PARAMETER ::  L2_L3O6_AUGER = 461
INTEGER (KIND=C_INT),PARAMETER ::  L2_L3O7_AUGER = 462
INTEGER (KIND=C_INT),PARAMETER ::  L2_L3P1_AUGER = 463
INTEGER (KIND=C_INT),PARAMETER ::  L2_L3P2_AUGER = 464
INTEGER (KIND=C_INT),PARAMETER ::  L2_L3P3_AUGER = 465
INTEGER (KIND=C_INT),PARAMETER ::  L2_L3P4_AUGER = 466
INTEGER (KIND=C_INT),PARAMETER ::  L2_L3P5_AUGER = 467
INTEGER (KIND=C_INT),PARAMETER ::  L2_L3Q1_AUGER = 468
INTEGER (KIND=C_INT),PARAMETER ::  L2_L3Q2_AUGER = 469
INTEGER (KIND=C_INT),PARAMETER ::  L2_L3Q3_AUGER = 470
INTEGER (KIND=C_INT),PARAMETER ::  L2_M1L3_AUGER = 471
INTEGER (KIND=C_INT),PARAMETER ::  L2_M1M1_AUGER = 472
INTEGER (KIND=C_INT),PARAMETER ::  L2_M1M2_AUGER = 473
INTEGER (KIND=C_INT),PARAMETER ::  L2_M1M3_AUGER = 474
INTEGER (KIND=C_INT),PARAMETER ::  L2_M1M4_AUGER = 475
INTEGER (KIND=C_INT),PARAMETER ::  L2_M1M5_AUGER = 476
INTEGER (KIND=C_INT),PARAMETER ::  L2_M1N1_AUGER = 477
INTEGER (KIND=C_INT),PARAMETER ::  L2_M1N2_AUGER = 478
INTEGER (KIND=C_INT),PARAMETER ::  L2_M1N3_AUGER = 479
INTEGER (KIND=C_INT),PARAMETER ::  L2_M1N4_AUGER = 480
INTEGER (KIND=C_INT),PARAMETER ::  L2_M1N5_AUGER = 481
INTEGER (KIND=C_INT),PARAMETER ::  L2_M1N6_AUGER = 482
INTEGER (KIND=C_INT),PARAMETER ::  L2_M1N7_AUGER = 483
INTEGER (KIND=C_INT),PARAMETER ::  L2_M1O1_AUGER = 484
INTEGER (KIND=C_INT),PARAMETER ::  L2_M1O2_AUGER = 485
INTEGER (KIND=C_INT),PARAMETER ::  L2_M1O3_AUGER = 486
INTEGER (KIND=C_INT),PARAMETER ::  L2_M1O4_AUGER = 487
INTEGER (KIND=C_INT),PARAMETER ::  L2_M1O5_AUGER = 488
INTEGER (KIND=C_INT),PARAMETER ::  L2_M1O6_AUGER = 489
INTEGER (KIND=C_INT),PARAMETER ::  L2_M1O7_AUGER = 490
INTEGER (KIND=C_INT),PARAMETER ::  L2_M1P1_AUGER = 491
INTEGER (KIND=C_INT),PARAMETER ::  L2_M1P2_AUGER = 492
INTEGER (KIND=C_INT),PARAMETER ::  L2_M1P3_AUGER = 493
INTEGER (KIND=C_INT),PARAMETER ::  L2_M1P4_AUGER = 494
INTEGER (KIND=C_INT),PARAMETER ::  L2_M1P5_AUGER = 495
INTEGER (KIND=C_INT),PARAMETER ::  L2_M1Q1_AUGER = 496
INTEGER (KIND=C_INT),PARAMETER ::  L2_M1Q2_AUGER = 497
INTEGER (KIND=C_INT),PARAMETER ::  L2_M1Q3_AUGER = 498
INTEGER (KIND=C_INT),PARAMETER ::  L2_M2L3_AUGER = 499
INTEGER (KIND=C_INT),PARAMETER ::  L2_M2M1_AUGER = 500
INTEGER (KIND=C_INT),PARAMETER ::  L2_M2M2_AUGER = 501
INTEGER (KIND=C_INT),PARAMETER ::  L2_M2M3_AUGER = 502
INTEGER (KIND=C_INT),PARAMETER ::  L2_M2M4_AUGER = 503
INTEGER (KIND=C_INT),PARAMETER ::  L2_M2M5_AUGER = 504
INTEGER (KIND=C_INT),PARAMETER ::  L2_M2N1_AUGER = 505
INTEGER (KIND=C_INT),PARAMETER ::  L2_M2N2_AUGER = 506
INTEGER (KIND=C_INT),PARAMETER ::  L2_M2N3_AUGER = 507
INTEGER (KIND=C_INT),PARAMETER ::  L2_M2N4_AUGER = 508
INTEGER (KIND=C_INT),PARAMETER ::  L2_M2N5_AUGER = 509
INTEGER (KIND=C_INT),PARAMETER ::  L2_M2N6_AUGER = 510
INTEGER (KIND=C_INT),PARAMETER ::  L2_M2N7_AUGER = 511
INTEGER (KIND=C_INT),PARAMETER ::  L2_M2O1_AUGER = 512
INTEGER (KIND=C_INT),PARAMETER ::  L2_M2O2_AUGER = 513
INTEGER (KIND=C_INT),PARAMETER ::  L2_M2O3_AUGER = 514
INTEGER (KIND=C_INT),PARAMETER ::  L2_M2O4_AUGER = 515
INTEGER (KIND=C_INT),PARAMETER ::  L2_M2O5_AUGER = 516
INTEGER (KIND=C_INT),PARAMETER ::  L2_M2O6_AUGER = 517
INTEGER (KIND=C_INT),PARAMETER ::  L2_M2O7_AUGER = 518
INTEGER (KIND=C_INT),PARAMETER ::  L2_M2P1_AUGER = 519
INTEGER (KIND=C_INT),PARAMETER ::  L2_M2P2_AUGER = 520
INTEGER (KIND=C_INT),PARAMETER ::  L2_M2P3_AUGER = 521
INTEGER (KIND=C_INT),PARAMETER ::  L2_M2P4_AUGER = 522
INTEGER (KIND=C_INT),PARAMETER ::  L2_M2P5_AUGER = 523
INTEGER (KIND=C_INT),PARAMETER ::  L2_M2Q1_AUGER = 524
INTEGER (KIND=C_INT),PARAMETER ::  L2_M2Q2_AUGER = 525
INTEGER (KIND=C_INT),PARAMETER ::  L2_M2Q3_AUGER = 526
INTEGER (KIND=C_INT),PARAMETER ::  L2_M3L3_AUGER = 527
INTEGER (KIND=C_INT),PARAMETER ::  L2_M3M1_AUGER = 528
INTEGER (KIND=C_INT),PARAMETER ::  L2_M3M2_AUGER = 529
INTEGER (KIND=C_INT),PARAMETER ::  L2_M3M3_AUGER = 530
INTEGER (KIND=C_INT),PARAMETER ::  L2_M3M4_AUGER = 531
INTEGER (KIND=C_INT),PARAMETER ::  L2_M3M5_AUGER = 532
INTEGER (KIND=C_INT),PARAMETER ::  L2_M3N1_AUGER = 533
INTEGER (KIND=C_INT),PARAMETER ::  L2_M3N2_AUGER = 534
INTEGER (KIND=C_INT),PARAMETER ::  L2_M3N3_AUGER = 535
INTEGER (KIND=C_INT),PARAMETER ::  L2_M3N4_AUGER = 536
INTEGER (KIND=C_INT),PARAMETER ::  L2_M3N5_AUGER = 537
INTEGER (KIND=C_INT),PARAMETER ::  L2_M3N6_AUGER = 538
INTEGER (KIND=C_INT),PARAMETER ::  L2_M3N7_AUGER = 539
INTEGER (KIND=C_INT),PARAMETER ::  L2_M3O1_AUGER = 540
INTEGER (KIND=C_INT),PARAMETER ::  L2_M3O2_AUGER = 541
INTEGER (KIND=C_INT),PARAMETER ::  L2_M3O3_AUGER = 542
INTEGER (KIND=C_INT),PARAMETER ::  L2_M3O4_AUGER = 543
INTEGER (KIND=C_INT),PARAMETER ::  L2_M3O5_AUGER = 544
INTEGER (KIND=C_INT),PARAMETER ::  L2_M3O6_AUGER = 545
INTEGER (KIND=C_INT),PARAMETER ::  L2_M3O7_AUGER = 546
INTEGER (KIND=C_INT),PARAMETER ::  L2_M3P1_AUGER = 547
INTEGER (KIND=C_INT),PARAMETER ::  L2_M3P2_AUGER = 548
INTEGER (KIND=C_INT),PARAMETER ::  L2_M3P3_AUGER = 549
INTEGER (KIND=C_INT),PARAMETER ::  L2_M3P4_AUGER = 550
INTEGER (KIND=C_INT),PARAMETER ::  L2_M3P5_AUGER = 551
INTEGER (KIND=C_INT),PARAMETER ::  L2_M3Q1_AUGER = 552
INTEGER (KIND=C_INT),PARAMETER ::  L2_M3Q2_AUGER = 553
INTEGER (KIND=C_INT),PARAMETER ::  L2_M3Q3_AUGER = 554
INTEGER (KIND=C_INT),PARAMETER ::  L2_M4L3_AUGER = 555
INTEGER (KIND=C_INT),PARAMETER ::  L2_M4M1_AUGER = 556
INTEGER (KIND=C_INT),PARAMETER ::  L2_M4M2_AUGER = 557
INTEGER (KIND=C_INT),PARAMETER ::  L2_M4M3_AUGER = 558
INTEGER (KIND=C_INT),PARAMETER ::  L2_M4M4_AUGER = 559
INTEGER (KIND=C_INT),PARAMETER ::  L2_M4M5_AUGER = 560
INTEGER (KIND=C_INT),PARAMETER ::  L2_M4N1_AUGER = 561
INTEGER (KIND=C_INT),PARAMETER ::  L2_M4N2_AUGER = 562
INTEGER (KIND=C_INT),PARAMETER ::  L2_M4N3_AUGER = 563
INTEGER (KIND=C_INT),PARAMETER ::  L2_M4N4_AUGER = 564
INTEGER (KIND=C_INT),PARAMETER ::  L2_M4N5_AUGER = 565
INTEGER (KIND=C_INT),PARAMETER ::  L2_M4N6_AUGER = 566
INTEGER (KIND=C_INT),PARAMETER ::  L2_M4N7_AUGER = 567
INTEGER (KIND=C_INT),PARAMETER ::  L2_M4O1_AUGER = 568
INTEGER (KIND=C_INT),PARAMETER ::  L2_M4O2_AUGER = 569
INTEGER (KIND=C_INT),PARAMETER ::  L2_M4O3_AUGER = 570
INTEGER (KIND=C_INT),PARAMETER ::  L2_M4O4_AUGER = 571
INTEGER (KIND=C_INT),PARAMETER ::  L2_M4O5_AUGER = 572
INTEGER (KIND=C_INT),PARAMETER ::  L2_M4O6_AUGER = 573
INTEGER (KIND=C_INT),PARAMETER ::  L2_M4O7_AUGER = 574
INTEGER (KIND=C_INT),PARAMETER ::  L2_M4P1_AUGER = 575
INTEGER (KIND=C_INT),PARAMETER ::  L2_M4P2_AUGER = 576
INTEGER (KIND=C_INT),PARAMETER ::  L2_M4P3_AUGER = 577
INTEGER (KIND=C_INT),PARAMETER ::  L2_M4P4_AUGER = 578
INTEGER (KIND=C_INT),PARAMETER ::  L2_M4P5_AUGER = 579
INTEGER (KIND=C_INT),PARAMETER ::  L2_M4Q1_AUGER = 580
INTEGER (KIND=C_INT),PARAMETER ::  L2_M4Q2_AUGER = 581
INTEGER (KIND=C_INT),PARAMETER ::  L2_M4Q3_AUGER = 582
INTEGER (KIND=C_INT),PARAMETER ::  L2_M5L3_AUGER = 583
INTEGER (KIND=C_INT),PARAMETER ::  L2_M5M1_AUGER = 584
INTEGER (KIND=C_INT),PARAMETER ::  L2_M5M2_AUGER = 585
INTEGER (KIND=C_INT),PARAMETER ::  L2_M5M3_AUGER = 586
INTEGER (KIND=C_INT),PARAMETER ::  L2_M5M4_AUGER = 587
INTEGER (KIND=C_INT),PARAMETER ::  L2_M5M5_AUGER = 588
INTEGER (KIND=C_INT),PARAMETER ::  L2_M5N1_AUGER = 589
INTEGER (KIND=C_INT),PARAMETER ::  L2_M5N2_AUGER = 590
INTEGER (KIND=C_INT),PARAMETER ::  L2_M5N3_AUGER = 591
INTEGER (KIND=C_INT),PARAMETER ::  L2_M5N4_AUGER = 592
INTEGER (KIND=C_INT),PARAMETER ::  L2_M5N5_AUGER = 593
INTEGER (KIND=C_INT),PARAMETER ::  L2_M5N6_AUGER = 594
INTEGER (KIND=C_INT),PARAMETER ::  L2_M5N7_AUGER = 595
INTEGER (KIND=C_INT),PARAMETER ::  L2_M5O1_AUGER = 596
INTEGER (KIND=C_INT),PARAMETER ::  L2_M5O2_AUGER = 597
INTEGER (KIND=C_INT),PARAMETER ::  L2_M5O3_AUGER = 598
INTEGER (KIND=C_INT),PARAMETER ::  L2_M5O4_AUGER = 599
INTEGER (KIND=C_INT),PARAMETER ::  L2_M5O5_AUGER = 600
INTEGER (KIND=C_INT),PARAMETER ::  L2_M5O6_AUGER = 601
INTEGER (KIND=C_INT),PARAMETER ::  L2_M5O7_AUGER = 602
INTEGER (KIND=C_INT),PARAMETER ::  L2_M5P1_AUGER = 603
INTEGER (KIND=C_INT),PARAMETER ::  L2_M5P2_AUGER = 604
INTEGER (KIND=C_INT),PARAMETER ::  L2_M5P3_AUGER = 605
INTEGER (KIND=C_INT),PARAMETER ::  L2_M5P4_AUGER = 606
INTEGER (KIND=C_INT),PARAMETER ::  L2_M5P5_AUGER = 607
INTEGER (KIND=C_INT),PARAMETER ::  L2_M5Q1_AUGER = 608
INTEGER (KIND=C_INT),PARAMETER ::  L2_M5Q2_AUGER = 609
INTEGER (KIND=C_INT),PARAMETER ::  L2_M5Q3_AUGER = 610
INTEGER (KIND=C_INT),PARAMETER ::  L3_M1M1_AUGER = 611
INTEGER (KIND=C_INT),PARAMETER ::  L3_M1M2_AUGER = 612
INTEGER (KIND=C_INT),PARAMETER ::  L3_M1M3_AUGER = 613
INTEGER (KIND=C_INT),PARAMETER ::  L3_M1M4_AUGER = 614
INTEGER (KIND=C_INT),PARAMETER ::  L3_M1M5_AUGER = 615
INTEGER (KIND=C_INT),PARAMETER ::  L3_M1N1_AUGER = 616
INTEGER (KIND=C_INT),PARAMETER ::  L3_M1N2_AUGER = 617
INTEGER (KIND=C_INT),PARAMETER ::  L3_M1N3_AUGER = 618
INTEGER (KIND=C_INT),PARAMETER ::  L3_M1N4_AUGER = 619
INTEGER (KIND=C_INT),PARAMETER ::  L3_M1N5_AUGER = 620
INTEGER (KIND=C_INT),PARAMETER ::  L3_M1N6_AUGER = 621
INTEGER (KIND=C_INT),PARAMETER ::  L3_M1N7_AUGER = 622
INTEGER (KIND=C_INT),PARAMETER ::  L3_M1O1_AUGER = 623
INTEGER (KIND=C_INT),PARAMETER ::  L3_M1O2_AUGER = 624
INTEGER (KIND=C_INT),PARAMETER ::  L3_M1O3_AUGER = 625
INTEGER (KIND=C_INT),PARAMETER ::  L3_M1O4_AUGER = 626
INTEGER (KIND=C_INT),PARAMETER ::  L3_M1O5_AUGER = 627
INTEGER (KIND=C_INT),PARAMETER ::  L3_M1O6_AUGER = 628
INTEGER (KIND=C_INT),PARAMETER ::  L3_M1O7_AUGER = 629
INTEGER (KIND=C_INT),PARAMETER ::  L3_M1P1_AUGER = 630
INTEGER (KIND=C_INT),PARAMETER ::  L3_M1P2_AUGER = 631
INTEGER (KIND=C_INT),PARAMETER ::  L3_M1P3_AUGER = 632
INTEGER (KIND=C_INT),PARAMETER ::  L3_M1P4_AUGER = 633
INTEGER (KIND=C_INT),PARAMETER ::  L3_M1P5_AUGER = 634
INTEGER (KIND=C_INT),PARAMETER ::  L3_M1Q1_AUGER = 635
INTEGER (KIND=C_INT),PARAMETER ::  L3_M1Q2_AUGER = 636
INTEGER (KIND=C_INT),PARAMETER ::  L3_M1Q3_AUGER = 637
INTEGER (KIND=C_INT),PARAMETER ::  L3_M2M1_AUGER = 638
INTEGER (KIND=C_INT),PARAMETER ::  L3_M2M2_AUGER = 639
INTEGER (KIND=C_INT),PARAMETER ::  L3_M2M3_AUGER = 640
INTEGER (KIND=C_INT),PARAMETER ::  L3_M2M4_AUGER = 641
INTEGER (KIND=C_INT),PARAMETER ::  L3_M2M5_AUGER = 642
INTEGER (KIND=C_INT),PARAMETER ::  L3_M2N1_AUGER = 643
INTEGER (KIND=C_INT),PARAMETER ::  L3_M2N2_AUGER = 644
INTEGER (KIND=C_INT),PARAMETER ::  L3_M2N3_AUGER = 645
INTEGER (KIND=C_INT),PARAMETER ::  L3_M2N4_AUGER = 646
INTEGER (KIND=C_INT),PARAMETER ::  L3_M2N5_AUGER = 647
INTEGER (KIND=C_INT),PARAMETER ::  L3_M2N6_AUGER = 648
INTEGER (KIND=C_INT),PARAMETER ::  L3_M2N7_AUGER = 649
INTEGER (KIND=C_INT),PARAMETER ::  L3_M2O1_AUGER = 650
INTEGER (KIND=C_INT),PARAMETER ::  L3_M2O2_AUGER = 651
INTEGER (KIND=C_INT),PARAMETER ::  L3_M2O3_AUGER = 652
INTEGER (KIND=C_INT),PARAMETER ::  L3_M2O4_AUGER = 653
INTEGER (KIND=C_INT),PARAMETER ::  L3_M2O5_AUGER = 654
INTEGER (KIND=C_INT),PARAMETER ::  L3_M2O6_AUGER = 655
INTEGER (KIND=C_INT),PARAMETER ::  L3_M2O7_AUGER = 656
INTEGER (KIND=C_INT),PARAMETER ::  L3_M2P1_AUGER = 657
INTEGER (KIND=C_INT),PARAMETER ::  L3_M2P2_AUGER = 658
INTEGER (KIND=C_INT),PARAMETER ::  L3_M2P3_AUGER = 659
INTEGER (KIND=C_INT),PARAMETER ::  L3_M2P4_AUGER = 660
INTEGER (KIND=C_INT),PARAMETER ::  L3_M2P5_AUGER = 661
INTEGER (KIND=C_INT),PARAMETER ::  L3_M2Q1_AUGER = 662
INTEGER (KIND=C_INT),PARAMETER ::  L3_M2Q2_AUGER = 663
INTEGER (KIND=C_INT),PARAMETER ::  L3_M2Q3_AUGER = 664
INTEGER (KIND=C_INT),PARAMETER ::  L3_M3M1_AUGER = 665
INTEGER (KIND=C_INT),PARAMETER ::  L3_M3M2_AUGER = 666
INTEGER (KIND=C_INT),PARAMETER ::  L3_M3M3_AUGER = 667
INTEGER (KIND=C_INT),PARAMETER ::  L3_M3M4_AUGER = 668
INTEGER (KIND=C_INT),PARAMETER ::  L3_M3M5_AUGER = 669
INTEGER (KIND=C_INT),PARAMETER ::  L3_M3N1_AUGER = 670
INTEGER (KIND=C_INT),PARAMETER ::  L3_M3N2_AUGER = 671
INTEGER (KIND=C_INT),PARAMETER ::  L3_M3N3_AUGER = 672
INTEGER (KIND=C_INT),PARAMETER ::  L3_M3N4_AUGER = 673
INTEGER (KIND=C_INT),PARAMETER ::  L3_M3N5_AUGER = 674
INTEGER (KIND=C_INT),PARAMETER ::  L3_M3N6_AUGER = 675
INTEGER (KIND=C_INT),PARAMETER ::  L3_M3N7_AUGER = 676
INTEGER (KIND=C_INT),PARAMETER ::  L3_M3O1_AUGER = 677
INTEGER (KIND=C_INT),PARAMETER ::  L3_M3O2_AUGER = 678
INTEGER (KIND=C_INT),PARAMETER ::  L3_M3O3_AUGER = 679
INTEGER (KIND=C_INT),PARAMETER ::  L3_M3O4_AUGER = 680
INTEGER (KIND=C_INT),PARAMETER ::  L3_M3O5_AUGER = 681
INTEGER (KIND=C_INT),PARAMETER ::  L3_M3O6_AUGER = 682
INTEGER (KIND=C_INT),PARAMETER ::  L3_M3O7_AUGER = 683
INTEGER (KIND=C_INT),PARAMETER ::  L3_M3P1_AUGER = 684
INTEGER (KIND=C_INT),PARAMETER ::  L3_M3P2_AUGER = 685
INTEGER (KIND=C_INT),PARAMETER ::  L3_M3P3_AUGER = 686
INTEGER (KIND=C_INT),PARAMETER ::  L3_M3P4_AUGER = 687
INTEGER (KIND=C_INT),PARAMETER ::  L3_M3P5_AUGER = 688
INTEGER (KIND=C_INT),PARAMETER ::  L3_M3Q1_AUGER = 689
INTEGER (KIND=C_INT),PARAMETER ::  L3_M3Q2_AUGER = 690
INTEGER (KIND=C_INT),PARAMETER ::  L3_M3Q3_AUGER = 691
INTEGER (KIND=C_INT),PARAMETER ::  L3_M4M1_AUGER = 692
INTEGER (KIND=C_INT),PARAMETER ::  L3_M4M2_AUGER = 693
INTEGER (KIND=C_INT),PARAMETER ::  L3_M4M3_AUGER = 694
INTEGER (KIND=C_INT),PARAMETER ::  L3_M4M4_AUGER = 695
INTEGER (KIND=C_INT),PARAMETER ::  L3_M4M5_AUGER = 696
INTEGER (KIND=C_INT),PARAMETER ::  L3_M4N1_AUGER = 697
INTEGER (KIND=C_INT),PARAMETER ::  L3_M4N2_AUGER = 698
INTEGER (KIND=C_INT),PARAMETER ::  L3_M4N3_AUGER = 699
INTEGER (KIND=C_INT),PARAMETER ::  L3_M4N4_AUGER = 700
INTEGER (KIND=C_INT),PARAMETER ::  L3_M4N5_AUGER = 701
INTEGER (KIND=C_INT),PARAMETER ::  L3_M4N6_AUGER = 702
INTEGER (KIND=C_INT),PARAMETER ::  L3_M4N7_AUGER = 703
INTEGER (KIND=C_INT),PARAMETER ::  L3_M4O1_AUGER = 704
INTEGER (KIND=C_INT),PARAMETER ::  L3_M4O2_AUGER = 705
INTEGER (KIND=C_INT),PARAMETER ::  L3_M4O3_AUGER = 706
INTEGER (KIND=C_INT),PARAMETER ::  L3_M4O4_AUGER = 707
INTEGER (KIND=C_INT),PARAMETER ::  L3_M4O5_AUGER = 708
INTEGER (KIND=C_INT),PARAMETER ::  L3_M4O6_AUGER = 709
INTEGER (KIND=C_INT),PARAMETER ::  L3_M4O7_AUGER = 710
INTEGER (KIND=C_INT),PARAMETER ::  L3_M4P1_AUGER = 711
INTEGER (KIND=C_INT),PARAMETER ::  L3_M4P2_AUGER = 712
INTEGER (KIND=C_INT),PARAMETER ::  L3_M4P3_AUGER = 713
INTEGER (KIND=C_INT),PARAMETER ::  L3_M4P4_AUGER = 714
INTEGER (KIND=C_INT),PARAMETER ::  L3_M4P5_AUGER = 715
INTEGER (KIND=C_INT),PARAMETER ::  L3_M4Q1_AUGER = 716
INTEGER (KIND=C_INT),PARAMETER ::  L3_M4Q2_AUGER = 717
INTEGER (KIND=C_INT),PARAMETER ::  L3_M4Q3_AUGER = 718
INTEGER (KIND=C_INT),PARAMETER ::  L3_M5M1_AUGER = 719
INTEGER (KIND=C_INT),PARAMETER ::  L3_M5M2_AUGER = 720
INTEGER (KIND=C_INT),PARAMETER ::  L3_M5M3_AUGER = 721
INTEGER (KIND=C_INT),PARAMETER ::  L3_M5M4_AUGER = 722
INTEGER (KIND=C_INT),PARAMETER ::  L3_M5M5_AUGER = 723
INTEGER (KIND=C_INT),PARAMETER ::  L3_M5N1_AUGER = 724
INTEGER (KIND=C_INT),PARAMETER ::  L3_M5N2_AUGER = 725
INTEGER (KIND=C_INT),PARAMETER ::  L3_M5N3_AUGER = 726
INTEGER (KIND=C_INT),PARAMETER ::  L3_M5N4_AUGER = 727
INTEGER (KIND=C_INT),PARAMETER ::  L3_M5N5_AUGER = 728
INTEGER (KIND=C_INT),PARAMETER ::  L3_M5N6_AUGER = 729
INTEGER (KIND=C_INT),PARAMETER ::  L3_M5N7_AUGER = 730
INTEGER (KIND=C_INT),PARAMETER ::  L3_M5O1_AUGER = 731
INTEGER (KIND=C_INT),PARAMETER ::  L3_M5O2_AUGER = 732
INTEGER (KIND=C_INT),PARAMETER ::  L3_M5O3_AUGER = 733
INTEGER (KIND=C_INT),PARAMETER ::  L3_M5O4_AUGER = 734
INTEGER (KIND=C_INT),PARAMETER ::  L3_M5O5_AUGER = 735
INTEGER (KIND=C_INT),PARAMETER ::  L3_M5O6_AUGER = 736
INTEGER (KIND=C_INT),PARAMETER ::  L3_M5O7_AUGER = 737
INTEGER (KIND=C_INT),PARAMETER ::  L3_M5P1_AUGER = 738
INTEGER (KIND=C_INT),PARAMETER ::  L3_M5P2_AUGER = 739
INTEGER (KIND=C_INT),PARAMETER ::  L3_M5P3_AUGER = 740
INTEGER (KIND=C_INT),PARAMETER ::  L3_M5P4_AUGER = 741
INTEGER (KIND=C_INT),PARAMETER ::  L3_M5P5_AUGER = 742
INTEGER (KIND=C_INT),PARAMETER ::  L3_M5Q1_AUGER = 743
INTEGER (KIND=C_INT),PARAMETER ::  L3_M5Q2_AUGER = 744
INTEGER (KIND=C_INT),PARAMETER ::  L3_M5Q3_AUGER = 745
INTEGER (KIND=C_INT),PARAMETER ::  M1_M2M2_AUGER = 746
INTEGER (KIND=C_INT),PARAMETER ::  M1_M2M3_AUGER = 747
INTEGER (KIND=C_INT),PARAMETER ::  M1_M2M4_AUGER = 748
INTEGER (KIND=C_INT),PARAMETER ::  M1_M2M5_AUGER = 749
INTEGER (KIND=C_INT),PARAMETER ::  M1_M2N1_AUGER = 750
INTEGER (KIND=C_INT),PARAMETER ::  M1_M2N2_AUGER = 751
INTEGER (KIND=C_INT),PARAMETER ::  M1_M2N3_AUGER = 752
INTEGER (KIND=C_INT),PARAMETER ::  M1_M2N4_AUGER = 753
INTEGER (KIND=C_INT),PARAMETER ::  M1_M2N5_AUGER = 754
INTEGER (KIND=C_INT),PARAMETER ::  M1_M2N6_AUGER = 755
INTEGER (KIND=C_INT),PARAMETER ::  M1_M2N7_AUGER = 756
INTEGER (KIND=C_INT),PARAMETER ::  M1_M2O1_AUGER = 757
INTEGER (KIND=C_INT),PARAMETER ::  M1_M2O2_AUGER = 758
INTEGER (KIND=C_INT),PARAMETER ::  M1_M2O3_AUGER = 759
INTEGER (KIND=C_INT),PARAMETER ::  M1_M2O4_AUGER = 760
INTEGER (KIND=C_INT),PARAMETER ::  M1_M2O5_AUGER = 761
INTEGER (KIND=C_INT),PARAMETER ::  M1_M2O6_AUGER = 762
INTEGER (KIND=C_INT),PARAMETER ::  M1_M2O7_AUGER = 763
INTEGER (KIND=C_INT),PARAMETER ::  M1_M2P1_AUGER = 764
INTEGER (KIND=C_INT),PARAMETER ::  M1_M2P2_AUGER = 765
INTEGER (KIND=C_INT),PARAMETER ::  M1_M2P3_AUGER = 766
INTEGER (KIND=C_INT),PARAMETER ::  M1_M2P4_AUGER = 767
INTEGER (KIND=C_INT),PARAMETER ::  M1_M2P5_AUGER = 768
INTEGER (KIND=C_INT),PARAMETER ::  M1_M2Q1_AUGER = 769
INTEGER (KIND=C_INT),PARAMETER ::  M1_M2Q2_AUGER = 770
INTEGER (KIND=C_INT),PARAMETER ::  M1_M2Q3_AUGER = 771
INTEGER (KIND=C_INT),PARAMETER ::  M1_M3M2_AUGER = 772
INTEGER (KIND=C_INT),PARAMETER ::  M1_M3M3_AUGER = 773
INTEGER (KIND=C_INT),PARAMETER ::  M1_M3M4_AUGER = 774
INTEGER (KIND=C_INT),PARAMETER ::  M1_M3M5_AUGER = 775
INTEGER (KIND=C_INT),PARAMETER ::  M1_M3N1_AUGER = 776
INTEGER (KIND=C_INT),PARAMETER ::  M1_M3N2_AUGER = 777
INTEGER (KIND=C_INT),PARAMETER ::  M1_M3N3_AUGER = 778
INTEGER (KIND=C_INT),PARAMETER ::  M1_M3N4_AUGER = 779
INTEGER (KIND=C_INT),PARAMETER ::  M1_M3N5_AUGER = 780
INTEGER (KIND=C_INT),PARAMETER ::  M1_M3N6_AUGER = 781
INTEGER (KIND=C_INT),PARAMETER ::  M1_M3N7_AUGER = 782
INTEGER (KIND=C_INT),PARAMETER ::  M1_M3O1_AUGER = 783
INTEGER (KIND=C_INT),PARAMETER ::  M1_M3O2_AUGER = 784
INTEGER (KIND=C_INT),PARAMETER ::  M1_M3O3_AUGER = 785
INTEGER (KIND=C_INT),PARAMETER ::  M1_M3O4_AUGER = 786
INTEGER (KIND=C_INT),PARAMETER ::  M1_M3O5_AUGER = 787
INTEGER (KIND=C_INT),PARAMETER ::  M1_M3O6_AUGER = 788
INTEGER (KIND=C_INT),PARAMETER ::  M1_M3O7_AUGER = 789
INTEGER (KIND=C_INT),PARAMETER ::  M1_M3P1_AUGER = 790
INTEGER (KIND=C_INT),PARAMETER ::  M1_M3P2_AUGER = 791
INTEGER (KIND=C_INT),PARAMETER ::  M1_M3P3_AUGER = 792
INTEGER (KIND=C_INT),PARAMETER ::  M1_M3P4_AUGER = 793
INTEGER (KIND=C_INT),PARAMETER ::  M1_M3P5_AUGER = 794
INTEGER (KIND=C_INT),PARAMETER ::  M1_M3Q1_AUGER = 795
INTEGER (KIND=C_INT),PARAMETER ::  M1_M3Q2_AUGER = 796
INTEGER (KIND=C_INT),PARAMETER ::  M1_M3Q3_AUGER = 797
INTEGER (KIND=C_INT),PARAMETER ::  M1_M4M2_AUGER = 798
INTEGER (KIND=C_INT),PARAMETER ::  M1_M4M3_AUGER = 799
INTEGER (KIND=C_INT),PARAMETER ::  M1_M4M4_AUGER = 800
INTEGER (KIND=C_INT),PARAMETER ::  M1_M4M5_AUGER = 801
INTEGER (KIND=C_INT),PARAMETER ::  M1_M4N1_AUGER = 802
INTEGER (KIND=C_INT),PARAMETER ::  M1_M4N2_AUGER = 803
INTEGER (KIND=C_INT),PARAMETER ::  M1_M4N3_AUGER = 804
INTEGER (KIND=C_INT),PARAMETER ::  M1_M4N4_AUGER = 805
INTEGER (KIND=C_INT),PARAMETER ::  M1_M4N5_AUGER = 806
INTEGER (KIND=C_INT),PARAMETER ::  M1_M4N6_AUGER = 807
INTEGER (KIND=C_INT),PARAMETER ::  M1_M4N7_AUGER = 808
INTEGER (KIND=C_INT),PARAMETER ::  M1_M4O1_AUGER = 809
INTEGER (KIND=C_INT),PARAMETER ::  M1_M4O2_AUGER = 810
INTEGER (KIND=C_INT),PARAMETER ::  M1_M4O3_AUGER = 811
INTEGER (KIND=C_INT),PARAMETER ::  M1_M4O4_AUGER = 812
INTEGER (KIND=C_INT),PARAMETER ::  M1_M4O5_AUGER = 813
INTEGER (KIND=C_INT),PARAMETER ::  M1_M4O6_AUGER = 814
INTEGER (KIND=C_INT),PARAMETER ::  M1_M4O7_AUGER = 815
INTEGER (KIND=C_INT),PARAMETER ::  M1_M4P1_AUGER = 816
INTEGER (KIND=C_INT),PARAMETER ::  M1_M4P2_AUGER = 817
INTEGER (KIND=C_INT),PARAMETER ::  M1_M4P3_AUGER = 818
INTEGER (KIND=C_INT),PARAMETER ::  M1_M4P4_AUGER = 819
INTEGER (KIND=C_INT),PARAMETER ::  M1_M4P5_AUGER = 820
INTEGER (KIND=C_INT),PARAMETER ::  M1_M4Q1_AUGER = 821
INTEGER (KIND=C_INT),PARAMETER ::  M1_M4Q2_AUGER = 822
INTEGER (KIND=C_INT),PARAMETER ::  M1_M4Q3_AUGER = 823
INTEGER (KIND=C_INT),PARAMETER ::  M1_M5M2_AUGER = 824
INTEGER (KIND=C_INT),PARAMETER ::  M1_M5M3_AUGER = 825
INTEGER (KIND=C_INT),PARAMETER ::  M1_M5M4_AUGER = 826
INTEGER (KIND=C_INT),PARAMETER ::  M1_M5M5_AUGER = 827
INTEGER (KIND=C_INT),PARAMETER ::  M1_M5N1_AUGER = 828
INTEGER (KIND=C_INT),PARAMETER ::  M1_M5N2_AUGER = 829
INTEGER (KIND=C_INT),PARAMETER ::  M1_M5N3_AUGER = 830
INTEGER (KIND=C_INT),PARAMETER ::  M1_M5N4_AUGER = 831
INTEGER (KIND=C_INT),PARAMETER ::  M1_M5N5_AUGER = 832
INTEGER (KIND=C_INT),PARAMETER ::  M1_M5N6_AUGER = 833
INTEGER (KIND=C_INT),PARAMETER ::  M1_M5N7_AUGER = 834
INTEGER (KIND=C_INT),PARAMETER ::  M1_M5O1_AUGER = 835
INTEGER (KIND=C_INT),PARAMETER ::  M1_M5O2_AUGER = 836
INTEGER (KIND=C_INT),PARAMETER ::  M1_M5O3_AUGER = 837
INTEGER (KIND=C_INT),PARAMETER ::  M1_M5O4_AUGER = 838
INTEGER (KIND=C_INT),PARAMETER ::  M1_M5O5_AUGER = 839
INTEGER (KIND=C_INT),PARAMETER ::  M1_M5O6_AUGER = 840
INTEGER (KIND=C_INT),PARAMETER ::  M1_M5O7_AUGER = 841
INTEGER (KIND=C_INT),PARAMETER ::  M1_M5P1_AUGER = 842
INTEGER (KIND=C_INT),PARAMETER ::  M1_M5P2_AUGER = 843
INTEGER (KIND=C_INT),PARAMETER ::  M1_M5P3_AUGER = 844
INTEGER (KIND=C_INT),PARAMETER ::  M1_M5P4_AUGER = 845
INTEGER (KIND=C_INT),PARAMETER ::  M1_M5P5_AUGER = 846
INTEGER (KIND=C_INT),PARAMETER ::  M1_M5Q1_AUGER = 847
INTEGER (KIND=C_INT),PARAMETER ::  M1_M5Q2_AUGER = 848
INTEGER (KIND=C_INT),PARAMETER ::  M1_M5Q3_AUGER = 849
INTEGER (KIND=C_INT),PARAMETER ::  M2_M3M3_AUGER = 850
INTEGER (KIND=C_INT),PARAMETER ::  M2_M3M4_AUGER = 851
INTEGER (KIND=C_INT),PARAMETER ::  M2_M3M5_AUGER = 852
INTEGER (KIND=C_INT),PARAMETER ::  M2_M3N1_AUGER = 853
INTEGER (KIND=C_INT),PARAMETER ::  M2_M3N2_AUGER = 854
INTEGER (KIND=C_INT),PARAMETER ::  M2_M3N3_AUGER = 855
INTEGER (KIND=C_INT),PARAMETER ::  M2_M3N4_AUGER = 856
INTEGER (KIND=C_INT),PARAMETER ::  M2_M3N5_AUGER = 857
INTEGER (KIND=C_INT),PARAMETER ::  M2_M3N6_AUGER = 858
INTEGER (KIND=C_INT),PARAMETER ::  M2_M3N7_AUGER = 859
INTEGER (KIND=C_INT),PARAMETER ::  M2_M3O1_AUGER = 860
INTEGER (KIND=C_INT),PARAMETER ::  M2_M3O2_AUGER = 861
INTEGER (KIND=C_INT),PARAMETER ::  M2_M3O3_AUGER = 862
INTEGER (KIND=C_INT),PARAMETER ::  M2_M3O4_AUGER = 863
INTEGER (KIND=C_INT),PARAMETER ::  M2_M3O5_AUGER = 864
INTEGER (KIND=C_INT),PARAMETER ::  M2_M3O6_AUGER = 865
INTEGER (KIND=C_INT),PARAMETER ::  M2_M3O7_AUGER = 866
INTEGER (KIND=C_INT),PARAMETER ::  M2_M3P1_AUGER = 867
INTEGER (KIND=C_INT),PARAMETER ::  M2_M3P2_AUGER = 868
INTEGER (KIND=C_INT),PARAMETER ::  M2_M3P3_AUGER = 869
INTEGER (KIND=C_INT),PARAMETER ::  M2_M3P4_AUGER = 870
INTEGER (KIND=C_INT),PARAMETER ::  M2_M3P5_AUGER = 871
INTEGER (KIND=C_INT),PARAMETER ::  M2_M3Q1_AUGER = 872
INTEGER (KIND=C_INT),PARAMETER ::  M2_M3Q2_AUGER = 873
INTEGER (KIND=C_INT),PARAMETER ::  M2_M3Q3_AUGER = 874
INTEGER (KIND=C_INT),PARAMETER ::  M2_M4M3_AUGER = 875
INTEGER (KIND=C_INT),PARAMETER ::  M2_M4M4_AUGER = 876
INTEGER (KIND=C_INT),PARAMETER ::  M2_M4M5_AUGER = 877
INTEGER (KIND=C_INT),PARAMETER ::  M2_M4N1_AUGER = 878
INTEGER (KIND=C_INT),PARAMETER ::  M2_M4N2_AUGER = 879
INTEGER (KIND=C_INT),PARAMETER ::  M2_M4N3_AUGER = 880
INTEGER (KIND=C_INT),PARAMETER ::  M2_M4N4_AUGER = 881
INTEGER (KIND=C_INT),PARAMETER ::  M2_M4N5_AUGER = 882
INTEGER (KIND=C_INT),PARAMETER ::  M2_M4N6_AUGER = 883
INTEGER (KIND=C_INT),PARAMETER ::  M2_M4N7_AUGER = 884
INTEGER (KIND=C_INT),PARAMETER ::  M2_M4O1_AUGER = 885
INTEGER (KIND=C_INT),PARAMETER ::  M2_M4O2_AUGER = 886
INTEGER (KIND=C_INT),PARAMETER ::  M2_M4O3_AUGER = 887
INTEGER (KIND=C_INT),PARAMETER ::  M2_M4O4_AUGER = 888
INTEGER (KIND=C_INT),PARAMETER ::  M2_M4O5_AUGER = 889
INTEGER (KIND=C_INT),PARAMETER ::  M2_M4O6_AUGER = 890
INTEGER (KIND=C_INT),PARAMETER ::  M2_M4O7_AUGER = 891
INTEGER (KIND=C_INT),PARAMETER ::  M2_M4P1_AUGER = 892
INTEGER (KIND=C_INT),PARAMETER ::  M2_M4P2_AUGER = 893
INTEGER (KIND=C_INT),PARAMETER ::  M2_M4P3_AUGER = 894
INTEGER (KIND=C_INT),PARAMETER ::  M2_M4P4_AUGER = 895
INTEGER (KIND=C_INT),PARAMETER ::  M2_M4P5_AUGER = 896
INTEGER (KIND=C_INT),PARAMETER ::  M2_M4Q1_AUGER = 897
INTEGER (KIND=C_INT),PARAMETER ::  M2_M4Q2_AUGER = 898
INTEGER (KIND=C_INT),PARAMETER ::  M2_M4Q3_AUGER = 899
INTEGER (KIND=C_INT),PARAMETER ::  M2_M5M3_AUGER = 900
INTEGER (KIND=C_INT),PARAMETER ::  M2_M5M4_AUGER = 901
INTEGER (KIND=C_INT),PARAMETER ::  M2_M5M5_AUGER = 902
INTEGER (KIND=C_INT),PARAMETER ::  M2_M5N1_AUGER = 903
INTEGER (KIND=C_INT),PARAMETER ::  M2_M5N2_AUGER = 904
INTEGER (KIND=C_INT),PARAMETER ::  M2_M5N3_AUGER = 905
INTEGER (KIND=C_INT),PARAMETER ::  M2_M5N4_AUGER = 906
INTEGER (KIND=C_INT),PARAMETER ::  M2_M5N5_AUGER = 907
INTEGER (KIND=C_INT),PARAMETER ::  M2_M5N6_AUGER = 908
INTEGER (KIND=C_INT),PARAMETER ::  M2_M5N7_AUGER = 909
INTEGER (KIND=C_INT),PARAMETER ::  M2_M5O1_AUGER = 910
INTEGER (KIND=C_INT),PARAMETER ::  M2_M5O2_AUGER = 911
INTEGER (KIND=C_INT),PARAMETER ::  M2_M5O3_AUGER = 912
INTEGER (KIND=C_INT),PARAMETER ::  M2_M5O4_AUGER = 913
INTEGER (KIND=C_INT),PARAMETER ::  M2_M5O5_AUGER = 914
INTEGER (KIND=C_INT),PARAMETER ::  M2_M5O6_AUGER = 915
INTEGER (KIND=C_INT),PARAMETER ::  M2_M5O7_AUGER = 916
INTEGER (KIND=C_INT),PARAMETER ::  M2_M5P1_AUGER = 917
INTEGER (KIND=C_INT),PARAMETER ::  M2_M5P2_AUGER = 918
INTEGER (KIND=C_INT),PARAMETER ::  M2_M5P3_AUGER = 919
INTEGER (KIND=C_INT),PARAMETER ::  M2_M5P4_AUGER = 920
INTEGER (KIND=C_INT),PARAMETER ::  M2_M5P5_AUGER = 921
INTEGER (KIND=C_INT),PARAMETER ::  M2_M5Q1_AUGER = 922
INTEGER (KIND=C_INT),PARAMETER ::  M2_M5Q2_AUGER = 923
INTEGER (KIND=C_INT),PARAMETER ::  M2_M5Q3_AUGER = 924
INTEGER (KIND=C_INT),PARAMETER ::  M3_M4M4_AUGER = 925
INTEGER (KIND=C_INT),PARAMETER ::  M3_M4M5_AUGER = 926
INTEGER (KIND=C_INT),PARAMETER ::  M3_M4N1_AUGER = 927
INTEGER (KIND=C_INT),PARAMETER ::  M3_M4N2_AUGER = 928
INTEGER (KIND=C_INT),PARAMETER ::  M3_M4N3_AUGER = 929
INTEGER (KIND=C_INT),PARAMETER ::  M3_M4N4_AUGER = 930
INTEGER (KIND=C_INT),PARAMETER ::  M3_M4N5_AUGER = 931
INTEGER (KIND=C_INT),PARAMETER ::  M3_M4N6_AUGER = 932
INTEGER (KIND=C_INT),PARAMETER ::  M3_M4N7_AUGER = 933
INTEGER (KIND=C_INT),PARAMETER ::  M3_M4O1_AUGER = 934
INTEGER (KIND=C_INT),PARAMETER ::  M3_M4O2_AUGER = 935
INTEGER (KIND=C_INT),PARAMETER ::  M3_M4O3_AUGER = 936
INTEGER (KIND=C_INT),PARAMETER ::  M3_M4O4_AUGER = 937
INTEGER (KIND=C_INT),PARAMETER ::  M3_M4O5_AUGER = 938
INTEGER (KIND=C_INT),PARAMETER ::  M3_M4O6_AUGER = 939
INTEGER (KIND=C_INT),PARAMETER ::  M3_M4O7_AUGER = 940
INTEGER (KIND=C_INT),PARAMETER ::  M3_M4P1_AUGER = 941
INTEGER (KIND=C_INT),PARAMETER ::  M3_M4P2_AUGER = 942
INTEGER (KIND=C_INT),PARAMETER ::  M3_M4P3_AUGER = 943
INTEGER (KIND=C_INT),PARAMETER ::  M3_M4P4_AUGER = 944
INTEGER (KIND=C_INT),PARAMETER ::  M3_M4P5_AUGER = 945
INTEGER (KIND=C_INT),PARAMETER ::  M3_M4Q1_AUGER = 946
INTEGER (KIND=C_INT),PARAMETER ::  M3_M4Q2_AUGER = 947
INTEGER (KIND=C_INT),PARAMETER ::  M3_M4Q3_AUGER = 948
INTEGER (KIND=C_INT),PARAMETER ::  M3_M5M4_AUGER = 949
INTEGER (KIND=C_INT),PARAMETER ::  M3_M5M5_AUGER = 950
INTEGER (KIND=C_INT),PARAMETER ::  M3_M5N1_AUGER = 951
INTEGER (KIND=C_INT),PARAMETER ::  M3_M5N2_AUGER = 952
INTEGER (KIND=C_INT),PARAMETER ::  M3_M5N3_AUGER = 953
INTEGER (KIND=C_INT),PARAMETER ::  M3_M5N4_AUGER = 954
INTEGER (KIND=C_INT),PARAMETER ::  M3_M5N5_AUGER = 955
INTEGER (KIND=C_INT),PARAMETER ::  M3_M5N6_AUGER = 956
INTEGER (KIND=C_INT),PARAMETER ::  M3_M5N7_AUGER = 957
INTEGER (KIND=C_INT),PARAMETER ::  M3_M5O1_AUGER = 958
INTEGER (KIND=C_INT),PARAMETER ::  M3_M5O2_AUGER = 959
INTEGER (KIND=C_INT),PARAMETER ::  M3_M5O3_AUGER = 960
INTEGER (KIND=C_INT),PARAMETER ::  M3_M5O4_AUGER = 961
INTEGER (KIND=C_INT),PARAMETER ::  M3_M5O5_AUGER = 962
INTEGER (KIND=C_INT),PARAMETER ::  M3_M5O6_AUGER = 963
INTEGER (KIND=C_INT),PARAMETER ::  M3_M5O7_AUGER = 964
INTEGER (KIND=C_INT),PARAMETER ::  M3_M5P1_AUGER = 965
INTEGER (KIND=C_INT),PARAMETER ::  M3_M5P2_AUGER = 966
INTEGER (KIND=C_INT),PARAMETER ::  M3_M5P3_AUGER = 967
INTEGER (KIND=C_INT),PARAMETER ::  M3_M5P4_AUGER = 968
INTEGER (KIND=C_INT),PARAMETER ::  M3_M5P5_AUGER = 969
INTEGER (KIND=C_INT),PARAMETER ::  M3_M5Q1_AUGER = 970
INTEGER (KIND=C_INT),PARAMETER ::  M3_M5Q2_AUGER = 971
INTEGER (KIND=C_INT),PARAMETER ::  M3_M5Q3_AUGER = 972
INTEGER (KIND=C_INT),PARAMETER ::  M4_M5M5_AUGER = 973
INTEGER (KIND=C_INT),PARAMETER ::  M4_M5N1_AUGER = 974
INTEGER (KIND=C_INT),PARAMETER ::  M4_M5N2_AUGER = 975
INTEGER (KIND=C_INT),PARAMETER ::  M4_M5N3_AUGER = 976
INTEGER (KIND=C_INT),PARAMETER ::  M4_M5N4_AUGER = 977
INTEGER (KIND=C_INT),PARAMETER ::  M4_M5N5_AUGER = 978
INTEGER (KIND=C_INT),PARAMETER ::  M4_M5N6_AUGER = 979
INTEGER (KIND=C_INT),PARAMETER ::  M4_M5N7_AUGER = 980
INTEGER (KIND=C_INT),PARAMETER ::  M4_M5O1_AUGER = 981
INTEGER (KIND=C_INT),PARAMETER ::  M4_M5O2_AUGER = 982
INTEGER (KIND=C_INT),PARAMETER ::  M4_M5O3_AUGER = 983
INTEGER (KIND=C_INT),PARAMETER ::  M4_M5O4_AUGER = 984
INTEGER (KIND=C_INT),PARAMETER ::  M4_M5O5_AUGER = 985
INTEGER (KIND=C_INT),PARAMETER ::  M4_M5O6_AUGER = 986
INTEGER (KIND=C_INT),PARAMETER ::  M4_M5O7_AUGER = 987
INTEGER (KIND=C_INT),PARAMETER ::  M4_M5P1_AUGER = 988
INTEGER (KIND=C_INT),PARAMETER ::  M4_M5P2_AUGER = 989
INTEGER (KIND=C_INT),PARAMETER ::  M4_M5P3_AUGER = 990
INTEGER (KIND=C_INT),PARAMETER ::  M4_M5P4_AUGER = 991
INTEGER (KIND=C_INT),PARAMETER ::  M4_M5P5_AUGER = 992
INTEGER (KIND=C_INT),PARAMETER ::  M4_M5Q1_AUGER = 993
INTEGER (KIND=C_INT),PARAMETER ::  M4_M5Q2_AUGER = 994
INTEGER (KIND=C_INT),PARAMETER ::  M4_M5Q3_AUGER = 995

INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_A_150_TISSUE_EQUIVALENT_PLASTIC = 0
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_ACETONE = 1
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_ACETYLENE = 2
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_ADENINE = 3
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_ADIPOSE_TISSUE_ICRP = 4
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_AIR_DRY_NEAR_SEA_LEVEL = 5
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_ALANINE = 6
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_ALUMINUM_OXIDE = 7
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_AMBER = 8
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_AMMONIA = 9
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_ANILINE = 10
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_ANTHRACENE = 11
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_B_100_BONE_EQUIVALENT_PLASTIC = 12
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_BAKELITE = 13
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_BARIUM_FLUORIDE = 14
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_BARIUM_SULFATE = 15
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_BENZENE = 16
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_BERYLLIUM_OXIDE = 17
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_BISMUTH_GERMANIUM_OXIDE = 18
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_BLOOD_ICRP = 19
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_BONE_COMPACT_ICRU = 20
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_BONE_CORTICAL_ICRP = 21
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_BORON_CARBIDE = 22
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_BORON_OXIDE = 23
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_BRAIN_ICRP = 24
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_BUTANE = 25
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_N_BUTYL_ALCOHOL = 26
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_C_552_AIR_EQUIVALENT_PLASTIC = 27
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_CADMIUM_TELLURIDE = 28
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_CADMIUM_TUNGSTATE = 29
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_CALCIUM_CARBONATE = 30
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_CALCIUM_FLUORIDE = 31
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_CALCIUM_OXIDE = 32
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_CALCIUM_SULFATE = 33
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_CALCIUM_TUNGSTATE = 34
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_CARBON_DIOXIDE = 35
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_CARBON_TETRACHLORIDE = 36
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_CELLULOSE_ACETATE_CELLOPHANE = 37
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_CELLULOSE_ACETATE_BUTYRATE = 38
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_CELLULOSE_NITRATE = 39
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_CERIC_SULFATE_DOSIMETER_SOLUTION = 40
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_CESIUM_FLUORIDE = 41
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_CESIUM_IODIDE = 42
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_CHLOROBENZENE = 43
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_CHLOROFORM = 44
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_CONCRETE_PORTLAND = 45
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_CYCLOHEXANE = 46
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_12_DDIHLOROBENZENE = 47
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_DICHLORODIETHYL_ETHER = 48
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_12_DICHLOROETHANE = 49
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_DIETHYL_ETHER = 50
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_NN_DIMETHYL_FORMAMIDE = 51
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_DIMETHYL_SULFOXIDE = 52
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_ETHANE = 53
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_ETHYL_ALCOHOL = 54
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_ETHYL_CELLULOSE = 55
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_ETHYLENE = 56
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_EYE_LENS_ICRP = 57
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_FERRIC_OXIDE = 58
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_FERROBORIDE = 59
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_FERROUS_OXIDE = 60
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_FERROUS_SULFATE_DOSIMETER_SOLUTION = 61
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_FREON_12 = 62
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_FREON_12B2 = 63
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_FREON_13 = 64
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_FREON_13B1 = 65
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_FREON_13I1 = 66
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_GADOLINIUM_OXYSULFIDE = 67
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_GALLIUM_ARSENIDE = 68
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_GEL_IN_PHOTOGRAPHIC_EMULSION = 69
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_GLASS_PYREX = 70
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_GLASS_LEAD = 71
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_GLASS_PLATE = 72
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_GLUCOSE = 73
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_GLUTAMINE = 74
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_GLYCEROL = 75
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_GUANINE = 76
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_GYPSUM_PLASTER_OF_PARIS = 77
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_N_HEPTANE = 78
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_N_HEXANE = 79
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_KAPTON_POLYIMIDE_FILM = 80
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_LANTHANUM_OXYBROMIDE = 81
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_LANTHANUM_OXYSULFIDE = 82
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_LEAD_OXIDE = 83
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_LITHIUM_AMIDE = 84
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_LITHIUM_CARBONATE = 85
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_LITHIUM_FLUORIDE = 86
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_LITHIUM_HYDRIDE = 87
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_LITHIUM_IODIDE = 88
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_LITHIUM_OXIDE = 89
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_LITHIUM_TETRABORATE = 90
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_LUNG_ICRP = 91
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_M3_WAX = 92
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_MAGNESIUM_CARBONATE = 93
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_MAGNESIUM_FLUORIDE = 94
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_MAGNESIUM_OXIDE = 95
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_MAGNESIUM_TETRABORATE = 96
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_MERCURIC_IODIDE = 97
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_METHANE = 98
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_METHANOL = 99
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_MIX_D_WAX = 100
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_MS20_TISSUE_SUBSTITUTE = 101
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_MUSCLE_SKELETAL = 102
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_MUSCLE_STRIATED = 103
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_MUSCLE_EQUIVALENT_LIQUID_WITH_SUCROSE = 104
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_MUSCLE_EQUIVALENT_LIQUID_WITHOUT_SUCROSE = 105
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_NAPHTHALENE = 106
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_NITROBENZENE = 107
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_NITROUS_OXIDE = 108
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_NYLON_DU_PONT_ELVAMIDE_8062 = 109
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_NYLON_TYPE_6_AND_TYPE_66 = 110
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_NYLON_TYPE_610 = 111
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_NYLON_TYPE_11_RILSAN = 112
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_OCTANE_LIQUID = 113
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_PARAFFIN_WAX = 114
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_N_PENTANE = 115
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_PHOTOGRAPHIC_EMULSION = 116
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_PLASTIC_SCINTILLATOR_VINYLTOLUENE_BASED = 117
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_PLUTONIUM_DIOXIDE = 118
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_POLYACRYLONITRILE = 119
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_POLYCARBONATE_MAKROLON_LEXAN = 120
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_POLYCHLOROSTYRENE = 121
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_POLYETHYLENE = 122
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_POLYETHYLENE_TEREPHTHALATE_MYLAR = 123
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_POLYMETHYL_METHACRALATE_LUCITE_PERSPEX = 124
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_POLYOXYMETHYLENE = 125
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_POLYPROPYLENE = 126
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_POLYSTYRENE = 127
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_POLYTETRAFLUOROETHYLENE_TEFLON = 128
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_POLYTRIFLUOROCHLOROETHYLENE = 129
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_POLYVINYL_ACETATE = 130
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_POLYVINYL_ALCOHOL = 131
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_POLYVINYL_BUTYRAL = 132
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_POLYVINYL_CHLORIDE = 133
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_POLYVINYLIDENE_CHLORIDE_SARAN = 134
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_POLYVINYLIDENE_FLUORIDE = 135
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_POLYVINYL_PYRROLIDONE = 136
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_POTASSIUM_IODIDE = 137
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_POTASSIUM_OXIDE = 138
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_PROPANE = 139
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_PROPANE_LIQUID = 140
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_N_PROPYL_ALCOHOL = 141
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_PYRIDINE = 142
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_RUBBER_BUTYL = 143
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_RUBBER_NATURAL = 144
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_RUBBER_NEOPRENE = 145
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_SILICON_DIOXIDE = 146
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_SILVER_BROMIDE = 147
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_SILVER_CHLORIDE = 148
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_SILVER_HALIDES_IN_PHOTOGRAPHIC_EMULSION = 149
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_SILVER_IODIDE = 150
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_SKIN_ICRP = 151
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_SODIUM_CARBONATE = 152
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_SODIUM_IODIDE = 153
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_SODIUM_MONOXIDE = 154
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_SODIUM_NITRATE = 155
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_STILBENE = 156
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_SUCROSE = 157
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_TERPHENYL = 158
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_TESTES_ICRP = 159
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_TETRACHLOROETHYLENE = 160
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_THALLIUM_CHLORIDE = 161
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_TISSUE_SOFT_ICRP = 162
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_TISSUE_SOFT_ICRU_FOUR_COMPONENT = 163
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_TISSUE_EQUIVALENT_GAS_METHANE_BASED = 164
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_TISSUE_EQUIVALENT_GAS_PROPANE_BASED = 165
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_TITANIUM_DIOXIDE = 166
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_TOLUENE = 167
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_TRICHLOROETHYLENE = 168
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_TRIETHYL_PHOSPHATE = 169
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_TUNGSTEN_HEXAFLUORIDE = 170
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_URANIUM_DICARBIDE = 171
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_URANIUM_MONOCARBIDE = 172
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_URANIUM_OXIDE = 173
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_UREA = 174
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_VALINE = 175
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_VITON_FLUOROELASTOMER = 176
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_WATER_LIQUID = 177
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_WATER_VAPOR = 178
INTEGER (KIND=C_INT),PARAMETER ::  NIST_COMPOUND_XYLENE = 179

INTEGER (KIND=C_INT),PARAMETER ::  RADIO_NUCLIDE_55FE = 0
INTEGER (KIND=C_INT),PARAMETER ::  RADIO_NUCLIDE_57CO = 1
INTEGER (KIND=C_INT),PARAMETER ::  RADIO_NUCLIDE_109CD = 2
INTEGER (KIND=C_INT),PARAMETER ::  RADIO_NUCLIDE_125I = 3
INTEGER (KIND=C_INT),PARAMETER ::  RADIO_NUCLIDE_137CS = 4
INTEGER (KIND=C_INT),PARAMETER ::  RADIO_NUCLIDE_133BA = 5
INTEGER (KIND=C_INT),PARAMETER ::  RADIO_NUCLIDE_153GD = 6
INTEGER (KIND=C_INT),PARAMETER ::  RADIO_NUCLIDE_238PU = 7
INTEGER (KIND=C_INT),PARAMETER ::  RADIO_NUCLIDE_241AM = 8
INTEGER (KIND=C_INT),PARAMETER ::  RADIO_NUCLIDE_244CM = 9




INTERFACE
!All procedures are pure

        !Initialization
        SUBROUTINE XRayInit() BIND(C,NAME='XRayInit')
        ENDSUBROUTINE XRayInit

        !Error handling
        SUBROUTINE SetHardExit(hard_exit) BIND(C,NAME='SetHardExit')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                INTEGER (KIND=C_INT),INTENT(IN),VALUE :: hard_exit
        ENDSUBROUTINE SetHardExit

        SUBROUTINE SetExitStatus(exit_status) BIND(C,NAME='SetExitStatus')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                INTEGER (KIND=C_INT),INTENT(IN),VALUE :: exit_status
        ENDSUBROUTINE SetExitStatus

        FUNCTION GetExitStatus() BIND(C,NAME='GetExitStatus')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                INTEGER (KIND=C_INT) :: GetExitStatus
        ENDFUNCTION

        SUBROUTINE SetErrorMessages(status) BIND(C,NAME='SetErrorMessages')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                INTEGER (KIND=C_INT),INTENT(IN),VALUE :: status
        ENDSUBROUTINE SetErrorMessages

        FUNCTION GetErrorMessages() BIND(C,NAME='GetErrorMessages')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                INTEGER (KIND=C_INT) :: GetErrorMessages
        ENDFUNCTION



        !Atomic Weights
        PURE FUNCTION AtomicWeight(Z) BIND(C,NAME='AtomicWeight')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: AtomicWeight
                INTEGER (KIND=C_INT),INTENT(IN),VALUE :: Z
        END FUNCTION AtomicWeight

        !Element densities
        PURE FUNCTION ElementDensity(Z) BIND(C,NAME='ElementDensity')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: ElementDensity
                INTEGER (KIND=C_INT),INTENT(IN),VALUE :: Z
        END FUNCTION ElementDensity

        !Cross sections (cm2/g)
        PURE FUNCTION CS_Total(Z,E) BIND(C,NAME='CS_Total')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: CS_Total
                INTEGER (KIND=C_INT),INTENT(IN),VALUE :: Z
                REAL (KIND=C_DOUBLE), INTENT(IN),VALUE :: E
        END FUNCTION CS_Total

        PURE FUNCTION CS_Photo(Z,E) BIND(C,NAME='CS_Photo')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: CS_Photo
                INTEGER (KIND=C_INT),INTENT(IN),VALUE :: Z
                REAL (C_DOUBLE),INTENT(IN),VALUE :: E
        END FUNCTION CS_Photo

        PURE FUNCTION CS_Rayl(Z,E) BIND(C,NAME='CS_Rayl')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: CS_Rayl
                INTEGER (KIND=C_INT),INTENT(IN),VALUE :: Z
                REAL (KIND=C_DOUBLE),INTENT(IN),VALUE :: E
        END FUNCTION CS_Rayl

        PURE FUNCTION CS_Compt(Z,E) BIND(C,NAME='CS_Compt')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: CS_Compt
                INTEGER (KIND=C_INT),INTENT(IN),VALUE :: Z
                REAL (KIND=C_DOUBLE),INTENT(IN),VALUE :: E
        END FUNCTION CS_Compt

        PURE FUNCTION CS_Energy(Z,E) BIND(C,NAME='CS_Energy')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: CS_Energy
                INTEGER (KIND=C_INT),INTENT(IN),VALUE :: Z
                REAL (KIND=C_DOUBLE),INTENT(IN),VALUE :: E
        END FUNCTION CS_Energy

        PURE FUNCTION CS_KN(E) BIND(C,NAME='CS_KN')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: CS_KN
                REAL (KIND=C_DOUBLE),INTENT(IN),VALUE :: E
        END FUNCTION CS_KN

        !Cross sections (barn/atom)
        PURE FUNCTION CSb_Total(Z,E) BIND(C,NAME='CSb_Total')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: CSb_Total
                INTEGER (KIND=C_INT),INTENT(IN),VALUE :: Z
                REAL (KIND=C_DOUBLE), INTENT(IN),VALUE :: E
        END FUNCTION CSb_Total

        PURE FUNCTION CSb_Photo(Z,E) BIND(C,NAME='CSb_Photo')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: CSb_Photo
                INTEGER (KIND=C_INT),INTENT(IN),VALUE :: Z
                REAL (C_DOUBLE),INTENT(IN),VALUE :: E
        END FUNCTION CSb_Photo

        PURE FUNCTION CSb_Rayl(Z,E) BIND(C,NAME='CSb_Rayl')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: CSb_Rayl
                INTEGER (KIND=C_INT),INTENT(IN),VALUE :: Z
                REAL (KIND=C_DOUBLE),INTENT(IN),VALUE :: E
        END FUNCTION CSb_Rayl

        PURE FUNCTION CSb_Compt(Z,E) BIND(C,NAME='CSb_Compt')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: CSb_Compt
                INTEGER (KIND=C_INT),INTENT(IN),VALUE :: Z
                REAL (KIND=C_DOUBLE),INTENT(IN),VALUE :: E
        END FUNCTION CSb_Compt

        !Unpolarized differential scattering cross sections
        PURE FUNCTION DCS_Thoms(theta) BIND(C,NAME='DCS_Thoms')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: DCS_Thoms
                REAL (KIND=C_DOUBLE),INTENT(IN),VALUE :: theta
        ENDFUNCTION DCS_Thoms

        PURE FUNCTION DCS_KN(E ,theta) BIND(C,NAME='DCS_KN')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: DCS_KN
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E, theta
        ENDFUNCTION DCS_KN

        PURE FUNCTION DCS_Rayl(Z ,E ,theta) BIND(C,NAME='DCS_Rayl')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: DCS_Rayl
                INTEGER (KIND=C_INT), INTENT(IN),VALUE :: Z
                REAL (KIND=C_DOUBLE), INTENT(IN),VALUE :: E,theta
        ENDFUNCTION DCS_Rayl

        PURE FUNCTION DCS_Compt(Z ,E ,theta) BIND(C,NAME='DCS_Compt')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: DCS_Compt
                INTEGER (KIND=C_INT), INTENT(IN),VALUE :: Z
                REAL (KIND=C_DOUBLE), INTENT(IN),VALUE :: E,theta
        ENDFUNCTION DCS_Compt

        PURE FUNCTION DCSb_Rayl(Z ,E ,theta) BIND(C,NAME='DCSb_Rayl')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: DCSb_Rayl
                INTEGER (KIND=C_INT), INTENT(IN),VALUE :: Z
                REAL (KIND=C_DOUBLE), INTENT(IN),VALUE :: E,theta
        ENDFUNCTION DCSb_Rayl

        PURE FUNCTION DCSb_Compt(Z ,E ,theta) BIND(C,NAME='DCSb_Compt')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: DCSb_Compt
                INTEGER (KIND=C_INT), INTENT(IN),VALUE :: Z
                REAL (KIND=C_DOUBLE), INTENT(IN),VALUE :: E,theta
        ENDFUNCTION DCSb_Compt

        !Polarized differential scattering cross sections
        PURE FUNCTION DCSP_Thoms(theta, phi) BIND(C,NAME='DCSP_Thoms')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: DCSP_Thoms
                REAL (KIND=C_DOUBLE), INTENT(IN),VALUE :: theta, phi
        ENDFUNCTION DCSP_Thoms

        PURE FUNCTION DCSP_KN(E, theta, phi) BIND(C,NAME='DCSP_KN')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: DCSP_KN
                REAL (KIND=C_DOUBLE), INTENT(IN),VALUE :: E, theta, phi
        ENDFUNCTION DCSP_KN

        PURE FUNCTION DCSP_Rayl(Z, E, theta, phi) BIND(C,NAME='DCSP_Rayl')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: DCSP_Rayl
                INTEGER (KIND=C_INT), INTENT(IN),VALUE :: Z
                REAL (KIND=C_DOUBLE), INTENT(IN),VALUE :: E, theta, phi
        ENDFUNCTION DCSP_Rayl

        PURE FUNCTION DCSP_Compt(Z, E, theta, phi) BIND(C,NAME='DCSP_Compt')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: DCSP_Compt
                INTEGER (KIND=C_INT), INTENT(IN),VALUE :: Z
                REAL (KIND=C_DOUBLE), INTENT(IN),VALUE :: E, theta, phi
        ENDFUNCTION DCSP_Compt

        PURE FUNCTION DCSPb_Rayl(Z, E, theta, phi) BIND(C,NAME='DCSPb_Rayl')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: DCSPb_Rayl
                INTEGER (KIND=C_INT), INTENT(IN),VALUE :: Z
                REAL (KIND=C_DOUBLE), INTENT(IN),VALUE :: E, theta, phi
        ENDFUNCTION DCSPb_Rayl

        PURE FUNCTION DCSPb_Compt(Z, E, theta, phi) BIND(C,NAME='DCSPb_Compt')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: DCSPb_Compt
                INTEGER (KIND=C_INT), INTENT(IN),VALUE :: Z
                REAL (KIND=C_DOUBLE), INTENT(IN),VALUE :: E, theta, phi
        ENDFUNCTION DCSPb_Compt

        !Scattering factors
        PURE FUNCTION FF_Rayl(Z , q) BIND(C,NAME='FF_Rayl')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: FF_Rayl
                INTEGER (KIND=C_INT), INTENT(IN), VALUE :: Z
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: q
        ENDFUNCTION FF_Rayl

        PURE FUNCTION SF_Compt(Z , q) BIND(C,NAME='SF_Compt')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: SF_Compt
                INTEGER (KIND=C_INT), INTENT(IN), VALUE :: Z
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: q
        ENDFUNCTION SF_Compt

        PURE FUNCTION MomentTransf(E , theta) BIND(C,NAME='MomentTransf')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: MomentTransf
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E , theta
        ENDFUNCTION

        !X-ray fluorescent line energy
        PURE FUNCTION LineEnergy(Z,line) BIND(C,NAME='LineEnergy')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: LineEnergy
                INTEGER (KIND=C_INT),INTENT(IN),VALUE :: Z,line
        END FUNCTION LineEnergy

        !Fluorescence yield
        PURE FUNCTION FluorYield(Z,shell) BIND(C,NAME='FluorYield')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: FluorYield
                INTEGER (KIND=C_INT),INTENT(IN),VALUE ::Z,shell
        END FUNCTION FluorYield

        !Coster-Kronig transition probability
        PURE FUNCTION CosKronTransProb(Z,trans) &
                BIND(C,NAME='CosKronTransProb')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: CosKronTransProb
                INTEGER (KIND=C_INT),INTENT(IN),VALUE ::Z,trans
        END FUNCTION CosKronTransProb

        !Absorption-edge energies
        PURE FUNCTION EdgeEnergy(Z,shell) BIND(C,NAME='EdgeEnergy')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: EdgeEnergy
                INTEGER (KIND=C_INT),INTENT(IN),VALUE ::Z,shell
        END FUNCTION EdgeEnergy

        !Jump ratios
        PURE FUNCTION JumpFactor(Z,shell) BIND(C,NAME='JumpFactor')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: JumpFactor
                INTEGER (KIND=C_INT),INTENT(IN),VALUE ::Z,shell
        END FUNCTION JumpFactor

        !Fluorescent-lines cross sections
        PURE FUNCTION CS_FluorLine(Z,line,E) BIND(C,NAME='CS_FluorLine')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: CS_FluorLine
                INTEGER (KIND=C_INT),INTENT(IN),VALUE :: Z,line
                REAL (KIND=C_DOUBLE), INTENT(IN),VALUE :: E
        END FUNCTION CS_FluorLine

        PURE FUNCTION CSb_FluorLine(Z,line,E) &
                BIND(C,NAME='CSb_FluorLine')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: CSb_FluorLine
                INTEGER (KIND=C_INT),INTENT(IN),VALUE :: Z,line
                REAL (KIND=C_DOUBLE), INTENT(IN),VALUE :: E
        END FUNCTION CSb_FluorLine

        !Fractional radiative rate
        PURE FUNCTION RadRate(Z, line) BIND (C,NAME='RadRate')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: RadRate
                INTEGER (KIND=C_INT), INTENT(IN), VALUE :: Z , line
        ENDFUNCTION RadRate

        !Photon energy after Compton scattering
        PURE FUNCTION ComptonEnergy(E0 , theta) BIND(C,NAME='ComptonEnergy')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: ComptonEnergy
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E0 , theta
        ENDFUNCTION ComptonEnergy

        !Anomalous Scattering Factors
        PURE FUNCTION Fi (Z , E) BIND(C, NAME='Fi')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: Fi
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E
                INTEGER (KIND=C_INT),INTENT(IN), VALUE :: Z
        ENDFUNCTION Fi

        PURE FUNCTION Fii (Z , E) BIND(C, NAME='Fii')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: Fii
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E
                INTEGER (KIND=C_INT),INTENT(IN), VALUE :: Z
        ENDFUNCTION Fii

        !Kissel photoelectric cross sections
        PURE FUNCTION CS_Photo_Total (Z, E) BIND(C, NAME='CS_Photo_Total')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: CS_Photo_Total
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E
                INTEGER (KIND=C_INT),INTENT(IN), VALUE :: Z
        ENDFUNCTION CS_Photo_Total

        PURE FUNCTION CSb_Photo_Total (Z, E) BIND(C, NAME='CSb_Photo_Total')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: CSb_Photo_Total
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E
                INTEGER (KIND=C_INT),INTENT(IN), VALUE :: Z
        ENDFUNCTION CSb_Photo_Total

        PURE FUNCTION CS_Photo_Partial (Z,shell, E) &
                BIND(C, NAME='CS_Photo_Partial')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: CS_Photo_Partial
                INTEGER (KIND=C_INT), INTENT(IN), VALUE :: shell, Z
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E
        ENDFUNCTION CS_Photo_Partial

        PURE FUNCTION CSb_Photo_Partial (Z,shell, E) &
                BIND(C, NAME='CSb_Photo_Partial')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: CSb_Photo_Partial
                INTEGER (KIND=C_INT), INTENT(IN), VALUE :: Z, shell
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E
        ENDFUNCTION CSb_Photo_Partial

        PURE FUNCTION CS_Total_Kissel (Z, E) BIND(C, NAME='CS_Total_Kissel')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: CS_Total_Kissel
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E
                INTEGER (KIND=C_INT),INTENT(IN), VALUE :: Z
        ENDFUNCTION CS_Total_Kissel

        PURE FUNCTION CSb_Total_Kissel (Z, E) BIND(C, NAME='CSb_Total_Kissel')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: CSb_Total_Kissel
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E
                INTEGER (KIND=C_INT),INTENT(IN), VALUE :: Z
        ENDFUNCTION CSb_Total_Kissel

        FUNCTION CompoundParser_C(compoundString) BIND(C,NAME='CompoundParser')&
        RESULT(rv)
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                TYPE (C_PTR), INTENT(IN), VALUE :: compoundString
                TYPE (C_PTR) :: rv
        ENDFUNCTION CompoundParser_C
        !compound parser based functions
        PURE FUNCTION CS_Total_CP_C(compound,E) BIND(C,NAME='CS_Total_CP')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                TYPE (C_PTR), VALUE, INTENT(IN) :: compound
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E
                REAL (KIND=C_DOUBLE) :: CS_Total_CP_C
        ENDFUNCTION CS_Total_CP_C

        PURE FUNCTION CS_Photo_CP_C(compound,E) BIND(C,NAME='CS_Photo_CP')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                TYPE (C_PTR), VALUE, INTENT(IN) :: compound
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E
                REAL (KIND=C_DOUBLE) :: CS_Photo_CP_C
        ENDFUNCTION CS_Photo_CP_C

        PURE FUNCTION CS_Rayl_CP_C(compound,E) BIND(C,NAME='CS_Rayl_CP')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                TYPE (C_PTR), VALUE, INTENT(IN) :: compound
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E
                REAL (KIND=C_DOUBLE) :: CS_Rayl_CP_C
        ENDFUNCTION CS_Rayl_CP_C

        PURE FUNCTION CS_Compt_CP_C(compound,E) BIND(C,NAME='CS_Compt_CP')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                TYPE (C_PTR), VALUE, INTENT(IN) :: compound
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E
                REAL (KIND=C_DOUBLE) :: CS_Compt_CP_C
        ENDFUNCTION CS_Compt_CP_C

        PURE FUNCTION CS_Energy_CP_C(compound,E) BIND(C,NAME='CS_Energy_CP')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                TYPE (C_PTR), VALUE, INTENT(IN) :: compound
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E
                REAL (KIND=C_DOUBLE) :: CS_Energy_CP_C
        ENDFUNCTION CS_Energy_CP_C

        PURE FUNCTION CSb_Total_CP_C(compound,E) BIND(C,NAME='CSb_Total_CP')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                TYPE (C_PTR), VALUE, INTENT(IN) :: compound
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E
                REAL (KIND=C_DOUBLE) :: CSb_Total_CP_C
        ENDFUNCTION CSb_Total_CP_C

        PURE FUNCTION CSb_Photo_CP_C(compound,E) BIND(C,NAME='CSb_Photo_CP')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                TYPE (C_PTR), VALUE, INTENT(IN) :: compound
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E
                REAL (KIND=C_DOUBLE) :: CSb_Photo_CP_C
        ENDFUNCTION CSb_Photo_CP_C

        PURE FUNCTION CSb_Rayl_CP_C(compound,E) BIND(C,NAME='CSb_Rayl_CP')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                TYPE (C_PTR), VALUE, INTENT(IN) :: compound
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E
                REAL (KIND=C_DOUBLE) :: CSb_Rayl_CP_C
        ENDFUNCTION CSb_Rayl_CP_C

        PURE FUNCTION CSb_Compt_CP_C(compound,E) BIND(C,NAME='CSb_Compt_CP')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                TYPE (C_PTR), VALUE, INTENT(IN) :: compound
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E
                REAL (KIND=C_DOUBLE) :: CSb_Compt_CP_C
        ENDFUNCTION CSb_Compt_CP_C

        PURE FUNCTION DCS_Rayl_CP_C(compound,E,theta) BIND(C,NAME='DCS_Rayl_CP')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                TYPE (C_PTR), VALUE, INTENT(IN) :: compound
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E,theta
                REAL (KIND=C_DOUBLE) :: DCS_Rayl_CP_C
        ENDFUNCTION DCS_Rayl_CP_C

        PURE FUNCTION DCS_Compt_CP_C(compound,E,theta) BIND(C,NAME='DCS_Compt_CP')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                TYPE (C_PTR), VALUE, INTENT(IN) :: compound
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E,theta
                REAL (KIND=C_DOUBLE) :: DCS_Compt_CP_C
        ENDFUNCTION DCS_Compt_CP_C

        PURE FUNCTION DCSb_Rayl_CP_C(compound,E,theta) BIND(C,NAME='DCSb_Rayl_CP')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                TYPE (C_PTR), VALUE, INTENT(IN) :: compound
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E,theta
                REAL (KIND=C_DOUBLE) :: DCSb_Rayl_CP_C
        ENDFUNCTION DCSb_Rayl_CP_C

        PURE FUNCTION DCSb_Compt_CP_C(compound,E,theta) BIND(C,NAME='DCSb_Compt_CP')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                TYPE (C_PTR), VALUE, INTENT(IN) :: compound
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E,theta
                REAL (KIND=C_DOUBLE) :: DCSb_Compt_CP_C
        ENDFUNCTION DCSb_Compt_CP_C

        PURE FUNCTION DCSP_Rayl_CP_C(compound,E,theta,phi) BIND(C,NAME='DCSP_Rayl_CP')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                TYPE (C_PTR), VALUE, INTENT(IN) :: compound
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E,theta,phi
                REAL (KIND=C_DOUBLE) :: DCSP_Rayl_CP_C
        ENDFUNCTION DCSP_Rayl_CP_C

        PURE FUNCTION DCSP_Compt_CP_C(compound,E,theta,phi) BIND(C,NAME='DCSP_Compt_CP')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                TYPE (C_PTR), VALUE, INTENT(IN) :: compound
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E,theta,phi
                REAL (KIND=C_DOUBLE) :: DCSP_Compt_CP_C
        ENDFUNCTION DCSP_Compt_CP_C

        PURE FUNCTION DCSPb_Rayl_CP_C(compound,E,theta,phi) BIND(C,NAME='DCSPb_Rayl_CP')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                TYPE (C_PTR), VALUE, INTENT(IN) :: compound
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E,theta,phi
                REAL (KIND=C_DOUBLE) :: DCSPb_Rayl_CP_C
        ENDFUNCTION DCSPb_Rayl_CP_C

        PURE FUNCTION DCSPb_Compt_CP_C(compound,E,theta,phi) BIND(C,NAME='DCSPb_Compt_CP')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                TYPE (C_PTR), VALUE, INTENT(IN) :: compound
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E,theta,phi
                REAL (KIND=C_DOUBLE) :: DCSPb_Compt_CP_C
        ENDFUNCTION DCSPb_Compt_CP_C

        PURE FUNCTION CS_Photo_Total_CP_C(compound,E) BIND(C,NAME='CS_Photo_Total_CP')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                TYPE (C_PTR), VALUE, INTENT(IN) :: compound
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E
                REAL (KIND=C_DOUBLE) :: CS_Photo_Total_CP_C
        ENDFUNCTION CS_Photo_Total_CP_C

        PURE FUNCTION CSb_Photo_Total_CP_C(compound,E) BIND(C,NAME='CSb_Photo_Total_CP')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                TYPE (C_PTR), VALUE, INTENT(IN) :: compound
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E
                REAL (KIND=C_DOUBLE) :: CSb_Photo_Total_CP_C
        ENDFUNCTION CSb_Photo_Total_CP_C

        PURE FUNCTION CS_Total_Kissel_CP_C(compound,E) BIND(C,NAME='CS_Total_Kissel_CP')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                TYPE (C_PTR), VALUE, INTENT(IN) :: compound
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E
                REAL (KIND=C_DOUBLE) :: CS_Total_Kissel_CP_C
        ENDFUNCTION CS_Total_Kissel_CP_C

        PURE FUNCTION CSb_Total_Kissel_CP_C(compound,E) BIND(C,NAME='CSb_Total_Kissel_CP')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                TYPE (C_PTR), VALUE, INTENT(IN) :: compound
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E
                REAL (KIND=C_DOUBLE) :: CSb_Total_Kissel_CP_C
        ENDFUNCTION CSb_Total_Kissel_CP_C

        PURE FUNCTION Refractive_Index_Re_C(compound,E,density) BIND(C,NAME='Refractive_Index_Re')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                TYPE (C_PTR), INTENT(IN), VALUE :: compound
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E, density
                REAL (KIND=C_DOUBLE) :: Refractive_Index_Re_C
        ENDFUNCTION Refractive_Index_Re_C

        PURE FUNCTION Refractive_Index_Im_C(compound,E,density) BIND(C,NAME='Refractive_Index_Im')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                TYPE (C_PTR), INTENT(IN), VALUE :: compound
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E, density
                REAL (KIND=C_DOUBLE) :: Refractive_Index_Im_C
        ENDFUNCTION Refractive_Index_Im_C

        PURE FUNCTION Refractive_Index_C(compound,E,density) BIND(C,NAME='Refractive_Index')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPORT :: xrlComplex_C
                IMPLICIT NONE
                TYPE (C_PTR), INTENT(IN), VALUE :: compound
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E, density
                TYPE (xrlComplex_C) :: Refractive_Index_C
        ENDFUNCTION Refractive_Index_C

        PURE FUNCTION ComptonProfile(Z, pz) BIND(C,NAME='ComptonProfile')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                INTEGER (KIND=C_INT), INTENT(IN), VALUE :: Z
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: pz
                REAL (KIND=C_DOUBLE) :: ComptonProfile
        ENDFUNCTION ComptonProfile

        PURE FUNCTION ComptonProfile_Partial(Z, shell, pz) BIND(C,NAME='ComptonProfile_Partial')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                INTEGER (KIND=C_INT), INTENT(IN), VALUE :: Z,shell
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: pz
                REAL (KIND=C_DOUBLE) :: ComptonProfile_Partial
        ENDFUNCTION ComptonProfile_Partial

        PURE FUNCTION ElectronConfig(Z,shell) BIND(C,NAME='ElectronConfig')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                INTEGER (KIND=C_INT), INTENT(IN), VALUE :: Z,shell
                REAL (KIND=C_DOUBLE) :: ElectronConfig
        ENDFUNCTION ElectronConfig

        PURE FUNCTION ElectronConfig_Biggs(Z,shell) BIND(C,NAME='ElectronConfig_Biggs')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                INTEGER (KIND=C_INT), INTENT(IN), VALUE :: Z,shell
                REAL (KIND=C_DOUBLE) :: ElectronConfig_Biggs
        ENDFUNCTION ElectronConfig_Biggs

        PURE FUNCTION AtomicLevelWidth(Z,shell) BIND(C,NAME='AtomicLevelWidth')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                INTEGER (KIND=C_INT), INTENT(IN), VALUE :: Z,shell
                REAL (KIND=C_DOUBLE) :: AtomicLevelWidth
        ENDFUNCTION AtomicLevelWidth
        PURE FUNCTION AugerRate(Z,auger_trans) BIND(C,NAME='AugerRate')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                INTEGER (KIND=C_INT), INTENT(IN), VALUE :: Z, auger_trans
                REAL (KIND=C_DOUBLE) :: AugerRate
        ENDFUNCTION
        PURE FUNCTION AugerYield(Z,shell) BIND(C,NAME='AugerYield')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                INTEGER (KIND=C_INT), INTENT(IN), VALUE :: Z, shell
                REAL (KIND=C_DOUBLE) :: AugerYield
        ENDFUNCTION

        !XRF cross sections using Kissel partial photoelectric cross sections
        PURE FUNCTION CS_FluorLine_Kissel (Z,line, E) &
                BIND(C, NAME='CS_FluorLine_Kissel')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: CS_FluorLine_Kissel
                INTEGER (KIND=C_INT), INTENT(IN), VALUE :: line, Z
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E
        ENDFUNCTION CS_FluorLine_Kissel

        PURE FUNCTION CSb_FluorLine_Kissel (Z,line, E) &
                BIND(C, NAME='CSb_FluorLine_Kissel')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: CSb_FluorLine_Kissel
                INTEGER (KIND=C_INT), INTENT(IN), VALUE :: line, Z
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E
        ENDFUNCTION CSb_FluorLine_Kissel

        PURE FUNCTION CS_FluorLine_Kissel_Cascade (Z,line, E) &
                BIND(C, NAME='CS_FluorLine_Kissel_Cascade')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: CS_FluorLine_Kissel_Cascade
                INTEGER (KIND=C_INT), INTENT(IN), VALUE :: line, Z
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E
        ENDFUNCTION CS_FluorLine_Kissel_Cascade

        PURE FUNCTION CSb_FluorLine_Kissel_Cascade (Z,line, E) &
                BIND(C, NAME='CSb_FluorLine_Kissel_Cascade')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: CSb_FluorLine_Kissel_Cascade
                INTEGER (KIND=C_INT), INTENT(IN), VALUE :: line, Z
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E
        ENDFUNCTION CSb_FluorLine_Kissel_Cascade

        PURE FUNCTION CS_FluorLine_Kissel_Nonradiative_Cascade (Z,line, E) &
                BIND(C, NAME='CS_FluorLine_Kissel_Nonradiative_Cascade')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: CS_FluorLine_Kissel_Nonradiative_Cascade
                INTEGER (KIND=C_INT), INTENT(IN), VALUE :: line, Z
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E
        ENDFUNCTION CS_FluorLine_Kissel_Nonradiative_Cascade

        PURE FUNCTION CSb_FluorLine_Kissel_Nonradiative_Cascade (Z,line, E) &
                BIND(C, NAME='CSb_FluorLine_Kissel_Nonradiative_Cascade')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: CSb_FluorLine_Kissel_Nonradiative_Cascade
                INTEGER (KIND=C_INT), INTENT(IN), VALUE :: line, Z
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E
        ENDFUNCTION CSb_FluorLine_Kissel_Nonradiative_Cascade

        PURE FUNCTION CS_FluorLine_Kissel_Radiative_Cascade (Z,line, E) &
                BIND(C, NAME='CS_FluorLine_Kissel_Radiative_Cascade')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: CS_FluorLine_Kissel_Radiative_Cascade
                INTEGER (KIND=C_INT), INTENT(IN), VALUE :: line, Z
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E
        ENDFUNCTION CS_FluorLine_Kissel_Radiative_Cascade

        PURE FUNCTION CSb_FluorLine_Kissel_Radiative_Cascade (Z,line, E) &
                BIND(C, NAME='CSb_FluorLine_Kissel_Radiative_Cascade')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: CSb_FluorLine_Kissel_Radiative_Cascade
                INTEGER (KIND=C_INT), INTENT(IN), VALUE :: line, Z
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E
        ENDFUNCTION CSb_FluorLine_Kissel_Radiative_Cascade

        PURE FUNCTION CS_FluorLine_Kissel_no_Cascade (Z,line, E) &
                BIND(C, NAME='CS_FluorLine_Kissel_no_Cascade')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: CS_FluorLine_Kissel_no_Cascade
                INTEGER (KIND=C_INT), INTENT(IN), VALUE :: line, Z
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E
        ENDFUNCTION CS_FluorLine_Kissel_no_Cascade

        PURE FUNCTION CSb_FluorLine_Kissel_no_Cascade (Z,line, E) &
                BIND(C, NAME='CSb_FluorLine_Kissel_no_Cascade')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: CSb_FluorLine_Kissel_no_Cascade
                INTEGER (KIND=C_INT), INTENT(IN), VALUE :: line, Z
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E
        ENDFUNCTION CSb_FluorLine_Kissel_no_Cascade

!xrf_cross_sections_aux function
        PURE FUNCTION PL1_pure_kissel(Z, E) &
                BIND(C, NAME='PL1_pure_kissel')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: PL1_pure_kissel
                INTEGER (KIND=C_INT), INTENT(IN), VALUE :: Z
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E
        ENDFUNCTION PL1_pure_kissel

        PURE FUNCTION PL2_pure_kissel(Z, E, PL1) &
                BIND(C, NAME='PL2_pure_kissel')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: PL2_pure_kissel
                INTEGER (KIND=C_INT), INTENT(IN), VALUE :: Z
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E, PL1
        ENDFUNCTION PL2_pure_kissel

        PURE FUNCTION PL3_pure_kissel(Z, E, PL1, PL2) &
                BIND(C, NAME='PL3_pure_kissel')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: PL3_pure_kissel
                INTEGER (KIND=C_INT), INTENT(IN), VALUE :: Z
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E, PL1, PL2
        ENDFUNCTION PL3_pure_kissel

        PURE FUNCTION PM1_pure_kissel(Z, E) &
                BIND(C, NAME='PM1_pure_kissel')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: PM1_pure_kissel
                INTEGER (KIND=C_INT), INTENT(IN), VALUE :: Z
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E
        ENDFUNCTION PM1_pure_kissel

        PURE FUNCTION PM2_pure_kissel(Z, E, PM1) &
                BIND(C, NAME='PM2_pure_kissel')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: PM2_pure_kissel
                INTEGER (KIND=C_INT), INTENT(IN), VALUE :: Z
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E, PM1
        ENDFUNCTION PM2_pure_kissel

        PURE FUNCTION PM3_pure_kissel(Z, E, PM1, PM2) &
                BIND(C, NAME='PM3_pure_kissel')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: PM3_pure_kissel
                INTEGER (KIND=C_INT), INTENT(IN), VALUE :: Z
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E, PM1, PM2
        ENDFUNCTION PM3_pure_kissel

        PURE FUNCTION PM4_pure_kissel(Z, E, PM1, PM2, PM3) &
                BIND(C, NAME='PM4_pure_kissel')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: PM4_pure_kissel
                INTEGER (KIND=C_INT), INTENT(IN), VALUE :: Z
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E, PM1, PM2, PM3
        ENDFUNCTION PM4_pure_kissel

        PURE FUNCTION PM5_pure_kissel(Z, E, PM1, PM2, PM3, PM4) &
                BIND(C, NAME='PM5_pure_kissel')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: PM5_pure_kissel
                INTEGER (KIND=C_INT), INTENT(IN), VALUE :: Z
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E, PM1, PM2, PM3, PM4
        ENDFUNCTION PM5_pure_kissel

        PURE FUNCTION PL1_rad_cascade_kissel(Z, E, PK) &
                BIND(C, NAME='PL1_rad_cascade_kissel')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: PL1_rad_cascade_kissel
                INTEGER (KIND=C_INT), INTENT(IN), VALUE :: Z
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E, PK
        ENDFUNCTION PL1_rad_cascade_kissel

        PURE FUNCTION PL2_rad_cascade_kissel(Z, E, PK, PL1) &
                BIND(C, NAME='PL2_rad_cascade_kissel')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: PL2_rad_cascade_kissel
                INTEGER (KIND=C_INT), INTENT(IN), VALUE :: Z
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E, PK, PL1
        ENDFUNCTION PL2_rad_cascade_kissel

        PURE FUNCTION PL3_rad_cascade_kissel(Z, E, PK, PL1, PL2) &
                BIND(C, NAME='PL3_rad_cascade_kissel')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: PL3_rad_cascade_kissel
                INTEGER (KIND=C_INT), INTENT(IN), VALUE :: Z
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E, PK, PL1, PL2
        ENDFUNCTION PL3_rad_cascade_kissel

        PURE FUNCTION PM1_rad_cascade_kissel(Z, E, PK, PL1, PL2, PL3) &
                BIND(C, NAME='PM1_rad_cascade_kissel')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: PM1_rad_cascade_kissel
                INTEGER (KIND=C_INT), INTENT(IN), VALUE :: Z
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E, PK, PL1, PL2,&
                PL3
        ENDFUNCTION PM1_rad_cascade_kissel

        PURE FUNCTION PM2_rad_cascade_kissel(Z, E, PK, PL1, PL2, PL3, &
                PM1) &
                BIND(C, NAME='PM2_rad_cascade_kissel')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: PM2_rad_cascade_kissel
                INTEGER (KIND=C_INT), INTENT(IN), VALUE :: Z
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E, PK, PL1, PL2,&
                PL3, PM1
        ENDFUNCTION PM2_rad_cascade_kissel

        PURE FUNCTION PM3_rad_cascade_kissel(Z, E, PK, PL1, PL2, PL3, &
                PM1, PM2) &
                BIND(C, NAME='PM3_rad_cascade_kissel')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: PM3_rad_cascade_kissel
                INTEGER (KIND=C_INT), INTENT(IN), VALUE :: Z
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E, PK, PL1, PL2,&
                PL3,PM1, PM2
        ENDFUNCTION PM3_rad_cascade_kissel

        PURE FUNCTION PM4_rad_cascade_kissel(Z, E, PK, PL1, PL2, PL3, &
                PM1, PM2, PM3) &
                BIND(C, NAME='PM4_rad_cascade_kissel')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: PM4_rad_cascade_kissel
                INTEGER (KIND=C_INT), INTENT(IN), VALUE :: Z
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E, PK, PL1, PL2,&
                PL3, PM1, PM2, PM3
        ENDFUNCTION PM4_rad_cascade_kissel

        PURE FUNCTION PM5_rad_cascade_kissel(Z, E, PK, PL1, PL2, PL3, &
                PM1, PM2, PM3, PM4) &
                BIND(C, NAME='PM5_rad_cascade_kissel')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: PM5_rad_cascade_kissel
                INTEGER (KIND=C_INT), INTENT(IN), VALUE :: Z
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E, PK, PL1, PL2, &
                PL3, PM1, PM2, PM3, PM4
        ENDFUNCTION PM5_rad_cascade_kissel

        PURE FUNCTION PL1_auger_cascade_kissel(Z, E, PK) &
                BIND(C, NAME='PL1_auger_cascade_kissel')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: PL1_auger_cascade_kissel
                INTEGER (KIND=C_INT), INTENT(IN), VALUE :: Z
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E, PK
        ENDFUNCTION PL1_auger_cascade_kissel

        PURE FUNCTION PL2_auger_cascade_kissel(Z, E, PK, PL1) &
                BIND(C, NAME='PL2_auger_cascade_kissel')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: PL2_auger_cascade_kissel
                INTEGER (KIND=C_INT), INTENT(IN), VALUE :: Z
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E, PK, PL1
        ENDFUNCTION PL2_auger_cascade_kissel

        PURE FUNCTION PL3_auger_cascade_kissel(Z, E, PK, PL1, PL2) &
                BIND(C, NAME='PL3_auger_cascade_kissel')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: PL3_auger_cascade_kissel
                INTEGER (KIND=C_INT), INTENT(IN), VALUE :: Z
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E, PK, PL1, PL2
        ENDFUNCTION PL3_auger_cascade_kissel

        PURE FUNCTION PM1_auger_cascade_kissel(Z, E, PK, PL1, PL2, PL3) &
                BIND(C, NAME='PM1_auger_cascade_kissel')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: PM1_auger_cascade_kissel
                INTEGER (KIND=C_INT), INTENT(IN), VALUE :: Z
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E, PK, PL1, PL2,&
                PL3
        ENDFUNCTION PM1_auger_cascade_kissel

        PURE FUNCTION PM2_auger_cascade_kissel(Z, E, PK, PL1, PL2, PL3, &
                PM1) &
                BIND(C, NAME='PM2_auger_cascade_kissel')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: PM2_auger_cascade_kissel
                INTEGER (KIND=C_INT), INTENT(IN), VALUE :: Z
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E, PK, PL1, PL2,&
                PL3, PM1
        ENDFUNCTION PM2_auger_cascade_kissel

        PURE FUNCTION PM3_auger_cascade_kissel(Z, E, PK, PL1, PL2, PL3, &
                PM1, PM2) &
                BIND(C, NAME='PM3_auger_cascade_kissel')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: PM3_auger_cascade_kissel
                INTEGER (KIND=C_INT), INTENT(IN), VALUE :: Z
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E, PK, PL1, PL2,&
                PL3,PM1, PM2
        ENDFUNCTION PM3_auger_cascade_kissel

        PURE FUNCTION PM4_auger_cascade_kissel(Z, E, PK, PL1, PL2, PL3, &
                PM1, PM2, PM3) &
                BIND(C, NAME='PM4_auger_cascade_kissel')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: PM4_auger_cascade_kissel
                INTEGER (KIND=C_INT), INTENT(IN), VALUE :: Z
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E, PK, PL1, PL2,&
                PL3, PM1, PM2, PM3
        ENDFUNCTION PM4_auger_cascade_kissel

        PURE FUNCTION PM5_auger_cascade_kissel(Z, E, PK, PL1, PL2, PL3, &
                PM1, PM2, PM3, PM4) &
                BIND(C, NAME='PM5_auger_cascade_kissel')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: PM5_auger_cascade_kissel
                INTEGER (KIND=C_INT), INTENT(IN), VALUE :: Z
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E, PK, PL1, PL2, &
                PL3, PM1, PM2, PM3, PM4
        ENDFUNCTION PM5_auger_cascade_kissel

        PURE FUNCTION PL1_full_cascade_kissel(Z, E, PK) &
                BIND(C, NAME='PL1_full_cascade_kissel')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: PL1_full_cascade_kissel
                INTEGER (KIND=C_INT), INTENT(IN), VALUE :: Z
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E, PK
        ENDFUNCTION PL1_full_cascade_kissel

        PURE FUNCTION PL2_full_cascade_kissel(Z, E, PK, PL1) &
                BIND(C, NAME='PL2_full_cascade_kissel')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: PL2_full_cascade_kissel
                INTEGER (KIND=C_INT), INTENT(IN), VALUE :: Z
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E, PK, PL1
        ENDFUNCTION PL2_full_cascade_kissel

        PURE FUNCTION PL3_full_cascade_kissel(Z, E, PK, PL1, PL2) &
                BIND(C, NAME='PL3_full_cascade_kissel')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: PL3_full_cascade_kissel
                INTEGER (KIND=C_INT), INTENT(IN), VALUE :: Z
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E, PK, PL1, PL2
        ENDFUNCTION PL3_full_cascade_kissel

        PURE FUNCTION PM1_full_cascade_kissel(Z, E, PK, PL1, PL2, PL3) &
                BIND(C, NAME='PM1_full_cascade_kissel')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: PM1_full_cascade_kissel
                INTEGER (KIND=C_INT), INTENT(IN), VALUE :: Z
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E, PK, PL1, PL2,&
                PL3
        ENDFUNCTION PM1_full_cascade_kissel

        PURE FUNCTION PM2_full_cascade_kissel(Z, E, PK, PL1, PL2, PL3, &
                PM1) &
                BIND(C, NAME='PM2_full_cascade_kissel')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: PM2_full_cascade_kissel
                INTEGER (KIND=C_INT), INTENT(IN), VALUE :: Z
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E, PK, PL1, PL2,&
                PL3, PM1
        ENDFUNCTION PM2_full_cascade_kissel

        PURE FUNCTION PM3_full_cascade_kissel(Z, E, PK, PL1, PL2, PL3, &
                PM1, PM2) &
                BIND(C, NAME='PM3_full_cascade_kissel')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: PM3_full_cascade_kissel
                INTEGER (KIND=C_INT), INTENT(IN), VALUE :: Z
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E, PK, PL1, PL2,&
                PL3,PM1, PM2
        ENDFUNCTION PM3_full_cascade_kissel

        PURE FUNCTION PM4_full_cascade_kissel(Z, E, PK, PL1, PL2, PL3, &
                PM1, PM2, PM3) &
                BIND(C, NAME='PM4_full_cascade_kissel')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: PM4_full_cascade_kissel
                INTEGER (KIND=C_INT), INTENT(IN), VALUE :: Z
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E, PK, PL1, PL2,&
                PL3, PM1, PM2, PM3
        ENDFUNCTION PM4_full_cascade_kissel

        PURE FUNCTION PM5_full_cascade_kissel(Z, E, PK, PL1, PL2, PL3, &
                PM1, PM2, PM3, PM4) &
                BIND(C, NAME='PM5_full_cascade_kissel')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                REAL (KIND=C_DOUBLE) :: PM5_full_cascade_kissel
                INTEGER (KIND=C_INT), INTENT(IN), VALUE :: Z
                REAL (KIND=C_DOUBLE), INTENT(IN), VALUE :: E, PK, PL1, PL2, &
                PL3, PM1, PM2, PM3, PM4
        ENDFUNCTION PM5_full_cascade_kissel



        PURE FUNCTION AtomicNumberToSymbol_c(Z)&
                BIND(C,NAME='AtomicNumberToSymbol')&
                RESULT(rv)
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                TYPE (C_PTR) :: rv
                INTEGER (KIND=C_INT), INTENT(IN), VALUE :: Z
        ENDFUNCTION AtomicNumberToSymbol_c

        PURE FUNCTION SymbolToAtomicNumber_c(symbol)&
                BIND(C,NAME='SymbolToAtomicNumber')&
                RESULT(rv)
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                TYPE (C_PTR), INTENT(IN), VALUE :: symbol
                INTEGER (KIND=C_INT) :: rv
        ENDFUNCTION SymbolToAtomicNumber_c

        SUBROUTINE xrlFree(xrlPtr)&
        BIND(C,NAME='xrlFree')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                TYPE (C_PTR), INTENT(IN), VALUE :: xrlPtr
        ENDSUBROUTINE xrlFree

        FUNCTION Crystal_GetCrystal_C (material, c_array)&
                BIND(C,NAME='Crystal_GetCrystal')&
                RESULT (rv)
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                TYPE (C_PTR), INTENT(IN), VALUE :: material
                TYPE (C_PTR), INTENT(IN), VALUE :: c_array
                TYPE (C_PTR) :: rv
        ENDFUNCTION Crystal_GetCrystal_C

        FUNCTION Crystal_AddCrystal_C (crystal, c_array)&
                BIND(C,NAME='Crystal_AddCrystal')&
                RESULT (rv)
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                TYPE (C_PTR), INTENT(IN), VALUE :: crystal
                TYPE (C_PTR), INTENT(IN), VALUE :: c_array
                INTEGER (C_INT) :: rv
        ENDFUNCTION Crystal_AddCrystal_C

        FUNCTION Bragg_angle_C (crystal, energy, i_miller, j_miller, k_miller)&
                BIND(C,NAME='Bragg_angle')&
                RESULT(rv)
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                TYPE (C_PTR), INTENT(IN), VALUE :: crystal
                REAL (C_DOUBLE), INTENT(IN), VALUE :: energy
                INTEGER (C_INT), INTENT(IN), VALUE :: i_miller, j_miller, k_miller
                REAL (C_DOUBLE) :: rv
        ENDFUNCTION Bragg_angle_C

        FUNCTION Q_scattering_amplitude_C(crystal, energy, i_miller, j_miller, &
                k_miller, rel_angle) BIND(C,NAME='Q_scattering_amplitude')&
                RESULT(rv)
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                TYPE (C_PTR), INTENT(IN), VALUE :: crystal
                REAL (C_DOUBLE), INTENT(IN), VALUE :: energy, rel_angle
                INTEGER (C_INT), INTENT(IN), VALUE :: i_miller, j_miller, k_miller
                REAL (C_DOUBLE) :: rv
        ENDFUNCTION Q_scattering_amplitude_C

        SUBROUTINE Atomic_Factors (Z, energy, q, debye_factor, f0, &
                f_primep, f_prime2) BIND(C,NAME='Atomic_Factors')
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                INTEGER (C_INT), INTENT(IN), VALUE :: Z
                REAL (C_DOUBLE), INTENT(IN), VALUE :: energy, q,debye_factor
                REAL (C_DOUBLE), INTENT(OUT) :: f0, f_primep, f_prime2
        ENDSUBROUTINE Atomic_Factors

        FUNCTION Crystal_F_H_StructureFactor_C(crystal, energy, i_miller,&
        j_miller, k_miller, debye_factor, rel_angle) BIND(C,NAME=&
        'Crystal_F_H_StructureFactor') RESULT(rv)
                USE, INTRINSIC :: ISO_C_BINDING
                IMPORT :: xrlComplex_C
                IMPLICIT NONE
                TYPE (C_PTR), INTENT(IN), VALUE :: crystal
                REAL (C_DOUBLE), INTENT(IN), VALUE :: energy, rel_angle,&
                debye_factor
                INTEGER (C_INT), INTENT(IN), VALUE :: i_miller, j_miller, k_miller
                TYPE(xrlComplex_C) :: rv
        ENDFUNCTION Crystal_F_H_StructureFactor_C

        FUNCTION Crystal_F_H_StructureFactor_Partial_C(crystal, &
        energy, i_miller, j_miller, k_miller, debye_factor, rel_angle, &
        f0_flag, f_prime_flag, f_prime2_flag) BIND(C,NAME=&
        'Crystal_F_H_StructureFactor_Partial') RESULT(rv)
                USE, INTRINSIC :: ISO_C_BINDING
                IMPORT :: xrlComplex_C
                IMPLICIT NONE
                TYPE (C_PTR), INTENT(IN), VALUE :: crystal
                REAL (C_DOUBLE), INTENT(IN), VALUE :: energy, rel_angle,&
                debye_factor
                INTEGER (C_INT), INTENT(IN), VALUE :: i_miller, j_miller, k_miller,&
                f0_flag, f_prime_flag, f_prime2_flag
                TYPE(xrlComplex_C) :: rv
        ENDFUNCTION Crystal_F_H_StructureFactor_Partial_C

        FUNCTION Crystal_UnitCellVolume_C(crystal)&
        BIND (C,NAME='Crystal_UnitCellVolume')&
        RESULT(rv)
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                TYPE (C_PTR), INTENT(IN), VALUE :: crystal
                REAL (C_DOUBLE) :: rv
        ENDFUNCTION Crystal_UnitCellVolume_C

        FUNCTION Crystal_dSpacing_C(crystal, i_miller, j_miller, k_miller)&
        BIND (C,NAME='Crystal_dSpacing')&
        RESULT(rv)
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                TYPE (C_PTR), INTENT(IN), VALUE :: crystal
                INTEGER (C_INT), INTENT(IN), VALUE :: i_miller, j_miller, k_miller
                REAL (C_DOUBLE) :: rv
        ENDFUNCTION Crystal_dSpacing_C

        FUNCTION GetCompoundDataNISTByName_C(compoundString)&
        BIND (C,NAME='GetCompoundDataNISTByName')&
        RESULT(rv)
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                TYPE (C_PTR), INTENT(IN), VALUE :: compoundString
                TYPE (C_PTR) :: rv
        ENDFUNCTION GetCompoundDataNISTByName_C

        FUNCTION GetCompoundDataNISTByIndex_C(index)&
        BIND (C,NAME='GetCompoundDataNISTByIndex')&
        RESULT(rv)
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                INTEGER (C_INT), INTENT(IN), VALUE :: index
                TYPE (C_PTR) :: rv
        ENDFUNCTION GetCompoundDataNISTByIndex_C

        FUNCTION GetCompoundDataNISTList_C(nCompounds)&
        BIND (C,NAME='GetCompoundDataNISTList')&
        RESULT(rv)
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                INTEGER (C_INT), INTENT(OUT) :: nCompounds
                TYPE (C_PTR) :: rv
        ENDFUNCTION GetCompoundDataNISTList_C

        FUNCTION GetRadioNuclideDataByName_C(string)&
        BIND (C,NAME='GetRadioNuclideDataByName')&
        RESULT(rv)
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                TYPE (C_PTR), INTENT(IN), VALUE :: string
                TYPE (C_PTR) :: rv
        ENDFUNCTION GetRadioNuclideDataByName_C

        FUNCTION GetRadioNuclideDataByIndex_C(index)&
        BIND (C,NAME='GetRadioNuclideDataByIndex')&
        RESULT(rv)
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                INTEGER (C_INT), INTENT(IN), VALUE :: index
                TYPE (C_PTR) :: rv
        ENDFUNCTION GetRadioNuclideDataByIndex_C

        FUNCTION GetRadioNuclideDataList_C(nNuclides)&
        BIND (C,NAME='GetRadioNuclideDataList')&
        RESULT(rv)
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                INTEGER (C_INT), INTENT(OUT) :: nNuclides
                TYPE (C_PTR) :: rv
        ENDFUNCTION GetRadioNuclideDataList_C

        FUNCTION Crystal_GetCrystalsList_C(c_array, nCrystals)&
        BIND (C,NAME='Crystal_GetCrystalsList')&
        RESULT(rv)
                USE, INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                INTEGER (C_INT) :: nCrystals
                TYPE (C_PTR), VALUE :: c_array
                TYPE (C_PTR) :: rv
        ENDFUNCTION Crystal_GetCrystalsList_C

ENDINTERFACE

CONTAINS

FUNCTION CompoundParser(compoundString) RESULT(rv)
        USE, INTRINSIC :: ISO_C_BINDING
        IMPLICIT NONE

        CHARACTER (KIND=C_CHAR,LEN=*), INTENT(IN) :: compoundString
        CHARACTER (KIND=C_CHAR), DIMENSION(:), ALLOCATABLE, TARGET :: &
        compoundString_F
        TYPE (compoundData), POINTER :: rv
        TYPE (compoundData_C), POINTER :: rv_C
        TYPE (C_PTR) :: rv_c_ptr
        INTEGER :: i

        NULLIFY(rv)

        CALL stringF2C(compoundString, compoundString_F)

        rv_c_ptr = CompoundParser_C(C_LOC(compoundString_F))

        IF (C_ASSOCIATED(rv_c_ptr) .EQV. .TRUE.) THEN
                ALLOCATE(rv)
                CALL C_F_POINTER(rv_c_ptr, rv_C)
                rv%nElements = rv_C%nElements
                rv%nAtomsAll = rv_C%nAtomsAll
                CALL C_F_POINTER(rv_C%Elements, rv%Elements, [rv%nElements])
                CALL C_F_POINTER(rv_C%massFractions, rv%massFractions, [rv%nElements])
                CALL C_F_POINTER(rv_C%nAtoms, rv%nAtoms, [rv%nElements])
                rv%molarMass = rv_C%molarMass
                CALL xrlFree(rv_c_ptr)
        ENDIF

        RETURN
ENDFUNCTION CompoundParser

SUBROUTINE FreeCompoundData(cd)
        USE, INTRINSIC :: ISO_C_BINDING
        IMPLICIT NONE
        TYPE (compoundData), POINTER, INTENT(INOUT) :: cd

        CALL xrlFree(C_LOC(cd%Elements(1)))
        CALL xrlFree(C_LOC(cd%massFractions(1)))
        CALL xrlFree(C_LOC(cd%nAtoms(1)))
        DEALLOCATE(cd)
ENDSUBROUTINE

FUNCTION AtomicNumberToSymbol(Z) RESULT(rv)
        USE, INTRINSIC :: ISO_C_BINDING
        IMPLICIT NONE
        INTEGER (KIND=C_INT), INTENT(IN) :: Z
        CHARACTER (KIND=C_CHAR,LEN=3) :: rv

        TYPE (C_PTR) :: symbol_C
        CHARACTER (KIND=C_CHAR), DIMENSION(:), POINTER :: symbol_F
        INTEGER :: i
        INTEGER (C_SIZE_T) :: symbol_len
        !interface for the libc strlen function
        INTERFACE
        PURE FUNCTION xrlstrlen(s) BIND(C,NAME='strlen')
                USE,INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                TYPE (C_PTR), INTENT(IN), VALUE :: s
                INTEGER (C_SIZE_T) :: xrlstrlen
        ENDFUNCTION xrlstrlen
        ENDINTERFACE

        symbol_C = AtomicNumberToSymbol_c(Z)
        IF (C_ASSOCIATED(symbol_C) .EQV. .FALSE.) THEN
                DO i=1,3
                        rv(i:i) = ' '
                ENDDO
                RETURN
        ENDIF

        symbol_len = xrlstrlen(symbol_C)

        CALL C_F_POINTER(symbol_C, symbol_F,[symbol_len])
        DO i=1,3
                IF (i .LE. symbol_len) THEN
                        rv(i:i) = symbol_F(i)
                ELSE
                        rv(i:i) = ' '
                ENDIF
        ENDDO

        CALL xrlFree(symbol_C)

        RETURN
ENDFUNCTION AtomicNumberToSymbol

FUNCTION SymbolToAtomicNumber(symbol) RESULT(rv)
        USE, INTRINSIC :: ISO_C_BINDING
        IMPLICIT NONE
        CHARACTER (KIND=C_CHAR,LEN=*), INTENT(IN) :: symbol
        INTEGER (KIND=C_INT) :: rv

        CHARACTER (KIND=C_CHAR), DIMENSION(:), ALLOCATABLE, TARGET :: symbol_F
        TYPE (C_PTR) :: symbol_C
        INTEGER :: i

        CALL stringF2C(symbol, symbol_F)

        symbol_C = C_LOC(symbol_F)

        rv = SymbolToAtomicNumber_c(symbol_C)

        RETURN
ENDFUNCTION SymbolToAtomicNumber

FUNCTION Crystal_GetCrystal (material, c_array) RESULT(rv)
        USE, INTRINSIC :: ISO_C_BINDING
        IMPLICIT NONE
        TYPE (Crystal_Array), INTENT(INOUT), OPTIONAL, TARGET :: c_array
        CHARACTER (KIND=C_CHAR,LEN=*), INTENT(IN) :: material
        CHARACTER (KIND=C_CHAR), DIMENSION(:), ALLOCATABLE, TARGET :: material_F
        TYPE (C_PTR) :: material_C, crystal_C
        INTEGER :: i
        TYPE (Crystal_Struct_C), POINTER :: c_struct_c
        TYPE (Crystal_Struct), POINTER :: rv
        CHARACTER (KIND=C_CHAR), DIMENSION(:), POINTER :: name_F

        NULLIFY(rv)

        CALL stringF2C(material, material_F)

        material_C = C_LOC(material_F)

        IF (PRESENT(c_array)) THEN
                crystal_c = Crystal_GetCrystal_C(material_C, C_LOC(c_array))
        ELSE
                crystal_c = Crystal_GetCrystal_C(material_C, C_NULL_PTR)
        ENDIF


        IF (C_ASSOCIATED(crystal_C) .EQV. .TRUE.) THEN
                ALLOCATE(rv)
                CALL C_F_POINTER(crystal_c,c_struct_c)
                rv%name=material
                rv%a=c_struct_c%a
                rv%b=c_struct_c%b
                rv%c=c_struct_c%c
                rv%alpha=c_struct_c%alpha
                rv%beta=c_struct_c%beta
                rv%gamma=c_struct_c%gamma
                rv%volume=c_struct_c%volume
                rv%n_atom =c_struct_c%n_atom
                CALL C_F_POINTER(c_struct_c%atom, rv%atom, [rv%n_atom])
        ENDIF

        RETURN
ENDFUNCTION Crystal_GetCrystal


FUNCTION Bragg_angle (crystal, energy, i_miller, j_miller, k_miller)&
        RESULT(rv)
        USE, INTRINSIC :: ISO_C_BINDING
        IMPLICIT NONE

        TYPE (Crystal_Struct), INTENT(IN) :: crystal
        REAL (C_DOUBLE), INTENT(IN) :: energy
        INTEGER (C_INT), INTENT(IN) :: i_miller, j_miller, k_miller
        REAL (C_DOUBLE) :: rv

        TYPE (C_PTR) :: crystal_ptr
        TYPE (Crystal_Struct_C), TARGET :: crystal_c

        crystal_c%a = crystal%a
        crystal_c%b = crystal%b
        crystal_c%c = crystal%c
        crystal_c%alpha = crystal%alpha
        crystal_c%beta = crystal%beta
        crystal_c%gamma = crystal%gamma
        crystal_c%volume = crystal%volume
        crystal_c%n_atom = crystal%n_atom
        crystal_c%atom = C_LOC(crystal%atom(1))

        crystal_ptr = C_LOC(crystal_c)

        rv = Bragg_angle_C(crystal_ptr, energy, i_miller, j_miller, k_miller)

        RETURN
ENDFUNCTION Bragg_angle

FUNCTION Q_scattering_amplitude(crystal, energy, i_miller, j_miller,&
        k_miller, rel_angle)&
        RESULT(rv)
        USE, INTRINSIC :: ISO_C_BINDING
        IMPLICIT NONE

        TYPE (Crystal_Struct), INTENT(IN) :: crystal
        REAL (C_DOUBLE), INTENT(IN) :: energy, rel_angle
        INTEGER (C_INT), INTENT(IN) :: i_miller, j_miller, k_miller
        REAL (C_DOUBLE) :: rv

        TYPE (C_PTR) :: crystal_ptr
        TYPE (Crystal_Struct_C), TARGET :: crystal_c

        crystal_c%a = crystal%a
        crystal_c%b = crystal%b
        crystal_c%c = crystal%c
        crystal_c%alpha = crystal%alpha
        crystal_c%beta = crystal%beta
        crystal_c%gamma = crystal%gamma
        crystal_c%volume = crystal%volume
        crystal_c%n_atom = crystal%n_atom
        crystal_c%atom = C_LOC(crystal%atom(1))

        crystal_ptr = C_LOC(crystal_c)

        rv = Q_scattering_amplitude_C(crystal_ptr, energy, i_miller,&
        j_miller, k_miller,rel_angle)

        RETURN
ENDFUNCTION Q_scattering_amplitude

FUNCTION Crystal_F_H_StructureFactor(crystal, energy, i_miller,&
        j_miller, k_miller, debye_factor, rel_angle) RESULT(rv)
        USE, INTRINSIC :: ISO_C_BINDING
        IMPLICIT NONE

        TYPE (Crystal_Struct), INTENT(IN) :: crystal
        REAL (C_DOUBLE), INTENT(IN) :: energy, rel_angle, debye_factor
        INTEGER (C_INT), INTENT(IN) :: i_miller, j_miller, k_miller
        TYPE (xrlComplex_C) :: temp
        COMPLEX (C_DOUBLE) :: rv

        TYPE (C_PTR) :: crystal_ptr
        TYPE (Crystal_Struct_C), TARGET :: crystal_c

        crystal_c%a = crystal%a
        crystal_c%b = crystal%b
        crystal_c%c = crystal%c
        crystal_c%alpha = crystal%alpha
        crystal_c%beta = crystal%beta
        crystal_c%gamma = crystal%gamma
        crystal_c%volume = crystal%volume
        crystal_c%n_atom = crystal%n_atom
        crystal_c%atom = C_LOC(crystal%atom(1))

        crystal_ptr = C_LOC(crystal_c)
        temp = Crystal_F_H_StructureFactor_C(crystal_ptr, energy, i_miller,&
        j_miller, k_miller, debye_factor, rel_angle)

        rv = CMPLX(temp%re, temp%im, C_DOUBLE)


        RETURN
ENDFUNCTION Crystal_F_H_StructureFactor

FUNCTION Crystal_F_H_StructureFactor_Partial(crystal, &
        energy, i_miller, j_miller, k_miller, debye_factor, rel_angle, &
        f0_flag, f_prime_flag, f_prime2_flag) RESULT(rv)

        USE, INTRINSIC :: ISO_C_BINDING
        IMPLICIT NONE

        TYPE (Crystal_Struct), INTENT(IN) :: crystal
        REAL (C_DOUBLE), INTENT(IN) :: energy, rel_angle, debye_factor
        INTEGER (C_INT), INTENT(IN) :: i_miller, j_miller, k_miller, &
        f0_flag, f_prime_flag, f_prime2_flag
        TYPE (xrlComplex_C) :: temp
        COMPLEX (C_DOUBLE) :: rv

        TYPE (C_PTR) :: crystal_ptr
        TYPE (Crystal_Struct_C), TARGET :: crystal_c

        crystal_c%a = crystal%a
        crystal_c%b = crystal%b
        crystal_c%c = crystal%c
        crystal_c%alpha = crystal%alpha
        crystal_c%beta = crystal%beta
        crystal_c%gamma = crystal%gamma
        crystal_c%volume = crystal%volume
        crystal_c%n_atom = crystal%n_atom
        crystal_c%atom = C_LOC(crystal%atom(1))

        crystal_ptr = C_LOC(crystal_c)
        temp = Crystal_F_H_StructureFactor_Partial_C(crystal_ptr,&
        energy, i_miller, j_miller, k_miller, debye_factor, &
        rel_angle, f0_flag, f_prime_flag, f_prime2_flag)

        rv = CMPLX(temp%re, temp%im, C_DOUBLE)


        RETURN
ENDFUNCTION Crystal_F_H_StructureFactor_Partial

FUNCTION Crystal_UnitCellVolume(crystal) RESULT(rv)
        USE, INTRINSIC :: ISO_C_BINDING
        IMPLICIT NONE

        TYPE (Crystal_Struct), INTENT(IN) :: crystal
        REAL (C_DOUBLE) :: rv

        TYPE (C_PTR) :: crystal_ptr
        TYPE (Crystal_Struct_C), TARGET :: crystal_c

        crystal_c%a = crystal%a
        crystal_c%b = crystal%b
        crystal_c%c = crystal%c
        crystal_c%alpha = crystal%alpha
        crystal_c%beta = crystal%beta
        crystal_c%gamma = crystal%gamma
        crystal_c%volume = crystal%volume
        crystal_c%n_atom = crystal%n_atom
        crystal_c%atom = C_LOC(crystal%atom(1))

        crystal_ptr = C_LOC(crystal_c)

        rv = Crystal_UnitCellVolume_C(crystal_ptr)
        RETURN
ENDFUNCTION Crystal_UnitCellVolume

FUNCTION Crystal_dSpacing(crystal, i_miller, j_miller, k_miller)&
        RESULT(rv)
        USE, INTRINSIC :: ISO_C_BINDING
        IMPLICIT NONE
        TYPE (Crystal_Struct), INTENT(IN) :: crystal
        INTEGER (C_INT), INTENT(IN) :: i_miller, j_miller, k_miller
        REAL (C_DOUBLE) :: rv

        TYPE (C_PTR) :: crystal_ptr
        TYPE (Crystal_Struct_C), TARGET :: crystal_c

        crystal_c%a = crystal%a
        crystal_c%b = crystal%b
        crystal_c%c = crystal%c
        crystal_c%alpha = crystal%alpha
        crystal_c%beta = crystal%beta
        crystal_c%gamma = crystal%gamma
        crystal_c%volume = crystal%volume
        crystal_c%n_atom = crystal%n_atom
        crystal_c%atom = C_LOC(crystal%atom(1))

        crystal_ptr = C_LOC(crystal_c)

        rv = Crystal_dSpacing_C(crystal_ptr, i_miller, j_miller, k_miller)
        RETURN
ENDFUNCTION Crystal_dSpacing

FUNCTION Crystal_AddCrystal (crystal, c_array) RESULT(rv)
        USE, INTRINSIC :: ISO_C_BINDING
        IMPLICIT NONE
        TYPE (Crystal_Array), INTENT(INOUT), OPTIONAL, TARGET :: c_array
        TYPE (Crystal_Struct), INTENT(IN) :: crystal
        INTEGER (C_INT) :: rv

        TYPE (C_PTR) :: crystal_ptr
        TYPE (Crystal_Struct_C), TARGET :: crystal_c

        crystal_c%a = crystal%a
        crystal_c%b = crystal%b
        crystal_c%c = crystal%c
        crystal_c%alpha = crystal%alpha
        crystal_c%beta = crystal%beta
        crystal_c%gamma = crystal%gamma
        crystal_c%volume = crystal%volume
        crystal_c%n_atom = crystal%n_atom
        crystal_c%atom = C_LOC(crystal%atom(1))

        crystal_ptr = C_LOC(crystal_c)

        IF (PRESENT(c_array)) THEN
                rv = Crystal_AddCrystal_C(crystal_ptr, C_LOC(c_array))
        ELSE
                rv = Crystal_AddCrystal_C(crystal_ptr, C_NULL_PTR)
        ENDIF
        RETURN
ENDFUNCTION Crystal_AddCrystal

FUNCTION Refractive_Index_Re(compoundString, E, density) RESULT(rv)
        USE, INTRINSIC :: ISO_C_BINDING
        IMPLICIT NONE

        CHARACTER (KIND=C_CHAR,LEN=*), INTENT(IN) :: compoundString
        REAL (C_DOUBLE), INTENT(IN) :: E, density
        CHARACTER (KIND=C_CHAR), DIMENSION(:), ALLOCATABLE, TARGET :: &
        compoundString_F
        INTEGER :: i
        REAL (C_DOUBLE) :: rv

        CALL stringF2C(compoundString, compoundString_F)

        rv = Refractive_Index_Re_C(C_LOC(compoundString_F), E, density)
ENDFUNCTION Refractive_Index_Re

FUNCTION Refractive_Index_Im(compoundString, E, density) RESULT(rv)
        USE, INTRINSIC :: ISO_C_BINDING
        IMPLICIT NONE

        CHARACTER (KIND=C_CHAR,LEN=*), INTENT(IN) :: compoundString
        REAL (C_DOUBLE), INTENT(IN) :: E, density
        CHARACTER (KIND=C_CHAR), DIMENSION(:), ALLOCATABLE, TARGET :: &
        compoundString_F
        INTEGER :: i
        REAL (C_DOUBLE) :: rv

        CALL stringF2C(compoundString, compoundString_F)

        rv = Refractive_Index_Im_C(C_LOC(compoundString_F), E, density)
ENDFUNCTION Refractive_Index_Im

FUNCTION Refractive_Index(compoundString, E, density) RESULT(rv)
        USE, INTRINSIC :: ISO_C_BINDING
        IMPLICIT NONE

        CHARACTER (KIND=C_CHAR,LEN=*), INTENT(IN) :: compoundString
        REAL (C_DOUBLE), INTENT(IN) :: E, density
        CHARACTER (KIND=C_CHAR), DIMENSION(:), ALLOCATABLE, TARGET :: &
        compoundString_F
        INTEGER :: i
        COMPLEX (C_DOUBLE) :: rv
        TYPE (xrlComplex_C) :: rv_C

        CALL stringF2C(compoundString, compoundString_F)

        rv_C = Refractive_Index_C(C_LOC(compoundString_F), E, density)
        rv = CMPLX(rv_C%re, rv_C%im, C_DOUBLE)
ENDFUNCTION Refractive_Index

FUNCTION GetCompoundDataNISTByName(compoundString) RESULT(rv)
        USE, INTRINSIC :: ISO_C_BINDING
        IMPLICIT NONE

        CHARACTER (KIND=C_CHAR,LEN=*), INTENT(IN) :: compoundString
        CHARACTER (KIND=C_CHAR), DIMENSION(:), ALLOCATABLE, TARGET :: &
        compoundString_F
        TYPE (compoundDataNIST), POINTER :: rv
        TYPE (compoundDataNIST_C), POINTER :: rv_C
        TYPE (C_PTR) :: rv_c_ptr
        INTEGER :: i

        NULLIFY(rv)

        CALL stringF2C(compoundString, compoundString_F)

        rv_c_ptr = GetCompoundDataNISTByName_C(C_LOC(compoundString_F))

        IF (C_ASSOCIATED(rv_c_ptr) .EQV. .TRUE.) THEN
                ALLOCATE(rv)
                CALL C_F_POINTER(rv_c_ptr, rv_C)
                rv%name = compoundString
                DO i=LEN_TRIM(compoundString)+1,LEN(rv%name)
                        rv%name(i:i) = ' '
                ENDDO
                rv%nElements = rv_C%nElements
                rv%density = rv_C%density
                CALL C_F_POINTER(rv_C%Elements, rv%Elements, [rv%nElements])
                CALL C_F_POINTER(rv_C%massFractions, rv%massFractions, [rv%nElements])
        ENDIF

        RETURN
ENDFUNCTION GetCompoundDataNISTByName

FUNCTION GetCompoundDataNISTByIndex(index) RESULT(rv)
        USE, INTRINSIC :: ISO_C_BINDING
        IMPLICIT NONE

        INTEGER (C_INT), INTENT(IN) :: index
        TYPE (compoundDataNIST), POINTER :: rv
        TYPE (compoundDataNIST_C), POINTER :: rv_C
        TYPE (C_PTR) :: rv_c_ptr
        INTEGER :: i
        CHARACTER (KIND=C_CHAR), DIMENSION(:), POINTER :: name_C

        INTERFACE
        PURE FUNCTION xrlstrlen(s) BIND(C,NAME='strlen')
                USE,INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                TYPE (C_PTR), INTENT(IN), VALUE :: s
                INTEGER (C_SIZE_T) :: xrlstrlen
        ENDFUNCTION xrlstrlen
        ENDINTERFACE

        NULLIFY(rv)

        rv_c_ptr = GetCompoundDataNISTByIndex_C(index)

        IF (C_ASSOCIATED(rv_c_ptr) .EQV. .TRUE.) THEN
                ALLOCATE(rv)
                CALL C_F_POINTER(rv_c_ptr, rv_C)
                CALL C_F_POINTER(rv_C%name, name_C, [xrlstrlen(rv_C%name)])
                DO i=1,xrlstrlen(rv_C%name)
                        rv%name(i:i)=name_C(i)
                ENDDO
                DO i=xrlstrlen(rv_C%name)+1,NIST_LIST_STRING_LENGTH
                        rv%name(i:i)=' '
                ENDDO
                NULLIFY(name_C)
                CALL xrlFree(rv_C%name)
                rv%nElements = rv_C%nElements
                rv%density = rv_C%density
                CALL C_F_POINTER(rv_C%Elements, rv%Elements, [rv%nElements])
                CALL C_F_POINTER(rv_C%massFractions, rv%massFractions, [rv%nElements])
        ENDIF

        RETURN
ENDFUNCTION GetCompoundDataNISTByIndex

SUBROUTINE FreeCompoundDataNIST(cdn)
        USE, INTRINSIC :: ISO_C_BINDING
        IMPLICIT NONE
        TYPE (compoundDataNIST), POINTER, INTENT(INOUT) :: cdn

        CALL xrlFree(C_LOC(cdn%Elements(1)))
        CALL xrlFree(C_LOC(cdn%massFractions(1)))
        DEALLOCATE(cdn)
ENDSUBROUTINE FreeCompoundDataNIST

FUNCTION GetCompoundDataNISTList() RESULT(rv)
        USE, INTRINSIC :: ISO_C_BINDING
        IMPLICIT NONE
        CHARACTER(KIND=C_CHAR, LEN=NIST_LIST_STRING_LENGTH), DIMENSION(:), POINTER :: rv
        INTEGER (C_INT) :: nCompounds
        TYPE (C_PTR) :: list_c_ptr
        TYPE (C_PTR), DIMENSION(:), POINTER :: list_c_ptrs
        INTEGER :: i,j
        CHARACTER (KIND=C_CHAR), DIMENSION(:), POINTER :: list_f

        INTERFACE
        PURE FUNCTION xrlstrlen(s) BIND(C,NAME='strlen')
                USE,INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                TYPE (C_PTR), INTENT(IN), VALUE :: s
                INTEGER (C_SIZE_T) :: xrlstrlen
        ENDFUNCTION xrlstrlen
        ENDINTERFACE

        list_c_ptr = GetCompoundDataNISTList_C(nCompounds)

        CALL C_F_POINTER(list_c_ptr, list_c_ptrs, [nCompounds])

        ALLOCATE(rv(nCompounds))

        DO i=1,nCompounds
                CALL C_F_POINTER(list_c_ptrs(i), list_f,&
                [xrlstrlen(list_c_ptrs(i))])
                DO j=1,xrlstrlen(list_c_ptrs(i))
                        rv(i)(j:j)=list_f(j)
                ENDDO
                DO j=xrlstrlen(list_c_ptrs(i))+1,NIST_LIST_STRING_LENGTH
                        rv(i)(j:j)=' '
                ENDDO
                NULLIFY(list_f)
                CALL xrlFree(list_c_ptrs(i))
        ENDDO
        NULLIFY(list_c_ptrs)
        CALL xrlFree(list_c_ptr)
ENDFUNCTION GetCompoundDataNISTList

FUNCTION CS_Total_CP(compound, E) RESULT(rv)
        USE, INTRINSIC :: ISO_C_BINDING
        IMPLICIT NONE

        CHARACTER (KIND=C_CHAR,LEN=*), INTENT(IN) :: compound
        CHARACTER (KIND=C_CHAR), DIMENSION(:), ALLOCATABLE, TARGET :: &
        compound_F
        REAL (C_DOUBLE), INTENT(IN) :: E
        REAL (C_DOUBLE) :: rv

        CALL stringF2C(compound, compound_F)

        rv = CS_Total_CP_C(C_LOC(compound_F), E)

ENDFUNCTION CS_Total_CP

FUNCTION CS_Photo_CP(compound, E) RESULT(rv)
        USE, INTRINSIC :: ISO_C_BINDING
        IMPLICIT NONE

        CHARACTER (KIND=C_CHAR,LEN=*), INTENT(IN) :: compound
        CHARACTER (KIND=C_CHAR), DIMENSION(:), ALLOCATABLE, TARGET :: &
        compound_F
        REAL (C_DOUBLE), INTENT(IN) :: E
        REAL (C_DOUBLE) :: rv

        CALL stringF2C(compound, compound_F)

        rv = CS_Photo_CP_C(C_LOC(compound_F), E)

ENDFUNCTION CS_Photo_CP

FUNCTION CS_Rayl_CP(compound, E) RESULT(rv)
        USE, INTRINSIC :: ISO_C_BINDING
        IMPLICIT NONE

        CHARACTER (KIND=C_CHAR,LEN=*), INTENT(IN) :: compound
        CHARACTER (KIND=C_CHAR), DIMENSION(:), ALLOCATABLE, TARGET :: &
        compound_F
        REAL (C_DOUBLE), INTENT(IN) :: E
        REAL (C_DOUBLE) :: rv

        CALL stringF2C(compound, compound_F)

        rv = CS_Rayl_CP_C(C_LOC(compound_F), E)

ENDFUNCTION CS_Rayl_CP

FUNCTION CS_Compt_CP(compound, E) RESULT(rv)
        USE, INTRINSIC :: ISO_C_BINDING
        IMPLICIT NONE

        CHARACTER (KIND=C_CHAR,LEN=*), INTENT(IN) :: compound
        CHARACTER (KIND=C_CHAR), DIMENSION(:), ALLOCATABLE, TARGET :: &
        compound_F
        REAL (C_DOUBLE), INTENT(IN) :: E
        REAL (C_DOUBLE) :: rv

        CALL stringF2C(compound, compound_F)

        rv = CS_Compt_CP_C(C_LOC(compound_F), E)

ENDFUNCTION CS_Compt_CP

FUNCTION CS_Energy_CP(compound, E) RESULT(rv)
        USE, INTRINSIC :: ISO_C_BINDING
        IMPLICIT NONE

        CHARACTER (KIND=C_CHAR,LEN=*), INTENT(IN) :: compound
        CHARACTER (KIND=C_CHAR), DIMENSION(:), ALLOCATABLE, TARGET :: &
        compound_F
        REAL (C_DOUBLE), INTENT(IN) :: E
        REAL (C_DOUBLE) :: rv

        CALL stringF2C(compound, compound_F)

        rv = CS_Energy_CP_C(C_LOC(compound_F), E)

ENDFUNCTION CS_Energy_CP

FUNCTION CSb_Total_CP(compound, E) RESULT(rv)
        USE, INTRINSIC :: ISO_C_BINDING
        IMPLICIT NONE

        CHARACTER (KIND=C_CHAR,LEN=*), INTENT(IN) :: compound
        CHARACTER (KIND=C_CHAR), DIMENSION(:), ALLOCATABLE, TARGET :: &
        compound_F
        REAL (C_DOUBLE), INTENT(IN) :: E
        REAL (C_DOUBLE) :: rv

        CALL stringF2C(compound, compound_F)

        rv = CSb_Total_CP_C(C_LOC(compound_F), E)

ENDFUNCTION CSb_Total_CP

FUNCTION CSb_Photo_CP(compound, E) RESULT(rv)
        USE, INTRINSIC :: ISO_C_BINDING
        IMPLICIT NONE

        CHARACTER (KIND=C_CHAR,LEN=*), INTENT(IN) :: compound
        CHARACTER (KIND=C_CHAR), DIMENSION(:), ALLOCATABLE, TARGET :: &
        compound_F
        REAL (C_DOUBLE), INTENT(IN) :: E
        REAL (C_DOUBLE) :: rv

        CALL stringF2C(compound, compound_F)

        rv = CSb_Photo_CP_C(C_LOC(compound_F), E)

ENDFUNCTION CSb_Photo_CP

FUNCTION CSb_Rayl_CP(compound, E) RESULT(rv)
        USE, INTRINSIC :: ISO_C_BINDING
        IMPLICIT NONE

        CHARACTER (KIND=C_CHAR,LEN=*), INTENT(IN) :: compound
        CHARACTER (KIND=C_CHAR), DIMENSION(:), ALLOCATABLE, TARGET :: &
        compound_F
        REAL (C_DOUBLE), INTENT(IN) :: E
        REAL (C_DOUBLE) :: rv

        CALL stringF2C(compound, compound_F)

        rv = CSb_Rayl_CP_C(C_LOC(compound_F), E)

ENDFUNCTION CSb_Rayl_CP

FUNCTION CSb_Compt_CP(compound, E) RESULT(rv)
        USE, INTRINSIC :: ISO_C_BINDING
        IMPLICIT NONE

        CHARACTER (KIND=C_CHAR,LEN=*), INTENT(IN) :: compound
        CHARACTER (KIND=C_CHAR), DIMENSION(:), ALLOCATABLE, TARGET :: &
        compound_F
        REAL (C_DOUBLE), INTENT(IN) :: E
        REAL (C_DOUBLE) :: rv

        CALL stringF2C(compound, compound_F)

        rv = CSb_Compt_CP_C(C_LOC(compound_F), E)

ENDFUNCTION CSb_Compt_CP

FUNCTION DCS_Rayl_CP(compound, E, theta) RESULT(rv)
        USE, INTRINSIC :: ISO_C_BINDING
        IMPLICIT NONE

        CHARACTER (KIND=C_CHAR,LEN=*), INTENT(IN) :: compound
        CHARACTER (KIND=C_CHAR), DIMENSION(:), ALLOCATABLE, TARGET :: &
        compound_F
        REAL (C_DOUBLE), INTENT(IN) :: E, theta
        REAL (C_DOUBLE) :: rv

        CALL stringF2C(compound, compound_F)

        rv = DCS_Rayl_CP_C(C_LOC(compound_F), E, theta)

ENDFUNCTION DCS_Rayl_CP

FUNCTION DCS_Compt_CP(compound, E, theta) RESULT(rv)
        USE, INTRINSIC :: ISO_C_BINDING
        IMPLICIT NONE

        CHARACTER (KIND=C_CHAR,LEN=*), INTENT(IN) :: compound
        CHARACTER (KIND=C_CHAR), DIMENSION(:), ALLOCATABLE, TARGET :: &
        compound_F
        REAL (C_DOUBLE), INTENT(IN) :: E, theta
        REAL (C_DOUBLE) :: rv

        CALL stringF2C(compound, compound_F)

        rv = DCS_Compt_CP_C(C_LOC(compound_F), E, theta)

ENDFUNCTION DCS_Compt_CP

FUNCTION DCSb_Rayl_CP(compound, E, theta) RESULT(rv)
        USE, INTRINSIC :: ISO_C_BINDING
        IMPLICIT NONE

        CHARACTER (KIND=C_CHAR,LEN=*), INTENT(IN) :: compound
        CHARACTER (KIND=C_CHAR), DIMENSION(:), ALLOCATABLE, TARGET :: &
        compound_F
        REAL (C_DOUBLE), INTENT(IN) :: E, theta
        REAL (C_DOUBLE) :: rv

        CALL stringF2C(compound, compound_F)

        rv = DCSb_Rayl_CP_C(C_LOC(compound_F), E, theta)

ENDFUNCTION DCSb_Rayl_CP

FUNCTION DCSb_Compt_CP(compound, E, theta) RESULT(rv)
        USE, INTRINSIC :: ISO_C_BINDING
        IMPLICIT NONE

        CHARACTER (KIND=C_CHAR,LEN=*), INTENT(IN) :: compound
        CHARACTER (KIND=C_CHAR), DIMENSION(:), ALLOCATABLE, TARGET :: &
        compound_F
        REAL (C_DOUBLE), INTENT(IN) :: E, theta
        REAL (C_DOUBLE) :: rv

        CALL stringF2C(compound, compound_F)

        rv = DCSb_Compt_CP_C(C_LOC(compound_F), E, theta)

ENDFUNCTION DCSb_Compt_CP

FUNCTION DCSP_Rayl_CP(compound, E, theta, phi) RESULT(rv)
        USE, INTRINSIC :: ISO_C_BINDING
        IMPLICIT NONE

        CHARACTER (KIND=C_CHAR,LEN=*), INTENT(IN) :: compound
        CHARACTER (KIND=C_CHAR), DIMENSION(:), ALLOCATABLE, TARGET :: &
        compound_F
        REAL (C_DOUBLE), INTENT(IN) :: E, theta, phi
        REAL (C_DOUBLE) :: rv

        CALL stringF2C(compound, compound_F)

        rv = DCSP_Rayl_CP_C(C_LOC(compound_F), E, theta, phi)

ENDFUNCTION DCSP_Rayl_CP

FUNCTION DCSP_Compt_CP(compound, E, theta, phi) RESULT(rv)
        USE, INTRINSIC :: ISO_C_BINDING
        IMPLICIT NONE

        CHARACTER (KIND=C_CHAR,LEN=*), INTENT(IN) :: compound
        CHARACTER (KIND=C_CHAR), DIMENSION(:), ALLOCATABLE, TARGET :: &
        compound_F
        REAL (C_DOUBLE), INTENT(IN) :: E, theta, phi
        REAL (C_DOUBLE) :: rv

        CALL stringF2C(compound, compound_F)

        rv = DCSP_Compt_CP_C(C_LOC(compound_F), E, theta, phi)

ENDFUNCTION DCSP_Compt_CP

FUNCTION DCSPb_Rayl_CP(compound, E, theta, phi) RESULT(rv)
        USE, INTRINSIC :: ISO_C_BINDING
        IMPLICIT NONE

        CHARACTER (KIND=C_CHAR,LEN=*), INTENT(IN) :: compound
        CHARACTER (KIND=C_CHAR), DIMENSION(:), ALLOCATABLE, TARGET :: &
        compound_F
        REAL (C_DOUBLE), INTENT(IN) :: E, theta, phi
        REAL (C_DOUBLE) :: rv

        CALL stringF2C(compound, compound_F)

        rv = DCSPb_Rayl_CP_C(C_LOC(compound_F), E, theta, phi)

ENDFUNCTION DCSPb_Rayl_CP

FUNCTION DCSPb_Compt_CP(compound, E, theta, phi) RESULT(rv)
        USE, INTRINSIC :: ISO_C_BINDING
        IMPLICIT NONE

        CHARACTER (KIND=C_CHAR,LEN=*), INTENT(IN) :: compound
        CHARACTER (KIND=C_CHAR), DIMENSION(:), ALLOCATABLE, TARGET :: &
        compound_F
        REAL (C_DOUBLE), INTENT(IN) :: E, theta, phi
        REAL (C_DOUBLE) :: rv

        CALL stringF2C(compound, compound_F)

        rv = DCSPb_Compt_CP_C(C_LOC(compound_F), E, theta, phi)

ENDFUNCTION DCSPb_Compt_CP

FUNCTION CS_Photo_Total_CP(compound, E) RESULT(rv)
        USE, INTRINSIC :: ISO_C_BINDING
        IMPLICIT NONE

        CHARACTER (KIND=C_CHAR,LEN=*), INTENT(IN) :: compound
        CHARACTER (KIND=C_CHAR), DIMENSION(:), ALLOCATABLE, TARGET :: &
        compound_F
        REAL (C_DOUBLE), INTENT(IN) :: E
        REAL (C_DOUBLE) :: rv

        CALL stringF2C(compound, compound_F)

        rv = CS_Photo_Total_CP_C(C_LOC(compound_F), E)

ENDFUNCTION CS_Photo_Total_CP

FUNCTION CS_Total_Kissel_CP(compound, E) RESULT(rv)
        USE, INTRINSIC :: ISO_C_BINDING
        IMPLICIT NONE

        CHARACTER (KIND=C_CHAR,LEN=*), INTENT(IN) :: compound
        CHARACTER (KIND=C_CHAR), DIMENSION(:), ALLOCATABLE, TARGET :: &
        compound_F
        REAL (C_DOUBLE), INTENT(IN) :: E
        REAL (C_DOUBLE) :: rv

        CALL stringF2C(compound, compound_F)

        rv = CS_Total_Kissel_CP_C(C_LOC(compound_F), E)

ENDFUNCTION CS_Total_Kissel_CP

FUNCTION CSb_Photo_Total_CP(compound, E) RESULT(rv)
        USE, INTRINSIC :: ISO_C_BINDING
        IMPLICIT NONE

        CHARACTER (KIND=C_CHAR,LEN=*), INTENT(IN) :: compound
        CHARACTER (KIND=C_CHAR), DIMENSION(:), ALLOCATABLE, TARGET :: &
        compound_F
        REAL (C_DOUBLE), INTENT(IN) :: E
        REAL (C_DOUBLE) :: rv

        CALL stringF2C(compound, compound_F)

        rv = CSb_Photo_Total_CP_C(C_LOC(compound_F), E)

ENDFUNCTION CSb_Photo_Total_CP

FUNCTION CSb_Total_Kissel_CP(compound, E) RESULT(rv)
        USE, INTRINSIC :: ISO_C_BINDING
        IMPLICIT NONE

        CHARACTER (KIND=C_CHAR,LEN=*), INTENT(IN) :: compound
        CHARACTER (KIND=C_CHAR), DIMENSION(:), ALLOCATABLE, TARGET :: &
        compound_F
        REAL (C_DOUBLE), INTENT(IN) :: E
        REAL (C_DOUBLE) :: rv

        CALL stringF2C(compound, compound_F)

        rv = CSb_Total_Kissel_CP_C(C_LOC(compound_F), E)

ENDFUNCTION CSb_Total_Kissel_CP



SUBROUTINE stringF2C(stringF, stringC)
        USE, INTRINSIC :: ISO_C_BINDING
        USE, INTRINSIC :: ISO_FORTRAN_ENV
        IMPLICIT NONE

        CHARACTER (KIND=C_CHAR,LEN=*), INTENT(IN) :: stringF
        CHARACTER (KIND=C_CHAR,LEN=512):: stringFcopy
        CHARACTER (KIND=C_CHAR), DIMENSION(:), ALLOCATABLE, INTENT(OUT) :: stringC
        INTEGER(8) :: i

        !for backwards compatibility
        IF (LEN(stringF) .GE. 512) THEN
                WRITE (error_unit, '(A)') 'Internal error: String too long for stringF2C'
                CALL EXIT(1)
        ENDIF
        DO i=1,LEN_TRIM(stringF)
                stringFcopy(i:i) = stringF(i:i)
        ENDDO
        DO i=LEN_TRIM(stringF)+1, LEN(stringFcopy)
                stringFcopy(i:i) = ' '
        ENDDO
        DO i=1,LEN(stringFcopy)
                IF (stringFcopy(i:i) .EQ. C_NULL_CHAR) THEN
                        stringFcopy(i:i) = ' '
                ENDIF
        ENDDO

        ALLOCATE(stringC(1+LEN_TRIM(stringFcopy)))
        DO i=1,LEN_TRIM(stringFcopy)
                stringC(i) = stringFcopy(i:i)
        ENDDO
        stringC(1+LEN_TRIM(stringFcopy)) = C_NULL_CHAR

        RETURN
ENDSUBROUTINE stringF2C

FUNCTION GetRadioNuclideDataByName(radioNuclideDataString) RESULT(rv)
        USE, INTRINSIC :: ISO_C_BINDING
        IMPLICIT NONE

        CHARACTER (KIND=C_CHAR,LEN=*), INTENT(IN) :: radioNuclideDataString
        CHARACTER (KIND=C_CHAR), DIMENSION(:), ALLOCATABLE, TARGET :: &
        radioNuclideDataString_F
        TYPE (radioNuclideData), POINTER :: rv
        TYPE (radioNuclideData_C), POINTER :: rv_C
        TYPE (C_PTR) :: rv_c_ptr
        INTEGER :: i

        NULLIFY(rv)

        CALL stringF2C(radioNuclideDataString, radioNuclideDataString_F)

        rv_c_ptr = GetRadioNuclideDataByName_C(C_LOC(radioNuclideDataString_F))

        IF (C_ASSOCIATED(rv_c_ptr) .EQV. .TRUE.) THEN
                ALLOCATE(rv)
                CALL C_F_POINTER(rv_c_ptr, rv_C)
                rv%name = radioNuclideDataString
                DO i=LEN_TRIM(radioNuclideDataString)+1,LEN(rv%name)
                        rv%name(i:i) = ' '
                ENDDO
                rv%Z = rv_C%Z
                rv%A = rv_C%A
                rv%N = rv_C%N
                rv%Z_xray = rv_C%Z_xray
                rv%nXrays = rv_C%nXrays
                rv%nGammas = rv_C%nGammas
                CALL C_F_POINTER(rv_C%XrayLines, rv%XrayLines, [rv%nXrays])
                CALL C_F_POINTER(rv_C%XrayIntensities, rv%XrayIntensities, [rv%nXrays])
                CALL C_F_POINTER(rv_C%GammaEnergies, rv%GammaEnergies, [rv%nGammas])
                CALL C_F_POINTER(rv_C%GammaIntensities, rv%GammaIntensities, [rv%nGammas])
        ENDIF

        RETURN
ENDFUNCTION GetRadioNuclideDataByName

FUNCTION GetRadioNuclideDataByIndex(index) RESULT(rv)
        USE, INTRINSIC :: ISO_C_BINDING
        IMPLICIT NONE

        INTEGER (C_INT), INTENT(IN) :: index
        TYPE (radioNuclideData), POINTER :: rv
        TYPE (radioNuclideData_C), POINTER :: rv_C
        TYPE (C_PTR) :: rv_c_ptr
        INTEGER :: i
        CHARACTER (KIND=C_CHAR), DIMENSION(:), POINTER :: name_C

        INTERFACE
        PURE FUNCTION xrlstrlen(s) BIND(C,NAME='strlen')
                USE,INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                TYPE (C_PTR), INTENT(IN), VALUE :: s
                INTEGER (C_SIZE_T) :: xrlstrlen
        ENDFUNCTION xrlstrlen
        ENDINTERFACE

        NULLIFY(rv)

        rv_c_ptr = GetRadioNuclideDataByIndex_C(index)

        IF (C_ASSOCIATED(rv_c_ptr) .EQV. .TRUE.) THEN
                ALLOCATE(rv)
                CALL C_F_POINTER(rv_c_ptr, rv_C)
                CALL C_F_POINTER(rv_C%name, name_C, [xrlstrlen(rv_C%name)])
                DO i=1,xrlstrlen(rv_C%name)
                        rv%name(i:i)=name_C(i)
                ENDDO
                DO i=xrlstrlen(rv_C%name)+1,RADIO_NUCLIDE_STRING_LENGTH
                        rv%name(i:i)=' '
                ENDDO
                NULLIFY(name_C)
                CALL xrlFree(rv_C%name)
                rv%Z = rv_C%Z
                rv%A = rv_C%A
                rv%N = rv_C%N
                rv%Z_xray = rv_C%Z_xray
                rv%nXrays = rv_C%nXrays
                rv%nGammas = rv_C%nGammas
                CALL C_F_POINTER(rv_C%XrayLines, rv%XrayLines, [rv%nXrays])
                CALL C_F_POINTER(rv_C%XrayIntensities, rv%XrayIntensities, [rv%nXrays])
                CALL C_F_POINTER(rv_C%GammaEnergies, rv%GammaEnergies, [rv%nGammas])
                CALL C_F_POINTER(rv_C%GammaIntensities, rv%GammaIntensities, [rv%nGammas])
        ENDIF


        RETURN
ENDFUNCTION GetRadioNuclideDataByIndex

SUBROUTINE FreeRadioNuclideData(cdn)
        USE, INTRINSIC :: ISO_C_BINDING
        IMPLICIT NONE
        TYPE (radioNuclideData), POINTER, INTENT(INOUT) :: cdn

        CALL xrlFree(C_LOC(cdn%XrayLines(1)))
        CALL xrlFree(C_LOC(cdn%XrayIntensities(1)))
        CALL xrlFree(C_LOC(cdn%GammaEnergies(1)))
        CALL xrlFree(C_LOC(cdn%GammaIntensities(1)))
        DEALLOCATE(cdn)
ENDSUBROUTINE FreeRadioNuclideData

FUNCTION GetRadioNuclideDataList() RESULT(rv)
        USE, INTRINSIC :: ISO_C_BINDING
        IMPLICIT NONE
        CHARACTER(KIND=C_CHAR, LEN=RADIO_NUCLIDE_STRING_LENGTH),&
        DIMENSION(:), POINTER :: rv
        INTEGER (C_INT) :: nNuclideDatas
        TYPE (C_PTR) :: list_c_ptr
        TYPE (C_PTR), DIMENSION(:), POINTER :: list_c_ptrs
        INTEGER :: i,j
        CHARACTER (KIND=C_CHAR), DIMENSION(:), POINTER :: list_f

        INTERFACE
        PURE FUNCTION xrlstrlen(s) BIND(C,NAME='strlen')
                USE,INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                TYPE (C_PTR), INTENT(IN), VALUE :: s
                INTEGER (C_SIZE_T) :: xrlstrlen
        ENDFUNCTION xrlstrlen
        ENDINTERFACE

        list_c_ptr = GetRadioNuclideDataList_C(nNuclideDatas)

        CALL C_F_POINTER(list_c_ptr, list_c_ptrs, [nNuclideDatas])

        ALLOCATE(rv(nNuclideDatas))

        DO i=1,nNuclideDatas
                CALL C_F_POINTER(list_c_ptrs(i), list_f,&
                [xrlstrlen(list_c_ptrs(i))])
                DO j=1,xrlstrlen(list_c_ptrs(i))
                        rv(i)(j:j)=list_f(j)
                ENDDO
                DO j=xrlstrlen(list_c_ptrs(i))+1,RADIO_NUCLIDE_STRING_LENGTH
                        rv(i)(j:j)=' '
                ENDDO
                NULLIFY(list_f)
                CALL xrlFree(list_c_ptrs(i))
        ENDDO
        NULLIFY(list_c_ptrs)
        CALL xrlFree(list_c_ptr)
ENDFUNCTION GetRadioNuclideDataList

FUNCTION Crystal_GetCrystalsList(c_array) RESULT(rv)
        USE, INTRINSIC :: ISO_C_BINDING
        IMPLICIT NONE
        TYPE (Crystal_Array), INTENT(INOUT), OPTIONAL, TARGET :: c_array
        CHARACTER(KIND=C_CHAR, LEN=CRYSTAL_STRING_LENGTH),&
        DIMENSION(:), POINTER :: rv
        INTEGER (C_INT) :: nCrystals
        TYPE (C_PTR) :: list_c_ptr
        TYPE (C_PTR), DIMENSION(:), POINTER :: list_c_ptrs
        INTEGER :: i,j
        CHARACTER (KIND=C_CHAR), DIMENSION(:), POINTER :: list_f

        INTERFACE
        PURE FUNCTION xrlstrlen(s) BIND(C,NAME='strlen')
                USE,INTRINSIC :: ISO_C_BINDING
                IMPLICIT NONE
                TYPE (C_PTR), INTENT(IN), VALUE :: s
                INTEGER (C_SIZE_T) :: xrlstrlen
        ENDFUNCTION xrlstrlen
        ENDINTERFACE

        IF (PRESENT(c_array)) THEN
          list_c_ptr = Crystal_GetCrystalsList_C(C_LOC(c_array), nCrystals)
        ELSE
          list_c_ptr = Crystal_GetCrystalsList_C(C_NULL_PTR, nCrystals)
        ENDIF

        CALL C_F_POINTER(list_c_ptr, list_c_ptrs, [nCrystals])

        ALLOCATE(rv(nCrystals))

        DO i=1,nCrystals
                CALL C_F_POINTER(list_c_ptrs(i), list_f,&
                [xrlstrlen(list_c_ptrs(i))])
                DO j=1,xrlstrlen(list_c_ptrs(i))
                        rv(i)(j:j)=list_f(j)
                ENDDO
                DO j=xrlstrlen(list_c_ptrs(i))+1,CRYSTAL_STRING_LENGTH
                        rv(i)(j:j)=' '
                ENDDO
                NULLIFY(list_f)
                CALL xrlFree(list_c_ptrs(i))
        ENDDO
        NULLIFY(list_c_ptrs)
        CALL xrlFree(list_c_ptr)
ENDFUNCTION Crystal_GetCrystalsList
ENDMODULE
