/*
 * Copyright (c) 2001, 2002 The XDoclet team
 * All rights reserved.
 */
package xdoclet.modules.wsee;

import xdoclet.XDocletException;
import xdoclet.XmlSubTask;
import xdoclet.util.Translator;

/**
 * Subtask that generates the jaxrpc-mapping.xml deployment descriptor.
 *
 * @author        Christoph G. Jung (christoph.jung@infor.de)
 * @created       23.12.03
 * @ant.element   display-name="jaxrpc-mapping.xml" name="jaxrpc-mapping" parent="xdoclet.modules.wsee.WseeDocletTask"
 * @version       $Revision: 1.1 $
 */

public class JaxrpcMappingSubTask extends XmlSubTask
{
    /**
     * constants
     */
    private static String DEFAULT_TEMPLATE_FILE =
        "resources/jaxrpc-mapping_xml.xdt";

    /**
     * initialise template
     */
    public JaxrpcMappingSubTask()
    {
        setTemplateURL(getClass().getResource(DEFAULT_TEMPLATE_FILE));
    }

    /**
     * runs the subtask
     *
     * @exception XDocletException
     */
    public void execute() throws XDocletException
    {
        validateOptions();
        startProcess();
    }

    /*
     * validates presence of a file location
     * @see xdoclet.SubTask#validateOptions()
     */
    public void validateOptions() throws XDocletException
    {
        setDestinationFile(
            (String) getContext().getConfigParam("JaxrpcMappingFile"));
        super.validateOptions();
    }

    /**
     * notify start of task
     *
     * @exception XDocletException
     */
    protected void engineStarted() throws XDocletException
    {
        System.out.println(
            Translator.getString(
            XDocletModulesMessages.class,
            XDocletModulesMessages.GENERATING_JAXRPC_MAPPING_DESCRIPTOR,
            new String[]{getDestinationFile()}));
    }

}
