/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.acm.seguin.awt.ExceptionPrinter;
import org.acm.seguin.tools.install.RefactoryInstaller;
import org.acm.seguin.util.MissingSettingsException;
import org.acm.seguin.util.NoSettingsFileException;
import org.acm.seguin.util.SettingNotFoundException;
import org.acm.seguin.util.Settings;

public class FileSettings
implements Settings {
    private String app;
    private String type;
    private File file;
    private long lastModified;
    private Properties props;
    private boolean continuallyReload;
    private boolean reloadNow;
    private FileSettings parent;
    private static Hashtable map = null;
    private static File settingsRoot = null;

    public FileSettings(File file) throws MissingSettingsException {
        this.file = file;
        if (!this.file.exists()) {
            throw new NoSettingsFileException(this.app, this.type);
        }
        this.load();
        this.app = file.getParent();
        this.type = file.getName();
        this.continuallyReload = false;
        this.reloadNow = false;
        this.parent = null;
    }

    protected FileSettings(String string, String string2) throws MissingSettingsException {
        File file = new File(FileSettings.getSettingsRoot(), "." + string);
        if (!file.exists()) {
            file.mkdirs();
            throw new NoSettingsFileException(string, string2);
        }
        this.file = new File(file, string2 + ".settings");
        if (!this.file.exists()) {
            throw new NoSettingsFileException(string, string2);
        }
        this.load();
        this.app = string;
        this.type = string2;
        this.continuallyReload = false;
        this.reloadNow = false;
        this.parent = null;
    }

    public void setContinuallyReload(boolean bl) {
        this.continuallyReload = bl;
    }

    public void setReloadNow(boolean bl) {
        this.reloadNow = bl;
        if (this.reloadNow) {
            this.load();
        }
    }

    public Enumeration getKeys() {
        if (!this.isUpToDate()) {
            this.load();
        }
        this.reloadNow = false;
        return ((Hashtable)this.props).keys();
    }

    public String getString(String string) {
        if (!this.isUpToDate()) {
            this.load();
        }
        this.reloadNow = false;
        String string2 = this.props.getProperty(string);
        if (string2 == null && this.parent != null) {
            string2 = this.parent.getString(string);
        }
        if (string2 == null) {
            throw new SettingNotFoundException(this.app, this.type, string);
        }
        return string2;
    }

    public int getInteger(String string) {
        try {
            return Integer.parseInt(this.getString(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new SettingNotFoundException(this.app, this.type, string);
        }
    }

    public double getDouble(String string) {
        try {
            Double d = new Double(this.getString(string));
            return d;
        }
        catch (NumberFormatException numberFormatException) {
            throw new SettingNotFoundException(this.app, this.type, string);
        }
    }

    public boolean getBoolean(String string) {
        try {
            Boolean bl = new Boolean(this.getString(string));
            return bl;
        }
        catch (NumberFormatException numberFormatException) {
            throw new SettingNotFoundException(this.app, this.type, string);
        }
    }

    protected void setParent(FileSettings fileSettings) {
        this.parent = fileSettings;
    }

    private char getSpecial(char c) {
        switch (c) {
            case 'b': {
                return '\b';
            }
            case 'r': {
                return '\r';
            }
            case 'n': {
                return '\n';
            }
            case 'f': {
                return '\f';
            }
            case 't': {
                return '\t';
            }
        }
        return c;
    }

    private boolean isUpToDate() {
        if (this.continuallyReload || this.reloadNow) {
            return this.lastModified == this.file.lastModified();
        }
        return true;
    }

    private synchronized void load() {
        this.props = new Properties();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.file));
            String string = bufferedReader.readLine();
            while (string != null) {
                int n;
                if (string.length() != 0 && string.charAt(0) != '#' && (n = string.indexOf(61)) > 0) {
                    String string2 = string.substring(0, n);
                    String string3 = this.unescapeChars(string.substring(n + 1));
                    ((Hashtable)this.props).put(string2, string3);
                }
                string = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            ExceptionPrinter.print(iOException, false);
        }
        this.setReloadNow(false);
        this.lastModified = this.file.lastModified();
    }

    private String unescapeChars(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '\\') {
                char c2 = string.charAt(n2 + 1);
                char c3 = ' ';
                if (c2 == 'u') {
                    c3 = this.unicode(string, n2);
                    n2 += 5;
                } else if (Character.isDigit(c2)) {
                    c3 = this.octal(string, n2);
                    n2 += 3;
                } else if (n2 != n - 1) {
                    c3 = this.getSpecial(c2);
                    ++n2;
                }
                stringBuffer.append(c3);
            } else {
                stringBuffer.append(c);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    private char unicode(String string, int n) {
        String string2 = string.substring(n + 2, n + 6);
        int n2 = Integer.parseInt(string2, 16);
        return (char)n2;
    }

    private char octal(String string, int n) {
        String string2 = string.substring(n + 1, n + 4);
        int n2 = Integer.parseInt(string2, 8);
        return (char)n2;
    }

    public static void setSettingsRoot(String string) {
        settingsRoot = new File(string);
    }

    public static void setSettingsRoot(File file) {
        settingsRoot = file;
    }

    public static FileSettings getSettings(String string, String string2) {
        String string3;
        FileSettings fileSettings;
        if (map == null) {
            FileSettings.init();
        }
        if ((fileSettings = (FileSettings)map.get(string3 = string + "::" + string2)) == null) {
            fileSettings = new FileSettings(string, string2);
            map.put(string3, fileSettings);
        }
        return fileSettings;
    }

    public static String getSettingsRoot() {
        if (settingsRoot == null) {
            FileSettings.initRootDir();
        }
        return settingsRoot.getPath();
    }

    public static void main(String[] stringArray) {
        new RefactoryInstaller(false).run();
        String string = "author";
        if (stringArray.length > 0) {
            string = stringArray[0];
        }
        String string2 = "pretty";
        if (stringArray.length > 1) {
            string2 = stringArray[1];
        }
        String string3 = "Refactory";
        if (stringArray.length > 2) {
            string3 = stringArray[2];
        }
        System.out.println("Found:  " + new FileSettings(string3, string2).getString(string));
    }

    private static synchronized void init() {
        if (map == null) {
            map = new Hashtable();
            FileSettings.initRootDir();
        }
    }

    private static void initRootDir() {
        File file;
        if (settingsRoot != null) {
            return;
        }
        String string = System.getProperty("jrefactory.home");
        if (string != null) {
            settingsRoot = new File(string);
            return;
        }
        string = System.getProperty("user.home");
        if (string != null) {
            settingsRoot = new File(string);
            return;
        }
        settingsRoot = new File("~/");
        if (settingsRoot.exists()) {
            return;
        }
        settingsRoot = new File("C:\\winnt\\profiles");
        if (settingsRoot.exists() && (file = new File(settingsRoot, System.getProperty("user.name"))).exists()) {
            settingsRoot = file;
            return;
        }
        settingsRoot = new File("c:\\windows");
    }

    public File getFile() {
        return this.file;
    }
}

