/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.util;

import java.io.File;
import org.acm.seguin.io.DirectoryTreeTraversal;
import org.acm.seguin.io.FileCopy;
import org.acm.seguin.tools.install.RefactoryInstaller;

public class BackupTraversal
extends DirectoryTreeTraversal {
    private String dest;

    public BackupTraversal(String string, String string2) {
        super(string);
        this.dest = string2.charAt(string2.length() - 1) != File.separatorChar ? string2 + File.separator : string2;
    }

    protected boolean isTarget(File file) {
        String string = file.getName();
        String string2 = string.toLowerCase();
        if (!string2.endsWith(".java")) {
            return false;
        }
        String string3 = string2.substring(0, string2.length() - 5) + ".class";
        File file2 = new File(file.getParentFile(), string3);
        return file2.exists();
    }

    protected void visit(File file) {
        String string = this.getDestination(file);
        File file2 = new File(string);
        new FileCopy(file, file2).run();
    }

    protected void arriveAtDir(File file) {
        String string = file.getPath();
        String string2 = "";
        string2 = string.startsWith("./") || string.startsWith(".\\") ? string.substring(2) : string;
        this.createDir(this.dest + "src/" + string2);
        this.createDir(this.dest + "test/src/" + string2);
    }

    private String getDestination(File file) {
        String string;
        String string2 = "src/";
        if (file.getName().startsWith("Test")) {
            string2 = "test/src/";
        }
        if ((string = file.getPath()).startsWith("./") || string.startsWith(".\\")) {
            return this.dest + string2 + string.substring(2);
        }
        return this.dest + string2 + string;
    }

    public static void main(String[] stringArray) {
        new RefactoryInstaller(false).run();
        if (stringArray.length != 2) {
            System.out.println("Syntax:  java BackupTraversal source dest");
            return;
        }
        new BackupTraversal(stringArray[0], stringArray[1]).go();
    }

    private void createDir(String string) {
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    private void deleteDir(String string) {
        File file = new File(string);
        String[] stringArray = file.list();
        if (stringArray.length == 0) {
            file.delete();
        }
    }

    protected void leaveDir(File file) {
        String string = file.getPath();
        String string2 = "";
        string2 = string.startsWith("./") || string.startsWith(".\\") ? string.substring(2) : string;
        this.deleteDir(this.dest + "src/" + string2);
        this.deleteDir(this.dest + "test/src/" + string2);
    }
}

