/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.uml.refactor;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Iterator;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import org.acm.seguin.awt.CenterDialog;
import org.acm.seguin.refactor.Refactoring;
import org.acm.seguin.refactor.RefactoringFactory;
import org.acm.seguin.refactor.method.RenameParameterRefactoring;
import org.acm.seguin.summary.MethodSummary;
import org.acm.seguin.summary.ParameterSummary;
import org.acm.seguin.uml.UMLPackage;
import org.acm.seguin.uml.refactor.ClassNameDialog;

class RenameParameterDialog
extends ClassNameDialog {
    private ParameterSummary param;
    private MethodSummary method;
    private JComboBox parameterSelection;

    public RenameParameterDialog(UMLPackage uMLPackage, ParameterSummary parameterSummary) {
        super(uMLPackage, 0);
        this.param = parameterSummary;
        this.method = (MethodSummary)this.param.getParent();
        if (this.method == null) {
            System.out.println("No method specified");
        }
        this.setTitle(this.getWindowTitle());
        this.pack();
        CenterDialog.center((JDialog)this, uMLPackage);
    }

    public RenameParameterDialog(UMLPackage uMLPackage, MethodSummary methodSummary) {
        super(uMLPackage, 1);
        this.param = null;
        this.method = methodSummary;
        if (this.method == null) {
            System.out.println("No method specified");
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = new JLabel("Parameter:  ");
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        GridBagLayout gridBagLayout = (GridBagLayout)this.getContentPane().getLayout();
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.getContentPane().add(jLabel);
        this.parameterSelection = new JComboBox();
        Iterator iterator = this.method.getParameters();
        while (iterator.hasNext()) {
            this.parameterSelection.addItem(iterator.next());
        }
        this.parameterSelection.setEditable(false);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.parameterSelection, gridBagConstraints);
        this.getContentPane().add(this.parameterSelection);
        this.setTitle(this.getWindowTitle());
        this.pack();
        CenterDialog.center((JDialog)this, uMLPackage);
    }

    public String getWindowTitle() {
        if (this.param == null) {
            return "Renaming a parameter";
        }
        return "Renaming the parameter " + this.param.getName() + " in " + this.method.getName();
    }

    public String getLabelText() {
        return "New parameter name:";
    }

    protected Refactoring createRefactoring() {
        RenameParameterRefactoring renameParameterRefactoring = RefactoringFactory.get().renameParameter();
        renameParameterRefactoring.setMethodSummary(this.method);
        if (this.param == null) {
            Object object = this.parameterSelection.getSelectedItem();
            renameParameterRefactoring.setParameterSummary((ParameterSummary)object);
        } else {
            renameParameterRefactoring.setParameterSummary(this.param);
        }
        renameParameterRefactoring.setNewName(this.getClassName());
        return renameParameterRefactoring;
    }
}

