/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.uml.refactor;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.acm.seguin.awt.ExceptionPrinter;
import org.acm.seguin.refactor.Refactoring;
import org.acm.seguin.refactor.RefactoringException;
import org.acm.seguin.uml.UMLPackage;
import org.acm.seguin.uml.loader.ReloaderSingleton;

abstract class RefactoringDialog
extends JDialog
implements ActionListener {
    private UMLPackage currentPackage;

    public RefactoringDialog(UMLPackage uMLPackage) {
        this.currentPackage = uMLPackage;
    }

    public RefactoringDialog(UMLPackage uMLPackage, JFrame jFrame) {
        super(jFrame);
        this.currentPackage = uMLPackage;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("OK")) {
            this.dispose();
            this.runRefactoring();
        } else if (actionEvent.getActionCommand().equals("Cancel")) {
            this.dispose();
        }
        if (this.currentPackage != null) {
            this.currentPackage.repaint();
        }
    }

    protected UMLPackage getUMLPackage() {
        return this.currentPackage;
    }

    protected abstract Refactoring createRefactoring();

    protected void updateSummaries() {
    }

    private void runRefactoring() {
        Refactoring refactoring = this.createRefactoring();
        try {
            refactoring.run();
        }
        catch (RefactoringException refactoringException) {
            JOptionPane.showMessageDialog(null, refactoringException.getMessage(), "Refactoring Exception", 0);
        }
        catch (Throwable throwable) {
            ExceptionPrinter.print(throwable, true);
        }
        this.followup(refactoring);
    }

    protected void followup(Refactoring refactoring) {
        this.updateSummaries();
        ReloaderSingleton.reload();
    }
}

