/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.uml.refactor;

import java.util.Iterator;
import org.acm.seguin.refactor.Refactoring;
import org.acm.seguin.refactor.RefactoringFactory;
import org.acm.seguin.refactor.method.PushDownMethodRefactoring;
import org.acm.seguin.summary.MethodSummary;
import org.acm.seguin.summary.TypeSummary;
import org.acm.seguin.uml.UMLPackage;
import org.acm.seguin.uml.refactor.ChildrenCheckboxDialog;
import org.acm.seguin.uml.refactor.TypeCheckbox;

class PushDownMethodDialog
extends ChildrenCheckboxDialog {
    private MethodSummary methodSummary;

    public PushDownMethodDialog(UMLPackage uMLPackage, TypeSummary typeSummary, MethodSummary methodSummary) {
        super(uMLPackage, typeSummary);
        this.methodSummary = methodSummary;
        this.setTitle("Push field " + this.methodSummary.toString() + " from " + this.parentType.getName() + " to:");
    }

    protected Refactoring createRefactoring() {
        PushDownMethodRefactoring pushDownMethodRefactoring = RefactoringFactory.get().pushDownMethod();
        pushDownMethodRefactoring.setMethod(this.methodSummary);
        Iterator iterator = this.children.getCheckboxes();
        while (iterator.hasNext()) {
            TypeCheckbox typeCheckbox = (TypeCheckbox)iterator.next();
            if (!typeCheckbox.isSelected()) continue;
            pushDownMethodRefactoring.addChild(typeCheckbox.getTypeSummary());
        }
        return pushDownMethodRefactoring;
    }
}

