/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.uml.refactor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.acm.seguin.awt.CenterDialog;
import org.acm.seguin.awt.ExceptionPrinter;
import org.acm.seguin.refactor.RefactoringException;
import org.acm.seguin.refactor.RefactoringFactory;
import org.acm.seguin.refactor.type.MoveClass;
import org.acm.seguin.summary.FileSummary;
import org.acm.seguin.summary.TypeSummary;
import org.acm.seguin.uml.loader.ReloaderSingleton;
import org.acm.seguin.uml.refactor.PackageList;

public class NewPackageDialog
extends JDialog
implements ActionListener {
    private JComboBox packageName;
    private TypeSummary[] typeArray;

    public NewPackageDialog(TypeSummary[] typeSummaryArray) {
        this.typeArray = typeSummaryArray;
        this.setTitle("Move class to new package");
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.getContentPane().setLayout(gridBagLayout);
        ((Component)this).setSize(310, 150);
        PackageList packageList = new PackageList();
        this.packageName = packageList.add(this);
        JButton jButton = new JButton("OK");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(jButton, gridBagConstraints);
        jButton.addActionListener(this);
        this.getContentPane().add(jButton);
        JButton jButton2 = new JButton("Cancel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(jButton2, gridBagConstraints);
        jButton2.addActionListener(this);
        this.getContentPane().add(jButton2);
        JPanel jPanel = new JPanel();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        Dimension dimension = new Dimension(50, jButton2.getPreferredSize().height * 4);
        jPanel.setMinimumSize(dimension);
        jPanel.setPreferredSize(dimension);
        this.getContentPane().add((Component)jPanel, gridBagConstraints);
        this.pack();
        CenterDialog.center(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("OK")) {
            this.dispose();
            String string = (String)this.packageName.getSelectedItem();
            if (string.startsWith("<")) {
                string = "";
            }
            this.repackage(string);
        } else if (actionEvent.getActionCommand().equals("Cancel")) {
            this.dispose();
        }
    }

    public void repackage(String string) {
        MoveClass moveClass = RefactoringFactory.get().moveClass();
        moveClass.setDestinationPackage(string);
        String string2 = null;
        int n = 0;
        while (n < this.typeArray.length) {
            string2 = this.addType(this.typeArray[n], moveClass);
            ++n;
        }
        try {
            moveClass.run();
        }
        catch (RefactoringException refactoringException) {
            JOptionPane.showMessageDialog(null, refactoringException.getMessage(), "Refactoring Exception", 0);
        }
        ReloaderSingleton.reload();
    }

    private String addType(TypeSummary typeSummary, MoveClass moveClass) {
        String string = null;
        FileSummary fileSummary = (FileSummary)typeSummary.getParent();
        File file = fileSummary.getFile();
        if (file == null) {
            return null;
        }
        try {
            String string2 = file.getCanonicalPath();
            string = new File(string2).getParent();
        }
        catch (IOException iOException) {
            ExceptionPrinter.print(iOException, false);
        }
        moveClass.setDirectory(string);
        moveClass.add(file.getName());
        return string;
    }
}

