/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.uml.refactor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.acm.seguin.awt.CenterDialog;
import org.acm.seguin.awt.OrderableList;
import org.acm.seguin.refactor.Refactoring;
import org.acm.seguin.refactor.RefactoringException;
import org.acm.seguin.refactor.RefactoringFactory;
import org.acm.seguin.refactor.method.ExtractMethodRefactoring;
import org.acm.seguin.summary.VariableSummary;
import org.acm.seguin.uml.refactor.RefactoringDialog;
import org.acm.seguin.uml.refactor.SignatureUpdateAdapter;
import org.acm.seguin.uml.refactor.VariableListCellRenderer;

public abstract class ExtractMethodDialog
extends RefactoringDialog {
    private JTextField newName;
    private ExtractMethodRefactoring emr;
    private OrderableList list;
    private JRadioButton privateButton;
    private JRadioButton packageButton;
    private JRadioButton protectedButton;
    private JRadioButton publicButton;
    private JList returnList;
    private JTextField returnTextField;
    private JLabel signatureLabel;
    private SignatureUpdateAdapter sua = new SignatureUpdateAdapter(this);
    private JLabel sizer;
    private Dimension originalSize;

    public ExtractMethodDialog(JFrame jFrame) throws RefactoringException {
        super(null, jFrame);
        JComponent jComponent;
        this.init();
        this.setTitle(this.getWindowTitle());
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.getContentPane().setLayout(gridBagLayout);
        ((Component)this).setSize(310, 120);
        Insets insets = new Insets(0, 0, 0, 0);
        int n = 1;
        JLabel jLabel = new JLabel(this.getLabelText());
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.getContentPane().add(jLabel);
        this.newName = new JTextField();
        this.newName.setColumns(40);
        this.newName.getDocument().addDocumentListener(this.sua);
        this.newName.addFocusListener(this.sua);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = insets;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.newName, gridBagConstraints);
        this.getContentPane().add(this.newName);
        JLabel jLabel2 = new JLabel("Parameters:  ");
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.getContentPane().add((Component)jLabel2, gridBagConstraints);
        Object[] objectArray = this.emr.getParameters();
        if (objectArray.length > 1) {
            this.list = new OrderableList(objectArray, new VariableListCellRenderer());
            this.list.addListDataListener(this.sua);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = n;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.insets = insets;
            gridBagConstraints.fill = 10;
            gridBagLayout.setConstraints(this.list, gridBagConstraints);
            this.getContentPane().add(this.list);
        } else {
            jComponent = objectArray.length == 0 ? new JLabel("There are no parameters required for this method") : new JLabel("There is only one parameter required for this method:  " + ((VariableSummary)objectArray[0]).getName());
            this.list = null;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = n;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.insets = insets;
            gridBagConstraints.fill = 10;
            gridBagLayout.setConstraints(jComponent, gridBagConstraints);
            this.getContentPane().add(jComponent);
        }
        ++n;
        jComponent = this.initRadioButtons();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = insets;
        gridBagConstraints.fill = 10;
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        this.getContentPane().add(jComponent);
        JLabel jLabel3 = new JLabel("Return:");
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(10, 0, 10, 10);
        gridBagLayout.setConstraints(jLabel3, gridBagConstraints);
        this.getContentPane().add(jLabel3);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = insets;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        gridBagConstraints.fill = 2;
        if (this.emr.isStatement()) {
            this.returnList = new JList<Object>(this.emr.getReturnTypes());
            this.returnList.setSelectedIndex(0);
            gridBagLayout.setConstraints(this.returnList, gridBagConstraints);
            this.getContentPane().add(this.returnList);
            this.returnList.addListSelectionListener(this.sua);
            this.returnTextField = null;
        } else {
            this.returnTextField = new JTextField(this.emr.getReturnType().toString());
            gridBagLayout.setConstraints(this.returnTextField, gridBagConstraints);
            this.getContentPane().add(this.returnTextField);
            this.returnTextField.getDocument().addDocumentListener(this.sua);
            this.returnTextField.addFocusListener(this.sua);
            this.returnList = null;
        }
        JLabel jLabel4 = new JLabel("Signature:");
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = ++n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(10, 0, 10, 10);
        gridBagLayout.setConstraints(jLabel4, gridBagConstraints);
        this.getContentPane().add(jLabel4);
        this.signatureLabel = new JLabel("");
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = insets;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.signatureLabel, gridBagConstraints);
        this.getContentPane().add(this.signatureLabel);
        JButton jButton = new JButton("OK");
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = insets;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(jButton, gridBagConstraints);
        jButton.addActionListener(this);
        this.getContentPane().add(jButton);
        JButton jButton2 = new JButton("Cancel");
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(jButton2, gridBagConstraints);
        jButton2.addActionListener(this);
        this.getContentPane().add(jButton2);
        this.update();
        this.pack();
        this.sizer = new JLabel();
        this.originalSize = this.signatureLabel.getSize();
        CenterDialog.center((JDialog)this, jFrame);
    }

    public String getWindowTitle() {
        return "Extract Method Dialog";
    }

    public String getLabelText() {
        return "Method name:";
    }

    public void update() {
        this.createRefactoring();
        String string = this.emr.getSignature();
        if (this.sizer != null) {
            this.sizer.setText(string);
            Dimension dimension = this.sizer.getPreferredSize();
            int n = string.length();
            while (dimension.width > this.originalSize.width) {
                string = string.substring(0, --n) + "...";
                this.sizer.setText(string);
                dimension = this.sizer.getPreferredSize();
            }
        }
        this.signatureLabel.setText(string);
    }

    protected abstract void setStringInIDE(String var1);

    protected abstract String getStringFromIDE();

    protected abstract String getSelectionFromIDE();

    protected void followup(Refactoring refactoring) {
        ExtractMethodRefactoring extractMethodRefactoring = (ExtractMethodRefactoring)refactoring;
        this.setStringInIDE(extractMethodRefactoring.getFullFile());
    }

    protected Refactoring createRefactoring() {
        this.emr.setMethodName(this.newName.getText());
        if (this.list != null) {
            this.emr.setParameterOrder(this.list.getData());
        }
        int n = 0;
        if (this.packageButton.isSelected()) {
            n = 1;
        }
        if (this.protectedButton.isSelected()) {
            n = 2;
        }
        if (this.publicButton.isSelected()) {
            n = 3;
        }
        this.emr.setProtection(n);
        if (this.returnTextField == null) {
            Object e = this.returnList.getSelectedValue();
            this.emr.setReturnType(e);
        } else {
            this.emr.setReturnType(this.returnTextField.getText());
        }
        return this.emr;
    }

    private void init() throws RefactoringException {
        this.emr = RefactoringFactory.get().extractMethod();
        String string = this.getStringFromIDE();
        if (string == null) {
            this.dispose();
            throw new RefactoringException("Invalid file for extracting the source code");
        }
        this.emr.setFullFile(string);
        String string2 = this.getSelectionFromIDE();
        if (string == null) {
            JOptionPane.showMessageDialog(null, "You must select a series of statements or an expression to extract.", "Extract Method Error", 0);
            this.dispose();
            throw new RefactoringException("Empty selection.");
        }
        this.emr.setSelection(string2);
        this.emr.setMethodName("extractedMethod");
    }

    private JPanel initRadioButtons() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        JLabel jLabel = new JLabel("Protection:");
        jPanel.add(jLabel);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.privateButton = new JRadioButton("private");
        this.privateButton.setSelected(true);
        jPanel.add(this.privateButton);
        buttonGroup.add(this.privateButton);
        this.privateButton.addActionListener(this.sua);
        this.packageButton = new JRadioButton("package");
        jPanel.add(this.packageButton);
        buttonGroup.add(this.packageButton);
        this.packageButton.addActionListener(this.sua);
        this.protectedButton = new JRadioButton("protected");
        jPanel.add(this.protectedButton);
        buttonGroup.add(this.protectedButton);
        this.protectedButton.addActionListener(this.sua);
        this.publicButton = new JRadioButton("public");
        jPanel.add(this.publicButton);
        buttonGroup.add(this.publicButton);
        this.publicButton.addActionListener(this.sua);
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        return jPanel;
    }
}

