/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.uml.print;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import org.acm.seguin.print.PagePrinter;
import org.acm.seguin.uml.UMLPackage;

public class UMLPagePrinter
extends PagePrinter {
    private UMLPackage currentPackage;

    public UMLPagePrinter(UMLPackage uMLPackage) {
        this.currentPackage = uMLPackage;
    }

    public int calculatePageCount(PageFormat pageFormat) {
        Dimension dimension = this.currentPackage.getPreferredSize();
        int n = (int)pageFormat.getImageableHeight() - PagePrinter.headerHeight;
        int n2 = (int)pageFormat.getImageableWidth();
        int n3 = (int)(1.0 + PagePrinter.getScale() * (double)dimension.width / (double)n2);
        int n4 = (int)(1.0 + PagePrinter.getScale() * (double)dimension.height / (double)n);
        return n3 * n4;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        int n2;
        Dimension dimension = this.currentPackage.getPreferredSize();
        int n3 = (int)pageFormat.getImageableHeight() - PagePrinter.headerHeight;
        int n4 = (int)pageFormat.getImageableWidth();
        int n5 = (int)(1.0 + PagePrinter.getScale() * (double)dimension.width / (double)n4);
        if (n > n5 * (n2 = (int)(1.0 + PagePrinter.getScale() * (double)dimension.height / (double)n3))) {
            return 1;
        }
        int n6 = n / n5;
        int n7 = n % n5;
        ((Graphics2D)graphics).translate(pageFormat.getImageableX() - (double)(n7 * n4), pageFormat.getImageableY() - (double)(n6 * n3) + (double)PagePrinter.headerHeight);
        ((Graphics2D)graphics).scale(PagePrinter.getScale(), PagePrinter.getScale());
        this.currentPackage.print(graphics, 0, 0);
        ((Graphics2D)graphics).scale(1.0 / PagePrinter.getScale(), 1.0 / PagePrinter.getScale());
        ((Graphics2D)graphics).translate(-(pageFormat.getImageableX() - (double)(n7 * n4)), -(pageFormat.getImageableY() - (double)(n6 * n3) + (double)PagePrinter.headerHeight));
        String string = this.currentPackage.getSummary().getName();
        if (string == null || string.length() == 0) {
            string = "Top Level Package";
        }
        this.printHeader(graphics, string, "(" + (1 + n7) + ", " + (1 + n6) + ")", "(" + n5 + ", " + n2 + ")");
        return 0;
    }

    public static PageFormat getPageFormat(boolean bl) {
        PageFormat pageFormat = PagePrinter.getPageFormat(bl);
        PagePrinter.setScale(0.8);
        return pageFormat;
    }

    public static int getPageHeight() {
        int n = PagePrinter.getPageHeight();
        if (n == -1) {
            return -1;
        }
        return n - PagePrinter.headerHeight;
    }
}

