/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.uml.line;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.io.PrintWriter;

public class Vertex {
    private Point point;
    private boolean selected;
    private boolean activated;
    private boolean rescaled;
    private double scale;
    private Point computed;
    private static double near = 3.0;
    private static int vertexSizeHalf = 2;
    private static int vertexSize = 5;

    public Vertex(Point point) {
        this.point = point;
        this.computed = new Point();
        this.activated = false;
        this.selected = false;
        this.rescaled = true;
        this.scale = 1.0;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public boolean isActive() {
        return this.activated;
    }

    public void paint(Graphics graphics) {
        if (this.activated) {
            graphics.setColor(Color.magenta);
            graphics.fillOval(this.getX() - vertexSizeHalf, this.getY() - vertexSizeHalf, vertexSize, vertexSize);
        } else if (this.selected) {
            graphics.setColor(Color.black);
            graphics.fillOval(this.getX() - vertexSizeHalf, this.getY() - vertexSizeHalf, vertexSize, vertexSize);
        }
    }

    public boolean hit(Point point) {
        double d;
        double d2 = (double)this.getX() - point.getX();
        double d3 = Math.sqrt(d2 * d2 + (d = (double)this.getY() - point.getY()) * d);
        return d3 < near;
    }

    public void move(Point point) {
        this.point.x = (int)((double)point.x / this.scale);
        this.point.y = (int)((double)point.y / this.scale);
        this.rescaled = true;
    }

    public void save(PrintWriter printWriter) {
        printWriter.print("(" + this.point.x + "," + this.point.y + ")");
    }

    public void shift(int n, int n2) {
        this.point.x += n;
        this.point.y += n2;
        this.rescaled = true;
    }

    public void scale(double d) {
        if (Math.abs(d - this.scale) > 0.001) {
            this.rescaled = true;
            this.scale = d;
        }
    }

    protected int getX() {
        if (this.rescaled) {
            this.computed.x = (int)((double)this.point.x * this.scale);
            this.computed.y = (int)((double)this.point.y * this.scale);
            this.rescaled = false;
        }
        return this.computed.x;
    }

    protected int getY() {
        if (this.rescaled) {
            this.computed.x = (int)((double)this.point.x * this.scale);
            this.computed.y = (int)((double)this.point.y * this.scale);
            this.rescaled = false;
        }
        return this.computed.y;
    }

    protected Point getPoint() {
        if (this.rescaled) {
            this.computed.x = (int)((double)this.point.x * this.scale);
            this.computed.y = (int)((double)this.point.y * this.scale);
            this.rescaled = false;
        }
        return this.computed;
    }

    protected void select(boolean bl) {
        this.selected = bl;
        if (!this.selected) {
            this.activated = false;
        }
    }

    protected void active(boolean bl) {
        this.activated = bl;
        if (this.activated) {
            this.selected = true;
        }
    }

    public static void setNear(double d) {
        near = d;
    }

    public static void setVertexSize(int n) {
        vertexSizeHalf = n / 2;
        vertexSize = n;
    }
}

