/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.uml.line;

import java.awt.Point;
import java.awt.Rectangle;

class Segment {
    private double A0 = 0.0;
    private double A1 = 1.0;
    private double B0 = 0.0;
    private double B1 = 1.0;
    private double m = 1.414;

    public Point getPoint(double d) {
        return new Point((int)(this.A0 + d * this.A1), (int)(this.B0 + d * this.B1));
    }

    public double getParamFromDistance(double d) {
        if (d > this.m) {
            return this.m - d;
        }
        return d / this.m;
    }

    public void reset(Rectangle rectangle, Rectangle rectangle2) {
        double d = rectangle.getX() + rectangle.getWidth() * 0.5;
        double d2 = rectangle.getY() + rectangle.getHeight() * 0.5;
        double d3 = rectangle2.getX() + rectangle2.getWidth() * 0.5;
        double d4 = rectangle2.getY() + rectangle2.getHeight() * 0.5;
        this.A0 = d;
        this.A1 = d3 - d;
        this.B0 = d2;
        this.B1 = d4 - d2;
        this.m = Math.sqrt(this.A1 * this.A1 + this.B1 * this.B1);
    }

    public void reset(Point point, Point point2) {
        double d = point.getX();
        double d2 = point.getY();
        double d3 = point2.getX();
        double d4 = point2.getY();
        this.A0 = d;
        this.A1 = d3 - d;
        this.B0 = d2;
        this.B1 = d4 - d2;
        this.m = Math.sqrt(this.A1 * this.A1 + this.B1 * this.B1);
    }

    public void reset(Rectangle rectangle, Point point) {
        double d = rectangle.getX() + rectangle.getWidth() * 0.5;
        double d2 = rectangle.getY() + rectangle.getHeight() * 0.5;
        double d3 = point.getX();
        double d4 = point.getY();
        this.A0 = d;
        this.A1 = d3 - d;
        this.B0 = d2;
        this.B1 = d4 - d2;
    }

    public void reset(Point point, Rectangle rectangle) {
        double d = point.getX();
        double d2 = point.getY();
        double d3 = rectangle.getX() + rectangle.getWidth() * 0.5;
        double d4 = rectangle.getY() + rectangle.getHeight() * 0.5;
        this.A0 = d;
        this.A1 = d3 - d;
        this.B0 = d2;
        this.B1 = d4 - d2;
        this.m = Math.sqrt(this.A1 * this.A1 + this.B1 * this.B1);
    }

    public double intersect(Rectangle rectangle) {
        double d = rectangle.getX();
        double d2 = rectangle.getX() + rectangle.getWidth();
        double d3 = rectangle.getY();
        double d4 = rectangle.getY() + rectangle.getHeight();
        double d5 = -1.0;
        double d6 = -1.0;
        if (Math.abs(this.A1) > 1.0E-4) {
            d5 = (d - this.A0) / this.A1;
            d6 = (d2 - this.A0) / this.A1;
        }
        double d7 = -1.0;
        double d8 = -1.0;
        if (Math.abs(this.B1) > 0.001) {
            d7 = (d3 - this.B0) / this.B1;
            d8 = (d4 - this.B0) / this.B1;
        }
        if (this.inRectangle(d5, rectangle)) {
            return d5;
        }
        if (this.inRectangle(d6, rectangle)) {
            return d6;
        }
        if (this.inRectangle(d7, rectangle)) {
            return d7;
        }
        if (this.inRectangle(d8, rectangle)) {
            return d8;
        }
        return -1.0;
    }

    public double distanceToPoint(Point point) {
        double d = this.A1;
        double d2 = this.B1;
        double d3 = point.getX() - this.A0;
        double d4 = point.getY() - this.B0;
        double d5 = d3 * d3 + d4 * d4;
        double d6 = d * d + d2 * d2;
        double d7 = d * d3 + d2 * d4;
        if (d7 < 0.0 || d7 > d6) {
            return -1.0;
        }
        double d8 = Math.sqrt(d5 - d7 * d7 / d6);
        return d8;
    }

    public double findFromEnd(double d) {
        double d2 = Math.sqrt(this.A1 * this.A1 + this.B1 * this.B1);
        return 1.0 - d / d2;
    }

    public Point aboveLine(double d, double d2) {
        if (Math.abs(this.A1) < 0.001) {
            Point point = this.getPoint(d);
            return new Point((int)(point.getX() - d2), (int)point.getY());
        }
        Point point = this.getPoint(d);
        double d3 = point.getX();
        double d4 = point.getY();
        double d5 = this.B1 * this.B1 + this.A1 * this.A1;
        double d6 = -2.0 * d4 * d5;
        double d7 = d4 * d4 * d5 - this.A1 * this.A1 * d2 * d2;
        double d8 = (-d6 + Math.sqrt(d6 * d6 - 4.0 * d5 * d7)) / (2.0 * d5);
        double d9 = -this.B1 * (d8 - d4) / this.A1 + d3;
        return new Point((int)d9, (int)d8);
    }

    public Point belowLine(double d, double d2) {
        if (Math.abs(this.A1) < 0.001) {
            Point point = this.getPoint(d);
            return new Point((int)(point.getX() + d2), (int)point.getY());
        }
        Point point = this.getPoint(d);
        double d3 = point.getX();
        double d4 = point.getY();
        double d5 = this.B1 * this.B1 + this.A1 * this.A1;
        double d6 = -2.0 * d4 * d5;
        double d7 = d4 * d4 * d5 - this.A1 * this.A1 * d2 * d2;
        double d8 = (-d6 - Math.sqrt(d6 * d6 - 4.0 * d5 * d7)) / (2.0 * d5);
        double d9 = -this.B1 * (d8 - d4) / this.A1 + d3;
        return new Point((int)d9, (int)d8);
    }

    private boolean inRectangle(double d, Rectangle rectangle) {
        if (d < 0.0 || d > 1.0) {
            return false;
        }
        double d2 = this.A0 + this.A1 * d;
        double d3 = this.B0 + this.B1 * d;
        double d4 = rectangle.getX();
        double d5 = rectangle.getX() + rectangle.getWidth();
        double d6 = rectangle.getY();
        double d7 = rectangle.getY() + rectangle.getHeight();
        return d4 <= d2 && d5 >= d2 && d6 <= d3 && d7 >= d3;
    }
}

