/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.uml.line;

import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JPanel;

abstract class ScalablePanel
extends JPanel {
    private double scale;
    private boolean inShapeChange;
    private int absoluteWidth = -1;
    private int absoluteHeight = -1;
    private boolean inScaling = false;
    private int absoluteX = -1;
    private int absoluteY = -1;

    public ScalablePanel() {
        this.init();
    }

    public ScalablePanel(boolean bl) {
        super(bl);
        this.init();
    }

    public ScalablePanel(LayoutManager layoutManager) {
        super(layoutManager);
        this.init();
    }

    public ScalablePanel(LayoutManager layoutManager, boolean bl) {
        super(layoutManager, bl);
        this.init();
    }

    public void setLocation(int n, int n2) {
        if (this.inShapeChange) {
            super.setLocation(n, n2);
        } else {
            this.inShapeChange = true;
            super.setLocation(this.scaleInteger(n), this.scaleInteger(n2));
            this.inShapeChange = false;
        }
    }

    public void setLocation(Point point) {
        if (this.inShapeChange) {
            super.setLocation(point);
        } else {
            this.inShapeChange = true;
            super.setLocation(this.scaleInteger(point.x), this.scaleInteger(point.y));
            this.inShapeChange = false;
        }
    }

    public void setSize(int n, int n2) {
        if (this.inShapeChange) {
            super.setSize(n, n2);
        } else {
            this.inShapeChange = true;
            super.setSize(this.scaleInteger(n), this.scaleInteger(n2));
            this.inShapeChange = false;
        }
    }

    public void setSize(Dimension dimension) {
        if (this.inShapeChange) {
            super.setSize(dimension);
        } else {
            this.inShapeChange = true;
            super.setSize(this.scaleInteger(dimension.width), this.scaleInteger(dimension.height));
            this.inShapeChange = false;
        }
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (this.inShapeChange) {
            super.setBounds(n, n2, n3, n4);
        } else {
            this.inShapeChange = true;
            super.setBounds(this.scaleInteger(n), this.scaleInteger(n2), this.scaleInteger(n4), this.scaleInteger(n4));
            this.inShapeChange = false;
        }
    }

    public void setBounds(Rectangle rectangle) {
        if (this.inShapeChange) {
            super.setBounds(rectangle);
        } else {
            this.inShapeChange = true;
            super.setBounds(this.scaleInteger(rectangle.x), this.scaleInteger(rectangle.y), this.scaleInteger(rectangle.width), this.scaleInteger(rectangle.height));
            this.inShapeChange = false;
        }
    }

    public void shift(int n, int n2) {
        Point point = this.getLocation();
        this.inShapeChange = true;
        this.setLocation(n + point.x, n2 + point.y);
        this.inShapeChange = false;
    }

    public void scale(double d) {
        if (Math.abs(this.scale - d) > 0.001) {
            Rectangle rectangle = this.getUnscaledBounds();
            this.scale = d;
            this.inScaling = true;
            this.setBounds(rectangle);
            this.inScaling = false;
        }
    }

    public void move(int n, int n2) {
        if (this.inShapeChange) {
            super.move(n, n2);
        } else {
            this.inShapeChange = true;
            super.move(this.scaleInteger(n), this.scaleInteger(n2));
            this.inShapeChange = false;
        }
    }

    public void resize(int n, int n2) {
        if (this.inShapeChange) {
            super.resize(n, n2);
        } else {
            this.inShapeChange = true;
            super.resize(this.scaleInteger(n), this.scaleInteger(n2));
            this.inShapeChange = false;
        }
    }

    public void resize(Dimension dimension) {
        if (this.inShapeChange) {
            super.resize(dimension);
        } else {
            this.inShapeChange = true;
            super.resize(this.scaleInteger(dimension.width), this.scaleInteger(dimension.height));
            this.inShapeChange = false;
        }
    }

    public void reshape(int n, int n2, int n3, int n4) {
        if (this.inShapeChange) {
            super.reshape(n, n2, n3, n4);
        } else {
            this.inShapeChange = true;
            super.reshape(this.scaleInteger(n), this.scaleInteger(n2), this.scaleInteger(n4), this.scaleInteger(n4));
            this.inShapeChange = false;
        }
    }

    protected double getScale() {
        return this.scale;
    }

    protected int scaleInteger(int n) {
        return (int)Math.round(this.scale * (double)n);
    }

    private Rectangle getUnscaledBounds() {
        Rectangle rectangle = this.getBounds();
        if (Math.abs(this.scale - 1.0) < 0.01) {
            this.absoluteX = rectangle.x;
            this.absoluteY = rectangle.y;
            this.absoluteWidth = rectangle.width;
            this.absoluteHeight = rectangle.height;
        } else {
            rectangle.x = this.getCoordinate(rectangle.x, this.absoluteX);
            rectangle.y = this.getCoordinate(rectangle.y, this.absoluteY);
            if (this.absoluteWidth == -1) {
                rectangle.width = this.unscaleInteger(rectangle.width);
                rectangle.height = this.unscaleInteger(rectangle.height);
            } else {
                rectangle.width = this.absoluteWidth;
                rectangle.height = this.absoluteHeight;
            }
        }
        return rectangle;
    }

    private int getCoordinate(int n, int n2) {
        int n3 = this.unscaleInteger(n);
        if (n2 >= 0 && Math.abs(n3 - n2) < 6) {
            n3 = n2;
        }
        return n3;
    }

    private int unscaleInteger(int n) {
        return (int)((double)n / this.scale);
    }

    private void init() {
        this.inShapeChange = false;
        this.scale = 1.0;
    }
}

