/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.uml;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.acm.seguin.summary.FieldSummary;
import org.acm.seguin.summary.MethodSummary;
import org.acm.seguin.summary.PackageSummary;
import org.acm.seguin.summary.Summary;
import org.acm.seguin.summary.TypeSummary;
import org.acm.seguin.uml.ISourceful;
import org.acm.seguin.uml.RoleHolder;
import org.acm.seguin.uml.UMLField;
import org.acm.seguin.uml.UMLLine;
import org.acm.seguin.uml.UMLMethod;
import org.acm.seguin.uml.UMLMouseAdapter;
import org.acm.seguin.uml.UMLNestedType;
import org.acm.seguin.uml.UMLPackage;
import org.acm.seguin.uml.line.AssociationRelationship;
import org.acm.seguin.uml.line.DragPanelAdapter;
import org.acm.seguin.uml.line.EndPointPanel;
import org.acm.seguin.uml.line.LabelSizeComputation;
import org.acm.seguin.uml.line.ScalablePanel;
import org.acm.seguin.uml.line.SizableLabel;

public class UMLType
extends EndPointPanel
implements ISourceful {
    protected int borderWidth = 2;
    protected int lineSize = 0;
    private UMLPackage parent;
    private SizableLabel nameLabel;
    private RoleHolder roles;
    private TypeSummary type;
    private int wide;
    private int high;
    private int titleHeight;
    private int state;
    private static Color defaultBG = null;
    private static Color selectedBG;
    private static Color foreignBG;
    private static Color selectedForeignBG;
    private static final int DEFAULT = 0;
    private static final int SELECTED = 1;
    private static final int FOREIGN = 2;
    private static final int TITLE_BORDER = 4;

    public UMLType(UMLPackage uMLPackage, TypeSummary typeSummary, boolean bl) {
        super(null, true);
        UMLLine uMLLine;
        Serializable serializable;
        this.parent = uMLPackage;
        this.type = typeSummary;
        this.wide = 0;
        this.high = 0;
        this.state = bl ? 2 : 0;
        UMLMouseAdapter uMLMouseAdapter = new UMLMouseAdapter(this.parent, this, null);
        this.addMouseListener(uMLMouseAdapter);
        DragPanelAdapter dragPanelAdapter = new DragPanelAdapter(this, this.parent);
        this.addMouseListener(dragPanelAdapter);
        this.addMouseMotionListener(dragPanelAdapter);
        this.nameLabel = new SizableLabel(this.type.getName());
        this.nameLabel.setLocation(this.borderWidth, this.borderWidth);
        this.nameLabel.setSLHorizontalAlignment(0);
        this.nameLabel.setSLFont(UMLLine.getProtectionFont(true, this.type.getModifiers()));
        Dimension dimension = this.nameLabel.getPreferredSize();
        this.titleHeight = dimension.height;
        this.wide = dimension.width + 8;
        this.add(this.nameLabel);
        this.nameLabel.addMouseListener(uMLMouseAdapter);
        this.nameLabel.addMouseListener(dragPanelAdapter);
        this.nameLabel.addMouseMotionListener(dragPanelAdapter);
        this.roles = new RoleHolder(uMLMouseAdapter, dragPanelAdapter);
        if (this.type.isInterface()) {
            this.roles.add("\u00abInterface\u00bb");
        }
        if (bl) {
            this.roles.add("Package:  " + this.getPackageName());
        }
        if (this.roles.hasAny()) {
            this.roles.setLocation(this.borderWidth, this.borderWidth + dimension.height);
            this.add(this.roles);
            Dimension dimension2 = this.roles.getPreferredSize();
            this.roles.setSize(dimension2);
            this.wide = Math.max(this.wide, dimension2.width);
            this.titleHeight += dimension2.height;
        }
        this.lineSize = this.computeLineSize();
        int n = this.titleHeight + this.borderWidth * 2;
        Iterator iterator = this.type.getFields();
        if (iterator != null) {
            while (iterator.hasNext()) {
                serializable = new UMLField(this.parent, this, (FieldSummary)iterator.next(), dragPanelAdapter);
                ((ScalablePanel)serializable).setLocation(this.borderWidth, n);
                this.add((Component)serializable);
                this.lineSize = ((UMLLine)serializable).getPreferredSize().height;
                n += ((UMLLine)serializable).getPreferredSize().height;
                this.wide = Math.max(this.wide, ((UMLLine)serializable).getPreferredSize().width);
            }
        } else {
            n += this.lineSize;
        }
        n += this.borderWidth;
        iterator = this.type.getMethods();
        if (iterator != null) {
            while (iterator.hasNext()) {
                serializable = (MethodSummary)iterator.next();
                if (((MethodSummary)serializable).isInitializer()) continue;
                uMLLine = new UMLMethod(this.parent, this, (MethodSummary)serializable, dragPanelAdapter);
                uMLLine.setLocation(this.borderWidth, n);
                this.add(uMLLine);
                n += uMLLine.getPreferredSize().height;
                this.wide = Math.max(this.wide, uMLLine.getPreferredSize().width);
            }
        } else {
            n += this.lineSize;
        }
        int n2 = this.type.getTypeCount();
        if (n2 > 0) {
            n += this.borderWidth;
            iterator = this.type.getTypes();
            if (iterator != null) {
                while (iterator.hasNext()) {
                    uMLLine = new UMLNestedType(this.parent, this, (TypeSummary)iterator.next(), dragPanelAdapter);
                    uMLLine.setLocation(this.borderWidth, n);
                    this.add(uMLLine);
                    n += uMLLine.getPreferredSize().height;
                    this.wide = Math.max(this.wide, uMLLine.getPreferredSize().width);
                }
            }
        }
        this.high = n + this.borderWidth;
        this.nameLabel.setSize(this.wide, dimension.height);
        if (this.roles.hasAny()) {
            this.roles.resetWidth(this.wide);
        }
        this.wide += 2 * this.borderWidth;
        this.setSize(this.getPreferredSize());
    }

    public void setSelected(boolean bl) {
        if (bl) {
            this.select();
        } else {
            this.deselect();
        }
    }

    public TypeSummary getSummary() {
        return this.type;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.wide, this.high);
    }

    public UMLPackage getPackage() {
        return this.parent;
    }

    public boolean isSelected() {
        return (this.state & 1) > 0;
    }

    public boolean isForeign() {
        return (this.state & 2) > 0;
    }

    public Color getBackgroundColor() {
        if (defaultBG == null) {
            UMLType.initColors();
        }
        if (this.state == 1) {
            return selectedBG;
        }
        if (this.state == 2) {
            return foreignBG;
        }
        if (this.isSelected() && this.isForeign()) {
            return selectedForeignBG;
        }
        return defaultBG;
    }

    public String getID() {
        return this.type.getPackageSummary().getName() + ":" + this.type.getName();
    }

    public UMLField getField(String string) {
        if (string == null) {
            return null;
        }
        Component[] componentArray = this.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            UMLField uMLField;
            if (componentArray[n2] instanceof UMLField && string.equals((uMLField = (UMLField)componentArray[n2]).getSummary().getName())) {
                return uMLField;
            }
            ++n2;
        }
        return null;
    }

    public void paint(Graphics graphics) {
        Color color = this.getBackgroundColor();
        this.setBackground(color);
        this.roles.setBackground(color);
        super.paint(graphics);
        this.drawFrame(graphics, 0, 0);
    }

    public void print(Graphics graphics, int n, int n2) {
        Rectangle rectangle = this.getBounds();
        graphics.setColor(this.getBackgroundColor());
        graphics.fillRect(n, n2, rectangle.width, rectangle.height);
        Point point = this.nameLabel.getLocation();
        this.nameLabel.print(graphics, n + point.x, n2 + point.y);
        if (this.roles.hasAny()) {
            point = this.roles.getLocation();
            this.roles.print(graphics, n + point.x, n2 + point.y);
        }
        Component[] componentArray = this.getComponents();
        int n3 = componentArray.length;
        int n4 = 0;
        while (n4 < n3) {
            if (componentArray[n4] instanceof UMLLine) {
                point = componentArray[n4].getLocation();
                ((UMLLine)componentArray[n4]).print(graphics, n + point.x, n2 + point.y);
            }
            ++n4;
        }
        this.drawFrame(graphics, n, n2);
    }

    public void resize() {
        int n;
        Component[] componentArray = this.getComponents();
        int n2 = componentArray.length;
        this.wide = 0;
        this.high = 0;
        Dimension dimension = this.nameLabel.getPreferredSize();
        this.titleHeight = dimension.height;
        this.wide = dimension.width + 2 * this.borderWidth;
        if (this.roles.hasAny()) {
            Dimension dimension2 = this.roles.getPreferredSize();
            this.titleHeight += dimension2.height;
            this.wide = Math.max(dimension2.width, this.wide);
        }
        int n3 = this.titleHeight + 2 * this.borderWidth;
        boolean bl = false;
        int n4 = 0;
        while (n4 < n2) {
            if (componentArray[n4] instanceof UMLField) {
                UMLField uMLField = (UMLField)componentArray[n4];
                uMLField.setLocation(this.borderWidth, n3);
                n3 += this.lineSize;
                this.wide = Math.max(this.wide, uMLField.getPreferredSize().width);
                bl = true;
            }
            ++n4;
        }
        if (!bl) {
            n3 += this.lineSize;
        }
        n3 += this.borderWidth;
        boolean bl2 = false;
        int n5 = 0;
        while (n5 < n2) {
            if (componentArray[n5] instanceof UMLMethod) {
                UMLMethod uMLMethod = (UMLMethod)componentArray[n5];
                uMLMethod.setLocation(this.borderWidth, n3);
                n3 += this.lineSize;
                this.wide = Math.max(this.wide, uMLMethod.getPreferredSize().width);
                bl2 = true;
            }
            ++n5;
        }
        if (!bl2) {
            n3 += this.lineSize;
        }
        if ((n = this.type.getTypeCount()) > 0) {
            n3 += this.borderWidth;
            int n6 = 0;
            while (n6 < n2) {
                if (componentArray[n6] instanceof UMLNestedType) {
                    UMLNestedType uMLNestedType = (UMLNestedType)componentArray[n6];
                    uMLNestedType.setLocation(this.borderWidth, n3);
                    n3 += this.lineSize;
                    this.wide = Math.max(this.wide, uMLNestedType.getPreferredSize().width);
                }
                ++n6;
            }
        }
        this.high = n3 + this.borderWidth;
        this.nameLabel.setSize(this.wide, dimension.height);
        if (this.roles.hasAny()) {
            this.roles.resetWidth(this.wide);
        }
        this.wide += 2 * this.borderWidth;
        this.setSize(this.getPreferredSize());
        this.parent.repaint();
    }

    public void select() {
        this.state |= 1;
        this.repaint();
    }

    public void deselect() {
        this.state &= 0xFFFFFFFE;
        this.repaint();
    }

    public void toggleSelect() {
        this.state ^= 1;
        this.repaint();
    }

    public void save(PrintWriter printWriter) {
        Point point = this.getUnscaledLocation();
        printWriter.println("P[" + this.getID() + "]{" + point.x + "," + point.y + "}");
    }

    public void load(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        try {
            this.setLocation(Integer.parseInt(string2), Integer.parseInt(string3));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public AssociationRelationship convertToAssociation(UMLPackage uMLPackage, UMLField uMLField) {
        this.remove(uMLField);
        this.resize();
        uMLPackage.add(uMLField);
        TypeSummary typeSummary = uMLField.getType();
        UMLType uMLType = uMLPackage.findType(typeSummary);
        if (uMLType == null) {
            uMLType = new UMLType(uMLPackage, typeSummary, true);
            uMLPackage.add((Component)uMLType);
            ((Component)uMLType).setLocation(0, 0);
        }
        AssociationRelationship associationRelationship = new AssociationRelationship(this, uMLType, uMLField);
        uMLPackage.add(associationRelationship);
        return associationRelationship;
    }

    public void convertToAttribute(UMLPackage uMLPackage, UMLField uMLField) {
        uMLPackage.remove(uMLField);
        uMLPackage.removeAssociation(uMLField);
        this.add(uMLField);
        this.resize();
    }

    public void scale(double d) {
        super.scale(d);
        this.nameLabel.scale(d);
        this.roles.scale(d);
        Component[] componentArray = this.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (componentArray[n2] instanceof UMLLine) {
                ((UMLLine)componentArray[n2]).scale(d);
            }
            ++n2;
        }
    }

    public Summary getSourceSummary() {
        return this.type;
    }

    private String getPackageName() {
        Summary summary = this.type;
        while (!(summary instanceof PackageSummary)) {
            summary = summary.getParent();
        }
        return ((PackageSummary)summary).getName();
    }

    private int getAttributeCount() {
        int n = 0;
        Component[] componentArray = this.getComponents();
        int n2 = componentArray.length;
        int n3 = 0;
        while (n3 < n2) {
            if (componentArray[n3] instanceof UMLField) {
                ++n;
            }
            ++n3;
        }
        return n;
    }

    private void drawFrame(Graphics graphics, int n, int n2) {
        graphics.setColor(UMLType.getFrameColor());
        Dimension dimension = this.getSize();
        double d = this.getScale();
        graphics.drawRect(n, n2, dimension.width - 1, dimension.height - 1);
        graphics.drawRect(n + 1, n2 + 1, dimension.width - 3, dimension.height - 3);
        graphics.drawLine(n, (int)((double)n2 + d * (double)(this.titleHeight + 4)), n + dimension.width - 1, (int)((double)n2 + d * (double)(this.titleHeight + 4)));
        graphics.drawLine(n, (int)((double)n2 + d * (double)(this.titleHeight + 5)), n + dimension.width - 1, (int)((double)n2 + d * (double)(this.titleHeight + 5)));
        int n3 = (int)(d * (double)(this.titleHeight + 4 + this.lineSize * Math.max(1, this.getAttributeCount())));
        graphics.drawLine(n, n2 + n3, n + dimension.width - 1, n2 + n3);
        graphics.drawLine(n, n2 + n3 + 1, n + dimension.width - 1, n2 + n3 + 1);
        int n4 = this.type.getTypeCount();
        if (n4 > 0) {
            int n5 = Math.max(1, this.getAttributeCount()) + Math.max(1, this.type.getMethodCount());
            n3 = (int)(d * (double)(this.titleHeight + 4 + this.lineSize * n5));
            graphics.drawLine(n, n2 + n3, n + dimension.width - 1, n2 + n3);
            graphics.drawLine(n, n2 + n3 + 1, n + dimension.width - 1, n2 + n3 + 1);
        }
    }

    private int computeLineSize() {
        LabelSizeComputation labelSizeComputation = LabelSizeComputation.get();
        int n = labelSizeComputation.computeHeight("Test", UMLLine.defaultFont);
        return n + 2;
    }

    private static Color getFrameColor() {
        return Color.black;
    }

    private static synchronized void initColors() {
        if (defaultBG == null) {
            defaultBG = Color.white;
            selectedBG = new Color(250, 255, 220);
            foreignBG = new Color(200, 200, 255);
            selectedForeignBG = new Color(220, 255, 220);
        }
    }
}

