/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.uml;

import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.acm.seguin.ide.common.SourceBrowser;
import org.acm.seguin.ide.common.SourceBrowserAdapter;
import org.acm.seguin.summary.MethodSummary;
import org.acm.seguin.summary.ParameterSummary;
import org.acm.seguin.summary.TypeSummary;
import org.acm.seguin.uml.ConvertAdapter;
import org.acm.seguin.uml.ISourceful;
import org.acm.seguin.uml.MethodMetricsListener;
import org.acm.seguin.uml.PackageMetricsListener;
import org.acm.seguin.uml.PopupMenuListener;
import org.acm.seguin.uml.ProjectMetricsListener;
import org.acm.seguin.uml.SelectedSummaryList;
import org.acm.seguin.uml.TypeMetricsListener;
import org.acm.seguin.uml.UMLField;
import org.acm.seguin.uml.UMLLine;
import org.acm.seguin.uml.UMLMethod;
import org.acm.seguin.uml.UMLPackage;
import org.acm.seguin.uml.UMLType;
import org.acm.seguin.uml.refactor.AddChildClassListener;
import org.acm.seguin.uml.refactor.AddMoveClassListener;
import org.acm.seguin.uml.refactor.AddParentClassListener;
import org.acm.seguin.uml.refactor.AddRenameClassListener;
import org.acm.seguin.uml.refactor.ExtractInterfaceListener;
import org.acm.seguin.uml.refactor.MoveMethodListener;
import org.acm.seguin.uml.refactor.PushDownFieldListener;
import org.acm.seguin.uml.refactor.PushDownMethodListener;
import org.acm.seguin.uml.refactor.PushUpAbstractMethodListener;
import org.acm.seguin.uml.refactor.PushUpFieldListener;
import org.acm.seguin.uml.refactor.PushUpMethodListener;
import org.acm.seguin.uml.refactor.RemoveClassListener;
import org.acm.seguin.uml.refactor.RenameFieldListener;
import org.acm.seguin.uml.refactor.RenameParameterListener;

public class UMLPopupMenu {
    private JPopupMenu popupMenu;
    private JPanel activeComponent;
    private UMLPackage current;

    public UMLPopupMenu(UMLPackage uMLPackage, JPanel jPanel) {
        this.activeComponent = jPanel;
        this.current = uMLPackage;
        this.popupMenu = this.createPopupMenu();
        this.popupMenu.setInvoker(this.activeComponent);
    }

    public JPopupMenu getMenu() {
        return this.popupMenu;
    }

    protected JMenuItem getMetricsMenu(JPopupMenu jPopupMenu) {
        JMenu jMenu = new JMenu("Metrics");
        JMenuItem jMenuItem = new JMenuItem("Project Metrics");
        jMenu.add(jMenuItem);
        ProjectMetricsListener projectMetricsListener = new ProjectMetricsListener(jPopupMenu, jMenuItem);
        jMenuItem.addMouseListener(projectMetricsListener);
        jMenuItem.addActionListener(projectMetricsListener);
        jMenuItem = new JMenuItem("Package Metrics");
        jMenu.add(jMenuItem);
        PackageMetricsListener packageMetricsListener = new PackageMetricsListener(this.current, jPopupMenu, jMenuItem);
        jMenuItem.addMouseListener(packageMetricsListener);
        jMenuItem.addActionListener(packageMetricsListener);
        jMenuItem = new JMenuItem("Class Metrics");
        jMenu.add(jMenuItem);
        TypeMetricsListener typeMetricsListener = new TypeMetricsListener(this.activeComponent, jPopupMenu, jMenuItem);
        jMenuItem.addMouseListener(typeMetricsListener);
        jMenuItem.addActionListener(typeMetricsListener);
        if (this.activeComponent != null && this.activeComponent instanceof UMLMethod) {
            UMLMethod uMLMethod = (UMLMethod)this.activeComponent;
            jMenuItem = new JMenuItem("Method Metrics");
            jMenu.add(jMenuItem);
            MethodMetricsListener methodMetricsListener = new MethodMetricsListener(uMLMethod.getSummary(), jPopupMenu, jMenuItem);
            jMenuItem.addMouseListener(methodMetricsListener);
            jMenuItem.addActionListener(methodMetricsListener);
        }
        return jMenu;
    }

    protected JPopupMenu createPopupMenu() {
        JMenuItem jMenuItem;
        Object object;
        JPopupMenu jPopupMenu = new JPopupMenu("UML Diagram");
        if (this.activeComponent != null && this.activeComponent instanceof UMLField) {
            object = (UMLField)this.activeComponent;
            jMenuItem = ((UMLField)object).isAssociation() ? new JMenuItem("Convert to Attribute") : new JMenuItem("Convert to Association");
            jMenuItem.setEnabled(((UMLField)object).isConvertable());
            jPopupMenu.add(jMenuItem);
            jMenuItem.addMouseListener(new PopupMenuListener(jPopupMenu, jMenuItem));
            jMenuItem.addActionListener(new ConvertAdapter(this.current, (UMLField)object));
            jPopupMenu.addSeparator();
        }
        this.addRefactorings(jPopupMenu);
        jPopupMenu.addSeparator();
        jMenuItem = this.getMetricsMenu(jPopupMenu);
        jPopupMenu.add(jMenuItem);
        if (SourceBrowser.get().canBrowseSource()) {
            jPopupMenu.addSeparator();
            jMenuItem = new JMenuItem("Show source");
            object = new SourceBrowserAdapter((ISourceful)((Object)this.activeComponent));
            jMenuItem.addActionListener((ActionListener)object);
            jPopupMenu.add(jMenuItem);
        }
        return jPopupMenu;
    }

    protected void addRefactorings(JPopupMenu jPopupMenu) {
        this.addTypeRefactorings(jPopupMenu);
        if (this.activeComponent != null) {
            if (this.activeComponent instanceof UMLMethod) {
                this.addMethodRefactorings(jPopupMenu);
            } else if (this.activeComponent instanceof UMLField) {
                this.addFieldRefactorings(jPopupMenu);
            }
        }
    }

    private UMLType getType() {
        if (this.activeComponent instanceof UMLType) {
            return (UMLType)this.activeComponent;
        }
        if (this.activeComponent instanceof UMLLine) {
            return ((UMLLine)this.activeComponent).getParentType();
        }
        return null;
    }

    private TypeSummary getTypeSummary() {
        UMLType uMLType = this.getType();
        if (uMLType == null) {
            return null;
        }
        return uMLType.getSummary();
    }

    private void addFieldRefactorings(JPopupMenu jPopupMenu) {
        JMenu jMenu = new JMenu("Field Refactorings");
        jPopupMenu.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem("Rename");
        jMenu.add(jMenuItem);
        jMenuItem.setEnabled(true);
        RenameFieldListener renameFieldListener = new RenameFieldListener(this.current, ((UMLField)this.activeComponent).getSummary(), jPopupMenu, jMenuItem);
        jMenuItem.addMouseListener(renameFieldListener);
        jMenuItem.addActionListener(renameFieldListener);
        jMenuItem = new JMenuItem("Push Up");
        jMenu.add(jMenuItem);
        jMenuItem.setEnabled(true);
        PushUpFieldListener pushUpFieldListener = new PushUpFieldListener(this.current, this.getTypeSummary(), ((UMLField)this.activeComponent).getSummary(), jPopupMenu, jMenuItem);
        jMenuItem.addMouseListener(pushUpFieldListener);
        jMenuItem.addActionListener(pushUpFieldListener);
        jMenuItem = new JMenuItem("Push Down");
        jMenu.add(jMenuItem);
        jMenuItem.setEnabled(true);
        PushDownFieldListener pushDownFieldListener = new PushDownFieldListener(this.current, this.getTypeSummary(), ((UMLField)this.activeComponent).getSummary(), jPopupMenu, jMenuItem);
        jMenuItem.addMouseListener(pushDownFieldListener);
        jMenuItem.addActionListener(pushDownFieldListener);
    }

    private void addMethodRefactorings(JPopupMenu jPopupMenu) {
        MethodSummary methodSummary = ((UMLMethod)this.activeComponent).getSummary();
        JMenu jMenu = new JMenu("Method Refactorings");
        jPopupMenu.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem("Rename");
        jMenuItem.setEnabled(false);
        jMenu.add(jMenuItem);
        jMenuItem.addMouseListener(new PopupMenuListener(jPopupMenu, jMenuItem));
        jMenuItem = new JMenuItem("Push Up");
        jMenu.add(jMenuItem);
        jMenuItem.setEnabled(true);
        PushUpMethodListener pushUpMethodListener = new PushUpMethodListener(this.current, ((UMLMethod)this.activeComponent).getSummary(), jPopupMenu, jMenuItem);
        jMenuItem.addMouseListener(pushUpMethodListener);
        jMenuItem.addActionListener(pushUpMethodListener);
        jMenuItem = new JMenuItem("Push Up (Abstract)");
        jMenu.add(jMenuItem);
        jMenuItem.setEnabled(true);
        PushUpAbstractMethodListener pushUpAbstractMethodListener = new PushUpAbstractMethodListener(this.current, ((UMLMethod)this.activeComponent).getSummary(), jPopupMenu, jMenuItem);
        jMenuItem.addMouseListener(pushUpAbstractMethodListener);
        jMenuItem.addActionListener(pushUpAbstractMethodListener);
        jMenuItem = new JMenuItem("Push Down");
        jMenu.add(jMenuItem);
        jMenuItem.setEnabled(true);
        PushDownMethodListener pushDownMethodListener = new PushDownMethodListener(this.current, this.getTypeSummary(), methodSummary, jPopupMenu, jMenuItem);
        jMenuItem.addMouseListener(pushDownMethodListener);
        jMenuItem.addActionListener(pushDownMethodListener);
        jMenuItem = new JMenuItem("Move Method");
        jMenu.add(jMenuItem);
        jMenuItem.setEnabled(methodSummary.getParameterCount() > 0);
        MoveMethodListener moveMethodListener = new MoveMethodListener(this.current, this.getTypeSummary(), methodSummary, jPopupMenu, jMenuItem);
        jMenuItem.addMouseListener(moveMethodListener);
        jMenuItem.addActionListener(moveMethodListener);
        if (methodSummary.getParameterCount() == 0) {
            jMenuItem = new JMenuItem("Rename Parameters");
            jMenuItem.setEnabled(false);
            jMenu.add(jMenuItem);
        } else {
            JMenu jMenu2 = new JMenu("Rename Parameter:");
            jMenu.add(jMenu2);
            Iterator iterator = methodSummary.getParameters();
            while (iterator.hasNext()) {
                ParameterSummary parameterSummary = (ParameterSummary)iterator.next();
                jMenuItem = new JMenuItem(parameterSummary.getName());
                jMenu2.add(jMenuItem);
                RenameParameterListener renameParameterListener = new RenameParameterListener(jPopupMenu, jMenuItem, this.current, parameterSummary);
                jMenuItem.addMouseListener(renameParameterListener);
                jMenuItem.addActionListener(renameParameterListener);
            }
        }
    }

    private void addTypeRefactorings(JPopupMenu jPopupMenu) {
        TypeSummary[] typeSummaryArray = SelectedSummaryList.list(this.current, this.getType());
        JMenu jMenu = new JMenu("Type Refactorings");
        jPopupMenu.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem("Rename Class");
        jMenu.add(jMenuItem);
        AddRenameClassListener addRenameClassListener = new AddRenameClassListener(this.current, this.getTypeSummary(), jPopupMenu, jMenuItem);
        jMenuItem.addMouseListener(addRenameClassListener);
        jMenuItem.addActionListener(addRenameClassListener);
        jMenuItem = new JMenuItem("Move Class To");
        jMenuItem.setEnabled(true);
        jMenu.add(jMenuItem);
        AddMoveClassListener addMoveClassListener = new AddMoveClassListener(typeSummaryArray, jPopupMenu, jMenuItem);
        jMenuItem.addMouseListener(addMoveClassListener);
        jMenuItem.addActionListener(addMoveClassListener);
        jMenuItem = new JMenuItem("Add Abstract Parent Class");
        jMenuItem.setEnabled(true);
        jMenu.add(jMenuItem);
        AddParentClassListener addParentClassListener = new AddParentClassListener(this.current, typeSummaryArray, jPopupMenu, jMenuItem);
        jMenuItem.addMouseListener(addParentClassListener);
        jMenuItem.addActionListener(addParentClassListener);
        jMenuItem = new JMenuItem("Add Child Class");
        jMenu.add(jMenuItem);
        jMenuItem.setEnabled(true);
        AddChildClassListener addChildClassListener = new AddChildClassListener(this.current, this.getTypeSummary(), jPopupMenu, jMenuItem);
        jMenuItem.addMouseListener(addChildClassListener);
        jMenuItem.addActionListener(addChildClassListener);
        jMenuItem = new JMenuItem("Remove Class");
        jMenu.add(jMenuItem);
        jMenuItem.setEnabled(true);
        RemoveClassListener removeClassListener = new RemoveClassListener(this.current, this.getTypeSummary(), jPopupMenu, jMenuItem);
        jMenuItem.addMouseListener(removeClassListener);
        jMenuItem.addActionListener(removeClassListener);
        jMenuItem = new JMenuItem("Extract Interface");
        jMenu.add(jMenuItem);
        jMenuItem.setEnabled(true);
        ExtractInterfaceListener extractInterfaceListener = new ExtractInterfaceListener(this.current, typeSummaryArray, jPopupMenu, jMenuItem);
        jMenuItem.addMouseListener(extractInterfaceListener);
        jMenuItem.addActionListener(extractInterfaceListener);
    }
}

