/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.uml;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import org.acm.seguin.awt.ExceptionPrinter;
import org.acm.seguin.ide.common.ClassListPanel;
import org.acm.seguin.io.Saveable;
import org.acm.seguin.print.PagePrinter;
import org.acm.seguin.summary.PackageSummary;
import org.acm.seguin.summary.TypeSummary;
import org.acm.seguin.uml.PackageLoader;
import org.acm.seguin.uml.UMLField;
import org.acm.seguin.uml.UMLLine;
import org.acm.seguin.uml.UMLType;
import org.acm.seguin.uml.line.AssociationRelationship;
import org.acm.seguin.uml.line.LineMouseAdapter;
import org.acm.seguin.uml.line.LinedPanel;
import org.acm.seguin.uml.line.SegmentedLine;
import org.acm.seguin.uml.line.Vertex;
import org.acm.seguin.uml.print.UMLPagePrinter;
import org.acm.seguin.util.FileSettings;
import org.acm.seguin.util.MissingSettingsException;

public class UMLPackage
extends LinedPanel
implements Saveable {
    private PackageSummary summary;
    private SegmentedLine currentLine = null;
    private boolean hasChanged;
    private String packageName;
    private JScrollPane scrollPane;
    private ClassListPanel classListPanel = null;
    private boolean first = false;
    private boolean loading = false;

    public UMLPackage(PackageSummary packageSummary) {
        this.defaultValues();
        this.setSummary(packageSummary);
        this.setLayout(null);
        new PackageLoader(this).start(this.summary);
        this.setSize(this.getPreferredSize());
        this.addMouseAdapter();
    }

    public UMLPackage(String string) {
        this.defaultValues();
        this.setLayout(null);
        new PackageLoader(this).start(string);
        this.setSize(this.getPreferredSize());
        this.addMouseAdapter();
    }

    public UMLPackage(InputStream inputStream) {
        this.defaultValues();
        this.setLayout(null);
        new PackageLoader(this).start(inputStream);
        this.setSize(this.getPreferredSize());
        this.addMouseAdapter();
    }

    public void setDirty() {
        this.hasChanged = true;
    }

    public void setScrollPane(JScrollPane jScrollPane) {
        this.scrollPane = jScrollPane;
    }

    public void setClassListPanel(ClassListPanel classListPanel) {
        this.classListPanel = classListPanel;
        this.first = true;
    }

    public void setLoading(boolean bl) {
        this.loading = bl;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public UMLType[] getTypes() {
        Component[] componentArray = this.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (componentArray[n3] instanceof UMLType) {
                ++n2;
            }
            ++n3;
        }
        UMLType[] uMLTypeArray = new UMLType[n2];
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            if (componentArray[n5] instanceof UMLType) {
                uMLTypeArray[n4] = (UMLType)componentArray[n5];
                ++n4;
            }
            ++n5;
        }
        return uMLTypeArray;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        int n = 10;
        int n2 = 10;
        Component[] componentArray = this.getComponents();
        int n3 = componentArray.length;
        int n4 = 0;
        while (n4 < n3) {
            Rectangle rectangle = componentArray[n4].getBounds();
            n = Math.max(n, 20 + rectangle.x + rectangle.width);
            n2 = Math.max(n2, 20 + rectangle.y + rectangle.height);
            ++n4;
        }
        return new Dimension(n, n2);
    }

    public PackageSummary getSummary() {
        return this.summary;
    }

    public File getFile() {
        return new PackageLoader(this).getFile();
    }

    public boolean isDirty() {
        return this.hasChanged;
    }

    public String getTitle() {
        return "UML Diagram for " + this.packageName;
    }

    public void removeAssociation(UMLField uMLField) {
        Iterator iterator = this.getLines();
        while (iterator.hasNext()) {
            AssociationRelationship associationRelationship;
            Object e = iterator.next();
            if (!(e instanceof AssociationRelationship) || !(associationRelationship = (AssociationRelationship)e).getField().equals(uMLField)) continue;
            associationRelationship.delete();
            iterator.remove();
            return;
        }
    }

    public void paint(Graphics graphics) {
        this.setBackground(Color.lightGray);
        graphics.setColor(Color.lightGray);
        Dimension dimension = this.getSize();
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        PageFormat pageFormat = UMLPagePrinter.getPageFormat(false);
        if (pageFormat != null) {
            int n = UMLPagePrinter.getPageHeight();
            int n2 = PagePrinter.getPageWidth();
            graphics.setColor(Color.gray);
            int n3 = n2;
            while (n3 < dimension.width) {
                graphics.drawLine(n3, 0, n3, dimension.height);
                n3 += n2;
            }
            int n4 = n;
            while (n4 < dimension.width) {
                graphics.drawLine(0, n4, dimension.width, n4);
                n4 += n;
            }
        }
        if (this.loading) {
            return;
        }
        Iterator iterator = this.getLines();
        while (iterator.hasNext()) {
            ((SegmentedLine)iterator.next()).paint(graphics);
        }
        this.paintChildren(graphics);
    }

    public void print(Graphics graphics, int n, int n2) {
        Object object;
        Component[] componentArray = this.getComponents();
        int n3 = componentArray.length;
        int n4 = 0;
        while (n4 < n3) {
            if (componentArray[n4] instanceof UMLType) {
                object = componentArray[n4].getLocation();
                ((UMLType)componentArray[n4]).print(graphics, n + ((Point)object).x, n2 + ((Point)object).y);
            } else if (componentArray[n4] instanceof UMLLine) {
                object = componentArray[n4].getLocation();
                ((UMLLine)componentArray[n4]).print(graphics, n + ((Point)object).x, n2 + ((Point)object).y);
            }
            ++n4;
        }
        object = this.getLines();
        while (object.hasNext()) {
            ((SegmentedLine)object.next()).paint(graphics);
        }
    }

    public void reload() {
        try {
            this.save();
        }
        catch (IOException iOException) {
            ExceptionPrinter.print(iOException, false);
        }
        new PackageLoader(this).start(this.summary);
        this.setSize(this.getPreferredSize());
        this.reset();
        this.hasChanged = false;
    }

    public void clear() {
        this.removeAll();
        super.clear();
    }

    public void hit(Point point) {
        SegmentedLine segmentedLine;
        this.currentLine = null;
        Iterator iterator = this.getLines();
        while (this.currentLine == null && iterator.hasNext()) {
            segmentedLine = (SegmentedLine)iterator.next();
            if (!segmentedLine.hit(point)) continue;
            this.currentLine = segmentedLine;
        }
        while (iterator.hasNext()) {
            segmentedLine = (SegmentedLine)iterator.next();
            segmentedLine.select(false);
        }
        this.repaint();
    }

    public void drag(Point point) {
        if (this.currentLine != null) {
            this.currentLine.drag(point);
            this.repaint();
        }
    }

    public void drop() {
        if (this.currentLine != null) {
            this.currentLine.drop();
            this.hasChanged = true;
            this.currentLine = null;
        }
        this.reset();
    }

    public void save() throws IOException {
        File file;
        if (!this.hasChanged) {
            return;
        }
        Component[] componentArray = this.getComponents();
        int n = componentArray.length;
        File file2 = this.summary.getDirectory();
        if (file2 == null) {
            file2 = new File(System.getProperty("user.home") + File.separator + ".Refactory" + File.separator + "UML");
            file2.mkdirs();
            file = new File(file2 + File.separator + this.summary.getName() + ".uml");
        } else {
            file = new File(this.summary.getDirectory(), "package.uml");
        }
        PrintWriter printWriter = new PrintWriter(new FileWriter(file));
        printWriter.println("V[1.1:" + this.summary.getName() + "]");
        Iterator iterator = this.getLines();
        while (iterator.hasNext()) {
            ((SegmentedLine)iterator.next()).save(printWriter);
        }
        int n2 = 0;
        while (n2 < n) {
            if (componentArray[n2] instanceof UMLType) {
                ((UMLType)componentArray[n2]).save(printWriter);
            }
            ++n2;
        }
        printWriter.close();
        this.hasChanged = false;
    }

    public void jumpTo(TypeSummary typeSummary) {
        UMLType uMLType = this.findType(typeSummary);
        if (uMLType == null) {
            return;
        }
        Point point = uMLType.getLocation();
        JScrollBar jScrollBar = this.scrollPane.getHorizontalScrollBar();
        jScrollBar.setValue(point.x - 10);
        JScrollBar jScrollBar2 = this.scrollPane.getVerticalScrollBar();
        jScrollBar2.setValue(point.y - 10);
    }

    protected UMLType findType(TypeSummary typeSummary) {
        Component[] componentArray = this.getComponents();
        int n = componentArray.length;
        boolean bl = false;
        if (typeSummary == null) {
            return null;
        }
        int n2 = 0;
        while (n2 < n) {
            TypeSummary typeSummary2;
            if (componentArray[n2] instanceof UMLType && typeSummary.equals(typeSummary2 = ((UMLType)componentArray[n2]).getSummary())) {
                return (UMLType)componentArray[n2];
            }
            ++n2;
        }
        return null;
    }

    protected UMLType find(String string) {
        Component[] componentArray = this.getComponents();
        int n = componentArray.length;
        boolean bl = false;
        if (string == null) {
            return null;
        }
        int n2 = 0;
        while (n2 < n) {
            String string2;
            if (componentArray[n2] instanceof UMLType && string.equals(string2 = ((UMLType)componentArray[n2]).getID())) {
                return (UMLType)componentArray[n2];
            }
            ++n2;
        }
        return null;
    }

    protected SegmentedLine find(String string, String string2) {
        UMLType uMLType = this.find(string);
        UMLType uMLType2 = this.find(string2);
        if (uMLType == null || uMLType2 == null) {
            return null;
        }
        Iterator iterator = this.getLines();
        while (iterator.hasNext()) {
            SegmentedLine segmentedLine = (SegmentedLine)iterator.next();
            if (!segmentedLine.match(uMLType, uMLType2)) continue;
            return segmentedLine;
        }
        return null;
    }

    void setSummary(PackageSummary packageSummary) {
        this.summary = packageSummary;
        if (this.summary != null) {
            this.packageName = this.summary.getName();
        }
    }

    void updateClassListPanel() {
        if (this.classListPanel == null) {
            return;
        }
        if (this.first) {
            this.first = false;
            return;
        }
        this.classListPanel.load(this.summary);
    }

    private void defaultValues() {
        this.packageName = "Unknown Package";
        this.hasChanged = false;
        try {
            FileSettings fileSettings = FileSettings.getSettings("Refactory", "uml");
            fileSettings.setContinuallyReload(true);
            Vertex.setVertexSize(fileSettings.getInteger("sticky.point.size"));
            Vertex.setNear(fileSettings.getDouble("halo.size"));
        }
        catch (MissingSettingsException missingSettingsException) {
            Vertex.setNear(3.0);
            Vertex.setVertexSize(5);
        }
    }

    private void addMouseAdapter() {
        LineMouseAdapter lineMouseAdapter = new LineMouseAdapter(this);
        this.addMouseListener(lineMouseAdapter);
        this.addMouseMotionListener(lineMouseAdapter);
    }

    private void reset() {
        if (this.scrollPane == null) {
            this.repaint();
        } else {
            Dimension dimension = this.getPreferredSize();
            JViewport jViewport = this.scrollPane.getViewport();
            Dimension dimension2 = jViewport.getSize();
            this.setSize(Math.max(dimension.width, dimension2.width), Math.max(dimension.height, dimension2.height));
            jViewport.setViewSize(this.getSize());
            this.scrollPane.repaint();
        }
    }
}

