/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.uml;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import org.acm.seguin.pretty.ModifierHolder;
import org.acm.seguin.uml.ProtectionIcon;
import org.acm.seguin.uml.UMLIcon;
import org.acm.seguin.uml.UMLType;
import org.acm.seguin.uml.line.DragPanelAdapter;
import org.acm.seguin.uml.line.EndPointPanel;
import org.acm.seguin.uml.line.SizableLabel;

public class UMLLine
extends EndPointPanel {
    protected SizableLabel label;
    protected int wide;
    protected int high;
    protected UMLIcon icon;
    private int iconWidth = 8;
    private int iconHeight = 8;
    private int protection;
    private UMLType parent;
    private Font font;
    public static final int PUBLIC = 0;
    public static final int PROTECTED_PRIVATE = 1;
    public static final int PROTECTED = 2;
    public static final int DEFAULT = 3;
    public static final int PRIVATE = 4;
    protected static Color[] protectionColors = null;
    protected static Font defaultFont = null;
    protected static Font staticFont = null;
    protected static Font abstractFont = null;
    protected static Font titleFont = null;
    protected static Font abstractTitleFont = null;
    protected static final int iconMargin = 1;
    protected static final int labelMargin = 1;

    public UMLLine(UMLType uMLType, DragPanelAdapter dragPanelAdapter) {
        super(null, true);
        this.parent = uMLType;
        this.label = new SizableLabel("");
        this.label.setLocation(this.iconWidth + 2 + 1, 1);
        this.add(this.label);
        this.addMouseListener(dragPanelAdapter);
        this.addMouseMotionListener(dragPanelAdapter);
        this.icon = new ProtectionIcon(this.iconWidth, this.iconHeight);
    }

    public void setProtection(int n) {
        this.protection = n;
        if (this.icon instanceof ProtectionIcon) {
            ((ProtectionIcon)this.icon).setProtection(n);
        }
    }

    public void setLabelText(String string) {
        this.label.setText(string);
        Dimension dimension = this.label.getPreferredSize();
        this.label.setSize(dimension);
        this.high = Math.max(this.iconWidth + 2, dimension.height + 2);
        this.wide = dimension.width + this.iconWidth + 2 + 2;
    }

    public void setLabelFont(Font font) {
        this.label.setSLFont(font);
        Dimension dimension = this.label.getPreferredSize();
        this.label.setSize(dimension);
        this.high = Math.max(this.iconWidth + 2, dimension.height + 2);
        this.wide = dimension.width + this.iconWidth + 2 + 2;
        this.font = font;
    }

    public void setSelected(boolean bl) {
        this.parent.setSelected(bl);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.wide, this.high);
    }

    public UMLType getParentType() {
        return this.parent;
    }

    public boolean isSelected() {
        return this.parent.isSelected();
    }

    public void paint(Graphics graphics) {
        this.setBackground(this.getDefaultBackground());
        super.paint(graphics);
        this.drawIcon(graphics, 0, 0);
    }

    public void print(Graphics graphics, int n, int n2) {
        Point point = this.label.getLocation();
        this.label.print(graphics, n + point.x, n2 + point.y);
        this.drawIcon(graphics, n, n2);
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.label.addMouseListener(mouseListener);
        super.addMouseListener(mouseListener);
    }

    public void removeMouseListener(MouseListener mouseListener) {
        this.label.removeMouseListener(mouseListener);
        super.removeMouseListener(mouseListener);
    }

    public void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.label.addMouseMotionListener(mouseMotionListener);
        super.addMouseMotionListener(mouseMotionListener);
    }

    public void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.label.removeMouseMotionListener(mouseMotionListener);
        super.removeMouseMotionListener(mouseMotionListener);
    }

    public void scale(double d) {
        super.scale(d);
        this.label.scale(d);
    }

    protected Color getDefaultBackground() {
        return this.parent.getBackground();
    }

    protected void drawIcon(Graphics graphics, int n, int n2) {
        int n3 = n2 + (this.high - this.icon.getIconHeight()) / 2;
        double d = this.getScale();
        this.icon.setScale(d);
        this.icon.paintIcon(this, graphics, n, n3);
    }

    protected static int getProtectionCode(ModifierHolder modifierHolder) {
        if (modifierHolder.isPublic()) {
            return 0;
        }
        if (modifierHolder.isProtected() && modifierHolder.isPrivate()) {
            return 1;
        }
        if (modifierHolder.isPrivate()) {
            return 4;
        }
        if (modifierHolder.isProtected()) {
            return 2;
        }
        return 3;
    }

    protected static Font getProtectionFont(boolean bl, ModifierHolder modifierHolder) {
        if (staticFont == null) {
            UMLLine.initFonts();
        }
        if (modifierHolder == null) {
            return defaultFont;
        }
        if (modifierHolder.isAbstract()) {
            if (bl) {
                return abstractTitleFont;
            }
            return abstractFont;
        }
        if (modifierHolder.isStatic()) {
            return staticFont;
        }
        if (bl) {
            return titleFont;
        }
        return defaultFont;
    }

    protected static Color getProtectionColor(int n) {
        if (protectionColors == null) {
            protectionColors = new Color[5];
            UMLLine.protectionColors[0] = Color.green;
            UMLLine.protectionColors[1] = Color.blue;
            UMLLine.protectionColors[2] = Color.yellow;
            UMLLine.protectionColors[3] = Color.orange;
            UMLLine.protectionColors[4] = Color.red;
        }
        return protectionColors[n];
    }

    private static void initFonts() {
        defaultFont = new Font("Serif", 0, 12);
        staticFont = new Font("Serif", 1, 12);
        abstractFont = new Font("Serif", 2, 12);
        titleFont = new Font("Serif", 0, 16);
        abstractTitleFont = new Font("Serif", 2, 16);
    }
}

