/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.tools.install;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import org.acm.seguin.awt.ExceptionPrinter;
import org.acm.seguin.util.FileSettings;
import org.acm.seguin.util.MissingSettingsException;

public class RefactoryStorage {
    private HashMap map = new HashMap();

    public RefactoryStorage() {
        this.load();
    }

    public int getValue(String string) {
        Object v = this.map.get(this.normalize(string));
        if (v == null) {
            return 1000;
        }
        return (Integer)v;
    }

    public void addKey(String string, int n) {
        this.map.put(this.normalize(string), new Integer(n));
    }

    public void store() {
        try {
            String string = FileSettings.getSettingsRoot() + File.separator + ".Refactory";
            String string2 = string + File.separator + "refactory.settings";
            PrintWriter printWriter = new PrintWriter(new FileWriter(string2));
            Iterator iterator = this.map.keySet().iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                printWriter.println(string3 + "=" + this.map.get(string3));
            }
            printWriter.close();
        }
        catch (IOException iOException) {
            ExceptionPrinter.print(iOException, false);
        }
    }

    private String normalize(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (Character.isJavaIdentifierPart(c) || c == '.') {
                stringBuffer.append(c);
            } else {
                stringBuffer.append('_');
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private void load() {
        try {
            FileSettings fileSettings = FileSettings.getSettings("Refactory", "refactory");
            Enumeration enumeration = fileSettings.getKeys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                this.map.put(string, new Integer(fileSettings.getInteger(string)));
            }
        }
        catch (MissingSettingsException missingSettingsException) {
            // empty catch block
        }
    }
}

