/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.tools.install;

import java.awt.Component;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.JOptionPane;
import org.acm.seguin.awt.ExceptionPrinter;
import org.acm.seguin.io.FileCopy;
import org.acm.seguin.print.PrintingSettings;
import org.acm.seguin.tools.install.PrettyPrinterConfigGUI;
import org.acm.seguin.tools.stub.StubPrompter;
import org.acm.seguin.util.FileSettings;
import org.acm.seguin.util.MissingSettingsException;

public class RefactoryInstaller {
    private boolean refactory;
    public static final double PRETTY_CURRENT_VERSION = 3.8;
    private static final double UML_CURRENT_VERSION = 1.2;

    public RefactoryInstaller(boolean bl) {
        this.refactory = bl;
    }

    public void run() {
        try {
            String string;
            double d;
            Object object;
            PrintWriter printWriter;
            FileWriter fileWriter;
            File file;
            Object object2;
            File file2;
            File file3;
            String string2 = FileSettings.getSettingsRoot();
            File file4 = new File(string2);
            String string3 = string2 + File.separator + ".Refactory";
            File file5 = new File(string3);
            if (!file5.exists()) {
                file5.mkdirs();
            }
            if ((file3 = new File(file4, "undo.stk")).exists()) {
                file2 = new File(file5, "undo.stk");
                new FileCopy(file3, file2).run();
                file3.delete();
            }
            if ((file2 = new File(file4, "log.txt")).exists()) {
                object2 = new File(file5, "log.txt");
                new FileCopy(file2, (File)object2).run();
                file2.delete();
            }
            if (!(file = new File((String)(object2 = string3 + File.separator + "pretty.settings"))).exists()) {
                fileWriter = new FileWriter(file);
                printWriter = new PrintWriter(fileWriter);
                this.prettySettings(printWriter, 0.0);
                printWriter.flush();
                fileWriter.flush();
                printWriter.close();
                fileWriter.close();
                object = FileSettings.getSettings("Refactory", "pretty");
                ((FileSettings)object).setReloadNow(true);
            } else {
                object = FileSettings.getSettings("Refactory", "pretty");
                ((FileSettings)object).setReloadNow(true);
                d = 1.0;
                try {
                    string = ((FileSettings)object).getString("indent");
                }
                catch (MissingSettingsException missingSettingsException) {
                    d = 0.5;
                }
                try {
                    d = ((FileSettings)object).getDouble("version");
                }
                catch (MissingSettingsException missingSettingsException) {
                    // empty catch block
                }
                if (d < 3.75) {
                    fileWriter = new FileWriter(file.getPath(), true);
                    printWriter = new PrintWriter(fileWriter);
                    this.prettySettings(printWriter, d);
                    printWriter.flush();
                    fileWriter.flush();
                    printWriter.close();
                    fileWriter.close();
                }
                ((FileSettings)object).setReloadNow(true);
            }
            object2 = string3 + File.separator + "uml.settings";
            file = new File((String)object2);
            if (!file.exists()) {
                fileWriter = new FileWriter(file);
                printWriter = new PrintWriter(fileWriter);
                this.umlSettings(printWriter, 0.0, string2);
                printWriter.close();
                fileWriter.close();
            } else {
                object = FileSettings.getSettings("Refactory", "uml");
                ((FileSettings)object).setReloadNow(true);
                d = 1.0;
                try {
                    string = ((FileSettings)object).getString("stub.dir");
                }
                catch (MissingSettingsException missingSettingsException) {
                    d = 0.5;
                }
                try {
                    d = ((FileSettings)object).getDouble("version");
                }
                catch (MissingSettingsException missingSettingsException) {
                    // empty catch block
                }
                if (d < 1.15) {
                    fileWriter = new FileWriter(file.getPath(), true);
                    printWriter = new PrintWriter(fileWriter);
                    this.umlSettings(printWriter, d, string2);
                    printWriter.flush();
                    printWriter.close();
                }
            }
            object2 = string3 + File.separator + "printing.settings";
            file = new File((String)object2);
            if (!file.exists()) {
                new PrintingSettings().save();
            }
            if (!(file = new File((String)(object2 = string3 + File.separator + "vss.settings"))).exists()) {
                fileWriter = new FileWriter(file);
                printWriter = new PrintWriter(fileWriter);
                this.vssSettings(printWriter);
                printWriter.close();
                fileWriter.close();
            }
            if (!(file = new File((String)(object2 = string3 + File.separator + "process.settings"))).exists()) {
                fileWriter = new FileWriter(file);
                printWriter = new PrintWriter(fileWriter);
                this.processSettings(printWriter);
                printWriter.close();
                fileWriter.close();
            }
            if (!(file = new File((String)(object2 = string3 + File.separator + "creation.txt"))).exists()) {
                this.generateCreationText(file);
            } else {
                object = new GregorianCalendar();
                ((Calendar)object).setTime(new Date(file.lastModified()));
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.add(2, -1);
                File file6 = new File(string3, "log.txt");
                if (gregorianCalendar.after(object) && file6.exists() && file6.length() > 0L) {
                    this.generateCreationText(file);
                    string = "Chris Seguin wrote JRefactory to discover\nhow people use refactorings.  While you have\nused this tool, it has created a log of which\nrefactorings you used.  This log contains a\nnumber representing the refactoring and a date.\n\nI would really appreciate it if you could e-mail\nthe following file to seguin@acm.org.\n\n" + string3 + File.separator + "log.txt\n" + "\n" + "Thank you for taking the time to do this.\n";
                    JOptionPane.showMessageDialog(null, string, "Research request", 3);
                }
            }
        }
        catch (IOException iOException) {
            ExceptionPrinter.print(iOException, false);
        }
        if (this.refactory) {
            this.jsdkStubInstall();
        }
    }

    private void prettySettings(PrintWriter printWriter, double d) {
        PrettyPrinterConfigGUI prettyPrinterConfigGUI = new PrettyPrinterConfigGUI(false);
        prettyPrinterConfigGUI.initializeFrame(false);
        prettyPrinterConfigGUI.save();
        FileSettings.getSettings("Refactory", "pretty").setReloadNow(true);
    }

    private void vssSettings(PrintWriter printWriter) {
        printWriter.println("#  This is the full path the visual source safe's executable ");
        printWriter.println("vss=c:\\\\program files\\\\microsoft visual studio\\\\win32\\\\ss.exe");
        printWriter.println(" ");
        printWriter.println("#  The following are the extensions of files which are");
        printWriter.println("#  stored in visual source safe");
        printWriter.println("extension.1=.java");
        printWriter.println("extension.2=.properties");
        printWriter.println("extension.3=.xml");
        printWriter.println("extension.4=.html");
        printWriter.println("extension.5=.htm");
        printWriter.println(" ");
        printWriter.println("#  The following shows how the projects in Visual Source");
        printWriter.println("#  Safe map to directories on the hard disk");
        printWriter.println("source.1=c:\\\\java\\\\src");
        printWriter.println("project.1=$/Source");
        printWriter.println(" ");
        printWriter.println("source.2=c:\\\\java\\\\properties");
        printWriter.println("project.2=$/Properties");
        printWriter.println(" ");
        printWriter.println("source.3=c:\\\\public_html");
        printWriter.println("project.3=$/HTML");
        printWriter.println(" ");
        printWriter.println("source.4=c:\\\\public_html\\\\xml");
        printWriter.println("project.4=$/XML");
    }

    private void processSettings(PrintWriter printWriter) {
        printWriter.println("#  The following settings are used to set");
        printWriter.println("#  up the process panel.");
        printWriter.println("#");
        printWriter.println("#  The button.name is the value that appears on the button");
        printWriter.println("#  The button.cmd is the value that is saved to the process");
        printWriter.println("#      tracking file");
        printWriter.println("#");
        printWriter.println("#  The system loads all properties starting with index 0");
        printWriter.println("#  and continuing until one or both of the next pair of");
        printWriter.println("#  values is missing.");
        printWriter.println(" ");
        printWriter.println("button.name.0=Design");
        printWriter.println("button.cmd.0=Design");
        printWriter.println(" ");
        printWriter.println("button.name.1=Coding");
        printWriter.println("button.cmd.1=Coding");
        printWriter.println(" ");
        printWriter.println("button.name.2=Unit Testing");
        printWriter.println("button.cmd.2=Unit Testing");
        printWriter.println(" ");
        printWriter.println("button.name.3=Verification");
        printWriter.println("button.cmd.3=Verification");
        printWriter.println(" ");
        printWriter.println("button.name.4=Meeting");
        printWriter.println("button.cmd.4=Meeting");
        printWriter.println(" ");
        printWriter.println("button.name.5=Interrupt");
        printWriter.println("button.cmd.5=Interrupt");
        printWriter.println(" ");
        printWriter.println("#  The name of the file to store the process data in");
        printWriter.println("process.file=c:\\tools\\process.txt");
    }

    private void umlSettings(PrintWriter printWriter, double d, String string) {
        if (d < 1.15) {
            printWriter.println("");
            printWriter.println("#  UML File Version");
            printWriter.println("version=1.2");
            printWriter.println("");
        }
        if (d < 0.95) {
            printWriter.println("#  The following settings are used to set");
            printWriter.println("#  up the uml diagrams.");
            printWriter.println("");
            printWriter.println("#");
            printWriter.println("#  The directory containing the stub files");
            printWriter.println("#");
            printWriter.println("stub.dir=" + this.doubleBackslashes(string));
            printWriter.println("");
            printWriter.println("#");
            printWriter.println("#  Size of the box where a segmented line changes direction");
            printWriter.println("#");
            printWriter.println("sticky.point.size=3");
            printWriter.println("");
            printWriter.println("#");
            printWriter.println("#  Size of the area where you must be to select the sticky point");
            printWriter.println("#");
            printWriter.println("halo.size=6");
            printWriter.println("");
            printWriter.println("#");
            printWriter.println("#  The type of icon for the UML diagram.  The valid types are:");
            printWriter.println("#    colored circle - the original for specifying scope");
            printWriter.println("#    letter - a letter + for public, # for protected, etc");
            printWriter.println("#");
            printWriter.println("icon.type=colored circle");
            printWriter.println("");
        }
        if (d < 1.05) {
            printWriter.println("#");
            printWriter.println("#  A pattern to cause the loading to skip");
            printWriter.println("#  a particular directory.  For instance,");
            printWriter.println("#  .cvs means that JRefactory will skip loading");
            printWriter.println("#  any directory that matches *.cvs*.  Additional");
            printWriter.println("#  patterns can be separated by the path separator");
            printWriter.println("#  character");
            printWriter.println("#");
            printWriter.println("skip.dir=");
            printWriter.println("");
            printWriter.println("#  The extension to add to the existing file when it is");
            printWriter.println("#  refactored.  The # represents the number of the copy");
            printWriter.println("#  of the file");
            printWriter.println("#");
            printWriter.println("backup.ext=.#");
            printWriter.println("");
        }
        if (d < 1.15) {
            printWriter.println("#");
            printWriter.println("#  This is used by the command line version");
            printWriter.println("#  of the program to launch a source code editor");
            printWriter.println("#  The command line program can get either 1 or ");
            printWriter.println("#  2 arguments.  These are:");
            printWriter.println("#     $FILE - the path to the file for the editor");
            printWriter.println("#     $LINE - the line number");
            printWriter.println("#  If your editor cannot accept the line number");
            printWriter.println("#  command line, leave out that variable");
            printWriter.println("#");
            printWriter.println("#source.editor=notepad $FILE");
            printWriter.println("#source.editor=gnuclientw -F +$LINE $FILE");
        }
    }

    private void jsdkStubInstall() {
        File file;
        String string;
        Object object;
        FileSettings fileSettings = FileSettings.getSettings("Refactory", "pretty");
        fileSettings.setContinuallyReload(true);
        try {
            object = FileSettings.getSettings("Refactory", "uml");
            string = ((FileSettings)object).getString("stub.dir");
        }
        catch (MissingSettingsException missingSettingsException) {
            string = System.getProperty("user.home");
        }
        object = new File(string + File.separator + ".Refactory");
        if (!((File)object).exists()) {
            ((File)object).mkdirs();
        }
        if (!(file = new File((File)object, "JDK.stub")).exists()) {
            ((Component)new StubPrompter(null, file)).setVisible(true);
        }
        fileSettings.setContinuallyReload(false);
    }

    private String doubleBackslashes(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '\\') {
                stringBuffer.append("\\\\");
            } else {
                stringBuffer.append(c);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    private void generateCreationText(File file) throws IOException {
        FileWriter fileWriter = new FileWriter(file);
        PrintWriter printWriter = new PrintWriter(fileWriter);
        printWriter.println("Created on " + DateFormat.getDateTimeInstance().format(new Date()));
        printWriter.close();
        fileWriter.close();
    }

    public static void main(String[] stringArray) {
        new RefactoryInstaller(false).run();
    }
}

