/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.tools.install;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.acm.seguin.ide.common.ExitOnCloseAdapter;
import org.acm.seguin.io.FileCopy;
import org.acm.seguin.tools.install.BlockGroup;
import org.acm.seguin.tools.install.CStyleGroup;
import org.acm.seguin.tools.install.DescriptionGroup;
import org.acm.seguin.tools.install.JavadocGroup;
import org.acm.seguin.tools.install.MiscGroup;
import org.acm.seguin.tools.install.PrettyPrintBuffer;
import org.acm.seguin.tools.install.SettingGroup;
import org.acm.seguin.tools.install.SingleLineGroup;
import org.acm.seguin.tools.install.SortGroup;
import org.acm.seguin.tools.install.SpacingGroup;
import org.acm.seguin.util.FileSettings;

public class PrettyPrinterConfigGUI {
    private JTabbedPane tabs;
    private LinkedList list = new LinkedList();
    private boolean isFromCommandLine;
    private JFrame frame = null;
    private PrettyPrintBuffer prettyPrinter;

    public PrettyPrinterConfigGUI(boolean bl) {
        this.isFromCommandLine = bl;
    }

    public void run() {
        this.backup();
        if (this.frame == null) {
            this.initializeFrame(true);
        } else {
            this.reload();
        }
        ((Component)this.frame).setVisible(true);
    }

    public void backup() {
        FileSettings fileSettings = FileSettings.getSettings("Refactory", "pretty");
        File file = fileSettings.getFile();
        File file2 = new File(file.getParentFile(), file.getName() + ".backup");
        new FileCopy(file, file2, false).run();
    }

    public void restore() {
        FileSettings fileSettings = FileSettings.getSettings("Refactory", "pretty");
        File file = fileSettings.getFile();
        File file2 = new File(file.getParentFile(), file.getName() + ".backup");
        new FileCopy(file2, file, false).run();
    }

    public void save() {
        try {
            File file = new File(FileSettings.getSettingsRoot(), ".Refactory");
            File file2 = new File(file, "pretty.settings");
            System.out.println("Saving:  " + file2.getPath());
            PrintWriter printWriter = new PrintWriter(new FileWriter(file2));
            printWriter.println("#  Version");
            printWriter.println("version=3.8");
            printWriter.println(" ");
            Iterator iterator = this.list.iterator();
            while (iterator.hasNext()) {
                SettingGroup settingGroup = (SettingGroup)iterator.next();
                settingGroup.generateSetting(printWriter);
            }
            printWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.out);
        }
    }

    private void add(SettingGroup settingGroup) {
        this.tabs.add(settingGroup.getGroupName(), new JScrollPane(settingGroup));
        this.list.add(settingGroup);
    }

    private void createTabs() {
        this.tabs = new JTabbedPane();
        this.add(new SpacingGroup());
        this.add(new BlockGroup());
        this.add(new SingleLineGroup());
        this.add(new CStyleGroup());
        this.add(new JavadocGroup());
        this.add(new DescriptionGroup());
        this.add(new MiscGroup());
        this.add(new SortGroup());
    }

    private String load(JEditorPane jEditorPane) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("package test;\n");
        stringBuffer.append("\n");
        stringBuffer.append("import java.io.*;\n");
        stringBuffer.append("import java.util.*;\n");
        stringBuffer.append("\n");
        stringBuffer.append("public class TestClass extends Object {\n");
        stringBuffer.append("  private String privateField;\n");
        stringBuffer.append("  public String getField() { return privateField; }\n");
        stringBuffer.append("  public void setField(String value) { privateField = value; }\n");
        stringBuffer.append("  public void run() {\n");
        stringBuffer.append("    int length = privateField.length();\n");
        stringBuffer.append("    switch (length) {\n");
        stringBuffer.append("      case 1:\n");
        stringBuffer.append("        System.out.println(\"Length is one\");\n");
        stringBuffer.append("        break;\n");
        stringBuffer.append("      default:\n");
        stringBuffer.append("        System.out.println(\"Length is not one\");\n");
        stringBuffer.append("        break;\n");
        stringBuffer.append("    }\n");
        stringBuffer.append("  }");
        stringBuffer.append("  private int getCode(int value) {");
        stringBuffer.append("    if (value > 0)");
        stringBuffer.append("      System.out.println(\"positive\");");
        stringBuffer.append("    else");
        stringBuffer.append("      System.out.println(\"negative\");");
        stringBuffer.append("    ");
        stringBuffer.append("    if (value % 2 == 0) {");
        stringBuffer.append("      System.out.println(\"even\");");
        stringBuffer.append("    }");
        stringBuffer.append("    else {");
        stringBuffer.append("      System.out.println(\"odd\");");
        stringBuffer.append("    }");
        stringBuffer.append("    ");
        stringBuffer.append("    try {");
        stringBuffer.append("       invokeOther();");
        stringBuffer.append("    } catch (Exception exc) {");
        stringBuffer.append("       exc.printStackTrace();");
        stringBuffer.append("    }");
        stringBuffer.append("  }");
        stringBuffer.append("}\n");
        String string = stringBuffer.toString();
        jEditorPane.setText(string);
        return string;
    }

    protected void initializeFrame(boolean bl) {
        this.frame = new JFrame("Pretty Printer Configuration");
        this.createTabs();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        jPanel.add((Component)this.tabs, gridBagConstraints);
        JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.setFont(new Font("Monospaced", 0, 10));
        String string = this.load(jEditorPane);
        JScrollPane jScrollPane = new JScrollPane(jEditorPane);
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        if (bl) {
            this.prettyPrinter = new PrettyPrintBuffer(jEditorPane, string);
            this.prettyPrinter.prettyPrintCurrentWindow();
        }
        this.frame.getContentPane().add(jPanel);
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem("Save");
        jMenuItem.addActionListener(new SaveAdapter());
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Restore");
        jMenuItem.addActionListener(new RestoreAdapter());
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Close");
        jMenuItem.addActionListener(new CloseAdapter());
        jMenu.add(jMenuItem);
        this.frame.setJMenuBar(jMenuBar);
        this.frame.pack();
        if (this.isFromCommandLine) {
            this.frame.addWindowListener(new ExitOnCloseAdapter());
        } else {
            this.frame.addWindowListener(new CloseFrameAdapter());
        }
    }

    public static void main(String[] stringArray) {
        new PrettyPrinterConfigGUI(true).run();
    }

    public void reload() {
        FileSettings fileSettings = FileSettings.getSettings("Refactory", "pretty");
        fileSettings.setReloadNow(true);
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            SettingGroup settingGroup = (SettingGroup)iterator.next();
            settingGroup.reload();
        }
        this.prettyPrinter.prettyPrintCurrentWindow();
    }

    class CloseFrameAdapter
    extends WindowAdapter {
        CloseFrameAdapter() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            ((Component)PrettyPrinterConfigGUI.this.frame).setVisible(false);
        }
    }

    private class CloseAdapter
    implements ActionListener {
        private CloseAdapter() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (PrettyPrinterConfigGUI.this.isFromCommandLine) {
                System.exit(0);
            } else {
                ((Component)PrettyPrinterConfigGUI.this.frame).setVisible(false);
            }
        }
    }

    private class RestoreAdapter
    implements ActionListener {
        private RestoreAdapter() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PrettyPrinterConfigGUI.this.restore();
        }
    }

    private class SaveAdapter
    implements ActionListener {
        private SaveAdapter() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PrettyPrinterConfigGUI.this.save();
            PrettyPrinterConfigGUI.this.prettyPrinter.prettyPrintCurrentWindow();
        }
    }
}

