/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.tools.build;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.LinkedList;
import org.acm.seguin.io.DirectoryTreeTraversal;

public class JavadocBuilder
extends DirectoryTreeTraversal {
    private LinkedList directoryList = new LinkedList();
    private PrintWriter output;
    private int rootLength;
    private boolean first;
    private int directoryCount;
    private static final int MAX_DIRS = 5;

    public JavadocBuilder(String string, PrintWriter printWriter) {
        super(string);
        this.output = printWriter;
        this.first = true;
        this.rootLength = string.length();
        this.directoryCount = 0;
    }

    protected boolean isTarget(File file) {
        return file.getName().endsWith(".java");
    }

    protected void visit(File file) {
        String string = file.getParent();
        if (!this.directoryList.contains(string)) {
            this.directoryList.add(string);
            if (string.length() != this.rootLength) {
                String string2 = string.substring(this.rootLength + 1);
                String string3 = this.convert(string2);
                this.output.println(string3);
            }
        }
    }

    private String convert(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(n) == '\\' || string.charAt(n) == '/') {
                stringBuffer.append(".");
            } else {
                stringBuffer.append(string.charAt(n));
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        String string = "sample.jar";
        String string2 = System.getProperty("user.dir");
        PrintWriter printWriter = null;
        try {
            printWriter = stringArray.length > 0 ? new PrintWriter(new FileWriter(stringArray[0])) : new PrintWriter(new OutputStreamWriter(System.out));
        }
        catch (IOException iOException) {
            System.out.println("Unable to create the output file:  " + stringArray[0]);
            return;
        }
        if (stringArray.length > 1) {
            string2 = stringArray[1];
        }
        new JavadocBuilder(string2, printWriter).go();
        printWriter.println("");
        printWriter.flush();
        printWriter.close();
    }
}

