/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.summary.query;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.acm.seguin.parser.ast.ASTName;
import org.acm.seguin.parser.ast.SimpleNode;
import org.acm.seguin.parser.factory.FileParserFactory;
import org.acm.seguin.parser.query.PackageNameGetter;
import org.acm.seguin.summary.FileSummary;
import org.acm.seguin.summary.PackageSummary;
import org.acm.seguin.summary.Summary;

public class TopLevelDirectory {
    public static File getPackageDirectory(Summary summary, String string) {
        Object object;
        File file = null;
        if (summary != null) {
            object = TopLevelDirectory.getFileSummary(summary);
            file = TopLevelDirectory.query((FileSummary)object);
        }
        if (file == null) {
            file = TopLevelDirectory.query();
        }
        object = new StringTokenizer(string, ".");
        File file2 = file;
        while (((StringTokenizer)object).hasMoreTokens()) {
            file2 = new File(file2, ((StringTokenizer)object).nextToken());
        }
        return file2;
    }

    public static File query(FileSummary fileSummary) {
        File file = fileSummary.getFile();
        if (file == null) {
            return null;
        }
        File file2 = file.getParentFile();
        PackageSummary packageSummary = (PackageSummary)fileSummary.getParent();
        String string = packageSummary.getName();
        if (string.length() == 0) {
            return file2;
        }
        int n = string.indexOf(".");
        file2 = file2.getParentFile();
        while (n != -1) {
            n = string.indexOf(".", n + 1);
            file2 = file2.getParentFile();
        }
        return file2;
    }

    public static File query(File file, String string) {
        File file2 = new File(file, string);
        FileParserFactory fileParserFactory = new FileParserFactory(file2);
        SimpleNode simpleNode = fileParserFactory.getAbstractSyntaxTree(false);
        File file3 = TopLevelDirectory.getParent(file2);
        ASTName aSTName = PackageNameGetter.query(simpleNode);
        if (aSTName != null) {
            int n = 0;
            while (n < aSTName.getNameSize()) {
                file3 = TopLevelDirectory.getParent(file3);
                ++n;
            }
        }
        return file3;
    }

    private static File getParent(File file) {
        try {
            String string = file.getCanonicalPath();
            File file2 = new File(string);
            return file2.getParentFile();
        }
        catch (IOException iOException) {
            return file.getParentFile();
        }
    }

    private static FileSummary getFileSummary(Summary summary) {
        Summary summary2 = summary;
        while (!(summary2 instanceof FileSummary)) {
            if ((summary2 = summary2.getParent()) != null) continue;
            return null;
        }
        return (FileSummary)summary2;
    }

    private static File query() {
        FileSummary fileSummary = TopLevelDirectory.findFileSummary();
        if (fileSummary == null) {
            return new File(System.getProperty("user.dir"));
        }
        PackageSummary packageSummary = (PackageSummary)fileSummary.getParent();
        String string = packageSummary.getName();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        File file = null;
        try {
            file = new File(fileSummary.getFile().getCanonicalPath());
        }
        catch (IOException iOException) {
            file = fileSummary.getFile();
        }
        File file2 = file.getParentFile();
        while (stringTokenizer.hasMoreTokens()) {
            file2 = file2.getParentFile();
            String string2 = stringTokenizer.nextToken();
        }
        return file2;
    }

    private static FileSummary findFileSummary() {
        Iterator iterator = PackageSummary.getAllPackages();
        if (iterator != null) {
            while (iterator.hasNext()) {
                PackageSummary packageSummary = (PackageSummary)iterator.next();
                Iterator iterator2 = packageSummary.getFileSummaries();
                while (iterator2 != null && iterator2.hasNext()) {
                    FileSummary fileSummary = (FileSummary)iterator2.next();
                    if (fileSummary.getFile() == null) continue;
                    return fileSummary;
                }
            }
        }
        return null;
    }
}

