/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.summary.query;

import java.util.Iterator;
import org.acm.seguin.pretty.ModifierHolder;
import org.acm.seguin.summary.FieldSummary;
import org.acm.seguin.summary.TypeDeclSummary;
import org.acm.seguin.summary.TypeSummary;
import org.acm.seguin.summary.query.GetTypeSummary;

public class FieldQuery {
    public static final int PRIVATE = 1;
    public static final int DEFAULT = 2;
    public static final int PROTECTED = 3;
    public static final int PUBLIC = 4;

    public static FieldSummary find(TypeSummary typeSummary, String string) {
        FieldSummary fieldSummary = FieldQuery.query(typeSummary, string, 1);
        if (fieldSummary == null) {
            fieldSummary = FieldQuery.queryAncestors(typeSummary, string, 3);
        }
        return fieldSummary;
    }

    public static FieldSummary query(TypeSummary typeSummary, String string, int n) {
        Iterator iterator = typeSummary.getFields();
        if (iterator != null) {
            while (iterator.hasNext()) {
                FieldSummary fieldSummary = (FieldSummary)iterator.next();
                if (!FieldQuery.appropriate(fieldSummary, string, n)) continue;
                return fieldSummary;
            }
        }
        return null;
    }

    public static FieldSummary queryAncestors(TypeSummary typeSummary, String string, int n) {
        TypeDeclSummary typeDeclSummary = typeSummary.getParentClass();
        TypeSummary typeSummary2 = GetTypeSummary.query(typeDeclSummary);
        while (typeSummary2 != null) {
            FieldSummary fieldSummary = FieldQuery.query(typeSummary2, string, n);
            if (fieldSummary != null) {
                return fieldSummary;
            }
            typeDeclSummary = typeSummary2.getParentClass();
            typeSummary2 = GetTypeSummary.query(typeDeclSummary);
        }
        return null;
    }

    private static boolean appropriate(FieldSummary fieldSummary, String string, int n) {
        if (fieldSummary.getName().equals(string)) {
            ModifierHolder modifierHolder = fieldSummary.getModifiers();
            if (n == 1) {
                return true;
            }
            if (n == 2 && !modifierHolder.isPrivate()) {
                return true;
            }
            if (n == 3 && (modifierHolder.isPublic() || modifierHolder.isProtected())) {
                return true;
            }
            if (n == 4 && modifierHolder.isPublic()) {
                return true;
            }
        }
        return false;
    }
}

