/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.summary.load;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import org.acm.seguin.summary.load.LoadStatus;
import org.acm.seguin.tools.install.RefactoryStorage;

public class SwingLoadStatus
extends JDialog
implements LoadStatus {
    private JLabel label;
    private JProgressBar progress;
    private int count;
    private int max;
    private int fivePercent;
    private String oldName;
    private RefactoryStorage lengths;

    public SwingLoadStatus() {
        super(new JFrame(), "Loading source files", false);
        this.getContentPane().setLayout(new GridLayout(2, 1));
        this.label = new JLabel("Loading:  XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        Dimension dimension = this.label.getPreferredSize();
        this.label.setSize(dimension);
        this.getContentPane().add(this.label);
        this.progress = new JProgressBar();
        this.progress.setSize(dimension);
        this.getContentPane().add(this.progress);
        this.pack();
        ((Component)this).setVisible(true);
        this.oldName = null;
        this.lengths = new RefactoryStorage();
    }

    public void setRoot(String string) {
        if (this.oldName != null) {
            this.lengths.addKey(this.oldName + ".count", this.count);
        }
        if (string.endsWith(".stub")) {
            string = string.substring(0, string.length() - 5);
            this.progress.setForeground(Color.red);
        } else {
            this.progress.setForeground(Color.blue);
        }
        this.label.setText("Loading:  " + string);
        this.label.setSize(this.label.getPreferredSize());
        this.count = 0;
        this.progress.setValue(this.count);
        this.max = this.lengths.getValue(string + ".count");
        this.progress.setMaximum(this.max);
        this.fivePercent = this.max / 20;
        this.oldName = string;
    }

    public void setCurrentFile(String string) {
        ++this.count;
        if (this.fivePercent < 1) {
            this.progress.setValue(this.count);
        } else if (this.count % this.fivePercent == 0) {
            this.progress.setValue(this.count);
        }
    }

    public void done() {
        this.dispose();
        if (this.oldName != null) {
            this.lengths.addKey(this.oldName + ".count", this.count);
        }
        this.lengths.store();
    }
}

