/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.summary;

import org.acm.seguin.parser.Node;
import org.acm.seguin.parser.ast.ASTName;
import org.acm.seguin.parser.ast.ASTPrimitiveType;
import org.acm.seguin.parser.ast.ASTResultType;
import org.acm.seguin.parser.ast.ASTType;
import org.acm.seguin.summary.Summary;
import org.acm.seguin.summary.SummaryVisitor;
import org.acm.seguin.summary.TypeSummary;
import org.acm.seguin.summary.query.GetTypeSummary;

public class TypeDeclSummary
extends Summary {
    private String typeName;
    private String packageName;
    private boolean primitive;
    private int arrayCount;

    public TypeDeclSummary(Summary summary) {
        super(summary);
        this.typeName = "void".intern();
        this.packageName = null;
        this.primitive = true;
        this.arrayCount = 0;
    }

    public TypeDeclSummary(Summary summary, ASTName aSTName) {
        super(summary);
        int n = aSTName.getNameSize();
        this.typeName = aSTName.getNamePart(n - 1).intern();
        if (n > 1) {
            StringBuffer stringBuffer = new StringBuffer(aSTName.getNamePart(0));
            int n2 = 1;
            while (n2 < n - 1) {
                stringBuffer.append(".");
                stringBuffer.append(aSTName.getNamePart(n2));
                ++n2;
            }
            this.packageName = stringBuffer.toString().intern();
        } else {
            this.packageName = null;
        }
        this.primitive = false;
        this.arrayCount = 0;
    }

    public TypeDeclSummary(Summary summary, ASTPrimitiveType aSTPrimitiveType) {
        super(summary);
        this.typeName = aSTPrimitiveType.getName().intern();
        this.packageName = null;
        this.primitive = true;
        this.arrayCount = 0;
    }

    public TypeDeclSummary(Summary summary, String string, String string2) {
        super(summary);
        this.typeName = string2;
        this.packageName = string;
        this.primitive = false;
        this.arrayCount = 0;
    }

    public void setArrayCount(int n) {
        if (n >= 0) {
            this.arrayCount = n;
        }
    }

    public int getArrayCount() {
        return this.arrayCount;
    }

    public boolean isArray() {
        return this.arrayCount > 0;
    }

    public String getPackage() {
        return this.packageName;
    }

    public String getType() {
        return this.typeName;
    }

    public boolean isPrimitive() {
        return this.primitive;
    }

    public String getLongName() {
        if (this.packageName == null) {
            return this.typeName;
        }
        return this.packageName + "." + this.typeName;
    }

    public String toString() {
        if (!this.isArray()) {
            return this.getLongName();
        }
        StringBuffer stringBuffer = new StringBuffer(this.getLongName());
        int n = 0;
        while (n < this.arrayCount) {
            stringBuffer.append("[]");
            ++n;
        }
        return stringBuffer.toString();
    }

    public Object accept(SummaryVisitor summaryVisitor, Object object) {
        return summaryVisitor.visit(this, object);
    }

    public boolean equals(Object object) {
        if (object instanceof TypeDeclSummary) {
            TypeDeclSummary typeDeclSummary = (TypeDeclSummary)object;
            boolean bl = this.typeName == null && typeDeclSummary.typeName == null || this.typeName != null && this.typeName.equals(typeDeclSummary.typeName);
            boolean bl2 = this.packageName == null && typeDeclSummary.packageName == null || this.packageName != null && this.packageName.equals(typeDeclSummary.packageName);
            boolean bl3 = this.primitive == typeDeclSummary.primitive;
            boolean bl4 = this.arrayCount == typeDeclSummary.arrayCount;
            return bl && bl2 && bl3 && bl4;
        }
        return super.equals(object);
    }

    public boolean isSame(TypeDeclSummary typeDeclSummary) {
        TypeSummary typeSummary;
        if (this.primitive) {
            if (!typeDeclSummary.primitive) {
                return false;
            }
            return this.typeName.equals(typeDeclSummary.typeName);
        }
        TypeSummary typeSummary2 = GetTypeSummary.query(this);
        return typeSummary2 == (typeSummary = GetTypeSummary.query(typeDeclSummary));
    }

    public static TypeDeclSummary getTypeDeclSummary(Summary summary, ASTType aSTType) {
        Node node = aSTType.jjtGetChild(0);
        TypeDeclSummary typeDeclSummary = node instanceof ASTPrimitiveType ? new TypeDeclSummary(summary, (ASTPrimitiveType)node) : new TypeDeclSummary(summary, (ASTName)node);
        typeDeclSummary.setArrayCount(aSTType.getArrayCount());
        return typeDeclSummary;
    }

    public static TypeDeclSummary getTypeDeclSummary(Summary summary, ASTResultType aSTResultType) {
        if (aSTResultType.hasAnyChildren()) {
            return TypeDeclSummary.getTypeDeclSummary(summary, (ASTType)aSTResultType.jjtGetChild(0));
        }
        return new TypeDeclSummary(summary);
    }

    public String getName() {
        return this.toString();
    }
}

