/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.summary;

import java.io.Serializable;
import org.acm.seguin.summary.SummaryVisitor;

public abstract class Summary
implements Serializable {
    private Summary parent;
    private int start;
    private int end;

    public Summary(Summary summary) {
        this.parent = summary;
        this.start = -1;
        this.end = -1;
    }

    public Summary getParent() {
        return this.parent;
    }

    public int getStartLine() {
        return this.start;
    }

    public int getEndLine() {
        return this.end;
    }

    public int getDeclarationLine() {
        return Math.min(this.start + 1, this.end);
    }

    public abstract String getName();

    public Object accept(SummaryVisitor summaryVisitor, Object object) {
        return summaryVisitor.visit(this, object);
    }

    protected void setStartLine(int n) {
        this.start = n;
    }

    protected void setEndLine(int n) {
        this.end = n;
        if (this.end < this.start) {
            this.start = this.end;
        }
    }
}

