/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.summary;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.acm.seguin.summary.FileSummary;
import org.acm.seguin.summary.Summary;
import org.acm.seguin.summary.SummaryVisitor;

public class PackageSummary
extends Summary {
    private LinkedList fileList;
    private String name;
    private static HashMap packageMap;

    protected PackageSummary(String string) {
        super(null);
        this.name = string.intern();
        this.fileList = null;
    }

    public static Iterator getAllPackages() {
        if (packageMap == null) {
            PackageSummary.init();
        }
        return packageMap.values().iterator();
    }

    /*
     * Unable to fully structure code
     */
    public File getDirectory() {
        var1_1 = this.getFileSummaries();
        if (var1_1 != null) ** GOTO lbl8
        return null;
lbl-1000:
        // 1 sources

        {
            var2_2 = (FileSummary)var1_1.next();
            var3_3 = var2_2.getFile();
            if (var3_3 == null || (var3_3 = var3_3.getParentFile()) == null) continue;
            return var3_3;
lbl8:
            // 2 sources

            ** while (var1_1.hasNext())
        }
lbl9:
        // 1 sources

        return null;
    }

    public Iterator getFileSummaries() {
        if (this.fileList == null) {
            return null;
        }
        return this.fileList.iterator();
    }

    public FileSummary getFileSummary(String string) {
        if (string == null) {
            return null;
        }
        if (this.fileList != null) {
            Iterator iterator = this.fileList.iterator();
            while (iterator.hasNext()) {
                FileSummary fileSummary = (FileSummary)iterator.next();
                if (!string.equals(fileSummary.getName())) continue;
                return fileSummary;
            }
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public static PackageSummary getPackageSummary(String string) {
        PackageSummary packageSummary;
        if (packageMap == null) {
            PackageSummary.init();
        }
        if ((packageSummary = (PackageSummary)packageMap.get(string)) == null) {
            packageSummary = new PackageSummary(string);
            packageMap.put(string, packageSummary);
        }
        return packageSummary;
    }

    public boolean isTopLevel() {
        return this.name == null || this.name.length() == 0;
    }

    public Object accept(SummaryVisitor summaryVisitor, Object object) {
        return summaryVisitor.visit(this, object);
    }

    protected void addFileSummary(FileSummary fileSummary) {
        if (fileSummary != null) {
            if (this.fileList == null) {
                this.initFileList();
            }
            this.fileList.add(fileSummary);
        }
    }

    public void deleteFileSummary(FileSummary fileSummary) {
        if (fileSummary != null) {
            if (this.fileList == null) {
                this.initFileList();
            }
            this.fileList.remove(fileSummary);
        }
    }

    private static void init() {
        if (packageMap == null) {
            packageMap = new HashMap();
        }
    }

    private void initFileList() {
        this.fileList = new LinkedList();
    }

    public static void loadAll(ObjectInputStream objectInputStream) throws IOException {
        try {
            packageMap = (HashMap)objectInputStream.readObject();
            if (packageMap == null || packageMap.values() == null) {
                return;
            }
            Iterator iterator = packageMap.values().iterator();
            while (iterator.hasNext()) {
                System.out.print("*");
                PackageSummary packageSummary = (PackageSummary)iterator.next();
                Iterator iterator2 = packageSummary.getFileSummaries();
                while (iterator2 != null && iterator2.hasNext()) {
                    System.out.print(".");
                    FileSummary fileSummary = (FileSummary)iterator2.next();
                    FileSummary.register(fileSummary);
                }
            }
            System.out.println(" ");
        }
        catch (ClassNotFoundException classNotFoundException) {
            packageMap = null;
            classNotFoundException.printStackTrace(System.out);
        }
    }

    public static void removeAll() {
        packageMap = null;
        PackageSummary.init();
        FileSummary.removeAll();
    }

    public static void saveAll(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(packageMap);
    }

    public String toString() {
        if (!this.isTopLevel()) {
            return this.name;
        }
        return "<Top Level Package>";
    }
}

