/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.summary;

import java.util.Iterator;
import java.util.LinkedList;
import org.acm.seguin.pretty.ModifierHolder;
import org.acm.seguin.summary.ParameterSummary;
import org.acm.seguin.summary.Summary;
import org.acm.seguin.summary.SummaryVisitor;
import org.acm.seguin.summary.TypeDeclSummary;

public class MethodSummary
extends Summary {
    private TypeDeclSummary returnType = null;
    private String name;
    private LinkedList parameterList = null;
    private LinkedList exceptionList = null;
    private LinkedList dependencyList = null;
    private ModifierHolder modifiers;
    private int statementCount = 0;
    private int blockDepth = 0;
    private int maxBlockDepth = 0;
    private int declarationLine = 0;

    public MethodSummary(Summary summary) {
        super(summary);
    }

    public void setName(String string) {
        this.name = string.intern();
    }

    public void setReturnType(TypeDeclSummary typeDeclSummary) {
        this.returnType = typeDeclSummary;
    }

    public void setDeclarationLine(int n) {
        this.declarationLine = n;
    }

    public String getName() {
        return this.name;
    }

    public TypeDeclSummary getReturnType() {
        return this.returnType;
    }

    public Iterator getExceptions() {
        if (this.exceptionList == null) {
            return null;
        }
        return this.exceptionList.iterator();
    }

    public Iterator getParameters() {
        if (this.parameterList == null) {
            return null;
        }
        return this.parameterList.iterator();
    }

    public int getParameterCount() {
        if (this.parameterList == null) {
            return 0;
        }
        return this.parameterList.size();
    }

    public Iterator getDependencies() {
        if (this.dependencyList == null) {
            return null;
        }
        return this.dependencyList.iterator();
    }

    public ModifierHolder getModifiers() {
        return this.modifiers;
    }

    public int getStatementCount() {
        return this.statementCount;
    }

    public boolean isNearMiss(MethodSummary methodSummary) {
        return this.checkSignature(methodSummary) && (!this.checkReturn(methodSummary) || !this.checkProtection(methodSummary));
    }

    public boolean isInitializer() {
        return this.name.equals("***Initializer***");
    }

    public int getMaxBlockDepth() {
        return this.maxBlockDepth;
    }

    public int getDeclarationLine() {
        return this.declarationLine;
    }

    public boolean isConstructor() {
        return this.returnType == null && !this.isInitializer();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getName());
        stringBuffer.append("(");
        Iterator iterator = this.getParameters();
        if (iterator != null) {
            while (iterator.hasNext()) {
                Object e = iterator.next();
                stringBuffer.append(e.toString());
                if (!iterator.hasNext()) continue;
                stringBuffer.append(", ");
            }
        }
        if (this.returnType == null) {
            stringBuffer.append(")");
        } else {
            stringBuffer.append(") : ");
            stringBuffer.append(this.returnType.toString());
        }
        return stringBuffer.toString();
    }

    public Object accept(SummaryVisitor summaryVisitor, Object object) {
        return summaryVisitor.visit(this, object);
    }

    public void incrStatementCount() {
        ++this.statementCount;
    }

    public boolean equals(Object object) {
        if (object instanceof MethodSummary) {
            MethodSummary methodSummary = (MethodSummary)object;
            return this.checkSignature(methodSummary) && this.checkReturn(methodSummary) && this.checkProtection(methodSummary);
        }
        return false;
    }

    public void beginBlock() {
        ++this.blockDepth;
        if (this.blockDepth > this.maxBlockDepth) {
            this.maxBlockDepth = this.blockDepth;
        }
    }

    public void endBlock() {
        --this.blockDepth;
    }

    /*
     * Unable to fully structure code
     */
    public boolean checkSignature(MethodSummary var1_1) {
        if (!this.name.equals(var1_1.getName())) {
            return false;
        }
        var2_2 = this.getParameters();
        var3_3 = var1_1.getParameters();
        if (var2_2 == null) {
            return var3_3 == null;
        }
        if (var3_3 != null) ** GOTO lbl13
        return false;
lbl-1000:
        // 1 sources

        {
            var4_4 = (ParameterSummary)var2_2.next();
            var5_5 = (ParameterSummary)var3_3.next();
            if (var4_4.getTypeDecl().isSame(var5_5.getTypeDecl())) continue;
            return false;
lbl13:
            // 2 sources

            ** while (var2_2.hasNext() && var3_3.hasNext())
        }
lbl14:
        // 1 sources

        return var2_2.hasNext() == var3_3.hasNext();
    }

    protected void setModifiers(ModifierHolder modifierHolder) {
        this.modifiers = modifierHolder;
    }

    protected void add(TypeDeclSummary typeDeclSummary) {
        if (typeDeclSummary != null) {
            if (this.exceptionList == null) {
                this.initExceptionList();
            }
            this.exceptionList.add(typeDeclSummary);
        }
    }

    protected void add(ParameterSummary parameterSummary) {
        if (parameterSummary != null) {
            if (this.parameterList == null) {
                this.initParameterList();
            }
            this.parameterList.add(parameterSummary);
        }
    }

    protected void addDependency(Summary summary) {
        if (summary != null) {
            if (this.dependencyList == null) {
                this.initDependencyList();
            }
            if (!this.dependencyList.contains(summary)) {
                this.dependencyList.add(summary);
            }
        }
    }

    private void initParameterList() {
        this.parameterList = new LinkedList();
    }

    private void initExceptionList() {
        this.exceptionList = new LinkedList();
    }

    private void initDependencyList() {
        this.dependencyList = new LinkedList();
    }

    private boolean checkReturn(MethodSummary methodSummary) {
        return this.getReturnType().isSame(methodSummary.getReturnType());
    }

    private boolean checkProtection(MethodSummary methodSummary) {
        ModifierHolder modifierHolder = this.getModifiers();
        ModifierHolder modifierHolder2 = methodSummary.getModifiers();
        return modifierHolder.isPublic() == modifierHolder2.isPublic() && modifierHolder.isProtected() == modifierHolder2.isProtected() && modifierHolder.isPackage() == modifierHolder2.isPackage() && modifierHolder.isPrivate() == modifierHolder2.isPrivate();
    }
}

