/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.summary;

import org.acm.seguin.parser.ast.ASTName;
import org.acm.seguin.summary.Summary;
import org.acm.seguin.summary.SummaryVisitor;
import org.acm.seguin.summary.TypeDeclSummary;
import org.acm.seguin.summary.TypeSummary;
import org.acm.seguin.summary.query.GetTypeSummary;

public class MessageSendSummary
extends Summary {
    private String objectName = null;
    private String packageName = null;
    private String messageName = null;
    private String first;

    public MessageSendSummary(Summary summary, ASTName aSTName) {
        super(summary);
        int n = aSTName.getNameSize();
        this.messageName = aSTName.getNamePart(n - 1).intern();
        if (n > 1) {
            this.first = aSTName.getNamePart(0);
            this.objectName = aSTName.getNamePart(n - 2).intern();
            if (n > 2) {
                StringBuffer stringBuffer = new StringBuffer(aSTName.getNamePart(0));
                int n2 = 1;
                while (n2 < n - 2) {
                    stringBuffer.append(".");
                    stringBuffer.append(aSTName.getNamePart(n2));
                    ++n2;
                }
                this.packageName = stringBuffer.toString().intern();
            }
        } else {
            this.first = null;
        }
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getMessageName() {
        return this.messageName;
    }

    public TypeDeclSummary getTypeDecl() {
        if (this.packageName == null) {
            TypeDeclSummary typeDeclSummary;
            TypeSummary typeSummary;
            if (this.objectName != null && (typeSummary = GetTypeSummary.query(typeDeclSummary = new TypeDeclSummary(this, this.packageName, this.objectName))) != null) {
                return typeDeclSummary;
            }
            return null;
        }
        return new TypeDeclSummary(this, this.packageName, this.objectName);
    }

    public String getName() {
        return this.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.packageName != null) {
            stringBuffer.append(this.packageName);
            stringBuffer.append(".");
        }
        if (this.objectName != null) {
            stringBuffer.append(this.objectName);
            stringBuffer.append(".");
        }
        stringBuffer.append(this.messageName);
        stringBuffer.append("()");
        return stringBuffer.toString();
    }

    public Object accept(SummaryVisitor summaryVisitor, Object object) {
        return summaryVisitor.visit(this, object);
    }

    public boolean equals(Object object) {
        if (object instanceof MessageSendSummary) {
            MessageSendSummary messageSendSummary = (MessageSendSummary)object;
            boolean bl = this.objectName == null && messageSendSummary.objectName == null || this.objectName != null && this.objectName.equals(messageSendSummary.objectName);
            boolean bl2 = this.packageName == null && messageSendSummary.packageName == null || this.packageName != null && this.packageName.equals(messageSendSummary.packageName);
            boolean bl3 = this.messageName == null && messageSendSummary.messageName == null || this.messageName != null && this.messageName.equals(messageSendSummary.messageName);
            return bl && bl2 && bl3;
        }
        return super.equals(object);
    }

    public String getFirstObject() {
        return this.first;
    }
}

