/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.summary;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import org.acm.seguin.awt.ExceptionPrinter;
import org.acm.seguin.summary.FileSummary;
import org.acm.seguin.summary.FrameworkLoader;
import org.acm.seguin.summary.PackageSummary;
import org.acm.seguin.summary.TypeSummary;
import org.acm.seguin.summary.load.LoadStatus;
import org.acm.seguin.summary.load.TextLoadStatus;
import org.acm.seguin.tools.stub.StubFile;
import org.acm.seguin.tools.stub.StubGenerator;
import org.acm.seguin.util.FileSettings;
import org.acm.seguin.util.MissingSettingsException;

public class FrameworkFileSummaryLoader
extends FrameworkLoader {
    private String directory;
    private boolean loaded;
    private LoadStatus status;

    public FrameworkFileSummaryLoader(LoadStatus loadStatus) {
        String string;
        this.status = loadStatus;
        try {
            FileSettings fileSettings = FileSettings.getSettings("Refactory", "uml");
            string = fileSettings.getString("stub.dir");
        }
        catch (MissingSettingsException missingSettingsException) {
            string = System.getProperty("user.home");
        }
        this.directory = string + File.separator + ".Refactory";
        this.loaded = false;
    }

    public void run() {
        if (this.loaded) {
            return;
        }
        StubGenerator.waitForLoaded();
        PackageSummary.getPackageSummary("java.lang");
        StubFile.waitForCreation();
        this.loaded = true;
        File file = new File(this.directory);
        String[] stringArray = file.list();
        if (stringArray == null) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].endsWith(".stub")) {
                this.loadFile(stringArray[n]);
            }
            ++n;
        }
    }

    private Reader getInputReader(String string) throws IOException {
        return new BufferedReader(new FileReader(new File(this.directory, string)));
    }

    private String getTypeName(FileSummary fileSummary) {
        if (fileSummary == null) {
            return "No summary";
        }
        Iterator iterator = fileSummary.getTypes();
        if (iterator == null) {
            return "No types";
        }
        TypeSummary typeSummary = (TypeSummary)iterator.next();
        String string = typeSummary.getName();
        if (string == null) {
            return "No name";
        }
        return string;
    }

    private void loadFile(String string) {
        try {
            this.status.setRoot(string);
            Reader reader = this.getInputReader(string);
            String string2 = this.loadBuffer(reader);
            while (string2.length() > 0) {
                FileSummary fileSummary = FileSummary.getFileSummary(string2);
                this.status.setCurrentFile(this.getTypeName(fileSummary));
                string2 = this.loadBuffer(reader);
                Thread.currentThread();
                Thread.yield();
            }
        }
        catch (IOException iOException) {
            ExceptionPrinter.print(iOException, false);
        }
    }

    private String loadBuffer(Reader reader) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = reader.read();
        while (n >= 0 && n != 124 && reader.ready()) {
            stringBuffer.append((char)n);
            n = reader.read();
        }
        return stringBuffer.toString().trim();
    }

    public static void main(String[] stringArray) {
        new FrameworkFileSummaryLoader(new TextLoadStatus()).run();
    }
}

