/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.summary;

import org.acm.seguin.parser.ast.ASTAssignmentOperator;
import org.acm.seguin.parser.ast.ASTExpression;
import org.acm.seguin.parser.ast.ASTName;
import org.acm.seguin.parser.ast.ASTStatementExpression;
import org.acm.seguin.parser.ast.SimpleNode;
import org.acm.seguin.summary.Summary;
import org.acm.seguin.summary.SummaryVisitor;
import org.acm.seguin.summary.TypeDeclSummary;
import org.acm.seguin.summary.TypeSummary;
import org.acm.seguin.summary.query.GetTypeSummary;

public class FieldAccessSummary
extends Summary {
    private String objectName = null;
    private String packageName = null;
    private String fieldName = null;
    private boolean isAssignment;

    public FieldAccessSummary(Summary summary, ASTName aSTName) {
        super(summary);
        this.isAssignment = this.checkAssignment(aSTName);
        int n = aSTName.getNameSize();
        this.fieldName = aSTName.getNamePart(n - 1).intern();
        if (n > 1) {
            this.objectName = aSTName.getNamePart(n - 2).intern();
            if (n > 2) {
                StringBuffer stringBuffer = new StringBuffer(aSTName.getNamePart(0));
                int n2 = 1;
                while (n2 < n - 2) {
                    stringBuffer.append(".");
                    stringBuffer.append(aSTName.getNamePart(n2));
                    ++n2;
                }
                this.packageName = stringBuffer.toString().intern();
            }
        }
    }

    public boolean isAssignment() {
        return this.isAssignment;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public TypeDeclSummary getTypeDecl() {
        if (this.packageName == null) {
            TypeDeclSummary typeDeclSummary;
            TypeSummary typeSummary;
            if (this.objectName != null && (typeSummary = GetTypeSummary.query(typeDeclSummary = new TypeDeclSummary(this, this.packageName, this.objectName))) != null) {
                return typeDeclSummary;
            }
            return null;
        }
        return new TypeDeclSummary(this, this.packageName, this.objectName);
    }

    public String getFirstObject() {
        String string = this.getName();
        int n = string.indexOf(".");
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    public String getName() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.packageName != null) {
            stringBuffer.append(this.packageName);
            stringBuffer.append(".");
        }
        if (this.objectName != null) {
            stringBuffer.append(this.objectName);
            stringBuffer.append(".");
        }
        stringBuffer.append(this.fieldName);
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.packageName != null) {
            stringBuffer.append(this.packageName);
            stringBuffer.append(".");
        }
        if (this.objectName != null) {
            stringBuffer.append(this.objectName);
            stringBuffer.append(".");
        }
        stringBuffer.append(this.fieldName);
        if (this.isAssignment) {
            stringBuffer.append("-W");
        }
        return stringBuffer.toString();
    }

    public Object accept(SummaryVisitor summaryVisitor, Object object) {
        return summaryVisitor.visit(this, object);
    }

    public boolean equals(Object object) {
        if (object instanceof FieldAccessSummary) {
            FieldAccessSummary fieldAccessSummary = (FieldAccessSummary)object;
            boolean bl = this.objectName == null && fieldAccessSummary.objectName == null || this.objectName != null && this.objectName.equals(fieldAccessSummary.objectName);
            boolean bl2 = this.packageName == null && fieldAccessSummary.packageName == null || this.packageName != null && this.packageName.equals(fieldAccessSummary.packageName);
            boolean bl3 = this.fieldName == null && fieldAccessSummary.fieldName == null || this.fieldName != null && this.fieldName.equals(fieldAccessSummary.fieldName);
            return bl && bl2 && bl3 && this.isAssignment == fieldAccessSummary.isAssignment;
        }
        return super.equals(object);
    }

    private int getChildIndex(SimpleNode simpleNode, SimpleNode simpleNode2) {
        int n = 0;
        while (n < simpleNode.jjtGetNumChildren()) {
            if (simpleNode.jjtGetChild(n) == simpleNode2) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private boolean checkAssignment(SimpleNode simpleNode) {
        SimpleNode simpleNode2 = simpleNode;
        SimpleNode simpleNode3 = (SimpleNode)simpleNode.jjtGetParent();
        while (simpleNode3 != null) {
            int n = this.getChildIndex(simpleNode3, simpleNode2);
            if (n == -1) {
                throw new IllegalArgumentException("Child node not found into its parent ???");
            }
            if (simpleNode3.jjtGetNumChildren() > n + 1 && (simpleNode3 instanceof ASTStatementExpression || simpleNode3 instanceof ASTExpression)) {
                return simpleNode3.jjtGetChild(n + 1) instanceof ASTAssignmentOperator;
            }
            simpleNode2 = simpleNode3;
            simpleNode3 = (SimpleNode)simpleNode3.jjtGetParent();
        }
        return false;
    }
}

