/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.refactor.undo;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Stack;
import org.acm.seguin.refactor.Refactoring;
import org.acm.seguin.refactor.undo.UndoAction;
import org.acm.seguin.uml.loader.ReloaderSingleton;
import org.acm.seguin.util.FileSettings;

public class UndoStack {
    private Stack stack;
    private static UndoStack singleton;

    public UndoStack() {
        if (!this.load()) {
            this.stack = new Stack();
        }
    }

    public boolean isStackEmpty() {
        return this.stack.isEmpty();
    }

    public UndoAction add(Refactoring refactoring) {
        UndoAction undoAction = new UndoAction(refactoring.getDescription());
        this.stack.push(undoAction);
        return undoAction;
    }

    public UndoAction peek() {
        return (UndoAction)this.stack.peek();
    }

    public Iterator list() {
        return ((AbstractList)this.stack).iterator();
    }

    public void undo() {
        UndoAction undoAction = (UndoAction)this.stack.pop();
        undoAction.undo();
        ReloaderSingleton.reload();
    }

    public void done() {
        this.save();
    }

    public void delete() {
        File file = this.getFile();
        file.delete();
        this.stack = new Stack();
    }

    private File getFile() {
        File file = new File(FileSettings.getSettingsRoot() + File.separator + ".Refactory");
        return new File(file, "undo.stk");
    }

    private void save() {
        try {
            File file = this.getFile();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
            objectOutputStream.writeObject(this.stack);
            objectOutputStream.flush();
            objectOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.out);
        }
    }

    private boolean load() {
        try {
            File file = this.getFile();
            ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file));
            this.stack = (Stack)objectInputStream.readObject();
            objectInputStream.close();
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.out);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace(System.out);
        }
        return false;
    }

    public static UndoStack get() {
        if (singleton == null) {
            singleton = new UndoStack();
        }
        return singleton;
    }
}

