/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.refactor.type;

import java.io.File;
import java.io.IOException;
import org.acm.seguin.parser.ast.ASTName;
import org.acm.seguin.parser.query.PackageNameGetter;
import org.acm.seguin.refactor.ComplexTransform;
import org.acm.seguin.refactor.EliminatePackageImportVisitor;
import org.acm.seguin.refactor.Refactoring;
import org.acm.seguin.refactor.RefactoringException;
import org.acm.seguin.refactor.type.RenameClassVisitor;
import org.acm.seguin.summary.FileSummary;
import org.acm.seguin.summary.PackageSummary;
import org.acm.seguin.summary.SummaryTraversal;
import org.acm.seguin.summary.TypeSummary;
import org.acm.seguin.summary.query.GetTypeSummary;
import org.acm.seguin.summary.query.PackageContainsClass;
import org.acm.seguin.summary.query.TopLevelDirectory;

public class RenameClassRefactoring
extends Refactoring {
    private String initDir = System.getProperty("user.dir");
    private String oldPackage;
    private String oldClassName;
    private String newClassName;
    private String srcPackage;
    private File base;

    protected RenameClassRefactoring() {
    }

    public void setDirectory(String string) {
        this.initDir = string;
    }

    public void setOldClassName(String string) {
        this.oldClassName = string;
    }

    public void setNewClassName(String string) {
        this.newClassName = string;
    }

    public String getDescription() {
        return "Renames a class from " + this.oldClassName + " to " + this.newClassName;
    }

    public int getID() {
        return 2;
    }

    protected FileSummary getFileSummary() {
        PackageSummary packageSummary = PackageSummary.getPackageSummary(this.srcPackage);
        TypeSummary typeSummary = GetTypeSummary.query(packageSummary, this.oldClassName);
        return (FileSummary)typeSummary.getParent();
    }

    protected void preconditions() throws RefactoringException {
        if (this.oldClassName == null) {
            throw new RefactoringException("No old class specified");
        }
        if (this.newClassName == null) {
            throw new RefactoringException("No new class specified");
        }
        File file = new File(this.initDir);
        String string = this.oldClassName + ".java";
        ASTName aSTName = PackageNameGetter.query(file, string);
        this.srcPackage = "";
        if (aSTName != null) {
            this.srcPackage = aSTName.getName();
        }
        this.base = TopLevelDirectory.query(file, string);
        String string2 = this.base.getPath();
        try {
            string2 = this.base.getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        new SummaryTraversal(string2).go();
        if (PackageContainsClass.query(this.srcPackage, this.newClassName)) {
            throw new RefactoringException(this.srcPackage + " already contains a class named " + this.newClassName);
        }
    }

    protected void transform() {
        System.out.println("Renaming " + this.oldClassName + " to " + this.newClassName);
        ComplexTransform complexTransform = this.getComplexTransform();
        EliminatePackageImportVisitor eliminatePackageImportVisitor = new EliminatePackageImportVisitor(complexTransform);
        eliminatePackageImportVisitor.setPackageSummary(PackageSummary.getPackageSummary(this.srcPackage));
        eliminatePackageImportVisitor.addFilterClass(this.oldClassName);
        eliminatePackageImportVisitor.visit(null);
        RenameClassVisitor renameClassVisitor = new RenameClassVisitor(this.srcPackage, this.oldClassName, this.newClassName, this.base, complexTransform);
        renameClassVisitor.visit(null);
    }
}

