/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.refactor.type;

import org.acm.seguin.parser.Node;
import org.acm.seguin.parser.ast.ASTImportDeclaration;
import org.acm.seguin.parser.ast.ASTName;
import org.acm.seguin.parser.ast.ASTPackageDeclaration;
import org.acm.seguin.parser.ast.SimpleNode;
import org.acm.seguin.refactor.TransformAST;

public class RemoveSamePackageTransform
extends TransformAST {
    public void update(SimpleNode simpleNode) {
        ASTName aSTName = this.getPackageName(simpleNode);
        int n = 0;
        while (n < simpleNode.jjtGetNumChildren()) {
            Node node = simpleNode.jjtGetChild(n);
            if (node instanceof ASTImportDeclaration) {
                if (this.isImporting(aSTName, (ASTImportDeclaration)node)) {
                    simpleNode.jjtDeleteChild(n);
                    continue;
                }
                ++n;
                continue;
            }
            ++n;
        }
    }

    private ASTName getPackageName(SimpleNode simpleNode) {
        SimpleNode simpleNode2 = (SimpleNode)simpleNode.jjtGetChild(0);
        if (simpleNode2 instanceof ASTPackageDeclaration) {
            return (ASTName)simpleNode2.jjtGetChild(0);
        }
        return null;
    }

    private boolean isImporting(ASTName aSTName, ASTImportDeclaration aSTImportDeclaration) {
        ASTName aSTName2 = (ASTName)aSTImportDeclaration.jjtGetChild(0);
        if (aSTName == null) {
            return aSTName2.getNameSize() == 1;
        }
        if (aSTImportDeclaration.isImportingPackage()) {
            return aSTName2.equals(aSTName);
        }
        return aSTName.getNameSize() + 1 == aSTName2.getNameSize() && aSTName2.startsWith(aSTName);
    }
}

