/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.refactor.type;

import java.io.File;
import java.io.IOException;
import org.acm.seguin.refactor.ComplexTransform;
import org.acm.seguin.refactor.Refactoring;
import org.acm.seguin.refactor.RefactoringException;
import org.acm.seguin.refactor.type.RemoveClassVisitor;
import org.acm.seguin.summary.FileSummary;
import org.acm.seguin.summary.PackageSummary;
import org.acm.seguin.summary.Summary;
import org.acm.seguin.summary.TraversalVisitor;
import org.acm.seguin.summary.TypeDeclSummary;
import org.acm.seguin.summary.TypeSummary;
import org.acm.seguin.summary.query.GetTypeSummary;
import org.acm.seguin.summary.query.TopLevelDirectory;

public class RemoveEmptyClassRefactoring
extends Refactoring {
    private TypeSummary typeSummary;
    private File base;

    protected RemoveEmptyClassRefactoring() {
    }

    public void setClass(String string, String string2) {
        this.setClass(GetTypeSummary.query(PackageSummary.getPackageSummary(string), string2));
    }

    public void setClass(TypeSummary typeSummary) {
        this.typeSummary = typeSummary;
    }

    public String getDescription() {
        return "Removes the class named " + this.typeSummary.getName();
    }

    public int getID() {
        return 5;
    }

    protected FileSummary getFileSummary() {
        FileSummary fileSummary = (FileSummary)this.typeSummary.getParent();
        return fileSummary;
    }

    protected void preconditions() throws RefactoringException {
        if (this.typeSummary == null) {
            throw new RefactoringException("No type specified");
        }
        TypeDeclSummary typeDeclSummary = this.typeSummary.getParentClass();
        TypeSummary typeSummary = typeDeclSummary == null ? GetTypeSummary.query(PackageSummary.getPackageSummary("java.lang"), "Object") : GetTypeSummary.query(typeDeclSummary);
        if (typeSummary == null) {
            throw new RefactoringException("Could not find the parent class for the specified class in the metadata");
        }
        FileSummary fileSummary = this.getFileSummary();
        if (fileSummary.getFile() == null) {
            throw new RefactoringException("This type is contained in a stub.  No refactorings allowed.");
        }
        if (fileSummary.getTypeCount() != 1) {
            throw new RefactoringException("This refactoring works only when the type is alone in a file.  Please remove other types from " + fileSummary.getFile().getName());
        }
        if (this.typeSummary.getFieldCount() > 0 || this.typeSummary.getMethodCount() > 0) {
            throw new RefactoringException("The " + this.typeSummary.getName() + " class has at least one method or field");
        }
        File file = fileSummary.getFile();
        String string = null;
        try {
            string = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            string = file.getPath();
        }
        File file2 = new File(string).getParentFile();
        String string2 = file.getName();
        this.base = TopLevelDirectory.query(file2, string2);
    }

    protected void transform() {
        Object object;
        String string;
        String string2;
        ComplexTransform complexTransform = this.getComplexTransform();
        FileSummary fileSummary = this.getFileSummary();
        complexTransform.removeFile(fileSummary.getFile());
        String string3 = ((PackageSummary)fileSummary.getParent()).getName();
        String string4 = this.typeSummary.getName();
        TypeDeclSummary typeDeclSummary = this.typeSummary.getParentClass();
        if (typeDeclSummary == null) {
            string2 = "Object";
            string = "java.lang";
        } else {
            string2 = typeDeclSummary.getType();
            object = GetTypeSummary.query(typeDeclSummary);
            Summary summary = ((Summary)object).getParent();
            while (!(summary instanceof PackageSummary)) {
                summary = summary.getParent();
            }
            string = ((PackageSummary)summary).getName();
        }
        FileSummary.removeFileSummary(fileSummary.getFile());
        object = new RemoveClassVisitor(string3, string4, string, string2, this.base, complexTransform);
        ((TraversalVisitor)object).visit(null);
    }
}

