/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.refactor.type;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import org.acm.seguin.parser.ast.ASTName;
import org.acm.seguin.parser.query.PackageNameGetter;
import org.acm.seguin.refactor.Refactoring;
import org.acm.seguin.refactor.RefactoringException;
import org.acm.seguin.refactor.type.MoveClassVisitor;
import org.acm.seguin.summary.SummaryTraversal;
import org.acm.seguin.summary.query.TopLevelDirectory;

public class MoveClass
extends Refactoring {
    protected String initDir = System.getProperty("user.dir");
    protected LinkedList fileList = new LinkedList();
    private String oldPackage;
    private File base;
    private String srcPackage;
    private String destPackage = null;

    protected MoveClass() {
    }

    public void setDestinationPackage(String string) {
        this.destPackage = string;
    }

    public void setDirectory(String string) {
        this.initDir = string;
    }

    public String getDescription() {
        return "Repackaging classes from " + this.srcPackage + " to " + this.destPackage;
    }

    public int getID() {
        return 1;
    }

    public void add(String string) {
        this.fileList.add(string);
    }

    protected void preconditions() throws RefactoringException {
        if (this.destPackage == null || this.fileList.size() == 0) {
            if (this.destPackage == null) {
                System.out.println("destPackage can not be null");
            }
            if (this.fileList.size() == 0) {
                System.out.println("No files provided");
            }
            return;
        }
        this.validateClassName(this.fileList);
        File file = new File(this.initDir);
        String string = (String)this.fileList.get(0);
        ASTName aSTName = PackageNameGetter.query(file, string);
        this.srcPackage = "";
        if (aSTName != null) {
            this.srcPackage = aSTName.getName();
        }
        this.base = TopLevelDirectory.query(file, string);
        String string2 = this.base.getPath();
        try {
            string2 = this.base.getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        new SummaryTraversal(string2).go();
    }

    protected void transform() {
        MoveClassVisitor moveClassVisitor = new MoveClassVisitor(this.srcPackage, this.destPackage, this.base, this.getComplexTransform());
        Iterator iterator = this.fileList.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            int n = Math.max(0, string.indexOf(File.separator));
            int n2 = string.indexOf(".java");
            String string2 = "";
            string2 = n2 > 0 ? string.substring(n, n2) : string.substring(n);
            moveClassVisitor.add(string2);
        }
        moveClassVisitor.visit(null);
    }

    protected void validateClassName(LinkedList linkedList) throws RefactoringException {
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string.endsWith(".java")) continue;
            throw new RefactoringException(string + " should ba a java file");
        }
    }
}

