/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.refactor.type;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.acm.seguin.parser.ast.ASTName;
import org.acm.seguin.pretty.ModifierHolder;
import org.acm.seguin.refactor.AddImportTransform;
import org.acm.seguin.refactor.ComplexTransform;
import org.acm.seguin.refactor.Refactoring;
import org.acm.seguin.refactor.RefactoringException;
import org.acm.seguin.refactor.method.AddConcreteMethod;
import org.acm.seguin.refactor.type.AddImplementedInterfaceTransform;
import org.acm.seguin.refactor.type.CreateNewInterface;
import org.acm.seguin.summary.FileSummary;
import org.acm.seguin.summary.MethodSummary;
import org.acm.seguin.summary.PackageSummary;
import org.acm.seguin.summary.Summary;
import org.acm.seguin.summary.TypeDeclSummary;
import org.acm.seguin.summary.TypeSummary;
import org.acm.seguin.summary.VariableSummary;
import org.acm.seguin.summary.query.GetTypeSummary;

public class ExtractInterfaceRefactoring
extends Refactoring {
    private String m_interfaceName;
    private String m_packageName;
    private Vector m_summaryList = new Vector();
    private ComplexTransform m_complexTransform = this.getComplexTransform();

    protected ExtractInterfaceRefactoring() {
    }

    public void setInterfaceName(String string) {
        if (string.indexOf(46) != -1) {
            this.m_packageName = string.substring(0, string.lastIndexOf(46));
            this.m_interfaceName = string.substring(string.lastIndexOf(46) + 1);
        } else {
            this.m_interfaceName = string;
        }
    }

    public void setPackageName(String string) {
        this.m_packageName = string;
    }

    public String getDescription() {
        return "Extract Interface.";
    }

    public int getID() {
        return 6;
    }

    public void addImplementingClass(String string, String string2) {
        TypeSummary typeSummary = GetTypeSummary.query(PackageSummary.getPackageSummary(string), string2);
        this.addImplementingClass(typeSummary);
    }

    public void addImplementingClass(TypeSummary typeSummary) {
        if (typeSummary != null) {
            this.m_summaryList.addElement(typeSummary);
        }
    }

    protected void preconditions() throws RefactoringException {
        if (this.m_interfaceName == null) {
            throw new RefactoringException("Interface name is not specified");
        }
        if (this.m_summaryList.size() == 0) {
            throw new RefactoringException("Unable to find type to extract interface from");
        }
    }

    protected void transform() {
        Object object;
        File file = this.createInterfaceFile();
        Vector vector = this.getMethodSummaries();
        int n = 0;
        while (n < vector.size()) {
            object = (MethodSummary)vector.elementAt(n);
            this.m_complexTransform.add(new AddConcreteMethod((MethodSummary)object));
            ++n;
        }
        object = this.getImportTypes(vector);
        while (object != null && object.hasNext()) {
            TypeDeclSummary typeDeclSummary = (TypeDeclSummary)object.next();
            TypeSummary typeSummary = GetTypeSummary.query(typeDeclSummary);
            if (typeSummary == null) continue;
            this.m_complexTransform.add(new AddImportTransform(typeSummary));
        }
        this.m_complexTransform.apply(file, file);
        file = new File(file.getAbsolutePath() + ".0");
        file.delete();
        this.addInterfaceToClasses();
    }

    private Vector getMethodSummaries() {
        Vector<MethodSummary> vector = new Vector<MethodSummary>();
        TypeSummary typeSummary = (TypeSummary)this.m_summaryList.elementAt(0);
        Iterator iterator = typeSummary.getMethods();
        while (iterator.hasNext()) {
            MethodSummary methodSummary = (MethodSummary)iterator.next();
            ModifierHolder modifierHolder = methodSummary.getModifiers();
            if (!modifierHolder.isPublic() || methodSummary.isConstructor() || modifierHolder.isStatic()) continue;
            modifierHolder.setSynchronized(false);
            vector.addElement(methodSummary);
        }
        return this.commonMethods(vector);
    }

    private Iterator getImportTypes(Vector vector) {
        HashMap<String, TypeDeclSummary> hashMap = new HashMap<String, TypeDeclSummary>();
        int n = 0;
        while (n < vector.size()) {
            TypeDeclSummary typeDeclSummary;
            Object object;
            MethodSummary methodSummary = (MethodSummary)vector.elementAt(n);
            TypeDeclSummary typeDeclSummary2 = methodSummary.getReturnType();
            String string = typeDeclSummary2.getName();
            if (!string.equals("void") && hashMap.get(string) == null) {
                hashMap.put(string, typeDeclSummary2);
            }
            Iterator iterator = methodSummary.getParameters();
            while (iterator != null && iterator.hasNext()) {
                object = (VariableSummary)iterator.next();
                typeDeclSummary = ((VariableSummary)object).getTypeDecl();
                string = typeDeclSummary.getName();
                if (hashMap.get(string) != null) continue;
                hashMap.put(string, typeDeclSummary);
            }
            object = methodSummary.getExceptions();
            while (object != null && object.hasNext()) {
                typeDeclSummary = (TypeDeclSummary)object.next();
                string = typeDeclSummary.getName();
                if (hashMap.get(string) != null) continue;
                hashMap.put(string, typeDeclSummary);
            }
            ++n;
        }
        return hashMap.values().iterator();
    }

    private void addInterfaceToClasses() {
        int n = 0;
        while (n < this.m_summaryList.size()) {
            TypeSummary typeSummary = (TypeSummary)this.m_summaryList.elementAt(n);
            FileSummary fileSummary = (FileSummary)typeSummary.getParent();
            File file = fileSummary.getFile();
            ASTName aSTName = new ASTName(0);
            String string = typeSummary.getPackageSummary().getName();
            if (this.m_packageName.length() > 0 && !string.equals(this.m_packageName)) {
                aSTName.fromString(this.m_packageName + "." + this.m_interfaceName);
            } else {
                aSTName.fromString(this.m_interfaceName);
            }
            this.m_complexTransform.clear();
            this.m_complexTransform.add(new AddImplementedInterfaceTransform(aSTName));
            if (!this.m_packageName.equals(string)) {
                this.m_complexTransform.add(new AddImportTransform(aSTName));
            }
            this.m_complexTransform.apply(file, new File(file.getAbsolutePath()));
            ++n;
        }
    }

    private Vector commonMethods(Vector vector) {
        Vector vector2 = new Vector();
        int n = 0;
        while (n < vector.size()) {
            Summary summary;
            boolean bl = true;
            int n2 = 1;
            while (n2 < this.m_summaryList.size()) {
                block5: {
                    summary = (TypeSummary)this.m_summaryList.elementAt(n2);
                    Iterator iterator = ((TypeSummary)summary).getMethods();
                    while (iterator.hasNext()) {
                        MethodSummary methodSummary = (MethodSummary)iterator.next();
                        if (!methodSummary.equals((MethodSummary)vector.elementAt(n))) {
                            continue;
                        }
                        break block5;
                    }
                    bl = false;
                }
                ++n2;
            }
            if (bl) {
                summary = (MethodSummary)vector.elementAt(n);
                vector2.addElement(vector.elementAt(n));
            }
            ++n;
        }
        return vector2;
    }

    private File createInterfaceFile() {
        File file = null;
        TypeSummary typeSummary = (TypeSummary)this.m_summaryList.elementAt(0);
        PackageSummary packageSummary = typeSummary.getPackageSummary();
        if (this.m_packageName == null) {
            this.m_packageName = packageSummary.getName();
        }
        CreateNewInterface createNewInterface = new CreateNewInterface(typeSummary, this.m_packageName, this.m_interfaceName);
        try {
            file = createNewInterface.run();
        }
        catch (RefactoringException refactoringException) {
            refactoringException.printStackTrace();
            return null;
        }
        this.m_complexTransform.createFile(file);
        return file;
    }
}

