/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.refactor.type;

import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import org.acm.seguin.parser.Node;
import org.acm.seguin.parser.ast.ASTClassBody;
import org.acm.seguin.parser.ast.ASTClassDeclaration;
import org.acm.seguin.parser.ast.ASTCompilationUnit;
import org.acm.seguin.parser.ast.ASTImportDeclaration;
import org.acm.seguin.parser.ast.ASTName;
import org.acm.seguin.parser.ast.ASTPackageDeclaration;
import org.acm.seguin.parser.ast.ASTTypeDeclaration;
import org.acm.seguin.parser.ast.ASTUnmodifiedClassDeclaration;
import org.acm.seguin.parser.ast.SimpleNode;
import org.acm.seguin.pretty.PrettyPrintFile;
import org.acm.seguin.refactor.RefactoringException;
import org.acm.seguin.refactor.method.AddConcreteMethod;
import org.acm.seguin.refactor.method.AddConstructor;
import org.acm.seguin.refactor.method.AddMethodTypeVisitor;
import org.acm.seguin.refactor.type.AbstractMethodFinder;
import org.acm.seguin.summary.MethodSummary;
import org.acm.seguin.summary.PackageSummary;
import org.acm.seguin.summary.TypeDeclSummary;
import org.acm.seguin.summary.TypeSummary;
import org.acm.seguin.summary.query.GetPackageSummary;
import org.acm.seguin.summary.query.GetTypeSummary;
import org.acm.seguin.summary.query.SamePackage;
import org.acm.seguin.summary.query.TopLevelDirectory;

public class CreateClass {
    private TypeSummary typeSummary;
    private String newClassName;
    private boolean isParent;
    private boolean isAbstract;
    private boolean isFinal;
    private String packageNameString;
    private String scope;

    public CreateClass(TypeSummary typeSummary, String string, boolean bl, String string2) {
        this.typeSummary = typeSummary;
        this.newClassName = string;
        this.isParent = bl;
        this.isAbstract = true;
        this.isFinal = false;
        this.packageNameString = string2;
        this.scope = "";
    }

    public CreateClass(TypeSummary typeSummary, String string, boolean bl) {
        this.typeSummary = typeSummary;
        this.newClassName = string;
        this.isParent = bl;
        this.isAbstract = true;
        this.isFinal = false;
        this.packageNameString = null;
        this.scope = "";
    }

    CreateClass() {
        this.typeSummary = null;
        this.newClassName = null;
    }

    public void setPackageName(String string) {
        this.packageNameString = string;
    }

    public void setScope(String string) {
        this.scope = string;
    }

    public void setAbstract(boolean bl) {
        this.isAbstract = bl;
    }

    public void setFinal(boolean bl) {
        this.isFinal = bl;
    }

    public File run() throws RefactoringException {
        Object object;
        if (this.newClassName == null) {
            throw new RefactoringException("No class name specified");
        }
        if (this.typeSummary == null) {
            throw new RefactoringException("No type to build upon");
        }
        if (this.packageNameString == null) {
            this.packageNameString = GetPackageSummary.query(this.typeSummary).getName();
        }
        ASTCompilationUnit aSTCompilationUnit = new ASTCompilationUnit(0);
        int n = 0;
        if (this.packageNameString != null && this.packageNameString.length() > 0) {
            object = this.createPackageDeclaration();
            aSTCompilationUnit.jjtAddChild((Node)object, 0);
            ++n;
        }
        object = null;
        if (this.isParent) {
            TypeDeclSummary typeDeclSummary = this.typeSummary.getParentClass();
            object = GetTypeSummary.query(typeDeclSummary);
            if (object == null) {
                object = GetTypeSummary.query(PackageSummary.getPackageSummary("java.lang"), "Object");
            }
        } else {
            object = this.typeSummary;
        }
        ASTName aSTName = this.getNameFromSummary((TypeSummary)object);
        int n2 = n;
        boolean bl = this.addImportStatement((TypeSummary)object, aSTName, aSTCompilationUnit, n);
        if (bl) {
            ++n2;
            aSTName = new ASTName(0);
            aSTName.addNamePart(((TypeSummary)object).getName());
        }
        ASTTypeDeclaration aSTTypeDeclaration = this.createTypeDeclaration(aSTName);
        aSTCompilationUnit.jjtAddChild(aSTTypeDeclaration, n2);
        this.addConstructors((TypeSummary)object, aSTCompilationUnit);
        if (!this.isAbstract) {
            this.addMethods(this.typeSummary, aSTCompilationUnit);
        }
        File file = this.print(this.newClassName, aSTCompilationUnit);
        return file;
    }

    ASTName getNameFromSummary(TypeSummary typeSummary) {
        ASTName aSTName = new ASTName(0);
        if (typeSummary == null || typeSummary.getName().equals("Object")) {
            aSTName.fromString("Object");
        } else {
            PackageSummary packageSummary = this.getPackageSummary(typeSummary);
            if (packageSummary.isTopLevel()) {
                aSTName.fromString(typeSummary.getName());
            } else if (!this.isSamePackage(this.packageNameString, typeSummary)) {
                aSTName.fromString(packageSummary.getName() + "." + typeSummary.getName());
            } else {
                aSTName.fromString(typeSummary.getName());
            }
        }
        return aSTName;
    }

    boolean isSamePackage(String string, TypeSummary typeSummary) {
        return typeSummary != null && SamePackage.query(string, typeSummary);
    }

    ASTPackageDeclaration createPackageDeclaration() {
        ASTPackageDeclaration aSTPackageDeclaration = new ASTPackageDeclaration(0);
        ASTName aSTName = new ASTName(0);
        aSTName.fromString(this.packageNameString);
        aSTPackageDeclaration.jjtAddChild(aSTName, 0);
        return aSTPackageDeclaration;
    }

    boolean addImportStatement(TypeSummary typeSummary, ASTName aSTName, ASTCompilationUnit aSTCompilationUnit, int n) {
        if (!this.isImportRequired(typeSummary)) {
            return false;
        }
        ASTImportDeclaration aSTImportDeclaration = new ASTImportDeclaration(0);
        aSTImportDeclaration.jjtAddChild(aSTName, 0);
        aSTCompilationUnit.jjtAddChild(aSTImportDeclaration, n);
        return true;
    }

    ASTTypeDeclaration createTypeDeclaration(ASTName aSTName) {
        ASTTypeDeclaration aSTTypeDeclaration = new ASTTypeDeclaration(0);
        ASTClassDeclaration aSTClassDeclaration = this.createModifiedClass(aSTName);
        aSTTypeDeclaration.jjtAddChild(aSTClassDeclaration, 0);
        return aSTTypeDeclaration;
    }

    ASTClassDeclaration createModifiedClass(ASTName aSTName) {
        ASTClassDeclaration aSTClassDeclaration = new ASTClassDeclaration(0);
        if (this.isAbstract) {
            aSTClassDeclaration.addModifier("abstract");
        }
        if (this.isFinal) {
            aSTClassDeclaration.addModifier("final");
        }
        if (this.scope.length() > 0) {
            aSTClassDeclaration.addModifier(this.scope);
        }
        ASTUnmodifiedClassDeclaration aSTUnmodifiedClassDeclaration = this.createClassBody(this.newClassName, aSTName);
        aSTClassDeclaration.jjtAddChild(aSTUnmodifiedClassDeclaration, 0);
        return aSTClassDeclaration;
    }

    ASTUnmodifiedClassDeclaration createClassBody(String string, ASTName aSTName) {
        ASTUnmodifiedClassDeclaration aSTUnmodifiedClassDeclaration = new ASTUnmodifiedClassDeclaration(0);
        aSTUnmodifiedClassDeclaration.setName(string);
        aSTUnmodifiedClassDeclaration.jjtAddChild(aSTName, 0);
        aSTUnmodifiedClassDeclaration.jjtAddChild(new ASTClassBody(0), 1);
        return aSTUnmodifiedClassDeclaration;
    }

    File print(String string, SimpleNode simpleNode) {
        File file = this.getDirectory();
        File file2 = new File(file, string + ".java");
        try {
            new PrettyPrintFile().apply(file2, simpleNode);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.out);
        }
        return file2;
    }

    private boolean isImportRequired(TypeSummary typeSummary) {
        return !this.isSamePackage(this.packageNameString, typeSummary) && !this.isSamePackage("java.lang", typeSummary);
    }

    private PackageSummary getPackageSummary(TypeSummary typeSummary) {
        return GetPackageSummary.query(typeSummary);
    }

    private boolean isSameParent(TypeSummary typeSummary, TypeSummary typeSummary2) {
        if (this.isObject(typeSummary)) {
            return this.isObject(typeSummary2);
        }
        if (this.isObject(typeSummary2)) {
            return false;
        }
        return typeSummary.equals(typeSummary2);
    }

    private boolean isObject(TypeSummary typeSummary) {
        if (typeSummary == null) {
            return true;
        }
        return typeSummary.getName().equals("Object");
    }

    private File getDirectory() {
        return TopLevelDirectory.getPackageDirectory(this.typeSummary, this.packageNameString);
    }

    private void addConstructors(TypeSummary typeSummary, SimpleNode simpleNode) {
        Iterator iterator = typeSummary.getMethods();
        if (iterator != null) {
            while (iterator.hasNext()) {
                MethodSummary methodSummary = (MethodSummary)iterator.next();
                if (!methodSummary.isConstructor()) continue;
                AddConstructor addConstructor = new AddConstructor(methodSummary, this.newClassName);
                addConstructor.update(simpleNode);
                AddMethodTypeVisitor addMethodTypeVisitor = new AddMethodTypeVisitor(false);
                addMethodTypeVisitor.visit(methodSummary, (Object)simpleNode);
            }
        }
    }

    private void addMethods(TypeSummary typeSummary, SimpleNode simpleNode) {
        AbstractMethodFinder abstractMethodFinder = new AbstractMethodFinder(typeSummary);
        LinkedList linkedList = abstractMethodFinder.getList();
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            MethodSummary methodSummary = (MethodSummary)iterator.next();
            AddConcreteMethod addConcreteMethod = new AddConcreteMethod(methodSummary);
            addConcreteMethod.update(simpleNode);
            AddMethodTypeVisitor addMethodTypeVisitor = new AddMethodTypeVisitor(false);
            addMethodTypeVisitor.visit(methodSummary, (Object)simpleNode);
        }
    }
}

