/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.refactor.type;

import java.util.Iterator;
import java.util.LinkedList;
import org.acm.seguin.summary.MethodSummary;
import org.acm.seguin.summary.TypeDeclSummary;
import org.acm.seguin.summary.TypeSummary;
import org.acm.seguin.summary.query.GetTypeSummary;

public class AbstractMethodFinder {
    private LinkedList list;
    private TypeSummary leaf;

    public AbstractMethodFinder(TypeSummary typeSummary) {
        this.leaf = typeSummary;
        this.list = new LinkedList();
        this.load();
    }

    AbstractMethodFinder(TypeSummary typeSummary, boolean bl) {
        this.leaf = typeSummary;
        this.list = new LinkedList();
    }

    public LinkedList getList() {
        return this.list;
    }

    void loadInterfaceMethods() {
        TypeSummary typeSummary = this.leaf;
        while (typeSummary != null) {
            Iterator iterator = typeSummary.getImplementedInterfaces();
            if (iterator != null) {
                while (iterator.hasNext()) {
                    TypeDeclSummary typeDeclSummary = (TypeDeclSummary)iterator.next();
                    TypeSummary typeSummary2 = GetTypeSummary.query(typeDeclSummary);
                    this.loadInterface(typeSummary2);
                }
            }
            typeSummary = this.nextType(typeSummary);
        }
    }

    void filter(TypeSummary typeSummary) {
        if (typeSummary == null) {
            return;
        }
        TypeSummary typeSummary2 = this.nextType(typeSummary);
        this.filter(typeSummary2);
        Iterator iterator = typeSummary.getMethods();
        if (iterator != null) {
            while (iterator.hasNext()) {
                MethodSummary methodSummary = (MethodSummary)iterator.next();
                if (methodSummary.getModifiers().isAbstract()) {
                    this.add(methodSummary);
                    continue;
                }
                this.removeImplementations(methodSummary);
            }
        }
    }

    private void load() {
        this.loadInterfaceMethods();
        this.filter(this.leaf);
    }

    private void loadInterface(TypeSummary typeSummary) {
        if (typeSummary == null) {
            return;
        }
        Iterator iterator = typeSummary.getMethods();
        if (iterator != null) {
            while (iterator.hasNext()) {
                this.add((MethodSummary)iterator.next());
            }
        }
        if ((iterator = typeSummary.getImplementedInterfaces()) != null) {
            while (iterator.hasNext()) {
                TypeDeclSummary typeDeclSummary = (TypeDeclSummary)iterator.next();
                TypeSummary typeSummary2 = GetTypeSummary.query(typeDeclSummary);
                this.loadInterface(typeSummary2);
            }
        }
    }

    private TypeSummary nextType(TypeSummary typeSummary) {
        return GetTypeSummary.query(typeSummary.getParentClass());
    }

    private void removeImplementations(MethodSummary methodSummary) {
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            MethodSummary methodSummary2 = (MethodSummary)iterator.next();
            if (!methodSummary.checkSignature(methodSummary2)) continue;
            iterator.remove();
        }
    }

    private void add(MethodSummary methodSummary) {
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            MethodSummary methodSummary2 = (MethodSummary)iterator.next();
            if (!methodSummary.checkSignature(methodSummary2)) continue;
            return;
        }
        this.list.add(methodSummary);
    }
}

